/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.tree;

import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.ITree;
import frostnox.nightfall.block.block.CoveredSoilBlock;
import frostnox.nightfall.block.block.SoilBlock;
import frostnox.nightfall.block.block.tree.TreeBranchesBlock;
import frostnox.nightfall.block.block.tree.TreeLeavesBlock;
import frostnox.nightfall.block.block.tree.TreeStemBlock;
import frostnox.nightfall.block.block.tree.TreeTrunkBlockEntity;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.Season;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class TreeTrunkBlock
extends BaseEntityBlock
implements ITimeSimulatedBlock {
    public final TreeStemBlock stemBlock;
    public final TreeLeavesBlock leavesBlock;
    @Nullable
    public final TreeBranchesBlock branchesBlock;
    @Nullable
    public final TreeLeavesBlock fruitBlock;
    public final TreeGenerator treeGenerator;
    public final ITree type;

    public TreeTrunkBlock(TreeStemBlock stemBlock, TreeLeavesBlock leavesBlock, @Nullable TreeBranchesBlock branchesBlock, @Nullable TreeLeavesBlock fruitBlock, TreeGenerator treeGenerator, BlockBehaviour.Properties properties) {
        super(properties);
        this.stemBlock = stemBlock;
        this.leavesBlock = leavesBlock;
        this.branchesBlock = branchesBlock;
        this.fruitBlock = fruitBlock;
        this.treeGenerator = treeGenerator;
        this.type = leavesBlock.type;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TreeTrunkBlockEntity) {
            TreeTrunkBlockEntity trunk = (TreeTrunkBlockEntity)blockEntity;
            if (level.m_46467_() - trunk.lastTick < (long)this.type.getGrowthIntervalTicks()) {
                return;
            }
            TreeTrunkBlockEntity.updating = true;
            TreeGenerator.Data d = this.treeGenerator.grow(level, trunk, false);
            if (trunk.isSpecial() && this.fruitBlock != null && trunk.maxHeight == d.maxHeight) {
                if (Season.get((Level)level) == Season.SUMMER) {
                    if (!trunk.hasFruited) {
                        this.treeGenerator.tryFruit((WorldGenLevel)level, d, trunk);
                    }
                } else {
                    trunk.hasFruited = false;
                    trunk.m_6596_();
                }
            }
            TreeTrunkBlockEntity.updating = false;
        }
    }

    public void onBlockStateChange(LevelReader levelReader, BlockPos pos, BlockState oldState, BlockState newState) {
        Level level = (Level)levelReader;
        if (!level.f_46443_ && !oldState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).addSimulatableBlock(TickPriority.LOW, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(pNewState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof TreeTrunkBlockEntity) {
            TreeTrunkBlockEntity trunk = (TreeTrunkBlockEntity)blockEntity;
            trunk.updateBlocks(pos, null, false);
        }
        super.m_6810_(state, level, pos, pNewState, pIsMoving);
        if (!pNewState.m_60713_((Block)this) && LevelData.isPresent(level)) {
            ChunkData.get(level.m_46745_(pos)).removeSimulatableBlock(TickPriority.LOW, pos);
        }
    }

    public void generateAt(WorldGenLevel level, BlockPos pos, ChunkPos chunkPos, Random random) {
        level.m_7731_(pos, this.m_49966_(), 4);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TreeTrunkBlockEntity) {
            BlockPos belowPos;
            Block block;
            TreeTrunkBlockEntity trunk = (TreeTrunkBlockEntity)blockEntity;
            level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_8113_(pos);
            trunk.initSeed(level, random);
            trunk.m_6596_();
            TreeGenerator.Data d = this.treeGenerator.grow(level, trunk, Integer.MAX_VALUE, true);
            if (trunk.isSpecial() && this.fruitBlock != null && trunk.maxHeight == d.maxHeight) {
                if (Season.get((Level)level.m_6018_()) == Season.SUMMER) {
                    if (!trunk.hasFruited) {
                        this.treeGenerator.tryFruit(level, d, trunk);
                    }
                } else {
                    trunk.hasFruited = false;
                    trunk.m_6596_();
                }
            }
            if ((block = level.m_8055_(belowPos = pos.m_7495_()).m_60734_()) instanceof CoveredSoilBlock) {
                CoveredSoilBlock coveredSoil = (CoveredSoilBlock)block;
                level.m_7731_(belowPos, ((SoilBlock)coveredSoil.soilBlock.get()).m_49966_(), 4);
            }
        }
    }

    public void growSaplingAt(ServerLevel level, BlockPos pos) {
        level.m_46597_(pos, this.m_49966_());
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TreeTrunkBlockEntity) {
            TreeTrunkBlockEntity trunk = (TreeTrunkBlockEntity)blockEntity;
            trunk.initSeed();
            trunk.m_6596_();
            this.treeGenerator.grow(level, trunk, true);
            BlockPos belowPos = pos.m_7495_();
            Block block = level.m_8055_(belowPos).m_60734_();
            if (block instanceof CoveredSoilBlock) {
                CoveredSoilBlock coveredSoil = (CoveredSoilBlock)block;
                level.m_7731_(belowPos, ((SoilBlock)coveredSoil.soilBlock.get()).m_49966_(), 19);
            }
        }
    }

    public boolean isTreeBase(BlockState state) {
        return state.m_60713_((Block)this.stemBlock) || state.m_60713_((Block)this);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesNF.TREE_TRUNK.get()).m_155264_(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public void simulateTime(ServerLevel level, LevelChunk chunk, IChunkData chunkData, BlockPos pos, BlockState state, long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        BlockEntity blockEntity;
        if (elapsedTime != Long.MAX_VALUE && (blockEntity = chunk.m_7702_(pos)) instanceof TreeTrunkBlockEntity) {
            long trials;
            int stages;
            TreeTrunkBlockEntity trunk = (TreeTrunkBlockEntity)blockEntity;
            long timePassed = gameTime - trunk.lastTick;
            int spacing = this.type.getGrowthIntervalTicks();
            if (timePassed > (long)spacing && (stages = MathUtil.getRandomSuccesses(randomTickChance, trials = elapsedTime - (timePassed > (long)spacing ? 0L : (long)spacing - timePassed), Math.max(this.treeGenerator.maxLeavesRadius, this.treeGenerator.maxLength - trunk.maxHeight - 1), spacing, random)) > 0) {
                TreeTrunkBlockEntity.updating = true;
                int tickAdjustedSpacing = spacing + (int)(1.0 / randomTickChance);
                long startSeasonTime = seasonTime - elapsedTime;
                long finalTickSeasonTime = seasonTime - elapsedTime + (long)(stages * tickAdjustedSpacing);
                TreeGenerator.Data d = this.treeGenerator.grow((WorldGenLevel)level, trunk, stages, finalTickSeasonTime, false);
                if (trunk.isSpecial() && this.fruitBlock != null && trunk.maxHeight == d.maxHeight) {
                    boolean doFruit;
                    boolean bl = doFruit = !d.decaying;
                    if (doFruit) {
                        long summerTime = Season.getTimePassedWithin(startSeasonTime, stages * tickAdjustedSpacing, 336000L, 672000L);
                        if (MathUtil.getRandomSuccesses(randomTickChance, summerTime, 1, random) >= 1) {
                            if (Season.get(finalTickSeasonTime) != Season.SUMMER && MathUtil.getRandomSuccesses(randomTickChance, Season.getTimePassedWithin(startSeasonTime, stages * tickAdjustedSpacing, 672000L, seasonTime), 1, random) >= 1) {
                                doFruit = false;
                            }
                        } else {
                            doFruit = false;
                        }
                    }
                    if (doFruit) {
                        if (!trunk.hasFruited) {
                            this.treeGenerator.tryFruit((WorldGenLevel)level, d, trunk);
                        }
                    } else {
                        trunk.hasFruited = false;
                        trunk.m_6596_();
                    }
                }
                TreeTrunkBlockEntity.updating = false;
                trunk.lastTick = gameTime / (long)tickAdjustedSpacing * (long)tickAdjustedSpacing;
            }
        }
    }

    @Override
    public TickPriority getTickPriority() {
        return TickPriority.LOW;
    }
}

