/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.block.tree;

import frostnox.nightfall.block.ITree;
import frostnox.nightfall.block.block.tree.TreeTrunkBlock;
import frostnox.nightfall.registry.forge.BlockEntitiesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class TreeTrunkBlockEntity
extends BlockEntity {
    protected static boolean updating = false;
    public long lastTick;
    public int maxHeight = -1;
    public boolean hasFruited;
    protected long seed;
    protected boolean special;

    public TreeTrunkBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntitiesNF.TREE_TRUNK.get(), pos, state);
    }

    protected TreeTrunkBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void initSeed(WorldGenLevel level, Random random) {
        if (this.seed == 0L) {
            this.seed = random.nextLong();
            this.lastTick = level.m_6106_().m_6793_();
            this.special = random.nextInt(64) == 0;
        }
    }

    public void initSeed() {
        if (this.seed == 0L && this.f_58857_ != null) {
            this.seed = this.f_58857_.f_46441_.nextLong();
            this.lastTick = this.f_58857_.m_46467_();
            this.special = this.f_58857_.f_46441_.nextInt(64) == 0;
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public ObjectSet<BlockPos> getTree() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TreeTrunkBlock trunk = (TreeTrunkBlock)this.m_58900_().m_60734_();
        return trunk.treeGenerator.getTree((WorldGenLevel)serverLevel, this, false).collectTree();
    }

    public static List<TreeTrunkBlockEntity> getNearbyTrunks(Level level, ITree type, BlockPos aroundPos, Collection<BlockPos> possiblePositions) {
        int minX = aroundPos.m_123341_();
        int maxX = aroundPos.m_123341_();
        int minZ = aroundPos.m_123343_();
        int maxZ = aroundPos.m_123343_();
        for (BlockPos pos : possiblePositions) {
            if (pos.m_123341_() < minX) {
                minX = pos.m_123341_();
            } else if (pos.m_123341_() > maxX) {
                maxX = pos.m_123341_();
            }
            if (pos.m_123343_() < minZ) {
                minZ = pos.m_123343_();
                continue;
            }
            if (pos.m_123343_() <= maxZ) continue;
            maxZ = pos.m_123343_();
        }
        return TreeTrunkBlockEntity.getNearbyTrunks(level, type, aroundPos, minX, maxX, minZ, maxZ);
    }

    public static List<TreeTrunkBlockEntity> getNearbyTrunks(Level level, ITree type, BlockPos aroundPos, int minXBlock, int maxXBlock, int minZBlock, int maxZBlock) {
        if (level == null || level.m_5776_()) {
            return List.of();
        }
        TreeGenerator gen = type.getGenerator();
        int centerX = SectionPos.m_123171_((int)aroundPos.m_123341_());
        int centerZ = SectionPos.m_123171_((int)aroundPos.m_123343_());
        int minX = SectionPos.m_123171_((int)minXBlock);
        int maxX = SectionPos.m_123171_((int)maxXBlock);
        int minZ = SectionPos.m_123171_((int)minZBlock);
        int maxZ = SectionPos.m_123171_((int)maxZBlock);
        ObjectArraySet chunks = new ObjectArraySet(9);
        ChunkSource source = level.m_7726_();
        chunks.add(source.m_62227_(centerX, centerZ, true));
        if (minX != centerX) {
            chunks.add(source.m_62227_(minX, centerZ, true));
        }
        if (minZ != centerZ) {
            chunks.add(source.m_62227_(centerX, minZ, true));
        }
        if (maxX != centerX) {
            chunks.add(source.m_62227_(maxX, centerZ, true));
        }
        if (maxZ != centerZ) {
            chunks.add(source.m_62227_(centerX, maxZ, true));
        }
        chunks.add(source.m_62227_(minX, minZ, true));
        if (maxX != minX) {
            chunks.add(source.m_62227_(maxX, minZ, true));
        }
        if (maxZ != minZ) {
            chunks.add(source.m_62227_(minX, maxZ, true));
        }
        chunks.add(source.m_62227_(maxX, maxZ, true));
        ArrayList<TreeTrunkBlockEntity> nearbyTrunks = new ArrayList<TreeTrunkBlockEntity>(16);
        for (LevelChunk chunk : chunks) {
            for (BlockEntity entity : chunk.m_62954_().values()) {
                TreeTrunkBlockEntity other;
                if (!(entity instanceof TreeTrunkBlockEntity) || !(other = (TreeTrunkBlockEntity)entity).m_58900_().m_204336_(type.getTag()) || Math.abs(aroundPos.m_123342_() - other.f_58858_.m_123342_()) > gen.maxPossibleHeight) continue;
                nearbyTrunks.add(other);
            }
        }
        return nearbyTrunks;
    }

    public void updateBlocks(BlockPos destroyPos, @Nullable TreeGenerator.Data simulatedData, boolean leavesOnly) {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TreeTrunkBlock trunk = (TreeTrunkBlock)this.m_58900_().m_60734_();
        TreeGenerator gen = trunk.treeGenerator;
        if (simulatedData == null) {
            simulatedData = gen.getTree((WorldGenLevel)serverLevel, this, true);
        }
        ObjectOpenHashSet currentTree = destroyPos.equals((Object)this.f_58858_) ? new ObjectOpenHashSet(0) : this.getTree();
        int minX = this.f_58858_.m_123341_() - gen.maxLeavesDistXZ;
        int maxX = this.f_58858_.m_123341_() + gen.maxLeavesDistXZ;
        int minZ = this.f_58858_.m_123343_() - gen.maxLeavesDistXZ;
        int maxZ = this.f_58858_.m_123343_() + gen.maxLeavesDistXZ;
        List<TreeTrunkBlockEntity> nearbyTrunks = TreeTrunkBlockEntity.getNearbyTrunks(this.f_58857_, trunk.type, this.f_58858_, minX, maxX, minZ, maxZ);
        ObjectOpenHashSet nearbyTrees = new ObjectOpenHashSet(60 * nearbyTrunks.size());
        for (TreeTrunkBlockEntity nearbyTrunk : nearbyTrunks) {
            if (nearbyTrunk == this) continue;
            nearbyTrees.addAll(nearbyTrunk.getTree());
        }
        int leavesDestroyed = 0;
        updating = true;
        for (BlockPos pos : simulatedData.collectLeaves()) {
            BlockState state;
            boolean isLeaves;
            if (currentTree.contains((Object)pos) || !(isLeaves = (state = serverLevel.m_8055_(pos)).m_60713_((Block)trunk.leavesBlock)) && !state.m_60713_((Block)trunk.branchesBlock) && !state.m_60713_((Block)trunk.fruitBlock) || nearbyTrees.contains((Object)pos)) continue;
            LevelUtil.uncheckedDropDestroyBlockNoSound(this.f_58857_, pos, state, Blocks.f_50016_.m_49966_(), null, 3);
            if (!isLeaves) continue;
            ++leavesDestroyed;
        }
        if (!leavesOnly) {
            int woodDestroyed = 0;
            for (BlockPos pos : simulatedData.collectWood()) {
                BlockState state;
                if (currentTree.contains((Object)pos) || !(state = serverLevel.m_8055_(pos)).m_60713_((Block)trunk.stemBlock) || nearbyTrees.contains((Object)pos)) continue;
                LevelUtil.uncheckedDropDestroyBlockNoSound(this.f_58857_, pos, state, Blocks.f_50016_.m_49966_(), null, 3);
                ++woodDestroyed;
            }
            if (leavesDestroyed > 5) {
                this.f_58857_.m_5594_(null, destroyPos, woodDestroyed >= 15 && leavesDestroyed >= 50 ? (SoundEvent)SoundsNF.BIG_TREE_FALL.get() : (SoundEvent)SoundsNF.SMALL_TREE_FALL.get(), SoundSource.BLOCKS, 1.0f, 0.96f + this.f_58857_.m_5822_().nextFloat() * 0.08f);
            } else if (woodDestroyed > 2) {
                this.f_58857_.m_5594_(null, destroyPos, (SoundEvent)SoundsNF.LOG_FALL.get(), SoundSource.BLOCKS, 1.0f, 0.92f + this.f_58857_.m_5822_().nextFloat() * 0.16f);
            }
        }
        updating = false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.seed = tag.m_128454_("seed");
        this.lastTick = tag.m_128454_("lastTick");
        this.maxHeight = tag.m_128451_("maxHeight");
        this.hasFruited = tag.m_128471_("hasFruited");
        this.special = tag.m_128471_("special");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("seed", this.seed);
        tag.m_128356_("lastTick", this.lastTick);
        tag.m_128405_("maxHeight", this.maxHeight);
        tag.m_128379_("hasFruited", this.hasFruited);
        tag.m_128379_("special", this.special);
    }
}

