/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.fluid;

import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.StoneBlock;
import frostnox.nightfall.block.fluid.SizedFluid;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class LavaFluidNF
extends SizedFluid {
    protected LavaFluidNF(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public void m_7449_(Level level, BlockPos pos, FluidState state, Random random) {
        block7: {
            if (!level.m_46469_().m_46207_(GameRules.f_46131_)) break block7;
            int i = random.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if (!level.m_46749_(blockpos = blockpos.m_142082_(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState blockstate = level.m_8055_(blockpos);
                    if (blockstate.m_60795_()) {
                        if (!this.hasFlammableNeighbours((LevelReader)level, blockpos)) continue;
                        level.m_46597_(blockpos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)blockpos, (BlockPos)pos, (BlockState)Blocks.f_50083_.m_49966_()));
                        return;
                    }
                    if (!blockstate.m_60767_().m_76334_()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = pos.m_142082_(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                    if (!level.m_46749_(blockpos1)) {
                        return;
                    }
                    if (!level.m_46859_(blockpos1.m_7494_()) || !this.isFlammable((LevelReader)level, blockpos1, Direction.UP)) continue;
                    level.m_46597_(blockpos1.m_7494_(), ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)blockpos1.m_7494_(), (BlockPos)pos, (BlockState)Blocks.f_50083_.m_49966_()));
                }
            }
        }
    }

    public void m_6292_(Level level, BlockPos pos, FluidState state) {
        super.m_6292_(level, pos, state);
        for (Direction dir : Direction.values()) {
            BlockPos spreadPos = pos.m_142300_(dir);
            BlockState spreadState = level.m_8055_(spreadPos);
            LevelUtil.spreadHeat(level, spreadPos, spreadState, TieredHeat.RED, dir.m_122424_());
        }
    }

    private boolean hasFlammableNeighbours(LevelReader level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.isFlammable(level, pos.m_142300_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private boolean isFlammable(LevelReader level, BlockPos pos, Direction face) {
        return pos.m_123342_() >= level.m_141937_() && pos.m_123342_() < level.m_151558_() && !level.m_46805_(pos) ? false : level.m_8055_(pos).isFlammable((BlockGetter)level, pos, face);
    }

    private void fizz(LevelAccessor level, BlockPos pos) {
        level.m_46796_(1501, pos, 0);
    }

    public void m_7450_(Level level, BlockPos pos, FluidState state, Random random) {
        BlockPos blockpos = pos.m_7494_();
        if (level.m_8055_(blockpos).m_60795_() && !level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos)) {
            if (random.nextInt(100) == 0) {
                double d0 = (double)pos.m_123341_() + random.nextDouble();
                double d1 = (double)pos.m_123342_() + 1.0;
                double d2 = (double)pos.m_123343_() + random.nextDouble();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, d0, d1, d2, 0.0, 0.0, 0.0);
                level.m_7785_(d0, d1, d2, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
            if (random.nextInt(200) == 0) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12030_, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    @Nullable
    public ParticleOptions m_7792_() {
        return (ParticleOptions)ParticleTypesNF.DRIPPING_LAVA.get();
    }

    protected boolean m_5486_(FluidState state, BlockGetter level, BlockPos pos, Fluid fluidIn, Direction direction) {
        return state.m_76155_(level, pos) >= 0.44444445f && fluidIn.m_205067_(FluidTags.f_13131_);
    }

    protected void m_6364_(LevelAccessor level, BlockPos pos, BlockState pBlockState, Direction pDirection, FluidState pFluidState) {
        if (pDirection == Direction.DOWN) {
            FluidState fluidstate = level.m_6425_(pos);
            if (this.m_205067_(FluidTags.f_13132_) && fluidstate.m_205070_(FluidTags.f_13131_)) {
                if (pBlockState.m_60734_() instanceof LiquidBlock) {
                    level.m_7731_(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)pos, (BlockState)((StoneBlock)((Object)BlocksNF.STONE_BLOCKS.get(Stone.PUMICE).get())).m_49966_()), 3);
                }
                this.fizz(level, pos);
                return;
            }
        }
        super.m_6364_(level, pos, pBlockState, pDirection, pFluidState);
    }

    protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
        this.fizz(level, pos);
    }

    public static class Source
    extends LavaFluidNF {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int m_7430_(FluidState state) {
            return 4;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends LavaFluidNF {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(3)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

