/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.block.fluid;

import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.block.fluid.SizedFluid;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class WaterFluidNF
extends SizedFluid {
    protected WaterFluidNF(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public void m_7450_(Level level, BlockPos pos, FluidState state, Random random) {
        if (!state.m_76170_() && !((Boolean)state.m_61143_((Property)f_75947_)).booleanValue()) {
            if (random.nextInt(64) == 0) {
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12540_, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123768_, (double)pos.m_123341_() + random.nextDouble(), (double)pos.m_123342_() + random.nextDouble(), (double)pos.m_123343_() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public ParticleOptions m_7792_() {
        return (ParticleOptions)ParticleTypesNF.DRIPPING_WATER.get();
    }

    public boolean m_6212_(Fluid pFluid) {
        return pFluid instanceof WaterFluidNF;
    }

    protected boolean m_5486_(FluidState state, BlockGetter level, BlockPos pos, Fluid fluidIn, Direction direction) {
        return direction == Direction.DOWN && !super.m_6212_(fluidIn);
    }

    protected boolean m_76096_(FluidState state) {
        return state.m_76170_() && super.m_6212_(state.m_76152_());
    }

    protected boolean m_75956_(BlockGetter p_75957_, Fluid p_75958_, BlockPos p_75959_, BlockState p_75960_, BlockPos p_75961_, BlockState p_75962_) {
        if (!this.m_76061_(Direction.DOWN, p_75957_, p_75959_, p_75960_, p_75961_, p_75962_)) {
            return false;
        }
        return super.m_6212_(p_75962_.m_60819_().m_76152_()) || this.m_75972_(p_75957_, p_75961_, p_75962_, p_75958_);
    }

    public void m_6292_(Level level, BlockPos pos, FluidState state) {
        if (!state.m_76170_()) {
            FluidState fluidstate = this.m_76035_((LevelReader)level, pos, level.m_8055_(pos));
            int i = this.m_6886_(level, pos, state, fluidstate);
            BlockState blockState = level.m_8055_(pos);
            if (fluidstate.m_76178_()) {
                state = fluidstate;
                level.m_7731_(pos, blockState.m_60734_() instanceof IWaterloggedBlock ? (BlockState)((BlockState)blockState.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(BlockStatePropertiesNF.WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.fromFluid(fluidstate.m_76152_()))) : Blocks.f_50016_.m_49966_(), 3);
            } else if (!fluidstate.equals(state)) {
                state = fluidstate;
                BlockState newBlock = blockState.m_60734_() instanceof IWaterloggedBlock ? (BlockState)((BlockState)blockState.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(fluidstate.m_76186_()))).m_61124_(BlockStatePropertiesNF.WATERLOG_TYPE, (Comparable)((Object)IWaterloggedBlock.WaterlogType.fromFluid(fluidstate.m_76152_()))) : fluidstate.m_76188_();
                level.m_7731_(pos, newBlock, 2);
                level.m_186469_(pos, fluidstate.m_76152_(), i);
                level.m_46672_(pos, newBlock.m_60734_());
            }
        }
        this.m_76010_((LevelAccessor)level, pos, state);
    }

    @Override
    protected FluidState m_76035_(LevelReader level, BlockPos pos, BlockState state) {
        int fluidLevel;
        Fluid maxSourceCount2;
        BlockPos abovePos;
        BlockState aboveBlock;
        FluidState aboveFluid;
        BlockState neighborBlock;
        FluidState currentState = state.m_60819_();
        int maxLevel = currentState.m_76186_();
        WaterFluidNF maxFluid = this;
        HashMap<WaterFluidNF, Integer> sourceCounts = new HashMap<WaterFluidNF, Integer>();
        int totalSourceCount = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int neighborAmount;
            BlockPos neighborPos = pos.m_142300_(direction);
            neighborBlock = level.m_8055_(neighborPos);
            FluidState neighborFluid = neighborBlock.m_60819_();
            Fluid fluid = neighborFluid.m_76152_();
            if (!(fluid instanceof WaterFluidNF)) continue;
            WaterFluidNF neighborType = (WaterFluidNF)fluid;
            if (!this.m_76061_(direction, (BlockGetter)level, pos, state, neighborPos, neighborBlock)) continue;
            if (neighborFluid.m_76170_() && ForgeEventFactory.canCreateFluidSource((LevelReader)level, (BlockPos)neighborPos, (BlockState)neighborBlock, (boolean)this.m_6760_())) {
                sourceCounts.put(neighborType, sourceCounts.getOrDefault((Object)neighborType, 0) + 1);
                ++totalSourceCount;
            }
            if ((neighborAmount = neighborFluid.m_76186_()) > maxLevel) {
                maxLevel = neighborAmount;
                maxFluid = neighborType;
                continue;
            }
            if (neighborAmount != maxLevel || !super.m_6212_((Fluid)neighborType)) continue;
            maxFluid = this;
        }
        if (totalSourceCount >= 2) {
            WaterFluidNF belowType;
            BlockState belowBlock = level.m_8055_(pos.m_7495_());
            FluidState belowFluid = belowBlock.m_60819_();
            if (belowFluid.m_76170_() && (neighborBlock = belowFluid.m_76152_()) instanceof WaterFluidNF && sourceCounts.getOrDefault((Object)(belowType = (WaterFluidNF)neighborBlock), 0) >= 2) {
                return belowType.m_76068_(false);
            }
            if (belowBlock.m_60767_().m_76333_()) {
                WaterFluidNF maxSourceFluid = this;
                int maxSourceCount2 = 0;
                for (Map.Entry entry : sourceCounts.entrySet()) {
                    if ((Integer)entry.getValue() > maxSourceCount2) {
                        maxSourceCount2 = (Integer)entry.getValue();
                        maxSourceFluid = (WaterFluidNF)((Object)entry.getKey());
                        continue;
                    }
                    if ((Integer)entry.getValue() != maxSourceCount2) continue;
                    maxSourceFluid = this;
                }
                return maxSourceFluid.m_76068_(false);
            }
        }
        if (!(aboveFluid = (aboveBlock = level.m_8055_(abovePos = pos.m_7494_())).m_60819_()).m_76178_() && (maxSourceCount2 = aboveFluid.m_76152_()) instanceof WaterFluidNF) {
            WaterFluidNF aboveType = (WaterFluidNF)maxSourceCount2;
            if (this.m_76061_(Direction.UP, (BlockGetter)level, pos, state, abovePos, aboveBlock)) {
                if (currentState.m_76170_()) {
                    return currentState;
                }
                return aboveType.m_75953_(aboveType.m_5613_().m_7430_(aboveFluid), true);
            }
        }
        return (fluidLevel = maxLevel - maxFluid.m_6713_(level)) <= 0 ? Fluids.f_76191_.m_76145_() : maxFluid.m_75953_(fluidLevel, false);
    }

    public static class Source
    extends WaterFluidNF {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int m_7430_(FluidState state) {
            return 6;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends WaterFluidNF {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(6)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

