/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.capability;

import com.google.common.collect.Lists;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.HitData;
import frostnox.nightfall.action.player.IClientAction;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.effect.DamageEffect;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.capability.StatusToClient;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.data.Vec3f;
import frostnox.nightfall.util.math.BoundingSphere;
import frostnox.nightfall.util.math.Easing;
import frostnox.nightfall.util.math.Mat4f;
import frostnox.nightfall.util.math.Quat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ActionTracker
implements IActionTracker {
    public static final Capability<IActionTracker> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IActionTracker>(){});
    private static final UUID UNDERWATER_SPEED_MODIFIER_UUID = UUID.fromString("48be4186-aa6c-476d-917a-4f07882832f4");
    private static final AttributeModifier UNDERWATER_SPEED_MODIFIER = new AttributeModifier(UNDERWATER_SPEED_MODIFIER_UUID, "Underwater speed penalty", 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final LivingEntity user;
    private ResourceLocation actionID = ActionsNF.EMPTY.getId();
    private int frame;
    private int duration;
    private int state;
    private int charge;
    private float speedMultiplier;
    private boolean queue;
    private int stunFrame;
    private int stunDuration;
    private int blockInvulnerableTime;
    private int movingBlockInvulnerableTime;
    private int dotInvulnerableTime;
    private int bleedTime;
    private int poisonTime;
    private int livingEntitiesHit;
    private final List<Integer> hitEntities;
    private float lastChargePartial;
    private Vec3 lastPosition;
    private BoundingSphere[] lastHurtSpheres;
    private float hitPause = -1.0f;

    public ActionTracker(LivingEntity entity) {
        this.user = entity;
        this.frame = -1;
        this.duration = 1;
        this.stunFrame = -1;
        this.stunDuration = 1;
        this.queue = false;
        this.hitEntities = Lists.newArrayList();
    }

    @Override
    public LivingEntity getEntity() {
        return this.user;
    }

    @Override
    public ResourceLocation getActionID() {
        return this.actionID;
    }

    @Override
    public void setActionID(ResourceLocation id) {
        this.actionID = id;
    }

    @Override
    public int getFrame() {
        return this.frame;
    }

    @Override
    public void setFrame(int frame) {
        this.frame = Mth.m_14045_((int)frame, (int)-1, (int)9999);
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = Mth.m_14045_((int)duration, (int)1, (int)9999);
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setState(int state) {
        this.state = Math.max(0, state);
    }

    @Override
    public int getCharge() {
        return this.charge;
    }

    @Override
    public void setCharge(int charge) {
        this.charge = this.getAction() != null ? Mth.m_14045_((int)charge, (int)0, (int)this.getAction().getMaxCharge()) : Math.max(0, charge);
    }

    @Override
    public float getChargePartial() {
        return this.lastChargePartial;
    }

    @Override
    public void setChargePartial(float partial) {
        this.lastChargePartial = partial;
    }

    @Override
    public float getChargeAttackMultiplier() {
        if (this.charge <= 0) {
            return 1.0f;
        }
        float minCharge = this.getAction().getRequiredCharge(this.user);
        return 1.0f + Mth.m_14036_((float)(((float)this.charge - minCharge) / ((float)this.getAction().getMaxCharge() - minCharge) * 0.5f), (float)0.0f, (float)0.5f);
    }

    @Override
    public float getChargeDestroyProgressMultiplier() {
        if (this.charge <= 0) {
            return 1.0f;
        }
        return 1.0f + Math.min(1.0f, (float)this.charge / (float)this.getAction().getMaxCharge());
    }

    @Override
    public boolean isFullyCharged() {
        return this.charge >= this.getAction().getMaxCharge();
    }

    @Override
    public float getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    @Override
    public boolean isQueued() {
        return this.queue;
    }

    @Override
    public void queue() {
        this.queue = true;
    }

    @Override
    public void dequeue() {
        this.queue = false;
    }

    @Override
    public void releaseCharge() {
        if (this.isCharging()) {
            this.queue();
        }
    }

    @Override
    public int getStunFrame() {
        return this.stunFrame;
    }

    @Override
    public int getStunDuration() {
        return this.stunDuration;
    }

    @Override
    public void setStunFrame(int frame) {
        this.stunFrame = Mth.m_14045_((int)frame, (int)-1, (int)9999);
    }

    @Override
    public void setStunDuration(int duration) {
        this.stunDuration = Mth.m_14045_((int)duration, (int)1, (int)9999);
    }

    @Override
    public int getBlockInvulnerableTime() {
        return this.blockInvulnerableTime;
    }

    @Override
    public void setBlockInvulnerableTime(int time) {
        this.blockInvulnerableTime = Math.max(0, time);
    }

    @Override
    public int getMovingBlockInvulnerableTime() {
        return this.movingBlockInvulnerableTime;
    }

    @Override
    public void setMovingBlockInvulnerableTime(int time) {
        this.movingBlockInvulnerableTime = Math.max(0, time);
    }

    @Override
    public int getDotInvulnerableTime() {
        return this.dotInvulnerableTime;
    }

    @Override
    public void setDotInvulnerableTime(int time) {
        this.dotInvulnerableTime = Math.max(0, time);
    }

    @Override
    public int getBleedDuration() {
        return this.bleedTime;
    }

    @Override
    public void setBleedDuration(int duration) {
        this.bleedTime = Math.max(0, duration);
    }

    @Override
    public int getPoisonDuration() {
        return this.poisonTime;
    }

    @Override
    public void setPoisonDuration(int duration) {
        this.poisonTime = Math.max(0, duration);
    }

    @Override
    public List<Integer> getHitEntities() {
        return this.hitEntities;
    }

    @Override
    public int getLivingEntitiesHit() {
        return this.livingEntitiesHit;
    }

    @Override
    public void setLivingEntitiesHit(int amount) {
        this.livingEntitiesHit = Math.max(0, amount);
    }

    @Override
    public Vec3 getLastPosition() {
        return this.lastPosition;
    }

    @Override
    public void setLastPosition(Vec3 pos) {
        this.lastPosition = pos;
    }

    @Override
    public float getProgress(float partial) {
        if (this.isCharging()) {
            float max = this.getAction().getRequiredCharge(this.user);
            if (max == 0.0f) {
                return 1.0f;
            }
            return Math.min(1.0f, Mth.m_14179_((float)this.modifyPartialTick(partial), (float)((float)(this.frame - 1) / max), (float)((float)this.frame / max)));
        }
        return Mth.m_14179_((float)this.modifyPartialTick(partial), (float)((float)(this.frame - 1) / (float)this.duration), (float)((float)this.frame / (float)this.duration));
    }

    @Override
    public void tick() {
        AttributeInstance actionSpeed = this.user.m_21051_((Attribute)AttributesNF.ACTION_SPEED.get());
        if (actionSpeed.m_22111_(UNDERWATER_SPEED_MODIFIER_UUID) != null) {
            actionSpeed.m_22130_(UNDERWATER_SPEED_MODIFIER);
        }
        if (this.user.m_5842_() && !this.user.m_6095_().m_204039_(TagsNF.AQUATIC_ENTITY)) {
            this.user.m_21051_((Attribute)AttributesNF.ACTION_SPEED.get()).m_22118_(UNDERWATER_SPEED_MODIFIER);
        }
        if (this.stunFrame != -1) {
            ++this.stunFrame;
            if (this.stunFrame > this.stunDuration) {
                this.stunFrame = -1;
                this.frame = -1;
                this.state = 0;
                this.charge = 0;
                this.hitPause = -1.0f;
                this.dequeue();
                this.startAction(ActionsNF.EMPTY.getId());
            }
        } else {
            Action action = this.getAction();
            if (action == null) {
                this.startAction(ActionsNF.EMPTY.getId());
                action = this.getAction();
            }
            if (this.frame != -1) {
                if (this.hitPause >= 0.0f) {
                    this.hitPause = -1.0f;
                } else {
                    ++this.frame;
                }
            }
            if (this.queue) {
                if (this.state == action.getChargeState()) {
                    if (this.frame >= action.getRequiredCharge(this.user)) {
                        this.charge = this.frame;
                        action.onChargeRelease(this.user);
                        this.moveState();
                    }
                } else if (action.hasDefaultChain() || action.hasConditionalChain()) {
                    if (action.getChainState() == this.state) {
                        action.onChainStart(this.user);
                        this.startAction(action.getChain(this.user).getId());
                    }
                } else {
                    this.dequeue();
                }
            }
            if (this.state == action.getChargeState()) {
                if (this.frame > action.getChargeTimeout() || !action.canContinueCharging(this.user)) {
                    this.charge = this.frame;
                    action.onChargeRelease(this.user);
                    this.moveState();
                }
            } else if (this.frame > this.duration) {
                if (action.isIdle() && this.state == action.getTotalStates() - 1) {
                    this.frame = 1;
                } else {
                    this.moveState();
                }
            }
        }
        this.setBlockInvulnerableTime(this.blockInvulnerableTime - 1);
        this.setMovingBlockInvulnerableTime(this.movingBlockInvulnerableTime - 1);
        this.setDotInvulnerableTime(this.dotInvulnerableTime - 1);
        if (this.bleedTime == 1 && !this.user.f_19853_.f_46443_) {
            NetworkHandler.toAllTrackingAndSelf((Entity)this.user, new StatusToClient(0, this.user.m_142049_(), StatusToClient.Status.BLEEDING));
        }
        this.setBleedDuration(this.bleedTime - 1);
        if (this.poisonTime == 1 && !this.user.f_19853_.f_46443_) {
            NetworkHandler.toAllTrackingAndSelf((Entity)this.user, new StatusToClient(0, this.user.m_142049_(), StatusToClient.Status.POISON));
        }
        this.setPoisonDuration(this.poisonTime - 1);
        if (!this.user.f_19853_.m_5776_() && this.dotInvulnerableTime == 0) {
            float damage = 0.0f;
            float highestDamage = 0.0f;
            DamageTypeSource strongestSource = DamageTypeSource.ON_FIRE;
            if (this.user.m_6060_()) {
                damage += 5.0f;
                highestDamage = 5.0f;
            }
            for (MobEffectInstance effectInstance : this.user.m_21220_()) {
                MobEffect mobEffect = effectInstance.m_19544_();
                if (!(mobEffect instanceof DamageEffect)) continue;
                DamageEffect effect = (DamageEffect)mobEffect;
                float effectDamage = effect.getDamage(this.user, effectInstance.m_19557_(), effectInstance.m_19564_());
                if (effectDamage > 0.0f) {
                    damage += effectDamage;
                }
                if (!(effectDamage > highestDamage)) continue;
                highestDamage = effectDamage;
                strongestSource = effect.damageSource;
            }
            if (damage > 0.0f) {
                this.user.m_6469_((DamageSource)strongestSource, damage);
            }
            this.dotInvulnerableTime = 40;
        }
    }

    @Override
    public void moveState() {
        Action action = this.getAction();
        if (this.state >= action.getTotalStates() - 1) {
            if (action.shouldFreeze()) {
                this.frame = this.duration + 1;
            } else {
                this.startAction(ActionsNF.EMPTY.getId());
            }
        } else {
            ++this.state;
            this.hitEntities.clear();
            this.livingEntitiesHit = 0;
            this.lastHurtSpheres = null;
            this.frame = 1;
            this.setDuration(action.getDuration(this.state, this.user));
        }
    }

    @Override
    public boolean isInactive() {
        if (this.stunFrame != -1) {
            return false;
        }
        if (this.actionID.equals((Object)ActionsNF.EMPTY.getId())) {
            return true;
        }
        if (this.frame == -1) {
            return true;
        }
        Action action = this.getAction();
        return action.isInterruptible() && action.isIdle();
    }

    @Override
    public boolean isDamaging() {
        if (this.frame > -1 && !this.isStunnedOrHitPaused()) {
            Action action = this.getAction();
            return action.isDamaging(this);
        }
        return false;
    }

    @Override
    public boolean isCharging() {
        return this.state == this.getAction().getChargeState();
    }

    @Override
    public Action getAction() {
        return ActionsNF.get(this.actionID);
    }

    @Override
    public void startAction(ResourceLocation actionID) {
        Action action = this.getAction();
        if (action != null) {
            action.onEnd(this.user);
        }
        this.setActionID(actionID);
        action = this.getAction();
        this.frame = 1;
        this.state = 0;
        this.speedMultiplier = (float)this.user.m_21133_((Attribute)AttributesNF.ACTION_SPEED.get());
        this.setDuration(action.getDuration(this.state, this.user));
        this.charge = 0;
        this.dequeue();
        this.hitEntities.clear();
        this.livingEntitiesHit = 0;
        this.stunFrame = -1;
        LivingEntity livingEntity = this.user;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PlayerData.get(player).setInteracted(false);
        }
        action.onStart(this.user);
    }

    @Override
    public void stunServer(int duration, boolean force) {
        if (this.user.f_19853_.m_5776_()) {
            return;
        }
        this.stun(duration, force);
        NetworkHandler.toAllTrackingAndSelf((Entity)this.user, new StatusToClient(this.stunDuration, this.user.m_142049_(), StatusToClient.Status.STUN));
    }

    @Override
    public void stun(int duration, boolean force) {
        if (this.stunFrame == -1 || force) {
            this.stunFrame = 0;
            this.setStunDuration(duration);
            this.dequeue();
        }
    }

    @Override
    public boolean isStunned() {
        return this.stunFrame > -1;
    }

    @Override
    public boolean isStunnedOrHitPaused() {
        return this.isStunned() || this.hasHitPause();
    }

    @Override
    public float modifyPartialTick(float partialTick) {
        if (this.isStunned()) {
            return 1.0f;
        }
        if (this.hasHitPause()) {
            return this.hitPause;
        }
        return partialTick;
    }

    @Override
    public void setHitPause(float hitPause) {
        this.hitPause = hitPause;
    }

    @Override
    public boolean hasHitPause() {
        return this.hitPause >= 0.0f;
    }

    @Override
    public BoundingSphere[] getLastHurtSpheres() {
        return this.lastHurtSpheres;
    }

    private BoundingSphere[] getTransformedSpheres(Attack attack, float partialTicks) {
        BoundingSphere[] spheres = attack.getHurtSpheres(this.user).getSpheres();
        Mat4f userMatrix = new Mat4f();
        LivingEntity livingEntity = this.user;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            userMatrix.multiply(new Quat(Mth.m_14179_((float)partialTicks, (float)ClientEngine.get().getLastXRot(), (float)player.m_146909_()), Vector3f.f_122222_, true));
            userMatrix.multiply(new Quat(Mth.m_14179_((float)partialTicks, (float)ClientEngine.get().getLastYRot(), (float)player.m_146908_()), Vector3f.f_122225_, true));
            translation = attack.getTranslation((LivingEntity)player);
            int frame = this.getFrame();
            int duration = this.getDuration();
            int side = PlayerData.get(player).getActiveHand() == InteractionHand.MAIN_HAND ? 1 : -1;
            AnimationData data = attack.getAnimationData((LivingEntity)player, this).get((Object)EntityPart.HAND_RIGHT);
            data.update(partialTicks);
            if (attack instanceof IClientAction) {
                IClientAction clientAction = (IClientAction)((Object)attack);
                clientAction.transformModelFP(this.getState(), frame, duration, attack.getChargeProgress(this.getCharge(), this.getChargePartial()), (LivingEntity)player, data);
            }
            Vector3f offset = attack.getOffset(this.user);
            for (int i = 0; i < spheres.length; ++i) {
                spheres[i].transformFP(data, userMatrix, (Vector3f)translation, offset, side != 1);
                spheres[i].yPos += (double)player.m_20192_();
            }
        } else {
            translation = this.user;
            if (translation instanceof ActionableEntity) {
                ActionableEntity actionable = (ActionableEntity)translation;
                AnimationCalculator mCalc = new AnimationCalculator();
                AnimationData layer = new AnimationData();
                Mat4f localMatrix = new Mat4f();
                userMatrix = new Mat4f(new Quat(actionable.getAttackYRot(1.0f), Vector3f.f_122225_, true));
                int frame = this.getFrame();
                int duration = this.getDuration();
                EnumMap<EntityPart, AnimationData> transforms = attack.getAnimationData(this.user, this);
                for (AnimationData transform : transforms.values()) {
                    transform.update(partialTicks);
                }
                mCalc.update(this.getFrame(), this.getDuration(), partialTicks, Easing.inOutSine);
                layer.update(this.getFrame(), this.getDuration(), partialTicks, Easing.inOutSine);
                Action action = this.getAction();
                attack.transformModel(this.getState(), frame, duration, action.getChargeProgress(this.getCharge(), this.getChargePartial()), attack.getPitch(this.user, partialTicks), this.user, transforms, mCalc);
                attack.transformLayer(this.getState(), frame, duration, action.getChargeProgress(this.getCharge(), this.getChargePartial()), this.user, layer);
                Vector3f mVec = mCalc.getTransformations();
                userMatrix.multiply(new Quat(mVec.m_122260_(), Vector3f.f_122225_, true));
                Vector3f lVec = layer.rCalc.getTransformations();
                localMatrix.multiply(new Quat(lVec.m_122269_(), Vector3f.f_122227_, true));
                localMatrix.multiply(new Quat(lVec.m_122260_(), Vector3f.f_122225_, true));
                localMatrix.multiply(new Quat(lVec.m_122239_(), Vector3f.f_122223_, true));
                Vector3f offset = attack.getOffset(this.user);
                Vector3f translation = attack.getTranslation(this.user);
                AnimationData[] transformsArray = transforms.values().toArray(new AnimationData[0]);
                for (int i = 0; i < spheres.length; ++i) {
                    spheres[i].transform(transformsArray, userMatrix, localMatrix, translation, offset);
                }
            }
        }
        Vec3 pos = this.user instanceof Player ? ClientEngine.get().getPlayerPosition(partialTicks) : this.user.m_20318_(partialTicks);
        for (int i = 0; i < spheres.length; ++i) {
            spheres[i].translate(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        }
        return spheres;
    }

    @Override
    public List<HitData> getEntitiesInAttack(Attack attack, float partialTicks) {
        ArrayList hitTargets = Lists.newArrayList();
        int maxTargets = attack.getMaxTargets();
        if ((maxTargets -= this.getLivingEntitiesHit()) <= 0) {
            return hitTargets;
        }
        if (this.lastHurtSpheres == null) {
            this.lastHurtSpheres = this.getTransformedSpheres(attack, 0.0f);
        }
        BoundingSphere[] spheres = this.getTransformedSpheres(attack, partialTicks);
        if (this.user.f_19853_.m_5776_() && Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (int i = 0; i < spheres.length; ++i) {
                this.user.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, spheres[i].xPos, spheres[i].yPos, spheres[i].zPos, 0.0, 0.0, 0.0);
            }
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (BoundingSphere s : spheres) {
            double sMinX = s.xPos - s.radius;
            double sMinY = s.yPos - s.radius;
            double sMinZ = s.zPos - s.radius;
            double sMaxX = s.xPos + s.radius;
            double sMaxY = s.yPos + s.radius;
            double sMaxZ = s.zPos + s.radius;
            if (sMinX < minX) {
                minX = sMinX;
            }
            if (sMinY < minY) {
                minY = sMinY;
            }
            if (sMinZ < minZ) {
                minZ = sMinZ;
            }
            if (sMaxX > maxX) {
                maxX = sMaxX;
            }
            if (sMaxY > maxY) {
                maxY = sMaxY;
            }
            if (!(sMaxZ > maxZ)) continue;
            maxZ = sMaxZ;
        }
        List<Entity> entities = CombatUtil.getAttackableEntitiesNearby(new AABB(minX, minY, minZ, maxX, maxY, maxZ).m_82400_(1.0), this.user, this.user.f_19853_);
        for (int i = 0; i < spheres.length; ++i) {
            boolean max = false;
            for (Entity entity : entities) {
                if (this.getHitEntities().contains(entity.m_142049_())) continue;
                HitData hitData = new HitData(entity);
                if (spheres[i].intersectsAndSeesEntity(this.user, entity, hitData)) {
                    if (entity instanceof LivingEntity) {
                        this.setLivingEntitiesHit(this.getLivingEntitiesHit() + 1);
                    }
                    this.getHitEntities().add(entity.m_142049_());
                    hitData.x -= (float)entity.m_20185_();
                    hitData.y -= (float)entity.m_20186_();
                    hitData.z -= (float)entity.m_20189_();
                    hitData.force = new Vec3f((float)(spheres[i].xPos - this.lastHurtSpheres[i].xPos), (float)(spheres[i].yPos - this.lastHurtSpheres[i].yPos), (float)(spheres[i].zPos - this.lastHurtSpheres[i].zPos)).normalize();
                    hitTargets.add(hitData);
                }
                if (hitTargets.size() < maxTargets) continue;
                max = true;
                break;
            }
            if (max) break;
        }
        this.lastHurtSpheres = spheres;
        return hitTargets;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag NBT = new CompoundTag();
        NBT.m_128359_("id", this.getActionID().toString());
        NBT.m_128405_("frame", this.getFrame());
        NBT.m_128405_("duration", this.getDuration());
        NBT.m_128405_("state", this.getState());
        NBT.m_128405_("charge", this.getCharge());
        NBT.m_128350_("speedMod", this.speedMultiplier);
        NBT.m_128379_("queue", this.isQueued());
        NBT.m_128405_("stunFrame", this.getStunFrame());
        NBT.m_128405_("stunDuration", this.getStunDuration());
        NBT.m_128405_("blockInvulnerableTime", this.getBlockInvulnerableTime());
        NBT.m_128405_("movingBlockInvulnerableTime", this.getMovingBlockInvulnerableTime());
        NBT.m_128405_("dotInvulnerableTime", this.getDotInvulnerableTime());
        NBT.m_128405_("bleedDuration", this.getBleedDuration());
        NBT.m_128405_("poisonDuration", this.getPoisonDuration());
        NBT.m_128405_("entitiesHit", this.getLivingEntitiesHit());
        return NBT;
    }

    @Override
    public void readNBT(CompoundTag NBT) {
        this.setActionID(ResourceLocation.parse((String)(NBT.m_128441_("id") ? NBT.m_128461_("id") : ActionsNF.EMPTY.getId().toString())));
        this.setFrame(NBT.m_128451_("frame"));
        this.duration = NBT.m_128451_("duration");
        this.setState(NBT.m_128451_("state"));
        this.setCharge(NBT.m_128451_("charge"));
        this.speedMultiplier = NBT.m_128457_("speedMod");
        if (NBT.m_128471_("queue")) {
            this.queue();
        } else {
            this.dequeue();
        }
        this.setStunFrame(NBT.m_128451_("stunFrame"));
        this.setStunDuration(NBT.m_128451_("stunDuration"));
        this.setBlockInvulnerableTime(NBT.m_128451_("blockInvulnerableTime"));
        this.setMovingBlockInvulnerableTime(NBT.m_128451_("movingBlockInvulnerableTime"));
        this.setDotInvulnerableTime(NBT.m_128451_("dotInvulnerableTime"));
        this.setBleedDuration(NBT.m_128451_("bleedDuration"));
        this.setPoisonDuration(NBT.m_128451_("poisonDuration"));
        this.setLivingEntitiesHit(NBT.m_128451_("entitiesHit"));
    }

    public static IActionTracker get(Entity entity) {
        return (IActionTracker)entity.getCapability(CAPABILITY, null).orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."));
    }

    public static boolean isPresent(Entity entity) {
        return entity.getCapability(CAPABILITY).isPresent();
    }

    public static class ActionTrackerCapability
    implements ICapabilitySerializable<CompoundTag> {
        private final ActionTracker cap;
        private final LazyOptional<IActionTracker> holder;

        public ActionTrackerCapability(LivingEntity entity) {
            this.cap = new ActionTracker(entity);
            this.holder = LazyOptional.of(() -> this.cap);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> c, Direction side) {
            return CAPABILITY == c ? this.holder : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.cap.writeNBT();
        }

        public void deserializeNBT(CompoundTag NBT) {
            this.cap.readNBT(NBT);
        }
    }
}

