/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.capability;

import com.google.common.collect.ImmutableSet;
import frostnox.nightfall.block.IDropsItems;
import frostnox.nightfall.block.IFallable;
import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.block.FrazilBlock;
import frostnox.nightfall.block.block.IceBlock;
import frostnox.nightfall.block.block.SnowBlock;
import frostnox.nightfall.capability.GlobalChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.MovingBlockEntity;
import frostnox.nightfall.network.message.world.ChunkClimateToClient;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.data.WrappedBool;
import frostnox.nightfall.world.Season;
import frostnox.nightfall.world.spawngroup.SpawnGroup;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntLongPair;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.tags.ITag;

public class ChunkData
implements IChunkData {
    public static final Capability<IChunkData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChunkData>(){});
    private final LevelChunk chunk;
    private final Level level;
    private final boolean clientSide;
    private long lastTickingGameTime = Long.MAX_VALUE;
    private long lastLoadedDayTime;
    private int ticksToSpawn = 0;
    private boolean isNew = true;
    private boolean spawnedUndead;
    private final float[] temperature = new float[256];
    private final float[] humidity = new float[256];
    private final float[] weather = new float[256];
    private final Set<BlockPos> physicsTicks;
    private final Set<BlockPos> wardingEffigies;
    private final Set<ObjectObjectImmutablePair<TickPriority, BlockPos>> timeSimulatables;
    private final Set<UUID> undeadIds;

    public ChunkData(LevelChunk chunk) {
        this.chunk = chunk;
        this.level = chunk.m_62953_();
        this.clientSide = chunk.m_62953_().f_46443_;
        if (this.clientSide) {
            this.physicsTicks = null;
            this.wardingEffigies = null;
            this.timeSimulatables = null;
            this.undeadIds = null;
        } else {
            Hash.Strategy<BlockPos> compactPosHash = new Hash.Strategy<BlockPos>(){

                public int hashCode(BlockPos pos) {
                    return DataUtil.hashPos(pos);
                }

                public boolean equals(BlockPos pos1, BlockPos pos2) {
                    if (pos1 == null || pos2 == null) {
                        return pos1 == pos2;
                    }
                    return pos1.m_123341_() == pos2.m_123341_() && pos1.m_123342_() == pos2.m_123342_() && pos1.m_123343_() == pos2.m_123343_();
                }
            };
            this.physicsTicks = new ObjectOpenCustomHashSet(8, (Hash.Strategy)compactPosHash);
            this.wardingEffigies = new ObjectOpenCustomHashSet(1, (Hash.Strategy)compactPosHash);
            this.timeSimulatables = new ObjectRBTreeSet((p1, p2) -> {
                int priority = Integer.compare(((TickPriority)p1.key()).m_193445_(), ((TickPriority)p2.key()).m_193445_());
                if (priority == 0) {
                    return Integer.compare(ChunkData.pseudoRandom(((BlockPos)p1.value()).hashCode()), ChunkData.pseudoRandom(((BlockPos)p2.value()).hashCode()));
                }
                return priority;
            });
            this.undeadIds = new ObjectOpenHashSet();
        }
    }

    private static int pseudoRandom(int val) {
        val = (val ^ 0x5A5A5A5A) * 73244475;
        return val ^ val >> 16;
    }

    private void init() {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (x % 5 == 0 && z % 5 == 0) continue;
                int minX = x / 5 * 5;
                int maxX = Math.min(15, minX + 5);
                int minZ = z / 5 * 5;
                int maxZ = Math.min(15, minZ + 5);
                float xAmount = (float)(x % 5) / 5.0f;
                float zAmount = (float)(z % 5) / 5.0f;
                this.setTemperature(x, z, MathUtil.lerp2D(xAmount, zAmount, this.getTemperature(minX, minZ), this.getTemperature(maxX, minZ), this.getTemperature(minX, maxZ), this.getTemperature(maxX, maxZ)));
                this.setHumidity(x, z, MathUtil.lerp2D(xAmount, zAmount, this.getHumidity(minX, minZ), this.getHumidity(maxX, minZ), this.getHumidity(minX, maxZ), this.getHumidity(maxX, maxZ)));
            }
        }
        for (int i = 0; i < this.weather.length; ++i) {
            float temp = this.temperature[i] - 0.5f;
            this.weather[i] = this.humidity[i] * (1.0f - 2.0f * temp * temp) * 0.3f;
        }
    }

    @Override
    public LevelChunk getChunk() {
        return this.chunk;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setOld() {
        if (this.isNew) {
            this.init();
        }
        this.isNew = false;
    }

    @Override
    public ChunkClimateToClient createClimateMessageToClient() {
        return new ChunkClimateToClient(this.chunk, this.temperature, this.humidity);
    }

    @Override
    public float getTemperature(BlockPos pos) {
        return this.getTemperature(pos.m_123341_(), pos.m_123343_());
    }

    @Override
    public float getTemperature(int x, int z) {
        return this.temperature[(x < 0 ? x % 16 + 16 : x) % 16 * 16 + (z < 0 ? z % 16 + 16 : z) % 16];
    }

    @Override
    public float getHumidity(BlockPos pos) {
        return this.getHumidity(pos.m_123341_(), pos.m_123343_());
    }

    @Override
    public float getHumidity(int x, int z) {
        return this.humidity[(x < 0 ? x % 16 + 16 : x) % 16 * 16 + (z < 0 ? z % 16 + 16 : z) % 16];
    }

    @Override
    public float getWeatherAddend(int x, int z) {
        return this.weather[(x < 0 ? x % 16 + 16 : x) % 16 * 16 + (z < 0 ? z % 16 + 16 : z) % 16];
    }

    @Override
    public void setTemperature(int x, int z, float temperature) {
        this.temperature[x * 16 + z] = temperature;
    }

    @Override
    public void setHumidity(int x, int z, float humidity) {
        this.humidity[x * 16 + z] = humidity;
    }

    @Override
    public boolean hasSpawnedUndead() {
        return this.spawnedUndead;
    }

    @Override
    public void setSpawnedUndead(boolean spawned) {
        this.spawnedUndead = spawned;
    }

    @Override
    public long getLastTickingGameTime() {
        return this.lastTickingGameTime;
    }

    @Override
    public void setLastTickingGameTime(long time) {
        this.lastTickingGameTime = time;
    }

    @Override
    public long getLastLoadedDayTime() {
        return this.lastLoadedDayTime;
    }

    @Override
    public void setLastLoadedDayTime(long time) {
        this.lastLoadedDayTime = time;
    }

    @Override
    public void tickPhysics() {
        if (this.physicsTicks.isEmpty()) {
            return;
        }
        ImmutableSet processedTicks = ImmutableSet.copyOf(this.physicsTicks);
        this.physicsTicks.clear();
        for (BlockPos pos : processedTicks) {
            CompoundTag data;
            IDropsItems droppable;
            BlockState state = this.chunk.m_8055_(pos);
            boolean floats = state.m_204336_(TagsNF.FLOATS);
            int maxDist = 0;
            if (state.m_204336_(TagsNF.SUPPORT_1)) {
                ++maxDist;
            }
            if (state.m_204336_(TagsNF.SUPPORT_2)) {
                maxDist += 2;
            }
            if (state.m_204336_(TagsNF.SUPPORT_4)) {
                maxDist += 4;
            }
            if (state.m_204336_(TagsNF.SUPPORT_8)) {
                maxDist += 8;
            }
            WrappedBool fell = new WrappedBool(true);
            if (maxDist == 0) {
                BlockPos belowPos;
                BlockState belowState;
                if (!state.m_60812_((BlockGetter)this.level, pos).m_83263_(Direction.DOWN).m_83281_() && (!LevelUtil.canFallThrough(belowState = this.chunk.m_8055_(belowPos = pos.m_7495_())) || floats && belowState.m_60819_().m_76170_())) {
                    fell.val = false;
                }
            } else {
                Object2FloatOpenHashMap visited = new Object2FloatOpenHashMap(maxDist * 2);
                visited.defaultReturnValue(Float.MAX_VALUE);
                this.checkForSupport(pos, state, (Object2FloatOpenHashMap<BlockPos>)visited, fell, 0.0f, maxDist, floats, pos);
            }
            if (!fell.val) continue;
            BlockEntity blockEntity = this.level.m_7702_(pos);
            Block block = state.m_60734_();
            if (block instanceof IFallable) {
                IFallable fallable = (IFallable)block;
                fallable.onFall(state, (ServerLevel)this.level, pos, blockEntity);
            }
            if (blockEntity instanceof IDropsItems && (droppable = (IDropsItems)blockEntity).dropOnFall()) {
                NonNullList<ItemStack> drops = droppable.getContainerDrops();
                Containers.m_19010_((Level)this.level, (BlockPos)pos, drops);
                drops.clear();
            }
            CompoundTag compoundTag = data = blockEntity != null ? blockEntity.m_187481_() : null;
            if (blockEntity instanceof Clearable) {
                Clearable clearable = (Clearable)blockEntity;
                clearable.m_6211_();
            }
            MovingBlockEntity block2 = MovingBlockEntity.fall(this.level, pos, state);
            block2.blockData = data;
            this.schedulePhysicsTickAround(pos);
        }
    }

    @Override
    public void schedulePhysicsTick(BlockPos pos) {
        this.physicsTicks.add(pos);
    }

    @Override
    public void schedulePhysicsTickAround(BlockPos pos) {
        int chunkX = pos.m_123341_() & 0xF;
        int chunkZ = pos.m_123343_() & 0xF;
        for (Direction dir : LevelUtil.PHYSICS_DIRECTIONS) {
            BlockState neighbor;
            BlockPos neighborPos = pos.m_142300_(dir);
            if (this.physicsTicks.contains(neighborPos) || !(neighbor = this.level.m_8055_(neighborPos)).m_204336_(TagsNF.HAS_PHYSICS)) continue;
            if (Math.abs(chunkX - (neighborPos.m_123341_() & 0xF)) > 1 || Math.abs(chunkZ - (neighborPos.m_123343_() & 0xF)) > 1) {
                ChunkData.get(this.level.m_46745_(neighborPos)).schedulePhysicsTick(neighborPos);
                continue;
            }
            this.schedulePhysicsTick(neighborPos);
        }
    }

    private void tryEntitySpawn(boolean spawnFriendlies, boolean spawnEnemies, BiFunction<ServerLevel, LevelChunk, BlockPos> centerPosProvider, TagKey<SpawnGroup> spawnTag, Function<BlockPos, BlockPos> poolPosProvider) {
        double spawnZ;
        double spawnY;
        ServerLevel level = (ServerLevel)this.level;
        BlockPos centerPos = centerPosProvider.apply(level, this.chunk);
        if (centerPos == null) {
            return;
        }
        double spawnX = (double)centerPos.m_123341_() + 0.5;
        if (LevelUtil.getShortestDistanceSqrToPlayer((Level)level, spawnX, spawnY = (double)centerPos.m_123342_(), spawnZ = (double)centerPos.m_123343_() + 0.5) > 6400.0) {
            ITag tag = RegistriesNF.getSpawnGroups().tags().getTag(spawnTag);
            Object2IntArrayMap weightedGroups = new Object2IntArrayMap(tag.size());
            int totalWeight = 0;
            BlockPos belowPos = centerPos.m_7495_();
            BlockState blockBelow = this.chunk.m_8055_(belowPos);
            BlockState blockAt = this.chunk.m_8055_(centerPos);
            int skyLight = level.m_45517_(LightLayer.SKY, centerPos);
            float temperature = this.getTemperature(centerPos);
            float humidity = this.getHumidity(centerPos);
            for (SpawnGroup group : tag) {
                if ((!spawnFriendlies || !group.isFriendly()) && (!spawnEnemies || group.isFriendly()) || !group.canSpawnAt(level, centerPos, group.getPlacementType() == SpawnPlacements.Type.ON_GROUND ? blockBelow : blockAt, skyLight, temperature, humidity)) continue;
                totalWeight += group.getWeight();
                weightedGroups.put((Object)group, group.getWeight());
            }
            if (totalWeight > 0) {
                SpawnGroup group = null;
                int weight = 0;
                int rand = level.f_46441_.nextInt(totalWeight);
                for (Object2IntMap.Entry entry : weightedGroups.object2IntEntrySet()) {
                    if (rand >= (weight += entry.getIntValue())) continue;
                    group = (SpawnGroup)((Object)entry.getKey());
                    break;
                }
                if (group != null) {
                    EntityType<?>[] types = group.createGroup(level, centerPos, blockBelow, skyLight, temperature, humidity);
                    SpawnGroupData data = group.getGroupData(level, centerPos, blockBelow, skyLight, temperature, humidity, types.length);
                    ObjectArrayList openPositions = ObjectArrayList.of();
                    for (int x = -3; x <= 3; ++x) {
                        for (int z = -3; z <= 3; ++z) {
                            int zPos;
                            int xPos = centerPos.m_123341_() + x;
                            if (!level.m_151577_(xPos, zPos = centerPos.m_123343_() + z)) continue;
                            BlockPos pos = poolPosProvider.apply(new BlockPos(xPos, centerPos.m_123342_(), zPos));
                            openPositions.add((Object)pos);
                        }
                    }
                    Collections.shuffle(openPositions, level.f_46441_);
                    boolean spawnedAny = false;
                    block4: for (int i = 0; i < types.length && !openPositions.isEmpty(); ++i) {
                        PathfinderMob mob;
                        EntityType<?> type = types[i];
                        Entity entity = type.m_20615_((Level)level);
                        if (entity instanceof PathfinderMob && !(mob = (PathfinderMob)entity).m_5545_((LevelAccessor)level, MobSpawnType.NATURAL)) continue;
                        for (BlockPos pos : openPositions) {
                            Mob mob2;
                            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)group.getPlacementType(), (LevelReader)level, (BlockPos)pos, type)) continue;
                            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                            if (entity instanceof Mob && !(mob2 = (Mob)entity).m_6914_((LevelReader)level)) continue;
                            entity.m_20035_(pos, level.f_46441_.nextFloat() * 360.0f, 0.0f);
                            entity.m_5618_(entity.m_146908_());
                            entity.m_5616_(entity.m_146908_());
                            if (entity instanceof ActionableEntity) {
                                ActionableEntity actionable = (ActionableEntity)entity;
                                actionable.noDespawnTicks = this.ticksToSpawn;
                            }
                            if (entity instanceof PathfinderMob) {
                                mob2 = (PathfinderMob)entity;
                                mob2.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.NATURAL, data, null);
                            }
                            level.m_47205_(entity);
                            spawnedAny = true;
                            openPositions.remove((Object)pos);
                            continue block4;
                        }
                    }
                    if (spawnedAny) {
                        this.chunk.m_8092_(true);
                    }
                }
            }
        }
    }

    @Override
    public void tryEntitySpawn(boolean spawnFriendlies, boolean spawnEnemies) {
        if (!this.level.f_46443_) {
            --this.ticksToSpawn;
            if (this.ticksToSpawn <= 0) {
                this.ticksToSpawn = 72000 + this.level.f_46441_.nextInt(48000);
                ILevelData levelData = LevelData.get(this.level);
                float temp = this.temperature[119] + Season.getTemperatureInfluence(levelData.getSeasonTime());
                float hum = this.humidity[119];
                float spawnChance = 0.0045f + Mth.m_14116_((float)(temp * temp + hum * hum)) * 9.0E-4f;
                if (this.level.f_46441_.nextFloat() < spawnChance) {
                    this.tryEntitySpawn(spawnFriendlies, spawnEnemies, LevelUtil::getRandomSurfacePos, TagsNF.SURFACE_GROUPS, pos -> new BlockPos(pos.m_123341_(), this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_()), pos.m_123343_()));
                }
                if (this.level.f_46441_.nextFloat() < spawnChance * 8.0f) {
                    this.tryEntitySpawn(spawnFriendlies, spawnEnemies, LevelUtil::getRandomWaterPos, TagsNF.OCEAN_GROUPS, pos -> pos);
                }
                if (this.level.f_46441_.nextFloat() < spawnChance) {
                    this.tryEntitySpawn(spawnFriendlies, spawnEnemies, LevelUtil::getRandomWaterPos, TagsNF.FRESHWATER_GROUPS, pos -> pos);
                }
                for (int i = 0; i < 10; ++i) {
                    this.tryEntitySpawn(spawnFriendlies, spawnEnemies, LevelUtil::getRandomPos, TagsNF.RANDOM_GROUPS, pos -> pos);
                }
            }
        }
    }

    @Override
    public void addWardingEffigy(BlockPos pos) {
        this.wardingEffigies.add(pos);
    }

    @Override
    public void removeWardingEffigy(BlockPos pos) {
        this.wardingEffigies.remove(pos);
    }

    @Override
    public boolean isUndeadSpawnBlocked(BlockPos spawnPos) {
        for (BlockPos pos : this.wardingEffigies) {
            if (Math.abs(pos.m_123341_() - spawnPos.m_123341_()) >= 16 || Math.abs(pos.m_123342_() - spawnPos.m_123342_()) >= 16 || Math.abs(pos.m_123343_() - spawnPos.m_123343_()) >= 16) continue;
            return true;
        }
        return false;
    }

    @Override
    public void simulateTime(long elapsedTime, long gameTime, long dayTime, long seasonTime, float seasonalTemp, double randomTickChance, Random random) {
        ServerLevel serverLevel = (ServerLevel)this.level;
        GlobalChunkData.get(this.chunk).simulateBreakProgress(elapsedTime);
        for (ObjectObjectImmutablePair<TickPriority, BlockPos> pair : this.timeSimulatables) {
            BlockPos pos = (BlockPos)pair.right();
            BlockState state = this.chunk.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof ITimeSimulatedBlock) {
                ITimeSimulatedBlock simulatable = (ITimeSimulatedBlock)block;
                simulatable.simulateTime(serverLevel, this.chunk, this, pos, state, elapsedTime, gameTime, dayTime, seasonTime, seasonalTemp, randomTickChance, random);
                continue;
            }
            this.timeSimulatables.remove(pair);
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        if (elapsedTime == Long.MAX_VALUE) {
            elapsedTime = 1344000L;
        } else if ((elapsedTime %= 1344000L) == 0L) {
            elapsedTime = 1344000L;
        }
        int chunkX = this.chunk.m_7697_().m_45604_();
        int chunkZ = this.chunk.m_7697_().m_45605_();
        ILevelData levelData = LevelData.get(this.level);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                long snowWindowStart;
                double snowChance;
                long snowTime;
                int y = this.chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING, x, z);
                int surfaceY = y + 1;
                BlockState surfaceBlock = this.chunk.m_8055_((BlockPos)pos.m_122178_(x, y, z));
                FluidState surfaceFluid = surfaceBlock.m_60819_();
                float temp = this.temperature[x * 16 + z];
                if (surfaceFluid.m_76170_()) {
                    Block block = surfaceBlock.m_60734_();
                    if (block != BlocksNF.WATER.get() && block != BlocksNF.SEAWATER.get()) continue;
                    boolean fresh = block == BlocksNF.WATER.get();
                    BlockState ice = fresh ? ((IceBlock)BlocksNF.ICE.get()).m_49966_() : ((IceBlock)BlocksNF.SEA_ICE.get()).m_49966_();
                    BlockState frazil = fresh ? ((FrazilBlock)BlocksNF.FRAZIL.get()).m_49966_() : ((FrazilBlock)BlocksNF.SEA_FRAZIL.get()).m_49966_();
                    float seasonalFrazilTemp = (fresh ? 0.22f : 0.07f) - temp;
                    if (!(Math.abs(seasonalFrazilTemp) < 0.25f)) continue;
                    LongLongPair frazilWindow = Season.getTimesAtTemperatureInfluence(seasonalFrazilTemp);
                    if (seasonalTemp > seasonalFrazilTemp && MathUtil.getRandomSuccesses(randomTickChance, Season.getTimePassedWithin(seasonTime, elapsedTime, frazilWindow.secondLong(), seasonTime % 1344000L), 1, random) >= 1) continue;
                    float seasonalIceTemp = (fresh ? 0.2f : 0.05f) - temp;
                    if (Math.abs(seasonalIceTemp) < 0.25f) {
                        LongLongPair iceWindow = Season.getTimesAtTemperatureInfluence(seasonalIceTemp);
                        long preFrazilTime = Season.getTimePassedWithin(seasonTime, elapsedTime, iceWindow.firstLong(), frazilWindow.secondLong());
                        IntLongPair preFrazil = MathUtil.getRandomSuccessesAndRemainingTrials(3.0048076923076925E-4, preFrazilTime, 1, random);
                        if (preFrazil.firstInt() == 1) {
                            long iceTime = Season.getTimePassedWithin(seasonTime, elapsedTime, iceWindow.firstLong(), iceWindow.secondLong());
                            if (MathUtil.getRandomSuccesses(randomTickChance, Math.min(preFrazil.secondLong(), iceTime), 1, random) >= 1) {
                                this.level.m_7731_((BlockPos)pos.m_122178_(chunkX + x, y, chunkZ + z), ice, 18);
                                continue;
                            }
                            this.level.m_7731_((BlockPos)pos.m_122178_(chunkX + x, surfaceY, chunkZ + z), frazil, 18);
                            continue;
                        }
                        if (MathUtil.getRandomSuccesses(3.0048076923076925E-4, Season.getTimePassedWithin(seasonTime, elapsedTime, frazilWindow.firstLong(), iceWindow.firstLong()), 1, random) < 1) continue;
                        this.level.m_7731_((BlockPos)pos.m_122178_(chunkX + x, surfaceY, chunkZ + z), frazil, 18);
                        continue;
                    }
                    if (MathUtil.getRandomSuccesses(3.0048076923076925E-4, Season.getTimePassedWithin(seasonTime, elapsedTime, frazilWindow.firstLong(), frazilWindow.secondLong()), 1, random) < 1) continue;
                    this.level.m_7731_((BlockPos)pos.m_122178_(chunkX + x, surfaceY, chunkZ + z), frazil, 18);
                    continue;
                }
                if (surfaceBlock.m_204336_(BlockTags.f_13047_) || !this.chunk.m_8055_((BlockPos)pos.m_142448_(surfaceY)).m_60795_() || !Block.m_49918_((VoxelShape)surfaceBlock.m_60816_((BlockGetter)this.level, (BlockPos)pos.m_142448_(y)), (Direction)Direction.UP)) continue;
                float seasonalSnowTemp = 0.3f - temp;
                if (seasonalSnowTemp >= 0.25f) {
                    if (MathUtil.getRandomSuccesses(3.0048076923076925E-4, elapsedTime, 1, random) < 1) continue;
                    this.level.m_7731_((BlockPos)pos.m_122178_(chunkX + x, surfaceY, chunkZ + z), ((SnowBlock)BlocksNF.SNOW.get()).m_49966_(), 18);
                    continue;
                }
                if (!(Math.abs(seasonalSnowTemp) < 0.25f)) continue;
                LongLongPair snowWindow = Season.getTimesAtTemperatureInfluence(seasonalSnowTemp);
                if (seasonalTemp > seasonalSnowTemp && MathUtil.getRandomSuccesses(randomTickChance, Season.getTimePassedWithin(seasonTime, elapsedTime, snowWindow.secondLong(), seasonTime % 1344000L), 1, random) >= 1 || (snowTime = Season.getTimePassedWithin(seasonTime, elapsedTime, snowWindow.firstLong(), snowWindow.secondLong())) <= 0L || MathUtil.getRandomSuccesses(3.0048076923076925E-4 * (snowChance = levelData.getWeatherPercentageAboveIntensityOverTime(0.45f - this.weather[x * 16 + z], Math.max(0L, snowWindowStart = seasonTime % 1344000L - Math.floorMod(snowWindow.secondLong(), 1344000L)), snowWindowStart + snowTime)), snowTime, 1, random) < 1) continue;
                this.level.m_7731_((BlockPos)pos.m_122178_(chunkX + x, surfaceY, chunkZ + z), ((SnowBlock)BlocksNF.SNOW.get()).m_49966_(), 2);
            }
        }
    }

    @Override
    public void addSimulatableBlock(TickPriority priority, BlockPos pos) {
        this.timeSimulatables.add(new ObjectObjectImmutablePair<TickPriority, BlockPos>(priority, pos){

            public int hashCode() {
                return ((BlockPos)this.right).hashCode();
            }
        });
    }

    @Override
    public void removeSimulatableBlock(TickPriority priority, BlockPos pos) {
        this.timeSimulatables.remove(new ObjectObjectImmutablePair((Object)priority, (Object)pos));
    }

    @Override
    public void addUndeadUUID(UUID id) {
        this.undeadIds.add(id);
    }

    @Override
    public void clearUndeadUUIDs() {
        this.undeadIds.clear();
    }

    @Override
    public boolean areUndeadLoaded() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (UUID id : this.undeadIds) {
                if (serverLevel.m_8791_(id) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void checkForSupport(BlockPos pos, BlockState state, Object2FloatOpenHashMap<BlockPos> visited, WrappedBool fell, float dist, int maxDist, boolean floats, BlockPos origin) {
        if (!fell.val || dist >= visited.getFloat((Object)pos) || dist > (float)maxDist) {
            return;
        }
        visited.put((Object)pos, dist);
        BlockPos belowPos = pos.m_7495_();
        VoxelShape shape = state.m_60812_((BlockGetter)this.level, pos);
        if (!visited.containsKey((Object)belowPos) && !shape.m_83263_(Direction.DOWN).m_83281_()) {
            if (floats && this.level.m_6425_(belowPos).m_76170_()) {
                fell.val = false;
                return;
            }
            if (pos.equals((Object)origin) && !LevelUtil.canFallThrough(this.level.m_8055_(belowPos))) {
                fell.val = false;
                return;
            }
        }
        for (Direction dir : LevelUtil.HORIZONTAL_DOWN_DIRECTIONS) {
            BlockPos supportPos;
            BlockState supportState;
            VoxelShape shapeS;
            VoxelShape face = shape.m_83263_(dir);
            if (face.m_83281_() || (shapeS = (supportState = this.level.m_8055_(supportPos = pos.m_142300_(dir))).m_60812_((BlockGetter)this.level, supportPos)).m_83263_(dir.m_122424_()).m_83281_()) continue;
            boolean joined = false;
            Direction.Axis otherAxis = dir.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            double xzCenter = (face.m_83288_(otherAxis) + face.m_83297_(otherAxis)) / 2.0;
            double yCenter = (face.m_83288_(Direction.Axis.Y) + face.m_83297_(Direction.Axis.Y)) / 2.0;
            for (AABB box : shapeS.m_83299_()) {
                if (dir.m_122421_() == Direction.AxisDirection.POSITIVE ? box.m_82340_(dir.m_122434_()) > 0.0 : box.m_82374_(dir.m_122434_()) < 1.0) continue;
                if (!(xzCenter >= box.m_82340_(otherAxis)) || !(xzCenter <= box.m_82374_(otherAxis)) || !(yCenter >= box.f_82289_) || !(yCenter <= box.f_82292_)) continue;
                joined = true;
                break;
            }
            if (!joined) continue;
            if (dir == Direction.DOWN) {
                fell.val = false;
                return;
            }
            this.checkForSupport(supportPos, supportState, visited, fell, supportState.m_61138_((Property)BlockStateProperties.f_61365_) && supportState.m_61143_((Property)BlockStateProperties.f_61365_) == dir.m_122434_() ? dist + 0.666f : dist + 1.0f, maxDist, floats, origin);
            if (fell.val) continue;
            return;
        }
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag temps = new ListTag();
        ListTag hums = new ListTag();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (x % 5 != 0 || z % 5 != 0) continue;
                int n = x * 16 + z;
                temps.add((Object)FloatTag.m_128566_((float)this.temperature[n]));
                hums.add((Object)FloatTag.m_128566_((float)this.humidity[n]));
            }
        }
        tag.m_128365_("temperature", (Tag)temps);
        tag.m_128365_("humidity", (Tag)hums);
        tag.m_128379_("new", this.isNew);
        tag.m_128379_("undead", this.spawnedUndead);
        tag.m_128356_("lastTickingGameTime", this.lastTickingGameTime);
        tag.m_128356_("loadDay", this.lastLoadedDayTime);
        tag.m_128405_("ticksToSpawn", this.ticksToSpawn);
        if (!this.physicsTicks.isEmpty()) {
            ListTag hashes = new ListTag();
            for (BlockPos blockPos : this.physicsTicks) {
                hashes.add((Object)IntTag.m_128679_((int)((blockPos.m_123341_() & 0xF) << 22 | (blockPos.m_123343_() & 0xF) << 12 | blockPos.m_123342_() & 0xFFF)));
            }
            tag.m_128365_("physicsTicks", (Tag)hashes);
        }
        if (!this.wardingEffigies.isEmpty()) {
            ListTag hashes = new ListTag();
            for (BlockPos blockPos : this.wardingEffigies) {
                hashes.add((Object)IntTag.m_128679_((int)((blockPos.m_123341_() & 0xF) << 22 | (blockPos.m_123343_() & 0xF) << 12 | blockPos.m_123342_() & 0xFFF)));
            }
            tag.m_128365_("wardingEffigies", (Tag)hashes);
        }
        if (!this.timeSimulatables.isEmpty()) {
            EnumMap<TickPriority, ListTag> priorityToTag = new EnumMap<TickPriority, ListTag>(TickPriority.class);
            for (ObjectObjectImmutablePair<TickPriority, BlockPos> objectObjectImmutablePair : this.timeSimulatables) {
                ListTag listTag = priorityToTag.computeIfAbsent((TickPriority)objectObjectImmutablePair.key(), k -> new ListTag());
                BlockPos pos = (BlockPos)objectObjectImmutablePair.right();
                listTag.add((Object)IntTag.m_128679_((int)((pos.m_123341_() & 0xF) << 22 | (pos.m_123343_() & 0xF) << 12 | pos.m_123342_() & 0xFFF)));
            }
            for (Map.Entry entry : priorityToTag.entrySet()) {
                tag.m_128365_("timeSimulatables" + ((TickPriority)entry.getKey()).m_193445_(), (Tag)entry.getValue());
            }
        }
        if (!this.undeadIds.isEmpty()) {
            ListTag ids = new ListTag();
            for (UUID uUID : this.undeadIds) {
                ids.add((Object)NbtUtils.m_129226_((UUID)uUID));
            }
            tag.m_128365_("undeadIds", (Tag)ids);
        }
        return tag;
    }

    @Override
    public void readNBT(CompoundTag tag) {
        int hash;
        ListTag temps = tag.m_128437_("temperature", 5);
        ListTag hums = tag.m_128437_("humidity", 5);
        int tagIndex = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (x % 5 != 0 || z % 5 != 0) continue;
                int i = x * 16 + z;
                this.temperature[i] = ((FloatTag)temps.get(tagIndex)).m_7057_();
                this.humidity[i] = ((FloatTag)hums.get(tagIndex)).m_7057_();
                ++tagIndex;
            }
        }
        if (tag.m_128425_("new", 1)) {
            this.isNew = tag.m_128471_("new");
        }
        this.spawnedUndead = tag.m_128471_("undead");
        if (tag.m_128441_("lastTickingGameTime")) {
            this.lastTickingGameTime = tag.m_128454_("lastTickingGameTime");
        }
        this.lastLoadedDayTime = tag.m_128454_("loadDay");
        this.ticksToSpawn = tag.m_128451_("ticksToSpawn");
        int minX = this.chunk.m_7697_().m_45604_();
        int minZ = this.chunk.m_7697_().m_45605_();
        if (tag.m_128441_("physicsTicks")) {
            ListTag hashes = tag.m_128437_("physicsTicks", 3);
            for (Tag hashTag : hashes) {
                hash = ((IntTag)hashTag).m_7047_();
                this.physicsTicks.add(new BlockPos(minX + (hash >>> 22), hash & 0xFFF, minZ + (hash >>> 12 & 0x3FF)));
            }
        }
        if (tag.m_128441_("wardingEffigies")) {
            ListTag hashes = tag.m_128437_("wardingEffigies", 3);
            for (Tag hashTag : hashes) {
                hash = ((IntTag)hashTag).m_7047_();
                this.wardingEffigies.add(new BlockPos(minX + (hash >>> 22), hash & 0xFFF, minZ + (hash >>> 12 & 0x3FF)));
            }
        }
        for (TickPriority tickPriority : TickPriority.values()) {
            String key = "timeSimulatables" + tickPriority.m_193445_();
            if (!tag.m_128441_(key)) continue;
            ListTag hashes = tag.m_128437_(key, 3);
            for (Tag hashTag : hashes) {
                int hash2 = ((IntTag)hashTag).m_7047_();
                this.timeSimulatables.add((ObjectObjectImmutablePair<TickPriority, BlockPos>)new ObjectObjectImmutablePair((Object)tickPriority, (Object)new BlockPos(minX + (hash2 >>> 22), hash2 & 0xFFF, minZ + (hash2 >>> 12 & 0x3FF))));
            }
        }
        if (tag.m_128441_("undeadIds")) {
            ListTag ids = tag.m_128437_("undeadIds", 11);
            for (Tag idTag : ids) {
                this.undeadIds.add(NbtUtils.m_129233_((Tag)idTag));
            }
        }
        this.init();
    }

    public static IChunkData get(LevelChunk chunk) {
        return (IChunkData)chunk.getCapability(CAPABILITY, null).orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."));
    }

    public static boolean isPresent(LevelChunk chunk) {
        return chunk.getCapability(CAPABILITY).isPresent();
    }

    public static class ChunkDataCapability
    implements ICapabilitySerializable<CompoundTag> {
        private final ChunkData cap;
        private final LazyOptional<IChunkData> holder;

        public ChunkDataCapability(LevelChunk chunk) {
            this.cap = new ChunkData(chunk);
            this.holder = LazyOptional.of(() -> this.cap);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> c, Direction side) {
            return CAPABILITY == c ? this.holder : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.cap.writeNBT();
        }

        public void deserializeNBT(CompoundTag NBT) {
            this.cap.readNBT(NBT);
        }
    }
}

