/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.capability;

import frostnox.nightfall.capability.IGlobalChunkData;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.world.ChunkDigProgressToClient;
import frostnox.nightfall.network.message.world.DigBlockToClient;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.util.MathUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntFloatMutablePair;
import it.unimi.dsi.fastutil.ints.IntFloatPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class GlobalChunkData
implements IGlobalChunkData {
    public static final Capability<IGlobalChunkData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGlobalChunkData>(){});
    private final LevelChunk chunk;
    private final boolean isClientSide;
    private final Object2ObjectMap<BlockPos, IntFloatPair> breakingBlocks;

    public GlobalChunkData(LevelChunk chunk) {
        this.chunk = chunk;
        this.isClientSide = chunk.m_62953_().f_46443_;
        Hash.Strategy<BlockPos> compactPosHash = new Hash.Strategy<BlockPos>(){

            public int hashCode(BlockPos pos) {
                return DataUtil.hashPos(pos);
            }

            public boolean equals(BlockPos pos1, BlockPos pos2) {
                if (pos1 == null || pos2 == null) {
                    return pos1 == pos2;
                }
                return pos1.m_123341_() == pos2.m_123341_() && pos1.m_123342_() == pos2.m_123342_() && pos1.m_123343_() == pos2.m_123343_();
            }
        };
        this.breakingBlocks = new Object2ObjectOpenCustomHashMap(8, (Hash.Strategy)compactPosHash);
    }

    @Override
    public void tick() {
        if (this.breakingBlocks.isEmpty()) {
            return;
        }
        ObjectArraySet removals = new ObjectArraySet(8);
        for (Map.Entry entry : this.breakingBlocks.entrySet()) {
            BlockPos pos;
            IntFloatPair data = (IntFloatPair)entry.getValue();
            int decay = data.firstInt();
            if (decay == 1) {
                pos = (BlockPos)entry.getKey();
                removals.add(pos);
                NetworkHandler.toAllTrackingChunk(this.chunk, new DigBlockToClient(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), -1.0f));
                continue;
            }
            data.first(decay - 1);
            if (decay > 400 || decay % 40 != 0) continue;
            pos = (BlockPos)entry.getKey();
            float progress = data.secondFloat() - 0.1f;
            if (progress <= 0.0f) {
                removals.add(pos);
                NetworkHandler.toAllTrackingChunk(this.chunk, new DigBlockToClient(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), -1.0f));
                continue;
            }
            data.second(progress);
            NetworkHandler.toAllTrackingChunk(this.chunk, new DigBlockToClient(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), progress));
        }
        for (BlockPos key : removals) {
            this.breakingBlocks.remove((Object)key);
        }
    }

    @Override
    public void setBreakProgress(BlockPos pos, int decay, float progress) {
        this.breakingBlocks.put((Object)pos, (Object)new IntFloatMutablePair(decay, progress));
    }

    @Override
    public void setBreakProgress(BlockPos pos, float progress) {
        this.breakingBlocks.put((Object)pos, (Object)new IntFloatMutablePair(1000, progress));
    }

    @Override
    public float getBreakProgress(BlockPos pos) {
        IntFloatPair data = (IntFloatPair)this.breakingBlocks.get((Object)pos);
        if (data != null) {
            return data.secondFloat();
        }
        return 0.0f;
    }

    @Override
    public void removeBreakProgress(BlockPos pos) {
        this.breakingBlocks.remove((Object)pos);
    }

    @Override
    public void simulateBreakProgress(long elapsedTime) {
        if (this.breakingBlocks.isEmpty()) {
            return;
        }
        if (elapsedTime >= 1000L) {
            this.breakingBlocks.clear();
        } else {
            ObjectArraySet removals = new ObjectArraySet(8);
            for (Map.Entry entry : this.breakingBlocks.entrySet()) {
                BlockPos pos;
                IntFloatPair data = (IntFloatPair)entry.getValue();
                int decay = data.firstInt();
                int newDecay = decay - (int)elapsedTime;
                if (newDecay <= 0) {
                    pos = (BlockPos)entry.getKey();
                    removals.add(pos);
                    continue;
                }
                data.first(newDecay);
                if (newDecay > 400) continue;
                pos = (BlockPos)entry.getKey();
                float progress = data.secondFloat() - 0.1f * (float)MathUtil.getPassedIntervals(newDecay, Math.min(400, decay), 40);
                if (progress <= 0.0f) {
                    removals.add(pos);
                    continue;
                }
                data.second(progress);
            }
            for (BlockPos key : removals) {
                this.breakingBlocks.remove((Object)key);
            }
        }
    }

    @Override
    public ChunkDigProgressToClient getBreakProgressMessage() {
        if (!this.isClientSide && !this.breakingBlocks.isEmpty()) {
            ChunkPos chunkPos = this.chunk.m_7697_();
            int[] packedPositions = new int[this.breakingBlocks.size()];
            float[] progress = new float[this.breakingBlocks.size()];
            int i = 0;
            for (Map.Entry entry : this.breakingBlocks.entrySet()) {
                packedPositions[i] = DataUtil.packChunkPos((BlockPos)entry.getKey());
                IntFloatPair data = (IntFloatPair)entry.getValue();
                progress[i] = data.secondFloat();
                ++i;
            }
            return new ChunkDigProgressToClient(chunkPos.f_45578_, chunkPos.f_45579_, packedPositions, progress);
        }
        return null;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        if (!this.breakingBlocks.isEmpty()) {
            ListTag hashes = new ListTag();
            ListTag decay = new ListTag();
            ListTag progress = new ListTag();
            for (Map.Entry entry : this.breakingBlocks.entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                hashes.add((Object)IntTag.m_128679_((int)((pos.m_123341_() & 0xF) << 22 | (pos.m_123343_() & 0xF) << 12 | pos.m_123342_() & 0xFFF)));
                decay.add((Object)IntTag.m_128679_((int)((IntFloatPair)entry.getValue()).firstInt()));
                progress.add((Object)FloatTag.m_128566_((float)((IntFloatPair)entry.getValue()).secondFloat()));
            }
            tag.m_128365_("breakPositions", (Tag)hashes);
            tag.m_128365_("breakDecay", (Tag)decay);
            tag.m_128365_("breakProgress", (Tag)progress);
        }
        return tag;
    }

    @Override
    public void readNBT(CompoundTag tag) {
        int minX = this.chunk.m_7697_().m_45604_();
        int minZ = this.chunk.m_7697_().m_45605_();
        if (tag.m_128441_("breakPositions")) {
            ListTag hashes = tag.m_128437_("breakPositions", 3);
            ListTag decayTag = tag.m_128437_("breakDecay", 3);
            ListTag progressTag = tag.m_128437_("breakProgress", 5);
            for (int i = 0; i < hashes.size(); ++i) {
                int hash = ((IntTag)hashes.get(i)).m_7047_();
                int decay = ((IntTag)decayTag.get(i)).m_7047_();
                float progress = ((FloatTag)progressTag.get(i)).m_7057_();
                this.breakingBlocks.put((Object)new BlockPos(minX + (hash >>> 22), hash & 0xFFF, minZ + (hash >>> 12 & 0x3FF)), (Object)new IntFloatMutablePair(decay, progress));
            }
        }
    }

    public static IGlobalChunkData get(LevelChunk chunk) {
        return (IGlobalChunkData)chunk.getCapability(CAPABILITY, null).orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."));
    }

    public static class GlobalChunkDataCapability
    implements ICapabilitySerializable<CompoundTag> {
        private final GlobalChunkData cap;
        private final LazyOptional<IGlobalChunkData> holder;

        public GlobalChunkDataCapability(LevelChunk chunk) {
            this.cap = new GlobalChunkData(chunk);
            this.holder = LazyOptional.of(() -> this.cap);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> c, Direction side) {
            return CAPABILITY == c ? this.holder : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.cap.writeNBT();
        }

        public void deserializeNBT(CompoundTag NBT) {
            this.cap.readNBT(NBT);
        }
    }
}

