/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.capability;

import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.math.noise.FractalSimplexNoiseFast;
import frostnox.nightfall.world.Season;
import frostnox.nightfall.world.Weather;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class LevelData
implements ILevelData {
    public static final Capability<ILevelData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ILevelData>(){});
    public static final float WATER_FREEZE_TEMP = 0.2f;
    public static final float SEAWATER_FREEZE_TEMP = 0.05f;
    public static final float FRAZIL_TEMP = 0.22f;
    public static final float SEA_FRAZIL_TEMP = 0.07f;
    public static final float SNOW_TEMP = 0.3f;
    private static final int HISTORY_LENGTH = 150;
    private final Level level;
    private final WeatherData[] weatherHistory = new WeatherData[150];
    private int historyIndex = -1;
    private int weatherDuration = 1;
    private int weatherTicks = 2;
    private long windTime;
    private long seasonTime = 336000L;
    private long seed;
    private float rawWeatherIntensity;
    private float weatherIntensity;
    private float lastWeatherIntensity;
    private float windX;
    private float windZ;
    private float lastWindX = -10.0f;
    private float lastWindZ;
    private FractalSimplexNoiseFast vegetationNoise;

    private LevelData(Level level) {
        this.level = level;
    }

    private void generateNewWeather() {
        float lastLastWeatherIntensity = this.lastWeatherIntensity;
        this.lastWeatherIntensity = this.weatherIntensity;
        if (Weather.get(lastLastWeatherIntensity) != Weather.FOG && Weather.get(this.lastWeatherIntensity) == Weather.FOG) {
            int time = (int)(3600.0f * -this.weatherIntensity);
            this.weatherDuration = time + this.level.f_46441_.nextInt(time);
        } else {
            this.weatherIntensity = (float)MathUtil.gammaSample(1.2, this.level.f_46441_) / 4.0f;
            Season season = this.getSeason();
            float f = this.level.f_46441_.nextFloat();
            float f2 = season == Season.FALL ? 0.5f : 0.3f;
            if (f < f2) {
                this.weatherIntensity = -Math.min(this.weatherIntensity, 1.0f);
            } else {
                if (season == Season.SUMMER) {
                    this.weatherIntensity *= 0.8f;
                } else if (season == Season.SPRING) {
                    this.weatherIntensity *= 1.2f;
                }
                this.weatherIntensity = Math.min(this.weatherIntensity, 1.0f);
            }
            this.weatherDuration = 9600 + this.level.f_46441_.nextInt(14400);
        }
        this.weatherHistory[this.historyIndex] = new WeatherData(this.weatherIntensity, this.weatherDuration);
        this.historyIndex = (this.historyIndex + 1) % 150;
    }

    @Override
    public void onLoad(long seed) {
        this.seed = seed;
        XoroshiroRandomSource random = new XoroshiroRandomSource(seed);
        this.vegetationNoise = new FractalSimplexNoiseFast(random.nextLong(), 0.0045f, 2, 0.5f, 2.0f);
        if (this.historyIndex == -1) {
            this.historyIndex = 0;
            for (int i = 0; i < 150; ++i) {
                if (i == 148) {
                    this.lastWeatherIntensity = this.weatherIntensity;
                    this.weatherIntensity = 0.0f;
                    this.weatherDuration = 9600 + this.level.f_46441_.nextInt(14400);
                    this.weatherHistory[this.historyIndex] = new WeatherData(this.weatherIntensity, this.weatherDuration);
                    this.historyIndex = (this.historyIndex + 1) % 150;
                    continue;
                }
                this.generateNewWeather();
            }
        }
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void updateWeather() {
        if (!this.level.f_46443_ && this.weatherTicks > this.weatherDuration) {
            this.generateNewWeather();
            this.weatherTicks = 0;
        }
        this.rawWeatherIntensity = Mth.m_14179_((float)((float)this.weatherTicks / (float)this.weatherDuration), (float)this.lastWeatherIntensity, (float)this.weatherIntensity);
    }

    @Override
    public double getWeatherPercentageAboveIntensityOverTime(float intensity, long startTime, long endTime) {
        double totalDuration = 0.0;
        double targetDuration = 0.0;
        if (startTime < (long)this.weatherTicks) {
            WeatherData cur = this.weatherHistory[this.historyIndex];
            WeatherData prev = this.weatherHistory[Math.floorMod(this.historyIndex - 1, 150)];
            float curIntensity = Mth.m_14179_((float)((float)this.weatherTicks / (float)cur.duration), (float)prev.intensity, (float)cur.intensity);
            float prevIntensity = endTime >= (long)this.weatherTicks ? prev.intensity : Mth.m_14179_((float)((float)endTime / (float)cur.duration), (float)cur.intensity, (float)prev.intensity);
            double duration = Math.min(endTime, (long)this.weatherTicks) - startTime;
            totalDuration += duration;
            if (intensity >= prevIntensity && intensity <= curIntensity || intensity >= curIntensity && intensity <= prevIntensity) {
                targetDuration += duration - (double)((intensity - prevIntensity) / (curIntensity - prevIntensity)) * duration;
            }
            if (endTime <= (long)this.weatherTicks) {
                return targetDuration / totalDuration;
            }
        } else {
            totalDuration += (double)this.weatherTicks;
        }
        int fromIndex = Math.floorMod(this.historyIndex - 1, 150);
        for (int i = 2; i < 150; ++i) {
            int toIndex = fromIndex;
            fromIndex = Math.floorMod(this.historyIndex - i, 150);
            WeatherData cur = this.weatherHistory[toIndex];
            double fullDuration = totalDuration + (double)cur.duration;
            if ((double)startTime < fullDuration) {
                WeatherData prev = this.weatherHistory[fromIndex];
                double intervalCur = Math.max((double)startTime - totalDuration, 0.0);
                double intervalPrev = Math.min(fullDuration, (double)endTime) - totalDuration;
                double curIntensity = Mth.m_14139_((double)(1.0 - intervalCur / (double)cur.duration), (double)prev.intensity, (double)cur.intensity);
                double prevIntensity = Mth.m_14139_((double)(intervalPrev / (double)cur.duration), (double)cur.intensity, (double)prev.intensity);
                double duration = intervalPrev - intervalCur;
                totalDuration += duration;
                if ((double)intensity >= prevIntensity && (double)intensity <= curIntensity || (double)intensity >= curIntensity && (double)intensity <= prevIntensity) {
                    targetDuration += duration - ((double)intensity - prevIntensity) / (curIntensity - prevIntensity) * duration;
                }
                if (!((double)endTime <= fullDuration)) continue;
                return targetDuration / totalDuration;
            }
            totalDuration += (double)cur.duration;
        }
        return targetDuration / totalDuration;
    }

    @Override
    public void setGlobalWeatherIntensity(float intensity) {
        this.weatherIntensity = intensity;
        this.weatherTicks = this.weatherDuration + 1;
        this.updateWeather();
    }

    @Override
    public float getTargetWeatherIntensity() {
        return this.weatherIntensity;
    }

    @Override
    public float getLastWeatherIntensity() {
        return this.lastWeatherIntensity;
    }

    @Override
    public void updateWind() {
        float v = (float)this.windTime * 1.1E-4f;
        float f = Mth.m_14031_((float)(MathUtil.SQRT_2 * 0.2f * v)) + Mth.m_14031_((float)(0.62831855f * v)) + Mth.m_14089_((float)(0.1f * v)) + Mth.m_14089_((float)(0.47123894f * v));
        float windIntensity = Math.min(1.0f, Math.max(0.0f, (f - Mth.m_14089_((float)(0.2f * MathUtil.PI_SQRT * v))) / 5.0f) + Math.max(0.0f, (f - Mth.m_14031_((float)(0.2f * MathUtil.PI_SQRT * v))) / 5.0f / 4.0f));
        if (this.lastWindX != 10.0f) {
            this.lastWindX = this.windX;
            this.lastWindZ = this.windZ;
        }
        if (windIntensity == 0.0f) {
            this.windX = 0.0f;
            this.windZ = 0.0f;
        } else {
            float rot = (1.0f + (Mth.m_14031_((float)(MathUtil.SQRT_2 * 0.1f * v)) + Mth.m_14031_((float)(0.31415927f * v)) + Mth.m_14089_((float)(0.05f * v)) + Mth.m_14089_((float)(0.23561947f * v)) - Mth.m_14031_((float)(0.1f * MathUtil.PI_SQRT * v))) / 5.0f) * (float)Math.PI;
            this.windX = Mth.m_14089_((float)rot) * windIntensity;
            this.windZ = Mth.m_14031_((float)rot) * windIntensity;
        }
        if (this.lastWindX == 10.0f) {
            this.lastWindX = this.windX;
            this.lastWindZ = this.windZ;
        }
    }

    @Override
    public long getWindTime() {
        return this.windTime;
    }

    @Override
    public void setWindTime(long time) {
        this.windTime = time;
        this.updateWind();
    }

    @Override
    public long getSeasonTime() {
        return this.seasonTime;
    }

    @Override
    public void setSeasonTime(long time) {
        this.seasonTime = time;
    }

    @Override
    public void tick() {
        ++this.windTime;
        ++this.seasonTime;
        ++this.weatherTicks;
        this.updateWind();
        this.updateWeather();
    }

    @Override
    public Season getSeason() {
        return Season.get(this.seasonTime);
    }

    @Override
    public float getSeasonalTemperature(IChunkData chunkData, BlockPos pos) {
        return this.getSeasonalTemperature(chunkData, pos.m_123341_(), pos.m_123343_());
    }

    @Override
    public float getSeasonalTemperature(IChunkData chunkData, int x, int z) {
        return Math.max(0.0f, chunkData.getTemperature(x, z) + Season.getTemperatureInfluence(this.seasonTime));
    }

    @Override
    public boolean isWaterFrozen(IChunkData chunkData, BlockPos pos) {
        return this.getSeasonalTemperature(chunkData, pos) <= 0.2f;
    }

    @Override
    public float getGlobalWeatherIntensity() {
        return this.rawWeatherIntensity;
    }

    @Override
    public Weather getGlobalWeather() {
        return Weather.get(this.rawWeatherIntensity);
    }

    @Override
    public float getGlobalRainLevel() {
        return this.rawWeatherIntensity < 0.15f ? 0.0f : Math.min((this.rawWeatherIntensity - 0.15f) * 3.0f, 1.0f);
    }

    @Override
    public float getGlobalThunderLevel() {
        return this.rawWeatherIntensity < 0.3f ? 0.0f : Math.min((this.rawWeatherIntensity - 0.3f) * 3.0f, 1.0f);
    }

    @Override
    public float getWeatherIntensity(IChunkData chunkData, BlockPos pos) {
        if (this.rawWeatherIntensity < 0.0f) {
            return this.rawWeatherIntensity;
        }
        return this.rawWeatherIntensity + chunkData.getWeatherAddend(pos.m_123341_(), pos.m_123343_());
    }

    @Override
    public Weather getWeather(IChunkData chunkData, BlockPos pos) {
        Weather weather = Weather.get(this.getWeatherIntensity(chunkData, pos));
        if (weather == Weather.RAIN && this.getSeasonalTemperature(chunkData, pos) <= 0.3f) {
            weather = Weather.SNOW;
        }
        return weather;
    }

    @Override
    public boolean isRainfallCommonAt(IChunkData chunkData, int x, int y, int z) {
        return this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) < y && Weather.get((float)(0.5f + chunkData.getWeatherAddend((int)x, (int)z))).isPrecipitation;
    }

    @Override
    public float getFogIntensity() {
        if (this.rawWeatherIntensity > -0.45f) {
            return 0.0f;
        }
        return -(this.rawWeatherIntensity - -0.45f) / 0.25f;
    }

    @Override
    public float getWindX(float partial) {
        return Mth.m_14179_((float)partial, (float)this.lastWindX, (float)this.windX);
    }

    @Override
    public float getWindZ(float partial) {
        return Mth.m_14179_((float)partial, (float)this.lastWindZ, (float)this.windZ);
    }

    @Override
    public float getVegetationNoise(int worldX, int worldZ) {
        if (this.vegetationNoise == null) {
            return 0.0f;
        }
        return this.vegetationNoise.noise2D(worldX, worldZ);
    }

    @Override
    public CompoundTag writeNBTClientInit(CompoundTag tag) {
        tag.m_128356_("seed", this.seed);
        return tag;
    }

    @Override
    public CompoundTag writeNBTSync(CompoundTag tag) {
        tag.m_128356_("windTime", this.windTime);
        tag.m_128356_("seasonTime", this.seasonTime);
        tag.m_128405_("weatherDuration", this.weatherDuration);
        tag.m_128405_("weatherTicks", this.weatherTicks);
        tag.m_128350_("weatherIntensity", this.weatherIntensity);
        tag.m_128350_("lastWeatherIntensity", this.lastWeatherIntensity);
        return tag;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("historyIndex", this.historyIndex);
        ListTag intensities = new ListTag();
        ListTag durations = new ListTag();
        for (WeatherData data : this.weatherHistory) {
            intensities.add((Object)FloatTag.m_128566_((float)data.intensity));
            durations.add((Object)IntTag.m_128679_((int)data.duration));
        }
        tag.m_128365_("intensities", (Tag)intensities);
        tag.m_128365_("durations", (Tag)durations);
        return this.writeNBTSync(tag);
    }

    @Override
    public void readNBT(CompoundTag tag) {
        if (tag.m_128441_("windTime")) {
            this.windTime = tag.m_128454_("windTime");
        }
        if (tag.m_128441_("seasonTime")) {
            this.seasonTime = tag.m_128454_("seasonTime");
        }
        if (tag.m_128441_("weatherDuration")) {
            this.weatherDuration = tag.m_128451_("weatherDuration");
        }
        if (tag.m_128441_("weatherTicks")) {
            this.weatherTicks = tag.m_128451_("weatherTicks");
        }
        if (tag.m_128441_("weatherIntensity")) {
            this.weatherIntensity = tag.m_128457_("weatherIntensity");
        }
        if (tag.m_128441_("lastWeatherIntensity")) {
            this.lastWeatherIntensity = tag.m_128457_("lastWeatherIntensity");
        }
        if (tag.m_128441_("historyIndex")) {
            this.historyIndex = tag.m_128451_("historyIndex");
        }
        if (tag.m_128441_("intensities") && tag.m_128441_("durations")) {
            ListTag intensities = tag.m_128437_("intensities", 5);
            ListTag durations = tag.m_128437_("durations", 3);
            if (intensities.size() != durations.size()) {
                throw new IllegalStateException("Recorded weather intensities and durations are not equal in size, likely corrupted data");
            }
            for (int i = 0; i < 150; ++i) {
                this.weatherHistory[i] = new WeatherData(intensities.m_128775_(i), durations.m_128763_(i));
            }
        }
    }

    public static ILevelData get(Level level) {
        return (ILevelData)level.getCapability(CAPABILITY, null).orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."));
    }

    public static boolean isPresent(Level level) {
        return level.getCapability(CAPABILITY).isPresent();
    }

    public static LazyOptional<ILevelData> getOptional(Level level) {
        return level.getCapability(CAPABILITY, null);
    }

    private record WeatherData(float intensity, int duration) {
    }

    public static class LevelDataCapability
    implements ICapabilitySerializable<CompoundTag> {
        private final LevelData cap;
        private final LazyOptional<ILevelData> holder;

        public LevelDataCapability(Level level) {
            this.cap = new LevelData(level);
            this.holder = LazyOptional.of(() -> this.cap);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> c, Direction side) {
            return CAPABILITY == c ? this.holder : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.cap.writeNBT();
        }

        public void deserializeNBT(CompoundTag NBT) {
            this.cap.readNBT(NBT);
        }
    }
}

