/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.capability;

import frostnox.nightfall.capability.ILightData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.item.IItemLightSource;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.world.ILightSource;
import frostnox.nightfall.world.inventory.AccessoryInventory;
import frostnox.nightfall.world.inventory.AccessorySlot;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class LightData
implements ILightData {
    public static final Capability<ILightData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ILightData>(){});
    private final Entity entity;
    private final Object2DoubleMap<BlockPos> lightPosMap;
    private int brightness;
    private int lastProcessedBrightness;
    private double lightRadiusSqr;
    private double lastProcessedLightRadiusSqr;
    private double lightX;
    private double lightY = Double.MIN_VALUE;
    private double lightZ;
    private boolean emitsLightServer = true;
    private boolean dirtyLight = true;

    private LightData(Entity entity) {
        this.entity = entity;
        this.lightPosMap = entity.f_19853_.f_46443_ ? new Object2DoubleOpenHashMap(1024) : null;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public void setBrightness(int brightness) {
        this.brightness = brightness;
    }

    @Override
    public void setLightRadiusSqr(double lightRadiusSqr) {
        this.lightRadiusSqr = lightRadiusSqr;
    }

    @Override
    public int getLastProcessedBrightness() {
        return this.lastProcessedBrightness;
    }

    @Override
    public void setLastProcessedBrightness(int brightness) {
        this.lastProcessedBrightness = brightness;
    }

    @Override
    public double getLastProcessedLightRadiusSqr() {
        return this.lastProcessedLightRadiusSqr;
    }

    @Override
    public void setLastProcessedLightRadiusSqr(double lightRadiusSqr) {
        this.lastProcessedLightRadiusSqr = lightRadiusSqr;
    }

    @Override
    public double getLightX() {
        return this.lightX;
    }

    @Override
    public double getLightY() {
        return this.lightY;
    }

    @Override
    public double getLightZ() {
        return this.lightZ;
    }

    @Override
    public void setLightX(double x) {
        this.lightX = x;
    }

    @Override
    public void setLightY(double y) {
        this.lightY = y;
    }

    @Override
    public void setLightZ(double z) {
        this.lightZ = z;
    }

    private void updateLight(ItemStack item) {
        Item item2 = item.m_41720_();
        if (item2 instanceof ILightSource) {
            ILightSource source = (ILightSource)item2;
            if (source.getBrightness() > this.brightness) {
                this.brightness = source.getBrightness();
            }
            if (source.getLightRadiusSqr() > this.lightRadiusSqr) {
                this.lightRadiusSqr = source.getLightRadiusSqr();
            }
        }
    }

    @Override
    public void updateLight() {
        EquipmentSlot[] equipmentSlotArray = this.entity;
        if (equipmentSlotArray instanceof Player) {
            Player player = (Player)equipmentSlotArray;
            this.brightness = 0;
            this.lightRadiusSqr = 0.0;
            if (!player.m_5833_()) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    this.updateLight(player.m_6844_(slot));
                }
                AccessoryInventory accessoryInventory = PlayerData.get(player).getAccessoryInventory();
                for (AccessorySlot slot : AccessorySlot.values()) {
                    this.updateLight(accessoryInventory.getItem(slot));
                }
            }
        }
    }

    private ItemStack tryExtinguish(Player player, ItemStack item, IItemLightSource source, double itemHeight) {
        double y = player.m_20186_() + itemHeight;
        BlockPos pos = new BlockPos(player.m_20185_(), y, player.m_20189_());
        FluidState fluid = player.f_19853_.m_6425_(pos);
        if (fluid.m_205070_(FluidTags.f_13131_) && (double)((float)pos.m_123342_() + fluid.m_76155_((BlockGetter)player.f_19853_, pos)) > y) {
            NetworkHandler.toAllTracking((Entity)player, new GenericEntityToClient(NetworkHandler.Type.REMOVE_LIGHT_SOURCE_CLIENT, player.m_142049_()));
            player.f_19853_.m_6269_(null, (Entity)player, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.2f + player.f_19853_.f_46441_.nextFloat());
            return new ItemStack((ItemLike)source.getExtinguishedItem(), item.m_41613_());
        }
        return item;
    }

    @Override
    public void inWaterTickServer() {
        ServerPlayer player;
        EquipmentSlot[] equipmentSlotArray = this.entity;
        if (equipmentSlotArray instanceof ServerPlayer && !(player = (ServerPlayer)equipmentSlotArray).m_5833_() && !player.m_7500_()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack extinguishedItem;
                IItemLightSource source;
                ItemStack item = player.m_6844_(slot);
                Item item2 = item.m_41720_();
                if (!(item2 instanceof IItemLightSource) || (source = (IItemLightSource)item2).getExtinguishedItem() == item.m_41720_() || (extinguishedItem = this.tryExtinguish((Player)player, item, source, slot.m_20743_() == EquipmentSlot.Type.HAND ? (double)(0.85f * player.m_20206_() / 1.8f) : source.getEquippedHeight(player.m_20089_()))).m_150930_(item.m_41720_())) continue;
                player.m_8061_(slot, extinguishedItem);
            }
            AccessoryInventory accessoryInventory = PlayerData.get((Player)player).getAccessoryInventory();
            for (AccessorySlot slot : AccessorySlot.values()) {
                ItemStack extinguishedItem;
                IItemLightSource source;
                ItemStack item = accessoryInventory.getItem(slot);
                Item item3 = item.m_41720_();
                if (!(item3 instanceof IItemLightSource) || (source = (IItemLightSource)item3).getExtinguishedItem() == item.m_41720_() || (extinguishedItem = this.tryExtinguish((Player)player, item, source, source.getEquippedHeight(player.m_20089_()))).m_150930_(item.m_41720_())) continue;
                accessoryInventory.setItem(slot, extinguishedItem);
            }
        }
    }

    @Override
    public void init() {
        Entity entity = this.entity;
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ILightSource source = (ILightSource)itemEntity.m_32055_().m_41720_();
            this.brightness = source.getBrightness();
            this.lightRadiusSqr = source.getLightRadiusSqr();
        }
    }

    @Override
    public boolean notifyClientOnStopTracking() {
        return this.emitsLightServer;
    }

    @Override
    public void setupClientNotifications() {
        ItemEntity itemEntity;
        Entity entity = this.entity;
        if (entity instanceof ItemEntity && !((itemEntity = (ItemEntity)entity).m_32055_().m_41720_() instanceof ILightSource)) {
            this.emitsLightServer = false;
        }
    }

    @Override
    public Object2DoubleMap<BlockPos> getLightMap() {
        return this.lightPosMap;
    }

    @Override
    public boolean isLightDirty() {
        return this.dirtyLight;
    }

    @Override
    public void setLightDirty(boolean dirty) {
        this.dirtyLight = dirty;
    }

    @Override
    public int getBrightness() {
        return this.brightness;
    }

    @Override
    public double getLightRadiusSqr() {
        return this.lightRadiusSqr;
    }

    public static ILightData get(Entity entity) {
        return (ILightData)entity.getCapability(CAPABILITY, null).orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."));
    }

    public static boolean isPresent(Entity entity) {
        return entity.getCapability(CAPABILITY).isPresent();
    }

    public static class LightDataCapability
    implements ICapabilitySerializable<CompoundTag> {
        private final LightData cap;
        private final LazyOptional<ILightData> holder;

        public LightDataCapability(Entity entity) {
            this.cap = new LightData(entity);
            this.holder = LazyOptional.of(() -> this.cap);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> c, Direction side) {
            return CAPABILITY == c ? this.holder : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("emitsLight", this.cap.emitsLightServer);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.cap.emitsLightServer = tag.m_128471_("emitsLight");
        }
    }
}

