/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.capability;

import com.mojang.math.Vector3d;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.block.IHoldable;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.encyclopedia.EntryStage;
import frostnox.nightfall.encyclopedia.knowledge.Knowledge;
import frostnox.nightfall.entity.PlayerAttribute;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.network.message.capability.ActionTrackerToClient;
import frostnox.nightfall.network.message.capability.EncyclopediaEntryToClient;
import frostnox.nightfall.network.message.capability.EncyclopediaKnowledgeToClient;
import frostnox.nightfall.network.message.capability.EncyclopediaToClient;
import frostnox.nightfall.network.message.capability.StaminaChangedToClient;
import frostnox.nightfall.network.message.world.ClimbPositionToServer;
import frostnox.nightfall.network.message.world.TakeHoldableToClient;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.EntriesNF;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.world.inventory.AccessoryInventory;
import frostnox.nightfall.world.inventory.AccessorySlot;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerData
implements IPlayerData {
    public static final Capability<IPlayerData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerData>(){});
    private static final UUID VITALITY_UUID = UUID.fromString("cc078d25-5332-4d91-bb71-ab98790bc63b");
    private static final UUID ENDURANCE_UUID = UUID.fromString("7ed3bc0a-87ed-4c49-b444-4804a7456765");
    private static final UUID WILLPOWER_UUID = UUID.fromString("295f9d46-540a-418e-877d-1d4bf78dec76");
    private static final UUID STRENGTH_UUID = UUID.fromString("7aa9386a-67b1-41a6-b0bd-e05b9c509549");
    private static final UUID AGILITY_UUID = UUID.fromString("d4501abd-e9b2-47d0-a303-f2a24db10e9e");
    private static final UUID PERCEPTION_UUID = UUID.fromString("dc94f46e-266d-410f-94f3-a626974c557e");
    private final Player player;
    private int lastDodgeTick = -100;
    private int lastBlockTick = -100;
    private int holdTicks = 0;
    private int climbTicks = 0;
    private double climbYAmount = 0.0;
    private final Vector3d climbPosition = new Vector3d(0.0, -1.0, 0.0);
    private int airTicks = 0;
    private int crouchTicks = 0;
    private int punchTicks = 0;
    private int dodgeDir;
    private boolean shouldSwing = false;
    private boolean mainhandActive = true;
    private boolean dugBlock = false;
    private int hitStop = -1;
    private float hitStopPartial = 0.0f;
    private boolean interacted = false;
    private String mainUUID = "NULL";
    private String offUUID = "NULL";
    private boolean isCrawling = false;
    private boolean isClimbing = false;
    private int ticksSinceHit;
    private CompoundTag heldBlock = new CompoundTag();
    private final AccessoryInventory accessoryInventory = new AccessoryInventory();
    private final ItemStack[] lastAccessories = new ItemStack[3];
    private int lastInventoryCapacity;
    private int cachedIndex;
    private ItemStack lastMainItem = ItemStack.f_41583_;
    private ItemStack lastOffItem = ItemStack.f_41583_;
    private ItemStack heldItemRecipeCache = ItemStack.f_41583_;
    private int lastMainSwapTime = 0;
    private int lastOffSwapTime = 0;
    private boolean godmode = false;
    private boolean needsAttributeSelection = true;
    private final EnumMap<PlayerAttribute, Integer> attributePoints = new EnumMap(PlayerAttribute.class);
    private int undeadKilled = 0;
    private int undeadPursuers = 0;
    private double stamina;
    private double lastStamina;
    private int lastStaminaTick = -100;
    private final Map<ResourceLocation, EntryStage> entryStages = new Object2ObjectOpenHashMap();
    private final Object2IntMap<ResourceLocation> revelatoryKnowledge = new Object2IntOpenHashMap();
    private final Set<ResourceLocation> knowledge = new ObjectOpenHashSet();
    private final Set<ResourceLocation> notifications = new ObjectArraySet();

    private PlayerData(Player player) {
        this.player = player;
        Arrays.fill(this.lastAccessories, ItemStack.f_41583_);
        for (PlayerAttribute attribute : PlayerAttribute.values()) {
            this.attributePoints.put(attribute, 0);
        }
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public double getStamina() {
        return this.stamina;
    }

    @Override
    public double getLastStamina() {
        return this.lastStamina;
    }

    @Override
    public int getLastStaminaDrainTick() {
        return this.lastStaminaTick;
    }

    @Override
    public void setStamina(double value) {
        double maxStamina = AttributesNF.getMaxStamina(this.player);
        if (value < this.stamina) {
            this.setLastStaminaDrainTick(this.player.f_19797_);
        }
        this.stamina = value < 0.0 ? 0.0 : Math.min(value, maxStamina);
    }

    @Override
    public void updateLastStamina() {
        this.lastStamina = this.stamina;
    }

    @Override
    public void setLastStaminaDrainTick(int tick) {
        this.lastStaminaTick = tick;
    }

    @Override
    public void addStamina(double value) {
        if (value >= 0.0) {
            this.stamina = Math.min(this.stamina + value, AttributesNF.getMaxStamina(this.player));
        } else {
            this.stamina = Math.max(this.stamina + value * this.player.m_21133_((Attribute)AttributesNF.STAMINA_REDUCTION.get()), 0.0);
            this.setLastStaminaDrainTick(this.player.f_19797_);
        }
    }

    @Override
    public void tickStamina() {
        double maxStamina = AttributesNF.getMaxStamina(this.player);
        IActionTracker capA = ActionTracker.get((Entity)this.player);
        if (!capA.getAction().allowStaminaRegen(capA.getState())) {
            this.setLastStaminaDrainTick(this.player.f_19797_);
        }
        if (this.player.m_20142_() && !this.player.m_20159_() && !this.player.m_21255_()) {
            this.addStamina(this.player.m_6067_() ? -0.4 : -0.8);
            if (this.getStamina() == 0.0) {
                this.player.m_6858_(false);
            }
        } else if (this.isClimbing()) {
            this.addStamina(-0.4);
            if (this.getStamina() <= 0.0) {
                this.setClimbing(false);
            }
        }
        if (this.getStamina() < maxStamina && this.player.f_19797_ - this.getLastStaminaDrainTick() >= 24 && (!this.player.f_19853_.m_5776_() || this.getStamina() > 0.0)) {
            double regen = 1.5;
            if (this.player.m_21023_((MobEffect)EffectsNF.ENERGIZING.get())) {
                regen += 0.5;
            }
            this.addStamina(regen * AttributesNF.getStaminaRegenMultiplier(this.player));
        }
        if (this.player.m_7500_() || this.player.m_5833_()) {
            this.setStamina(maxStamina);
        } else if (!this.player.f_19853_.f_46443_) {
            if (this.getStamina() > maxStamina) {
                this.setStamina(maxStamina);
            }
            if (this.getStamina() != this.getLastStamina()) {
                NetworkHandler.toClient((ServerPlayer)this.player, new StaminaChangedToClient(this.getStamina(), this.player.m_142049_()));
            }
        }
        this.updateLastStamina();
    }

    @Override
    public int getLastDodgeTick() {
        return this.lastDodgeTick;
    }

    @Override
    public void setLastDodgeTick(int value) {
        this.lastDodgeTick = value;
    }

    @Override
    public int getLastBlockTick() {
        return this.lastBlockTick;
    }

    @Override
    public void setLastBlockTick(int value) {
        this.lastBlockTick = value;
    }

    @Override
    public InteractionHand getActiveHand() {
        return this.isMainhandActive() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    @Override
    public InteractionHand getOppositeActiveHand() {
        return this.isMainhandActive() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    @Override
    public boolean isMainhandActive() {
        return this.mainhandActive;
    }

    @Override
    public void setMainhandActive() {
        this.mainhandActive = true;
    }

    @Override
    public void setOffhandActive() {
        this.mainhandActive = false;
    }

    @Override
    public int getDodgeDirection() {
        return this.dodgeDir;
    }

    @Override
    public void setDodgeDirection(int value) {
        this.dodgeDir = value;
    }

    @Override
    public boolean hasDugBlock() {
        return this.dugBlock;
    }

    @Override
    public void setDugBlock(boolean value) {
        this.dugBlock = value;
    }

    @Override
    public int getHitStopFrame() {
        return this.hitStop;
    }

    @Override
    public void setHitStopFrame(int value) {
        this.hitStop = value;
    }

    @Override
    public float getHitStopPartial() {
        return this.hitStopPartial;
    }

    @Override
    public void setHitStopPartial(float value) {
        this.hitStopPartial = value;
    }

    @Override
    public boolean hasInteracted() {
        return this.interacted;
    }

    @Override
    public void setInteracted(boolean value) {
        this.interacted = value;
    }

    @Override
    public boolean isCrawling() {
        return this.isCrawling;
    }

    @Override
    public void setCrawling(boolean value) {
        this.isCrawling = value;
    }

    @Override
    public boolean isClimbing() {
        return this.isClimbing;
    }

    @Override
    public void setClimbing(boolean value) {
        this.isClimbing = value;
    }

    @Override
    public int getClimbTicks() {
        return this.climbTicks;
    }

    @Override
    public void setClimbTicks(int amount) {
        this.climbTicks = amount;
    }

    @Override
    public double getClimbYAmount() {
        return this.climbYAmount;
    }

    @Override
    public void setClimbYAmount(double value) {
        this.climbYAmount = value;
    }

    @Override
    public Vector3d getClimbPosition() {
        return this.climbPosition;
    }

    @Override
    public void setClimbPosition(Vector3d position) {
        this.climbPosition.m_176289_(position);
    }

    @Override
    public void sendClimbPosition(Vector3d position) {
        if (!this.player.f_19853_.m_5776_()) {
            return;
        }
        this.setClimbPosition(position);
        NetworkHandler.toServer(new ClimbPositionToServer(position));
    }

    @Override
    public int getAirTicks() {
        return this.airTicks;
    }

    @Override
    public void setAirTicks(int amount) {
        this.airTicks = amount;
    }

    @Override
    public int getCrouchTicks() {
        return this.crouchTicks;
    }

    @Override
    public void setCrouchTicks(int amount) {
        this.crouchTicks = amount;
    }

    @Override
    public int getHoldTicks() {
        return this.holdTicks;
    }

    @Override
    public void setHoldTicks(int amount) {
        this.holdTicks = amount;
    }

    @Override
    public int getPunchTicks() {
        return this.punchTicks;
    }

    @Override
    public void setPunchTicks(int amount) {
        this.punchTicks = Math.max(-1, amount);
    }

    @Override
    public int getTicksSinceHit() {
        return this.ticksSinceHit;
    }

    @Override
    public void setTicksSinceHit(int amount) {
        this.ticksSinceHit = Math.max(-1, amount);
    }

    @Override
    public int getCachedModifiableIndex() {
        return this.cachedIndex;
    }

    @Override
    public void setCachedModifiableIndex(int index) {
        this.cachedIndex = index;
    }

    @Override
    public ItemStack getLastMainItem() {
        return this.lastMainItem;
    }

    @Override
    public void setLastMainItem() {
        this.lastMainItem = this.player.m_21205_().m_41777_();
        this.lastMainSwapTime = this.player.f_19797_;
    }

    @Override
    public ItemStack getLastOffItem() {
        return this.lastOffItem;
    }

    @Override
    public void setLastOffItem() {
        this.lastOffItem = this.player.m_21206_().m_41777_();
        this.lastOffSwapTime = this.player.f_19797_;
    }

    @Override
    public int getLastMainSwapTime() {
        return this.lastMainSwapTime;
    }

    @Override
    public int getLastOffSwapTime() {
        return this.lastOffSwapTime;
    }

    @Override
    public boolean hasNoSwapDelay() {
        int delay;
        int n = delay = this.player.f_19853_.m_5776_() ? 5 : 3;
        return this.isMainhandActive() ? this.player.f_19797_ - this.lastMainSwapTime > delay : this.player.f_19797_ - this.lastOffSwapTime > delay;
    }

    @Override
    public CompoundTag getHeldContents() {
        return this.heldBlock;
    }

    @Override
    public void setHeldContents(CompoundTag contents) {
        this.heldBlock = contents;
    }

    @Override
    public void holdBlockEntity(IHoldable holdable) {
        if (this.player.f_19853_.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = (BlockEntity)holdable;
        this.heldBlock = holdable.writeDataAndClear();
        if (this.player.f_19853_.m_7471_(blockEntity.m_58899_(), false)) {
            ActionTracker.get((Entity)this.player).startAction(ActionsNF.HOLD_ENTITY.getId());
            NetworkHandler.toAllTrackingAndSelf((Entity)this.player, new TakeHoldableToClient(this.heldBlock, this.player.m_142049_()));
            SoundType soundtype = blockEntity.m_58900_().getSoundType((LevelReader)this.player.f_19853_, blockEntity.m_58899_(), (Entity)this.player);
            this.player.f_19853_.m_5594_(null, blockEntity.m_58899_(), soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            blockEntity.m_7651_();
        } else {
            blockEntity.m_142466_(this.heldBlock);
            this.heldBlock = new CompoundTag();
            NetworkHandler.toClient((ServerPlayer)this.player, new ActionTrackerToClient(ActionTracker.get((Entity)this.player).writeNBT(), this.player.m_142049_()));
        }
    }

    @Override
    public void putBlockEntity(BlockPos putPos, BlockHitResult result) {
        if (this.player.f_19853_.m_5776_()) {
            return;
        }
        BlockState block = this.player.f_19853_.m_8055_(putPos);
        BlockPlaceContext placeContext = new BlockPlaceContext(this.player, InteractionHand.MAIN_HAND, ItemStack.f_41583_, result);
        boolean failed = false;
        if (!block.m_60629_(placeContext)) {
            failed = true;
        }
        BlockState state = Block.m_49803_((int)this.heldBlock.m_128451_("state"));
        IHoldable staticHoldable = (IHoldable)BlockEntity.m_155241_((BlockPos)this.player.m_142538_(), (BlockState)state, (CompoundTag)this.heldBlock);
        state = staticHoldable.resolvePutState(state, state.m_60734_().m_5573_(placeContext));
        if (!failed && state.m_60767_().m_76334_() && !this.player.f_19853_.m_45752_(state, putPos, CollisionContext.m_82750_((Entity)this.player))) {
            failed = true;
        }
        if (!failed && state.m_204336_(TagsNF.HAS_PHYSICS) && LevelUtil.canFallThrough(this.player.f_19853_.m_8055_(putPos.m_7495_()))) {
            failed = true;
        }
        if (!failed && this.player.f_19853_.m_46597_(putPos, state)) {
            ActionTracker.get((Entity)this.player).startAction(ActionsNF.EMPTY.getId());
            NetworkHandler.toAllTrackingAndSelf((Entity)this.player, new GenericEntityToClient(NetworkHandler.Type.STOP_HOLDING_CLIENT, this.player.m_142049_()));
            BlockEntity blockEntity = this.player.f_19853_.m_7702_(putPos);
            blockEntity.m_142466_(this.heldBlock);
            ((IHoldable)blockEntity).onPut(putPos, this.player);
            blockEntity.m_6596_();
            this.player.f_19853_.m_142346_((Entity)this.player, GameEvent.f_157797_, putPos);
            this.heldBlock = new CompoundTag();
            SoundType soundtype = blockEntity.m_58900_().getSoundType((LevelReader)this.player.f_19853_, putPos, (Entity)this.player);
            this.player.f_19853_.m_5594_(null, putPos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        } else {
            failed = true;
        }
        if (failed) {
            NetworkHandler.toClient((ServerPlayer)this.player, new ActionTrackerToClient(ActionTracker.get((Entity)this.player).writeNBT(), this.player.m_142049_()));
        }
    }

    @Override
    public boolean dropBlockEntity() {
        if (this.player.f_19853_.m_5776_() || this.heldBlock.m_128456_()) {
            return false;
        }
        IHoldable holdable = (IHoldable)BlockEntity.m_155241_((BlockPos)this.player.m_142538_(), (BlockState)Block.m_49803_((int)this.heldBlock.m_128451_("state")), (CompoundTag)this.heldBlock);
        holdable.onDrop(this.player.f_19853_, this.player.m_142538_());
        this.heldBlock = new CompoundTag();
        NetworkHandler.toAllTrackingAndSelf((Entity)this.player, new GenericEntityToClient(NetworkHandler.Type.STOP_HOLDING_CLIENT, this.player.m_142049_()));
        return true;
    }

    @Override
    public boolean useBlockEntity(BlockPos usePos) {
        if (this.player.f_19853_.m_5776_() || this.heldBlock.m_128456_()) {
            return false;
        }
        IHoldable holdable = (IHoldable)BlockEntity.m_155241_((BlockPos)this.player.m_142538_(), (BlockState)Block.m_49803_((int)this.heldBlock.m_128451_("state")), (CompoundTag)this.heldBlock);
        boolean result = holdable.heldUse(usePos, this.player);
        this.heldBlock = holdable.writeDataAndClear();
        return result;
    }

    @Override
    public boolean useBlockEntity(Entity target) {
        if (this.player.f_19853_.m_5776_() || this.heldBlock.m_128456_()) {
            return false;
        }
        IHoldable holdable = (IHoldable)BlockEntity.m_155241_((BlockPos)this.player.m_142538_(), (BlockState)Block.m_49803_((int)this.heldBlock.m_128451_("state")), (CompoundTag)this.heldBlock);
        boolean result = holdable.heldUse(target, this.player);
        this.heldBlock = holdable.writeDataAndClear();
        return result;
    }

    @Override
    public AccessoryInventory getAccessoryInventory() {
        if (this.accessoryInventory.player == null) {
            this.accessoryInventory.player = this.player;
        }
        return this.accessoryInventory;
    }

    @Override
    public ItemStack getLastAccessory(AccessorySlot slot) {
        return this.lastAccessories[slot.ordinal()];
    }

    @Override
    public void setLastAccessory(AccessorySlot slot, ItemStack item) {
        this.lastAccessories[slot.ordinal()] = item;
    }

    @Override
    public void updateExpandableInventory(boolean force) {
        int capacity = AttributesNF.getInventoryCapacity(this.player);
        if (capacity != this.lastInventoryCapacity || force) {
            for (int i = 9; i < 36; ++i) {
                ItemStack item;
                Slot slot = this.player.f_36095_.m_38853_(i);
                if (slot.m_6659_() || (item = slot.m_7993_()).m_41619_()) continue;
                this.player.m_150109_().m_150079_(item.m_41777_());
                slot.m_5852_(ItemStack.f_41583_);
            }
        }
        this.lastInventoryCapacity = capacity;
    }

    @Override
    public boolean hasGodMode() {
        return this.godmode;
    }

    @Override
    public boolean toggleGodMode() {
        this.godmode = !this.godmode;
        return this.godmode;
    }

    @Override
    public boolean needsAttributeSelection() {
        return this.needsAttributeSelection;
    }

    @Override
    public void setNeedsAttributeSelection(boolean value) {
        this.needsAttributeSelection = value;
    }

    @Override
    public void setAttributePoints(PlayerAttribute attribute, int points) {
        if (points < -3 || points > 3) {
            Nightfall.LOGGER.error("Cannot set " + attribute.toString() + " points to " + points + ". Points cannot exceed +-3");
        } else {
            this.attributePoints.put(attribute, points);
        }
        if (!this.player.f_19853_.f_46443_) {
            switch (attribute) {
                case VITALITY: {
                    this.player.m_21051_(Attributes.f_22276_).m_22127_(VITALITY_UUID);
                    this.player.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(VITALITY_UUID, "Innate vitality", (double)(points * 10), AttributeModifier.Operation.ADDITION));
                    break;
                }
                case ENDURANCE: {
                    this.player.m_21051_((Attribute)AttributesNF.ENDURANCE.get()).m_22127_(ENDURANCE_UUID);
                    this.player.m_21051_((Attribute)AttributesNF.ENDURANCE.get()).m_22125_(new AttributeModifier(ENDURANCE_UUID, "Innate endurance", (double)points, AttributeModifier.Operation.ADDITION));
                    break;
                }
                case WILLPOWER: {
                    this.player.m_21051_((Attribute)AttributesNF.WILLPOWER.get()).m_22127_(WILLPOWER_UUID);
                    this.player.m_21051_((Attribute)AttributesNF.WILLPOWER.get()).m_22125_(new AttributeModifier(WILLPOWER_UUID, "Innate willpower", (double)points, AttributeModifier.Operation.ADDITION));
                    break;
                }
                case STRENGTH: {
                    this.player.m_21051_((Attribute)AttributesNF.STRENGTH.get()).m_22127_(STRENGTH_UUID);
                    this.player.m_21051_((Attribute)AttributesNF.STRENGTH.get()).m_22125_(new AttributeModifier(STRENGTH_UUID, "Innate strength", (double)points, AttributeModifier.Operation.ADDITION));
                    break;
                }
                case AGILITY: {
                    this.player.m_21051_(Attributes.f_22279_).m_22127_(AGILITY_UUID);
                    this.player.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier(AGILITY_UUID, "Innate agility", (double)points * 0.03, AttributeModifier.Operation.MULTIPLY_BASE));
                    break;
                }
                case PERCEPTION: {
                    this.player.m_21051_((Attribute)AttributesNF.PERCEPTION.get()).m_22127_(PERCEPTION_UUID);
                    this.player.m_21051_((Attribute)AttributesNF.PERCEPTION.get()).m_22125_(new AttributeModifier(PERCEPTION_UUID, "Innate perception", (double)points, AttributeModifier.Operation.ADDITION));
                }
            }
        }
    }

    @Override
    public int getAttributePoints(PlayerAttribute attribute) {
        return this.attributePoints.get((Object)attribute);
    }

    @Override
    public EnumMap<PlayerAttribute, Integer> copyAttributePoints() {
        return this.attributePoints.clone();
    }

    @Override
    public void setHeldItemForRecipe(ItemStack item) {
        this.heldItemRecipeCache = item;
    }

    @Override
    public ItemStack getHeldItemForRecipe() {
        return this.heldItemRecipeCache;
    }

    @Override
    public int getUndeadKilledThisNight() {
        return this.undeadKilled;
    }

    @Override
    public void setUndeadKilledThisNight(int value) {
        this.undeadKilled = value;
    }

    @Override
    public String getMainUUID() {
        return this.mainUUID;
    }

    @Override
    public void setMainUUID(String uuid) {
        this.mainUUID = uuid;
    }

    @Override
    public String getOffUUID() {
        return this.offUUID;
    }

    @Override
    public void setOffUUID(String uuid) {
        this.offUUID = uuid;
    }

    @Override
    public boolean getShouldSwing() {
        return this.shouldSwing;
    }

    @Override
    public void setShouldSwing(boolean value) {
        this.shouldSwing = value;
    }

    @Override
    public void advanceStage(ResourceLocation id) {
        if (id == null) {
            Nightfall.LOGGER.error("Tried to advance null entry, likely from previous version. Ignoring...");
        } else if (!this.hasEntry(id)) {
            Nightfall.LOGGER.error("Stage for entry " + id + " could not be advanced since entry is not learned.");
        } else if (this.getStage(id) == EntryStage.COMPLETED) {
            Nightfall.LOGGER.error("Entry " + id + " cannot be advanced since it is already completed.");
        } else {
            EntryStage nextStage = this.getStage(id).advance();
            this.entryStages.put(id, nextStage);
            if (!this.player.f_19853_.m_5776_()) {
                Knowledge knowledge;
                NetworkHandler.toClient((ServerPlayer)this.player, new EncyclopediaEntryToClient(id, nextStage, this.player.m_142049_()));
                if (nextStage == EntryStage.COMPLETED && (knowledge = (Knowledge)RegistriesNF.getKnowledge().getValue(ResourceLocation.fromNamespaceAndPath((String)id.m_135827_(), (String)(id.m_135815_() + "_entry")))) != null) {
                    this.addKnowledge(knowledge.getRegistryName());
                }
            }
            this.refreshEncyclopedia();
        }
    }

    @Override
    public void unlockEntry(ResourceLocation id) {
        EntryStage stage = this.getStage(id);
        if (stage != EntryStage.LOCKED && stage != EntryStage.HIDDEN) {
            Nightfall.LOGGER.error("Tried to unlock entry " + id + " but it is already unlocked.");
        } else {
            this.addEntry(id, EntriesNF.get((ResourceLocation)id).puzzle == null ? EntryStage.COMPLETED : EntryStage.PUZZLE);
        }
    }

    @Override
    public void addEntry(ResourceLocation id, EntryStage stage) {
        if (id == null) {
            Nightfall.LOGGER.error("Tried to add null entry.");
        } else {
            this.entryStages.put(id, stage);
            if (!this.player.f_19853_.m_5776_()) {
                NetworkHandler.toClient((ServerPlayer)this.player, new EncyclopediaEntryToClient(id, stage, this.player.m_142049_()));
            }
        }
    }

    @Override
    public void removeEntry(ResourceLocation id) {
        if (id != null) {
            this.entryStages.remove(id);
            this.refreshEncyclopedia();
        }
    }

    @Override
    public void addKnowledge(ResourceLocation id) {
        if (id == null) {
            Nightfall.LOGGER.warn("Tried to add null knowledge.");
        } else if (this.knowledge.add(id)) {
            if (!this.player.f_19853_.m_5776_()) {
                NetworkHandler.toClient((ServerPlayer)this.player, new EncyclopediaKnowledgeToClient(id, false, this.player.m_142049_()));
            }
            this.refreshEncyclopedia();
        }
    }

    @Override
    public void addRevelatoryKnowledge(ResourceLocation id) {
        if (id == null) {
            Nightfall.LOGGER.warn("Tried to add null revelatory knowledge.");
        } else if (!this.revelatoryKnowledge.containsKey((Object)id) && !this.knowledge.contains(id)) {
            this.revelatoryKnowledge.put((Object)id, 4800 + this.player.m_21187_().nextInt(7200));
        }
    }

    @Override
    public void tickRevelatoryKnowledge() {
        for (Object2IntMap.Entry entry : this.revelatoryKnowledge.object2IntEntrySet()) {
            if (entry.getIntValue() == 1) {
                this.addKnowledge((ResourceLocation)entry.getKey());
                this.revelatoryKnowledge.remove(entry.getKey(), entry.getIntValue());
                continue;
            }
            this.revelatoryKnowledge.put((Object)((ResourceLocation)entry.getKey()), entry.getIntValue() - 1);
        }
    }

    @Override
    public void removeKnowledge(ResourceLocation id) {
        if (id != null) {
            if (this.knowledge.remove(id)) {
                if (!this.player.f_19853_.m_5776_()) {
                    NetworkHandler.toClient((ServerPlayer)this.player, new EncyclopediaKnowledgeToClient(id, true, this.player.m_142049_()));
                }
            } else {
                this.revelatoryKnowledge.remove((Object)id);
            }
        }
    }

    @Override
    public void refreshEncyclopedia() {
        for (Entry entry : RegistriesNF.getEntries()) {
            EntryStage stage = this.getStage(entry.getRegistryName());
            if (stage != EntryStage.HIDDEN && stage != EntryStage.LOCKED) continue;
            if (entry.shouldUnlock(this)) {
                this.unlockEntry(entry.getRegistryName());
                continue;
            }
            if (stage != EntryStage.HIDDEN || !entry.shouldReveal(this)) continue;
            this.addEntry(entry.getRegistryName(), EntryStage.LOCKED);
        }
    }

    @Override
    public void resetEncyclopedia() {
        this.entryStages.clear();
        this.revelatoryKnowledge.clear();
        this.notifications.clear();
        NetworkHandler.toClient((ServerPlayer)this.player, new EncyclopediaToClient(this.writeEncyclopediaNBT(new CompoundTag()), this.player.m_142049_()));
        this.unlockEntry(EntriesNF.TOOLS.getId());
        this.refreshEncyclopedia();
    }

    @Override
    public boolean hasEntry(ResourceLocation id) {
        return this.entryStages.getOrDefault(id, EntryStage.HIDDEN) != EntryStage.HIDDEN;
    }

    @Override
    public boolean hasEntryStage(ResourceLocation id, EntryStage stage) {
        return this.entryStages.containsKey(id) && stage == this.entryStages.get(id);
    }

    @Override
    public boolean hasCompletedEntry(ResourceLocation id) {
        return this.hasEntryStage(id, EntryStage.COMPLETED);
    }

    @Override
    public boolean hasNoEntries() {
        return this.entryStages.isEmpty();
    }

    @Override
    public boolean hasKnowledge(ResourceLocation id) {
        return this.knowledge.contains(id);
    }

    @Override
    public EntryStage getStage(ResourceLocation id) {
        if (!this.hasEntry(id)) {
            return EntryStage.HIDDEN;
        }
        return this.entryStages.get(id);
    }

    @Override
    public void addEntryNotification(ResourceLocation id) {
        this.notifications.add(id);
    }

    @Override
    public void removeEntryNotification(ResourceLocation id) {
        this.notifications.remove(id);
    }

    @Override
    public boolean hasEntryNotification(ResourceLocation id) {
        return this.notifications.contains(id);
    }

    @Override
    public Set<ResourceLocation> getEntryNotifications() {
        return this.notifications;
    }

    @Override
    public CompoundTag writeEncyclopediaNBT(CompoundTag tag) {
        CompoundTag entryStages = new CompoundTag();
        this.entryStages.forEach((id, stage) -> entryStages.m_128405_(id.toString(), stage.ordinal()));
        tag.m_128365_("entry_stages", (Tag)entryStages);
        CompoundTag revelatoryKnowledge = new CompoundTag();
        this.revelatoryKnowledge.forEach((id, ticks) -> revelatoryKnowledge.m_128405_(id.toString(), ticks.intValue()));
        tag.m_128365_("revelatory_knowledge", (Tag)revelatoryKnowledge);
        ListTag knowledge = new ListTag();
        this.knowledge.forEach(id -> knowledge.add((Object)StringTag.m_129297_((String)id.toString())));
        tag.m_128365_("knowledge", (Tag)knowledge);
        ListTag notifications = new ListTag();
        this.notifications.forEach(id -> notifications.add((Object)StringTag.m_129297_((String)id.toString())));
        tag.m_128365_("notifications", (Tag)notifications);
        return tag;
    }

    @Override
    public void readEncyclopediaNBT(CompoundTag tag) {
        this.entryStages.clear();
        CompoundTag entryStages = tag.m_128469_("entry_stages");
        for (Object id : entryStages.m_128431_()) {
            this.entryStages.put(ResourceLocation.parse((String)id), EntryStage.values()[entryStages.m_128451_((String)id)]);
        }
        this.revelatoryKnowledge.clear();
        CompoundTag revelatoryKnowledge = tag.m_128469_("revelatory_knowledge");
        for (Object id : revelatoryKnowledge.m_128431_()) {
            this.revelatoryKnowledge.put((Object)ResourceLocation.parse((String)id), revelatoryKnowledge.m_128451_((String)id));
        }
        this.knowledge.clear();
        ListTag knowledge = tag.m_128437_("knowledge", 8);
        for (Tag id : knowledge) {
            this.knowledge.add(ResourceLocation.parse((String)id.m_7916_()));
        }
        this.notifications.clear();
        ListTag notifications = tag.m_128437_("notifications", 8);
        for (Tag id : notifications) {
            this.notifications.add(ResourceLocation.parse((String)id.m_7916_()));
        }
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("stamina", this.stamina);
        tag.m_128347_("lastStamina", this.lastStamina);
        tag.m_128405_("lastDodgeTick", this.getLastDodgeTick());
        tag.m_128405_("lastBlockTick", this.getLastBlockTick());
        tag.m_128405_("dodgeDirection", this.getDodgeDirection());
        tag.m_128379_("dugBlock", this.hasDugBlock());
        tag.m_128405_("hitStop", this.getHitStopFrame());
        tag.m_128379_("interacted", this.hasInteracted());
        tag.m_128379_("swing", this.getShouldSwing());
        tag.m_128379_("activeMainhand", this.isMainhandActive());
        tag.m_128359_("mainUUID", this.getMainUUID());
        tag.m_128359_("offUUID", this.getOffUUID());
        tag.m_128379_("crawling", this.isCrawling());
        tag.m_128379_("climbing", this.isClimbing());
        tag.m_128405_("climbTicks", this.getClimbTicks());
        tag.m_128350_("climbX", (float)this.getClimbPosition().f_86214_);
        tag.m_128350_("climbY", (float)this.getClimbPosition().f_86215_);
        tag.m_128350_("climbZ", (float)this.getClimbPosition().f_86216_);
        tag.m_128405_("airTicks", this.getAirTicks());
        tag.m_128405_("crouchTicks", this.getCrouchTicks());
        tag.m_128405_("holdTicks", this.getHoldTicks());
        tag.m_128405_("punchTicks", this.getPunchTicks());
        tag.m_128365_("heldEntity", (Tag)this.heldBlock);
        tag.m_128365_("accessoryInventory", (Tag)this.accessoryInventory.save());
        tag.m_128405_("lastInventoryCapacity", this.lastInventoryCapacity);
        tag.m_128405_("undeadKilled", this.undeadKilled);
        tag.m_128379_("godmode", this.godmode);
        tag.m_128379_("needsAttributeSelection", this.needsAttributeSelection);
        for (PlayerAttribute key : this.attributePoints.keySet()) {
            tag.m_128405_(key.toString() + "Points", this.attributePoints.get((Object)key).intValue());
        }
        this.writeEncyclopediaNBT(tag);
        return tag;
    }

    @Override
    public void readNBT(CompoundTag tag) {
        this.stamina = tag.m_128459_("stamina");
        this.lastStamina = tag.m_128459_("lastStamina");
        this.setLastDodgeTick(tag.m_128451_("lastDodgeTick"));
        this.setLastBlockTick(tag.m_128451_("lastBlockTick"));
        this.setDodgeDirection(tag.m_128451_("dodgeDirection"));
        this.setDugBlock(tag.m_128471_("dugBlock"));
        this.setHitStopFrame(tag.m_128451_("hitStop"));
        this.setInteracted(tag.m_128471_("interacted"));
        this.setShouldSwing(tag.m_128471_("swing"));
        if (tag.m_128471_("activeMainhand")) {
            this.setMainhandActive();
        } else {
            this.setOffhandActive();
        }
        this.setMainUUID(tag.m_128461_("mainUUID"));
        this.setOffUUID(tag.m_128461_("offUUID"));
        this.setCrawling(tag.m_128471_("crawling"));
        this.setClimbing(tag.m_128471_("climbing"));
        this.setClimbTicks(tag.m_128451_("climbTicks"));
        this.setClimbPosition(new Vector3d((double)tag.m_128457_("climbX"), (double)tag.m_128457_("climbY"), (double)tag.m_128457_("climbZ")));
        this.setAirTicks(tag.m_128451_("airTicks"));
        this.setCrouchTicks(tag.m_128451_("crouchTicks"));
        this.setHoldTicks(tag.m_128451_("holdTicks"));
        this.setPunchTicks(tag.m_128451_("punchTicks"));
        this.heldBlock = tag.m_128469_("heldEntity");
        this.accessoryInventory.load(tag.m_128437_("accessoryInventory", 10));
        this.lastInventoryCapacity = tag.m_128451_("lastInventoryCapacity");
        this.undeadKilled = tag.m_128451_("undeadKilled");
        this.godmode = tag.m_128471_("godmode");
        if (tag.m_128441_("needsAttributeSelection")) {
            this.needsAttributeSelection = tag.m_128471_("needsAttributeSelection");
        }
        for (PlayerAttribute key : this.attributePoints.keySet()) {
            this.attributePoints.put(key, tag.m_128451_(key.toString() + "Points"));
        }
        this.readEncyclopediaNBT(tag);
    }

    public static IPlayerData get(Player p) {
        return (IPlayerData)p.getCapability(CAPABILITY, null).orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."));
    }

    public static boolean isPresent(Player p) {
        return p.getCapability(CAPABILITY, null).isPresent();
    }

    public static class PlayerDataCapability
    implements ICapabilitySerializable<CompoundTag> {
        private final PlayerData cap;
        private final LazyOptional<IPlayerData> holder;

        public PlayerDataCapability(Player player) {
            this.cap = new PlayerData(player);
            this.holder = LazyOptional.of(() -> this.cap);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> c, Direction side) {
            return CAPABILITY == c ? this.holder : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.cap.writeNBT();
        }

        public void deserializeNBT(CompoundTag NBT) {
            this.cap.readNBT(NBT);
        }
    }
}

