/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.block.IMicroGrid;
import frostnox.nightfall.block.Metal;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.gui.CategoryToast;
import frostnox.nightfall.client.gui.EntryToast;
import frostnox.nightfall.client.gui.screen.AttributeSelectionScreen;
import frostnox.nightfall.client.gui.screen.LimitedDebugScreen;
import frostnox.nightfall.client.gui.screen.encyclopedia.EncyclopediaCategory;
import frostnox.nightfall.client.gui.screen.encyclopedia.EncyclopediaScreen;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryClient;
import frostnox.nightfall.client.gui.screen.inventory.PlayerInventoryScreen;
import frostnox.nightfall.client.gui.screen.item.ModifiableItemScreen;
import frostnox.nightfall.client.model.AnimatedItemModel;
import frostnox.nightfall.client.render.BlockEntityAsItemRenderer;
import frostnox.nightfall.client.render.entity.PlayerRendererNF;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.item.Armament;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.item.TieredItemMaterial;
import frostnox.nightfall.item.client.IHeldClientTick;
import frostnox.nightfall.item.client.ISwapBehavior;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.capability.EntryNotificationToServer;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.EntriesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.data.SingleSortedSet;
import frostnox.nightfall.util.data.Vec3f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.LegacyStuffWrapper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.compress.utils.Lists;

public class ClientEngine {
    private static final ClientEngine INSTANCE = new ClientEngine();
    private int tickCount;
    public final IKeyConflictContext movementKeyConflict = new IKeyConflictContext(){

        public boolean isActive() {
            ModifiableItemScreen modifiableItemScreen;
            Screen screen = Minecraft.m_91087_().f_91080_;
            return screen == null || screen instanceof ModifiableItemScreen && (modifiableItemScreen = (ModifiableItemScreen)screen).allowMovementInputs();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return other == this || other == KeyConflictContext.IN_GAME;
        }
    };
    public final KeyMapping keyDash = new KeyMapping("nightfall.key.dash", 86, "key.categories.movement");
    public final KeyMapping keyOffhand = new KeyMapping("nightfall.key.offhand", 82, "key.categories.gameplay");
    public final KeyMapping keyEncyclopedia = new KeyMapping("nightfall.key.encyclopedia", 67, "key.categories.gameplay");
    public final KeyMapping keyModify = new KeyMapping("nightfall.key.modify", 90, "key.categories.gameplay");
    public final List<KeyMapping> movementConflictKeys = Lists.newArrayList();
    public int atlasWidth;
    public int atlasHeight;
    private boolean isDevVersion;
    private double normalizedFov;
    private int[] grassCache = new int[65536];
    private int[] forestCache = new int[256];
    private int[] lichenCache = new int[256];
    private int[] oakLeavesCache = new int[256];
    private int[] birchLeavesCache = new int[256];
    private int[] jungleLeavesCache = new int[256];
    private int[] larchLeavesCache = new int[256];
    private int[] mapleLeavesCache = new int[256];
    private int[] willowLeavesCache = new int[256];
    private int[] acaciaLeavesCache = new int[256];
    private int[] caedtarLeavesCache = new int[256];
    private final ResourceLocation waterPostLocation = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"shaders/post/water.json");
    private PostChain waterPost;
    private RenderTarget translucentTarget;
    public float tempFogStart;
    private PlayerRendererNF defaultPlayerRenderer;
    private PlayerRendererNF slimPlayerRenderer;
    private float partialTick;
    private float lastPartialTick;
    private boolean renderersCreated = false;
    private final Minecraft mc = Minecraft.m_91087_();
    public ItemStack mainHandItem = ItemStack.f_41583_;
    public ItemStack offHandItem = ItemStack.f_41583_;
    public float mainHandHeight;
    public float oMainHandHeight;
    public float offHandHeight;
    public float oOffHandHeight;
    public int mainHandLowerTime;
    public int lastMainHandLowerTime;
    public int offHandLowerTime;
    public int lastOffHandLowerTime;
    private DebugScreenOverlay debugScreen;
    private PlayerInventoryScreen inventoryScreen;
    private boolean dirtyScreen;
    private BlockEntityAsItemRenderer beiRenderer;
    private boolean beiRendererCreated = false;
    private ItemStack optionalMainItem = ItemStack.f_41583_;
    private ItemStack optionalOffItem = ItemStack.f_41583_;
    private int modifiableIndexMain = -1;
    private int modifiableIndexOff = -1;
    public boolean canUseModifiableMain;
    public boolean canUseModifiableOff;
    public int lastDashTick = -100;
    private double lastStamina;
    private float lastRenderYRot;
    private float lastRenderXRot;
    private double lastX;
    private double lastY;
    private double lastZ;
    private float lastXRot;
    private float lastYRot;
    private int lastPlayerTickCount;
    private long lastSeasonTime;
    private boolean firstRender = true;
    private boolean firstTick = true;
    public Vec3i microHitResult;
    public AABB microHitBox;
    public BlockPos microBlockEntityPos;
    public final Music MENU_MUSIC;
    public final Music SPRING_MUSIC;
    public final Music SUMMER_MUSIC;
    public final Music FALL_MUSIC;
    public final Music WINTER_MUSIC;
    public final Music NO_MUSIC;
    public final EncyclopediaCategory WYLDERY;
    public final EncyclopediaCategory METALLURGY;
    @Nullable
    public EntryClient openEntry;
    private final HashMap<EncyclopediaCategory, HashMap<ResourceLocation, EntryClient>> categories = new HashMap();
    private final List<EncyclopediaCategory> orderedCategories = new ObjectArrayList(5);
    private final Set<SoundEvent> soundsPlayedThisTick = new ObjectArraySet(4);

    private ClientEngine() {
        this.MENU_MUSIC = new Music((SoundEvent)SoundsNF.MUSIC_MENU.get(), 20, 400, true);
        this.SPRING_MUSIC = new Music((SoundEvent)SoundsNF.MUSIC_SPRING.get(), 6000, 12000, false);
        this.SUMMER_MUSIC = new Music((SoundEvent)SoundsNF.MUSIC_SUMMER.get(), 6000, 12000, false);
        this.FALL_MUSIC = new Music((SoundEvent)SoundsNF.MUSIC_FALL.get(), 6000, 12000, false);
        this.WINTER_MUSIC = new Music((SoundEvent)SoundsNF.MUSIC_WINTER.get(), 6000, 12000, false);
        this.NO_MUSIC = new Music((SoundEvent)SoundsNF.SILENT.get(), 6000, 12000, false);
        this.WYLDERY = new EncyclopediaCategory("nightfall.category.wyldery", ClientEngine.modLoc("textures/gui/icon/wyldery.png"), ClientEngine.modLoc("textures/gui/encyclopedia/background/wyldery.png"), EntriesNF.TOOLS.getId(), SoundsNF.EXPERIMENT_SURVIVAL_FAIL, SoundsNF.EXPERIMENT_SURVIVAL_SUCCESS);
        this.registerCategory(this.WYLDERY);
        this.registerEntry(this.WYLDERY, EntriesNF.TOOLS, 0, 0, new ItemStack((ItemLike)ItemsNF.FLINT_AXE.get()));
        this.registerEntry(this.WYLDERY, EntriesNF.SLING, 2, 0, new ItemStack((ItemLike)ItemsNF.SLING.get()));
        this.registerEntry(this.WYLDERY, EntriesNF.TAMING, 4, 0, new ItemStack((ItemLike)ItemsNF.ROPE.get()), null, null, ClientEngine.image(122, 23, ClientEngine.imageLoc("breeding")), false);
        this.registerEntry(this.WYLDERY, EntriesNF.WOODCARVING, -2, -1, new ItemStack((ItemLike)ItemsNF.WOODEN_BOWL.get()));
        this.registerEntry(this.WYLDERY, EntriesNF.WOODWORKING, -4, -1, new ItemStack((ItemLike)ItemsNF.PLANKS.get(Tree.OAK).get()));
        this.registerEntry(this.WYLDERY, EntriesNF.ADVANCED_WOODWORKING, -5, -3, new ItemStack((ItemLike)ItemsNF.CHESTS.get(Tree.OAK).get()));
        this.registerEntry(this.WYLDERY, EntriesNF.WOODEN_SHIELD, -3, -3, new ItemStack((ItemLike)ItemsNF.IRONWOOD_SHIELD.get()));
        this.registerEntry(this.WYLDERY, EntriesNF.TANNING, -6, -1, new ItemStack((ItemLike)ItemsNF.LEATHER.get()), null, ClientEngine.image(58, 12, ClientEngine.imageLoc("item_in_water")), null, false);
        this.registerEntry(this.WYLDERY, EntriesNF.CAMPFIRE, 0, -2, new ItemStack((ItemLike)ItemsNF.CAMPFIRE.get()));
        this.registerEntry(this.WYLDERY, EntriesNF.POTTERY, 0, -4, new ItemStack((ItemLike)ItemsNF.POT.get()), null, null, ClientEngine.image(96, 36, ClientEngine.imageLoc("kiln")), false);
        this.registerEntry(this.WYLDERY, EntriesNF.COOKING, 0, -6, new ItemStack((ItemLike)ItemsNF.HEARTY_STEW.get()), null, null, ClientEngine.image(31, 31, ClientEngine.imageLoc("stew")), false);
        this.registerEntry(this.WYLDERY, EntriesNF.WEAVING, -2, 1, new ItemStack((ItemLike)ItemsNF.LINEN.get()));
        this.registerEntry(this.WYLDERY, EntriesNF.MEDICINAL_BANDAGE, -2, 3, new ItemStack((ItemLike)ItemsNF.MEDICINAL_BANDAGE.get()));
        this.registerEntry(this.WYLDERY, EntriesNF.BOW_AND_ARROW, -4, 1, new ItemStack((ItemLike)ItemsNF.BOWS.get(Tree.OAK).get()));
        this.registerEntry(this.WYLDERY, EntriesNF.WARDING_CHARM, 0, 2, new ItemStack((ItemLike)ItemsNF.WARDING_CHARM.get()));
        this.registerEntry(this.WYLDERY, EntriesNF.WARDING_EFFIGY, 0, 4, new ItemStack((ItemLike)ItemsNF.WARDING_EFFIGY.get()), null, null, ClientEngine.image(90, 90, ClientEngine.imageLoc("warding_effigy")), false);
        this.METALLURGY = new EncyclopediaCategory("nightfall.category.metallurgy", ClientEngine.modLoc("textures/gui/icon/metallurgy.png"), ClientEngine.modLoc("textures/gui/encyclopedia/background/metallurgy.png"), EntriesNF.CASTING.getId(), SoundsNF.EXPERIMENT_METALLURGY_FAIL, SoundsNF.EXPERIMENT_METALLURGY_SUCCESS);
        this.registerCategory(this.METALLURGY);
        this.registerEntry(this.METALLURGY, EntriesNF.CASTING, 0, 0, new ItemStack((ItemLike)ItemsNF.CRUCIBLE.get()), null, null, ClientEngine.image(67, 25, ClientEngine.imageLoc("alloying")), false);
        this.registerEntry(this.METALLURGY, EntriesNF.SMITHING, -2, -1, new ItemStack((ItemLike)ItemsNF.ANVILS_METAL.get(Metal.COPPER).get()), null, null, ClientEngine.image(100, 12, ClientEngine.imageLoc("smithing")), false);
        this.registerEntry(this.METALLURGY, EntriesNF.SMELTING, -2, 1, new ItemStack((ItemLike)ItemsNF.INGOTS.get(Metal.COPPER).get()), null, null, ClientEngine.image(120, 58, ClientEngine.imageLoc("furnace")), false);
        this.registerEntry(this.METALLURGY, EntriesNF.IRONWORKING, -4, 0, new ItemStack((ItemLike)ItemsNF.INGOTS.get(Metal.IRON).get()));
        this.registerEntry(this.METALLURGY, EntriesNF.SABRE, 3, -5, new ItemStack((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.COPPER).get(Armament.SABRE).get()), true);
        this.registerEntry(this.METALLURGY, EntriesNF.SICKLE, 5, -5, new ItemStack((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.COPPER).get(Armament.SICKLE).get()), true);
        this.registerEntry(this.METALLURGY, EntriesNF.BUCKET, -2, -5, new ItemStack((ItemLike)ItemsNF.BRONZE_BUCKET.get()));
        this.registerEntry(this.METALLURGY, EntriesNF.PLATE_ARMOR, -1, -3, new ItemStack((ItemLike)ItemsNF.PLATES.get(Metal.COPPER).get()));
        this.registerEntry(this.METALLURGY, EntriesNF.CHAINMAIL_ARMOR, 1, -3, new ItemStack((ItemLike)ItemsNF.CHAINMAIL.get(Metal.COPPER).get()));
        this.registerEntry(this.METALLURGY, EntriesNF.SCALE_ARMOR, -3, -3, new ItemStack((ItemLike)ItemsNF.SCALES.get(Metal.COPPER).get()));
        this.registerEntry(this.METALLURGY, EntriesNF.MACE, -3, -4, new ItemStack((ItemLike)ItemsNF.METAL_ARMAMENTS.get(TieredItemMaterial.COPPER).get(Armament.MACE).get()));
        this.registerEntry(this.METALLURGY, EntriesNF.SHIELD, -1, -4, new ItemStack((ItemLike)ItemsNF.METAL_SHIELDS.get(Metal.COPPER).get()));
        this.registerEntry(this.METALLURGY, EntriesNF.SLAYER_PLATE, 3, -4, ClientEngine.dyedItem(new ItemStack((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.IRON_PLATE_SLAYER).get()), 0x844545), true);
        this.registerEntry(this.METALLURGY, EntriesNF.SLAYER_CHAINMAIL, 3, -3, ClientEngine.dyedItem(new ItemStack((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.IRON_CHAINMAIL_SLAYER).get()), 0x844545), true);
        this.registerEntry(this.METALLURGY, EntriesNF.SLAYER_SCALE, 3, -2, ClientEngine.dyedItem(new ItemStack((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.IRON_SCALE_SLAYER).get()), 0x844545), true);
        this.registerEntry(this.METALLURGY, EntriesNF.EXPLORER_PLATE, 5, -4, ClientEngine.dyedItem(new ItemStack((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.IRON_PLATE_EXPLORER).get()), 14930341), true);
        this.registerEntry(this.METALLURGY, EntriesNF.EXPLORER_CHAINMAIL, 5, -3, ClientEngine.dyedItem(new ItemStack((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.IRON_CHAINMAIL_EXPLORER).get()), 14930341), true);
        this.registerEntry(this.METALLURGY, EntriesNF.EXPLORER_SCALE, 5, -2, ClientEngine.dyedItem(new ItemStack((ItemLike)ItemsNF.CHESTPLATES.get(TieredArmorMaterial.IRON_SCALE_EXPLORER).get()), 14930341), true);
    }

    public static ClientEngine get() {
        return INSTANCE;
    }

    private static ItemStack dyedItem(ItemStack item, int color) {
        DyeableLeatherItem dyeableItem = (DyeableLeatherItem)item.m_41720_();
        dyeableItem.m_41115_(item, color);
        return item;
    }

    public RenderTarget getTranslucentTarget() {
        return this.translucentTarget;
    }

    private void setupShaders() {
        if (this.translucentTarget != null) {
            this.translucentTarget.m_83930_();
            this.translucentTarget = null;
        }
        this.waterPost = this.getShader(this.waterPost, this.waterPostLocation);
        this.translucentTarget = this.waterPost.m_110036_("translucent");
    }

    private PostChain getShader(PostChain oldShader, ResourceLocation location) {
        if (oldShader != null) {
            oldShader.close();
        }
        PostChain shader = null;
        try {
            shader = new PostChain(this.mc.m_91097_(), this.mc.m_91098_(), this.mc.m_91385_(), location);
            shader.m_110025_(this.mc.m_91268_().m_85441_(), this.mc.m_91268_().m_85442_());
        }
        catch (IOException exception) {
            Nightfall.LOGGER.error("Failed to load shader: {}", (Object)location, (Object)exception);
        }
        catch (JsonSyntaxException exception) {
            Nightfall.LOGGER.error("Failed to parse shader: {}", (Object)location, (Object)exception);
        }
        return shader;
    }

    public void resize(int width, int height) {
        if (this.waterPost != null) {
            this.waterPost.m_110025_(width, height);
        }
    }

    public void applyWaterShader(Matrix4f projMat, float partialTick) {
        if (!Nightfall.isRubidiumLoaded || Minecraft.m_91085_()) {
            return;
        }
        EffectInstance pass0 = ((PostPass)this.waterPost.f_110009_.get(0)).m_110074_();
        Matrix4f invMat = projMat.m_27658_();
        invMat.m_27646_(Vector3f.f_122223_.m_122240_(this.mc.f_91063_.m_109153_().m_90589_()));
        invMat.m_27657_();
        pass0.m_108960_("InvMat").m_5679_(invMat);
        pass0.m_108960_("DepthValue").m_5985_(Math.min(12.0f, RenderSystem.m_157199_() / 16.0f / 2.0f));
        pass0.m_108960_("FogColor").m_5941_(RenderSystem.m_157198_());
        pass0.m_108960_("FogStart").m_5985_(this.tempFogStart);
        pass0.m_108960_("FogEnd").m_5985_(RenderSystem.m_157199_());
        pass0.m_108960_("FogShape").m_142617_(RenderSystem.m_202041_().m_202324_());
        this.waterPost.m_110023_(partialTick);
        this.mc.m_91385_().m_83945_(this.translucentTarget);
    }

    public void dataExcludedInit() {
        this.setMovementConflictKeys(this.mc.f_91066_.f_92085_, this.mc.f_91066_.f_92087_, this.mc.f_91066_.f_92086_, this.mc.f_91066_.f_92088_, this.mc.f_91066_.f_92089_, this.mc.f_91066_.f_92090_, this.mc.f_91066_.f_92091_, this.mc.f_91066_.f_92103_, this.keyDash);
        this.mc.m_91301_().m_120588_(TutorialSteps.NONE);
        this.mc.f_91066_.f_92031_ = true;
        this.isDevVersion = this.mc.m_91388_().equals("MOD_DEV");
    }

    public void tickRenderStart() {
        this.partialTick = this.mc.m_91104_() ? this.lastPartialTick : this.mc.m_91296_();
        Camera camera = this.mc.f_91063_.m_109153_();
        this.normalizedFov = this.mc.f_91063_.m_109141_(camera, this.partialTick, true) / 85.556;
        if (this.mc.f_91074_ != null && this.mc.f_91074_.m_6084_() && !this.mc.m_91104_()) {
            IActionTracker capA = ActionTracker.get((Entity)this.mc.f_91074_);
            Action action = capA.getAction();
            if (action == null) {
                return;
            }
            if (capA.getState() == action.getChargeState() && !capA.isStunnedOrHitPaused()) {
                capA.setChargePartial(this.partialTick);
            }
            LocalPlayer player = this.mc.f_91074_;
            if (this.firstRender) {
                this.lastX = player.m_20185_();
                this.lastY = player.m_20186_();
                this.lastZ = player.m_20189_();
                this.lastXRot = player.m_146909_();
                this.lastYRot = player.m_146908_();
                this.lastRenderYRot = player.m_146908_();
                this.lastPlayerTickCount = player.f_19797_;
                this.firstRender = false;
            }
            if (action instanceof Attack) {
                Attack attack = (Attack)action;
                if (!ActionsNF.isEmpty(capA.getActionID())) {
                    float limitY = Math.max(0.0f, ((float)player.f_19797_ + this.partialTick - ((float)this.lastPlayerTickCount + this.lastPartialTick)) * attack.getMaxYRot(capA.getState()));
                    float limitX = Math.max(0.0f, ((float)player.f_19797_ + this.partialTick - ((float)this.lastPlayerTickCount + this.lastPartialTick)) * attack.getMaxXRot(capA.getState()));
                    player.m_146922_(Mth.m_14036_((float)player.m_146908_(), (float)(this.lastRenderYRot - limitY), (float)(this.lastRenderYRot + limitY)));
                    player.m_146926_(Mth.m_14036_((float)player.m_146909_(), (float)(this.lastRenderXRot - limitX), (float)(this.lastRenderXRot + limitX)));
                }
            }
            this.lastRenderYRot = player.m_146908_();
            this.lastRenderXRot = player.m_146909_();
            this.lastPlayerTickCount = player.f_19797_;
        }
        this.lastPartialTick = this.partialTick;
    }

    public void tickRenderEnd() {
        if (!this.mc.m_91104_()) {
            LocalPlayer player = this.mc.f_91074_;
            this.microHitResult = null;
            this.microHitBox = null;
            this.microBlockEntityPos = null;
            if ((player.m_20089_() == Pose.STANDING || player.m_20089_() == Pose.CROUCHING) && (player.m_21205_().m_204117_(TagsNF.GRID_INTERACTABLE) || player.m_21206_().m_204117_(TagsNF.GRID_INTERACTABLE))) {
                Vec3 startVec;
                int searchReach = 3;
                int playerReach = 2;
                Camera camera = this.mc.f_91063_.m_109153_();
                Vector3f look = new Vector3f(player.m_20252_(this.partialTick));
                Vec3 vec3 = startVec = camera.m_90594_() ? player.m_20299_(this.partialTick) : camera.m_90583_();
                if (this.mc.f_91066_.f_92080_) {
                    float f = player.f_19787_ - player.f_19867_;
                    float f1 = -(player.f_19787_ + f * this.getPartialTick());
                    float f2 = Mth.m_14179_((float)this.getPartialTick(), (float)player.f_36099_, (float)player.f_36100_);
                    float xBob = Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 0.5f;
                    float yaw = MathUtil.toRadians(Mth.m_14177_((float)(camera.m_90590_() + 90.0f)));
                    startVec = startVec.m_82492_((double)(xBob * Mth.m_14031_((float)(-yaw))), (double)(-Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI)) * f2)), (double)(xBob * Mth.m_14089_((float)(-yaw))));
                    Quaternion bob = Vector3f.f_122227_.m_122240_(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 3.0f);
                    bob.m_80148_(Vector3f.f_122223_.m_122240_(Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f));
                    look.m_122251_(bob);
                }
                look.m_122261_((float)playerReach);
                Vec3 endVec = startVec.m_82520_((double)look.m_122239_(), (double)look.m_122260_(), (double)look.m_122269_());
                BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
                for (int x = -searchReach; x <= searchReach; ++x) {
                    for (int y = -searchReach; y <= searchReach; ++y) {
                        for (int z = -searchReach; z <= searchReach; ++z) {
                            Vector3f gridSize;
                            blockPos.m_122169_(startVec.f_82479_ + (double)x, startVec.f_82480_ + (double)y, startVec.f_82481_ + (double)z);
                            BlockEntity blockEntity = player.f_19853_.m_7702_((BlockPos)blockPos);
                            if (!(blockEntity instanceof IMicroGrid)) continue;
                            IMicroGrid gridEntity = (IMicroGrid)blockEntity;
                            float rot = -gridEntity.getRotationDegrees();
                            Vec3 gridPos = gridEntity.getWorldPos((BlockPos)blockPos, 0.0f, 0.0f, 0.0f);
                            Optional prelimHitVec = new AABB(gridPos, gridPos.m_82520_((double)(gridSize = MathUtil.rotatePointByYaw(new Vector3f((float)gridEntity.getGridXSize() / 16.0f, (float)gridEntity.getGridYSize() / 16.0f, (float)gridEntity.getGridZSize() / 16.0f), rot)).m_122239_(), (double)gridSize.m_122260_(), (double)gridSize.m_122269_())).m_82371_(startVec, endVec);
                            if (prelimHitVec.isEmpty() || player.f_19853_.m_45547_(new ClipContext(startVec, (Vec3)prelimHitVec.get(), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_6662_() != HitResult.Type.MISS) continue;
                            double closestDistSqr = Double.MAX_VALUE;
                            for (int gridX = 0; gridX < gridEntity.getGridXSize(); ++gridX) {
                                for (int gridY = 0; gridY < gridEntity.getGridYSize(); ++gridY) {
                                    for (int gridZ = 0; gridZ < gridEntity.getGridZSize(); ++gridZ) {
                                        double distSqr;
                                        Vector3f selectPos = MathUtil.rotatePointByYaw(new Vector3f((float)gridX / 16.0f, (float)gridY / 16.0f, (float)gridZ / 16.0f), rot);
                                        Vector3f selectSize = MathUtil.rotatePointByYaw(new Vector3f(0.0625f, 0.0625f, 0.0625f), rot);
                                        Vec3 finalPos = gridPos.m_82520_((double)selectPos.m_122239_(), (double)selectPos.m_122260_(), (double)selectPos.m_122269_());
                                        Optional hitVec = new AABB(finalPos, finalPos.m_82520_((double)selectSize.m_122239_(), (double)selectSize.m_122260_(), (double)selectSize.m_122269_())).m_82371_(startVec, endVec);
                                        if (!gridEntity.getGrid()[gridX][gridY][gridZ] || !hitVec.isPresent() || !((distSqr = startVec.m_82557_((Vec3)hitVec.get())) < closestDistSqr)) continue;
                                        this.microHitResult = new Vec3i(gridX, gridY, gridZ);
                                        this.microHitBox = new AABB((double)gridX / 16.0 - 0.001, (double)gridY / 16.0 - 0.001, (double)gridZ / 16.0 - 0.001, (double)(gridX + 1) / 16.0 + 0.001, (double)(gridY + 1) / 16.0 + 0.001, (double)(gridZ + 1) / 16.0 + 0.001);
                                        this.microBlockEntityPos = new BlockPos((Vec3i)blockPos);
                                        closestDistSqr = distSqr;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void tickStart() {
        ++this.tickCount;
        this.soundsPlayedThisTick.clear();
        LocalPlayer player = this.mc.f_91074_;
        if (player != null && player.m_6084_()) {
            Item item;
            IPlayerData capP = PlayerData.get((Player)player);
            if (this.firstTick) {
                capP.setLastMainItem();
                capP.setLastOffItem();
                this.lastStamina = capP.getStamina();
                if (LevelData.isPresent(player.f_19853_)) {
                    this.lastSeasonTime = LevelData.get(player.f_19853_).getSeasonTime();
                }
            }
            this.oMainHandHeight = this.mainHandHeight;
            this.oOffHandHeight = this.offHandHeight;
            ItemStack mainItem = player.m_21205_();
            ItemStack offItem = player.m_21206_();
            if (ItemStack.m_41728_((ItemStack)this.mainHandItem, (ItemStack)mainItem)) {
                this.mainHandItem = mainItem;
            }
            if (ItemStack.m_41728_((ItemStack)this.offHandItem, (ItemStack)offItem)) {
                this.offHandItem = offItem;
            }
            if (player.m_108637_()) {
                this.mainHandHeight = Mth.m_14036_((float)(this.mainHandHeight - 0.15f), (float)0.0f, (float)1.0f);
                this.offHandHeight = Mth.m_14036_((float)(this.offHandHeight - 0.15f), (float)0.0f, (float)1.0f);
            } else {
                float f;
                float f2;
                BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_174264_(this.mainHandItem, player.f_19853_, (LivingEntity)player, 0);
                if (bakedModel instanceof AnimatedItemModel.Model) {
                    AnimatedItemModel.Model model = (AnimatedItemModel.Model)bakedModel;
                    f2 = (float)model.swapSpeed * 0.31f;
                } else {
                    f2 = 0.31f;
                }
                float limitMain = f2;
                BakedModel bakedModel2 = Minecraft.m_91087_().m_91291_().m_174264_(this.offHandItem, player.f_19853_, (LivingEntity)player, 0);
                if (bakedModel2 instanceof AnimatedItemModel.Model) {
                    AnimatedItemModel.Model model = (AnimatedItemModel.Model)bakedModel2;
                    f = (float)model.swapSpeed * 0.31f;
                } else {
                    f = 0.31f;
                }
                float limitOff = f;
                boolean requipM = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.mainHandItem, (ItemStack)mainItem, (int)player.m_150109_().f_35977_);
                boolean requipO = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.offHandItem, (ItemStack)offItem, (int)-1);
                if (!requipM && this.mainHandItem != mainItem) {
                    this.mainHandItem = mainItem;
                }
                if (!requipO && this.offHandItem != offItem) {
                    this.offHandItem = offItem;
                }
                this.mainHandHeight += Mth.m_14036_((float)((float)(!requipM ? 1 : 0) - this.mainHandHeight), (float)(-limitMain), (float)limitMain);
                this.offHandHeight += Mth.m_14036_((float)((float)(!requipO ? 1 : 0) - this.offHandHeight), (float)(-limitOff), (float)limitOff);
            }
            if (this.mainHandHeight < 0.05f) {
                this.mainHandItem = mainItem;
            }
            if (this.offHandHeight < 0.05f) {
                this.offHandItem = offItem;
            }
            if (!capP.getLastMainItem().m_41726_(mainItem) || this.firstTick) {
                Item item2;
                this.optionalMainItem = ItemStack.f_41583_;
                this.canUseModifiableMain = true;
                if (!mainItem.m_41619_() && (item2 = mainItem.m_41720_()) instanceof ISwapBehavior) {
                    ISwapBehavior swapItem = (ISwapBehavior)item2;
                    swapItem.swapClient(this.mc, mainItem, (Player)player, true);
                }
                capP.setLastMainItem();
            }
            if (!capP.getLastOffItem().m_41726_(offItem) || this.firstTick) {
                Item item3;
                this.optionalOffItem = ItemStack.f_41583_;
                this.canUseModifiableOff = true;
                if (!offItem.m_41619_() && (item3 = offItem.m_41720_()) instanceof ISwapBehavior) {
                    ISwapBehavior swapItem = (ISwapBehavior)item3;
                    swapItem.swapClient(this.mc, offItem, (Player)player, false);
                }
                capP.setLastOffItem();
            }
            if ((item = mainItem.m_41720_()) instanceof IHeldClientTick) {
                IHeldClientTick tickItem = (IHeldClientTick)item;
                tickItem.onHeldTickClient(this.mc, mainItem, (Player)player, true);
            }
            if ((item = offItem.m_41720_()) instanceof IHeldClientTick) {
                IHeldClientTick tickItem = (IHeldClientTick)item;
                tickItem.onHeldTickClient(this.mc, offItem, (Player)player, false);
            }
            this.lastMainHandLowerTime = this.mainHandLowerTime;
            if (this.canUseModifiableMain || this.optionalMainItem.m_41619_() || this.getPlayer().m_150110_().f_35937_) {
                if (this.mainHandLowerTime > 0) {
                    --this.mainHandLowerTime;
                }
            } else if (this.mainHandLowerTime < 4) {
                ++this.mainHandLowerTime;
            }
            this.lastOffHandLowerTime = this.offHandLowerTime;
            if (this.canUseModifiableOff || this.optionalOffItem.m_41619_() || this.getPlayer().m_150110_().f_35937_) {
                if (this.offHandLowerTime > 0) {
                    --this.offHandLowerTime;
                }
            } else if (this.offHandLowerTime < 4) {
                ++this.offHandLowerTime;
            }
            this.lastX = player.m_20185_();
            this.lastY = player.m_20186_();
            this.lastZ = player.m_20189_();
            this.lastXRot = player.m_146909_();
            this.lastYRot = player.m_146908_();
            this.lastStamina = capP.getStamina();
            this.firstTick = false;
        }
    }

    public void tickEnd() {
        if (this.mc.f_91073_ != null && LevelData.isPresent((Level)this.mc.f_91073_)) {
            ILevelData cap = LevelData.get((Level)this.mc.f_91073_);
            cap.tick();
            if (Math.abs(cap.getSeasonTime() - this.lastSeasonTime) > 1200L) {
                Minecraft.m_91087_().f_91060_.m_109818_();
            }
            this.lastSeasonTime = cap.getSeasonTime();
        }
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public double getLastStamina() {
        return this.lastStamina;
    }

    public float getLastRenderYRot() {
        return this.lastRenderYRot;
    }

    public float getLastRenderXRot() {
        return this.lastRenderXRot;
    }

    public double getLastX() {
        return this.lastX;
    }

    public double getLastY() {
        return this.lastY;
    }

    public double getLastZ() {
        return this.lastZ;
    }

    public float getLastXRot() {
        return this.lastXRot;
    }

    public float getLastYRot() {
        return this.lastYRot;
    }

    public int getLastPlayerTickCount() {
        return this.lastPlayerTickCount;
    }

    public ItemStack getOptionalMainItem() {
        return this.optionalMainItem;
    }

    public ItemStack getOptionalOffItem() {
        return this.optionalOffItem;
    }

    public double getNormalizedFov() {
        return this.normalizedFov;
    }

    private void fillGrassCache(int[] colors) {
        this.grassCache = colors;
    }

    public int getGrassColor(float temperature, float humidity) {
        int h;
        int t;
        int i;
        if (temperature > 0.4f) {
            temperature = Math.min(1.0f, temperature + (temperature - 0.4f));
        }
        if ((humidity *= temperature) < 0.33f) {
            temperature = Math.min(1.0f, temperature + 0.33f - humidity);
        }
        if ((i = (t = (int)((1.0 - (double)temperature) * 255.0)) | (h = (int)((1.0 - (double)humidity) * 255.0)) << 8) < 0) {
            return this.grassCache[0];
        }
        if (i >= 65536) {
            return this.grassCache[65535];
        }
        return this.grassCache[i];
    }

    private void fillForestCache(int[] colors) {
        this.forestCache = colors;
    }

    public int getForestColor(float temperature) {
        int i = (int)(temperature * 255.0f);
        if (i >= 256) {
            return this.forestCache[255];
        }
        return this.forestCache[i];
    }

    private void fillLichenCache(int[] colors) {
        this.lichenCache = colors;
    }

    public int getLichenColor(float humidity) {
        int i = (int)(humidity * 255.0f);
        if (i >= 256) {
            return this.lichenCache[255];
        }
        return this.lichenCache[i];
    }

    public int getLeavesColor(Tree type, float season) {
        return switch (type) {
            case Tree.BIRCH -> this.getBirchLeavesColor(season);
            case Tree.JUNGLE -> this.getJungleLeavesColor(season);
            case Tree.LARCH -> this.getLarchLeavesColor(season);
            case Tree.OAK -> this.getOakLeavesColor(season);
            case Tree.MAPLE -> this.getMapleLeavesColor(season);
            case Tree.WILLOW -> this.getWillowLeavesColor(season);
            case Tree.ACACIA -> this.getAcaciaLeavesColor(season);
            case Tree.CAEDTAR -> this.getCaedtarLeavesColor(season);
            default -> 0xFFFFFF;
        };
    }

    private void fillOakLeavesCache(int[] colors) {
        this.oakLeavesCache = colors;
    }

    private int getOakLeavesColor(float season) {
        if (season < 0.0f || season > 1.0f) {
            return this.oakLeavesCache[0];
        }
        return this.oakLeavesCache[(int)((double)season * 255.0)];
    }

    private void fillBirchLeavesCache(int[] colors) {
        this.birchLeavesCache = colors;
    }

    private int getBirchLeavesColor(float season) {
        if (season < 0.0f || season > 1.0f) {
            return this.birchLeavesCache[0];
        }
        return this.birchLeavesCache[(int)((double)season * 255.0)];
    }

    private void fillJungleLeavesCache(int[] colors) {
        this.jungleLeavesCache = colors;
    }

    private int getJungleLeavesColor(float season) {
        if (season < 0.0f || season > 1.0f) {
            return this.jungleLeavesCache[0];
        }
        return this.jungleLeavesCache[(int)((double)season * 255.0)];
    }

    private void fillLarchLeavesCache(int[] colors) {
        this.larchLeavesCache = colors;
    }

    private int getLarchLeavesColor(float season) {
        if (season < 0.0f || season > 1.0f) {
            return this.larchLeavesCache[0];
        }
        return this.larchLeavesCache[(int)((double)season * 255.0)];
    }

    private void fillMapleLeavesCache(int[] colors) {
        this.mapleLeavesCache = colors;
    }

    private int getMapleLeavesColor(float season) {
        if (season < 0.0f || season > 1.0f) {
            return this.mapleLeavesCache[0];
        }
        return this.mapleLeavesCache[(int)((double)season * 255.0)];
    }

    private void fillWillowLeavesCache(int[] colors) {
        this.willowLeavesCache = colors;
    }

    private int getWillowLeavesColor(float season) {
        if (season < 0.0f || season > 1.0f) {
            return this.willowLeavesCache[0];
        }
        return this.willowLeavesCache[(int)((double)season * 255.0)];
    }

    private void fillAcaciaLeavesCache(int[] colors) {
        this.acaciaLeavesCache = colors;
    }

    private int getAcaciaLeavesColor(float season) {
        if (season < 0.0f || season > 1.0f) {
            return this.acaciaLeavesCache[0];
        }
        return this.acaciaLeavesCache[(int)((double)season * 255.0)];
    }

    private void fillCaedtarLeavesCache(int[] colors) {
        this.caedtarLeavesCache = colors;
    }

    private int getCaedtarLeavesColor(float season) {
        if (season < 0.0f || season > 1.0f) {
            return this.caedtarLeavesCache[0];
        }
        return this.caedtarLeavesCache[(int)((double)season * 255.0)];
    }

    public Player getPlayer() {
        return this.mc.f_91074_;
    }

    public List<Entity> getPlayerToPush(ActionableEntity pusher) {
        if (this.mc.f_91074_ != null && pusher.getPushForce() >= 2.0f && pusher.m_142469_().m_82381_(this.mc.f_91074_.m_142469_()) && EntitySelector.m_20421_((Entity)pusher).test(this.mc.f_91074_)) {
            return List.of(this.mc.f_91074_);
        }
        return List.of();
    }

    public Vec3 getPlayerPosition(float partialTick) {
        if (this.mc.f_91074_ != null) {
            double x = Mth.m_14139_((double)partialTick, (double)this.lastX, (double)this.mc.f_91074_.m_20185_());
            double y = Mth.m_14139_((double)partialTick, (double)this.lastY, (double)this.mc.f_91074_.m_20186_());
            double z = Mth.m_14139_((double)partialTick, (double)this.lastZ, (double)this.mc.f_91074_.m_20189_());
            return new Vec3(x, y, z);
        }
        return Vec3.f_82478_;
    }

    public PlayerRendererNF getPlayerCombatRenderer(PlayerRenderer renderer) {
        if (!this.renderersCreated) {
            this.createPlayerRenderers();
        }
        return ((EntityRenderer)this.mc.m_91290_().getSkinMap().get("default")).equals(renderer) ? this.defaultPlayerRenderer : this.slimPlayerRenderer;
    }

    public PlayerRendererNF getDefaultPlayerCombatRenderer() {
        if (!this.renderersCreated) {
            this.createPlayerRenderers();
        }
        return this.defaultPlayerRenderer;
    }

    public PlayerRendererNF getSlimPlayerCombatRenderer() {
        if (!this.renderersCreated) {
            this.createPlayerRenderers();
        }
        return this.slimPlayerRenderer;
    }

    private void createPlayerRenderers() {
        EntityRendererProvider.Context renderer = new EntityRendererProvider.Context(this.mc.m_91290_(), this.mc.m_91291_(), this.mc.m_91098_(), this.mc.m_167973_(), this.mc.f_91062_);
        this.defaultPlayerRenderer = new PlayerRendererNF(renderer, false);
        this.slimPlayerRenderer = new PlayerRendererNF(renderer, true, (ImmutableMap<String, Vec3f>)ImmutableMap.of((Object)"arm", (Object)new Vec3f(0.75f, 1.0f, 1.0f)));
        this.renderersCreated = true;
    }

    public BlockEntityAsItemRenderer getBlockEntityAsItemRenderer() {
        if (!this.beiRendererCreated) {
            this.createBlockEntityAsItemRenderer();
        }
        return this.beiRenderer;
    }

    private void createBlockEntityAsItemRenderer() {
        this.beiRenderer = new BlockEntityAsItemRenderer();
        this.beiRendererCreated = true;
    }

    public void setMovementConflictKey(KeyMapping key) {
        key.setKeyConflictContext(this.movementKeyConflict);
        this.movementConflictKeys.add(key);
    }

    public void setMovementConflictKeys(KeyMapping ... keys) {
        for (KeyMapping key : keys) {
            this.setMovementConflictKey(key);
        }
    }

    public boolean isDevVersion() {
        return this.isDevVersion;
    }

    public boolean isShiftHeld() {
        return InputConstants.m_84830_((long)this.mc.m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)this.mc.m_91268_().m_85439_(), (int)344);
    }

    public boolean isCtrlHeld() {
        return Screen.m_96637_();
    }

    public Component getAttackKeyName() {
        return this.mc.f_91066_.f_92096_.getKey().m_84875_();
    }

    public Component getUseKeyName() {
        return this.mc.f_91066_.f_92095_.getKey().m_84875_();
    }

    public DebugScreenOverlay getLimitedDebugScreen() {
        if (this.debugScreen == null) {
            this.debugScreen = new LimitedDebugScreen(this.mc);
        }
        return this.debugScreen;
    }

    public PlayerInventoryScreen getInventoryScreen(Player player) {
        if (this.inventoryScreen == null || this.dirtyScreen) {
            this.inventoryScreen = new PlayerInventoryScreen(player);
            this.dirtyScreen = false;
        }
        return this.inventoryScreen;
    }

    public void dirtyScreen() {
        this.dirtyScreen = true;
    }

    public void updateRecipeSearchItems() {
        if (this.mc.f_91080_ != null && this.mc.f_91080_ == this.inventoryScreen) {
            this.inventoryScreen.recipeSearch.updateItems();
        }
    }

    public boolean isRecipeSearchOpen() {
        if (this.mc.f_91080_ != null && this.mc.f_91080_ == this.inventoryScreen) {
            return this.inventoryScreen.selectedComponent == this.inventoryScreen.recipeSearch;
        }
        return false;
    }

    public void openAttributeSelectionScreen() {
        if (!(this.mc.f_91080_ instanceof AttributeSelectionScreen) && this.mc.f_91074_ != null && this.mc.f_91074_.m_6084_()) {
            this.mc.m_91152_((Screen)new AttributeSelectionScreen());
        }
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public float getLastPartialTick() {
        return this.lastPartialTick;
    }

    public void setModifiableIndex(boolean main, ItemStack item, int index) {
        if (main) {
            this.optionalMainItem = item;
            this.modifiableIndexMain = index;
        } else {
            this.optionalOffItem = item;
            this.modifiableIndexOff = index;
        }
    }

    public int getModifiableIndexMain() {
        return this.modifiableIndexMain;
    }

    public int getModifiableIndexOff() {
        return this.modifiableIndexOff;
    }

    private static ResourceLocation modLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)name);
    }

    private static ResourceLocation itemLoc(RegistryObject<? extends Item> item) {
        return ResourceLocation.fromNamespaceAndPath((String)item.getId().m_135827_(), (String)("textures/item/" + item.getId().m_135815_() + ".png"));
    }

    private static ResourceLocation invItemLoc(RegistryObject<? extends Item> item) {
        return ResourceLocation.fromNamespaceAndPath((String)item.getId().m_135827_(), (String)("textures/item/" + item.getId().m_135815_() + "_inventory.png"));
    }

    private static ResourceLocation imageLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)("textures/gui/encyclopedia/image/" + name + ".png"));
    }

    private static EntryClient.Image image(int width, int height, ResourceLocation texture) {
        return new EntryClient.Image(width, height, texture);
    }

    public void registerCategory(EncyclopediaCategory category) {
        if (this.categories.containsKey(category)) {
            Nightfall.LOGGER.error("Category '" + category.name() + "' is already in use.");
        } else {
            this.categories.put(category, new HashMap());
            this.orderedCategories.add(category);
            this.orderedCategories.sort((c1, c2) -> {
                if (c1 == this.WYLDERY) {
                    return -1;
                }
                if (c2 == this.WYLDERY) {
                    return 1;
                }
                if (c1.name().contains("nightfall")) {
                    if (!c2.name().contains("nightfall")) {
                        return -1;
                    }
                } else if (c2.name().contains("nightfall") && !c1.name().contains("nightfall")) {
                    return 1;
                }
                return c1.name().compareTo(c2.name());
            });
        }
    }

    public void registerEntry(EncyclopediaCategory category, RegistryObject<? extends Entry> entry, int x, int y, ItemStack icon) {
        this.registerEntry(category, entry, x, y, icon, null, null, null, false);
    }

    public void registerEntry(EncyclopediaCategory category, RegistryObject<? extends Entry> entry, int x, int y, ItemStack icon, boolean separated) {
        this.registerEntry(category, entry, x, y, icon, null, null, null, separated);
    }

    public void registerEntry(EncyclopediaCategory category, RegistryObject<? extends Entry> entry, int x, int y, ResourceLocation icon, boolean separated) {
        this.registerEntry(category, entry, x, y, ItemStack.f_41583_, icon, null, null, separated);
    }

    public void registerEntry(EncyclopediaCategory category, RegistryObject<? extends Entry> entry, int x, int y, ItemStack itemIcon, ResourceLocation icon, EntryClient.Image puzzleImage, EntryClient.Image completedImage, boolean separated) {
        ResourceLocation entryId = entry.getId();
        if (!this.categories.containsKey(category)) {
            Nightfall.LOGGER.error("Category '" + category.name() + "' is not registered.");
        } else if (this.categories.get(category).containsKey(entryId)) {
            Nightfall.LOGGER.error("EntryClient ID " + entryId + " is already in use.");
        } else {
            ObjectArrayList addenda = new ObjectArrayList(4);
            for (RegistryObject e : EntriesNF.ENTRIES.getEntries()) {
                if (!((Entry)((Object)e.get())).isAddendum || !((Entry)((Object)e.get())).parents.get(0).getId().equals((Object)entryId)) continue;
                addenda.add(e);
            }
            this.categories.get(category).put(entryId, new EntryClient(category, entry, x, y, itemIcon, icon, puzzleImage, completedImage, (List<RegistryObject<? extends Entry>>)addenda, separated));
        }
    }

    public List<EntryClient> getEntries(EncyclopediaCategory category) {
        return this.categories.get(category).values().stream().toList();
    }

    public List<EncyclopediaCategory> getCategories() {
        return this.orderedCategories;
    }

    public EncyclopediaCategory getCategory(ResourceLocation id) {
        for (EncyclopediaCategory category : this.categories.keySet()) {
            HashMap<ResourceLocation, EntryClient> map = this.categories.get(category);
            EntryClient entry = map.get(id);
            if (entry == null) continue;
            return category;
        }
        Nightfall.LOGGER.error("Could not match entry " + id + " to a category.");
        return null;
    }

    @Nullable
    public EntryClient getEntry(ResourceLocation id) {
        for (HashMap<ResourceLocation, EntryClient> map : this.categories.values()) {
            EntryClient entry = map.get(id);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    public EntryClient getEntry(EncyclopediaCategory category, ResourceLocation id) {
        if (!this.categories.containsKey(category)) {
            throw new IllegalArgumentException("Category '" + category.name() + "' not found.");
        }
        return this.categories.get(category).get(id);
    }

    public void playExperimentSound(boolean success) {
        if (this.openEntry != null) {
            this.playGuiSound(success ? (SoundEvent)this.openEntry.category.experimentSuccessSound().get() : (SoundEvent)this.openEntry.category.experimentFailSound().get(), 1.0f, 1.0f);
        }
    }

    public void playGuiSound(SoundEvent sound, float pitch, float volume) {
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public void playToastSound(SoundEvent sound, float pitch, float volume) {
        if (!this.soundsPlayedThisTick.contains(sound)) {
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)pitch, (float)volume));
            this.soundsPlayedThisTick.add(sound);
        }
    }

    public void tryCategoryNotification(ResourceLocation entryId) {
        for (EncyclopediaCategory category : this.getCategories()) {
            if (category == this.WYLDERY || !category.unlockEntryId().equals((Object)entryId)) continue;
            PlayerData.get((Player)this.mc.f_91074_).addEntryNotification(entryId);
            NetworkHandler.toServer(new EntryNotificationToServer(entryId, false));
            this.mc.m_91300_().m_94922_((Toast)new CategoryToast(category));
            Screen screen = this.mc.f_91080_;
            if (!(screen instanceof EncyclopediaScreen)) break;
            EncyclopediaScreen encyclopediaScreen = (EncyclopediaScreen)screen;
            encyclopediaScreen.dirtyTabs = true;
            break;
        }
    }

    public void doEntryNotification(ResourceLocation id) {
        if (EntriesNF.contains(id)) {
            ResourceLocation notifId;
            IPlayerData capP = PlayerData.get((Player)this.mc.f_91074_);
            Entry entry = EntriesNF.get(id);
            ResourceLocation resourceLocation = notifId = entry.isAddendum ? entry.parents.get(0).getId() : entry.getRegistryName();
            if (capP.hasEntry(this.getCategory(notifId).unlockEntryId())) {
                capP.addEntryNotification(notifId);
                NetworkHandler.toServer(new EntryNotificationToServer(notifId, false));
                this.mc.m_91300_().m_94922_((Toast)new EntryToast(entry));
            }
        }
    }

    public void visuallyDestroyBlock(BlockPos pos, int progress) {
        if (progress >= 0 && progress < 10) {
            BlockDestructionProgress data = new BlockDestructionProgress(0, pos);
            data.m_139986_(Integer.MAX_VALUE);
            data.m_139981_(progress);
            this.mc.f_91060_.f_109409_.put(pos.m_121878_(), new SingleSortedSet<BlockDestructionProgress>(data));
        } else {
            this.mc.f_91060_.f_109409_.remove(pos.m_121878_());
        }
    }

    public void playEntitySound(Entity pEntity, SoundEvent pEvent, SoundSource pCategory, float pVolume, float pPitch) {
        pEntity.f_19853_.m_6269_((Player)this.mc.f_91074_, pEntity, pEvent, pCategory, pVolume, pPitch);
    }

    public void playUniqueEntitySound(Entity pEntity, SoundEvent sound, SoundSource pCategory, float pVolume, float pPitch) {
        if (!this.soundsPlayedThisTick.contains(sound) && this.mc.f_91074_ != null && this.mc.f_91074_.m_20280_(pEntity) <= (double)(pVolume * 16.0f * pVolume * 16.0f)) {
            pEntity.f_19853_.m_6269_((Player)this.mc.f_91074_, pEntity, sound, pCategory, pVolume, pPitch);
            this.soundsPlayedThisTick.add(sound);
        }
    }

    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
            ClientEngine.get().setupShaders();
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(Fluids.f_76193_.getAttributes().getStillTexture());
            ClientEngine.get().atlasWidth = (int)((float)(sprite.m_174743_() + sprite.m_118405_()) / sprite.m_118410_());
            ClientEngine.get().atlasHeight = (int)((float)(sprite.m_174744_() + sprite.m_118408_()) / sprite.m_118412_());
        }));
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/grass.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load grass color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillGrassCache(pObject);
            }
        });
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/forest.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load forest color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillForestCache(pObject);
            }
        });
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/lichen.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load lichen color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillLichenCache(pObject);
            }
        });
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/oak_leaves.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load oak leaves color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillOakLeavesCache(pObject);
            }
        });
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/birch_leaves.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load birch leaves color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillBirchLeavesCache(pObject);
            }
        });
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/jungle_leaves.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load jungle leaves color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillJungleLeavesCache(pObject);
            }
        });
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/larch_leaves.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load larch leaves color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillLarchLeavesCache(pObject);
            }
        });
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/maple_leaves.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load maple leaves color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillMapleLeavesCache(pObject);
            }
        });
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/willow_leaves.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load willow leaves color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillWillowLeavesCache(pObject);
            }
        });
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/acacia_leaves.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load acacia leaves color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillAcaciaLeavesCache(pObject);
            }
        });
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<int[]>(){
            private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/colormap/caedtar_leaves.png");

            protected int[] prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                try {
                    return LegacyStuffWrapper.m_118726_((ResourceManager)pResourceManager, (ResourceLocation)LOCATION);
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load caedtar leaves color texture", ioexception);
                }
            }

            protected void apply(int[] pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                ClientEngine.get().fillCaedtarLeavesCache(pObject);
            }
        });
    }
}

