/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client;

import frostnox.nightfall.capability.ILightData;
import frostnox.nightfall.capability.LightData;
import frostnox.nightfall.util.math.AxisDirection;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityLightEngine {
    private static final EntityLightEngine INSTANCE = new EntityLightEngine();
    private static final int MAX_LIGHT_SOURCES = 300;
    private static final int MAX_DIRTY_LIGHT_SOURCES = 60;
    private final Minecraft mc = Minecraft.m_91087_();
    private final Set<SectionPos> dirtySections = new ObjectOpenHashSet();
    private final Set<ILightData> lightSources = new ObjectOpenHashSet(50);
    private final Set<ILightData> activeLightSources = new ObjectOpenHashSet(50);
    private final ObjectArrayFIFOQueue<ILightData> dirtyLightSources = new ObjectArrayFIFOQueue(60);
    private boolean processedLastFrame = false;
    private int lastTickAtFrameProcess = -1;

    private EntityLightEngine() {
    }

    public static EntityLightEngine get() {
        return INSTANCE;
    }

    public void clear() {
        this.dirtySections.clear();
        this.lightSources.clear();
        this.activeLightSources.clear();
        this.processedLastFrame = false;
        this.lastTickAtFrameProcess = -1;
    }

    public void addLightSource(Entity entity) {
        if (this.lightSources.size() < 300) {
            ILightData source = LightData.get(entity);
            source.init();
            this.lightSources.add(source);
            this.enqueueDirtySource(source);
        }
    }

    public void removeLightSource(Entity entity) {
        ILightData source = LightData.get(entity);
        if (!this.lightSources.remove(source)) {
            return;
        }
        this.activeLightSources.remove(source);
        source.setBrightness(0);
        source.setLightRadiusSqr(0.0);
        if (!source.isLightDirty()) {
            source.setLightDirty(true);
            this.dirtyLightSources.enqueueFirst((Object)source);
        }
    }

    public void handleBlockUpdate(BlockPos pos) {
        for (ILightData source : this.activeLightSources) {
            if (source.isLightDirty() || !source.getLightMap().containsKey((Object)pos)) continue;
            this.enqueueDirtySource(source);
        }
    }

    public void tickStart() {
        for (ILightData source : this.lightSources) {
            source.updateLight();
            if (source.isLightDirty() || !this.needsUpdate(source)) continue;
            this.enqueueDirtySource(source);
        }
    }

    public void tickRenderStart() {
        if (!this.mc.m_91104_()) {
            ILightData source;
            float partial = this.mc.m_91296_();
            if (this.processedLastFrame) {
                if (this.mc.f_91074_.f_19797_ > this.lastTickAtFrameProcess) {
                    this.processedLastFrame = false;
                }
            } else {
                source = LightData.get((Entity)this.mc.f_91074_);
                source.updateLight();
                this.processLight(source, partial);
                if (!this.dirtySections.isEmpty()) {
                    this.processedLastFrame = true;
                    this.lastTickAtFrameProcess = this.mc.f_91074_.f_19797_;
                }
            }
            if (!this.dirtyLightSources.isEmpty()) {
                source = (ILightData)this.dirtyLightSources.dequeue();
                this.processLight(source, partial);
                source.setLightDirty(false);
            }
            if (!this.dirtySections.isEmpty()) {
                for (SectionPos pos : this.dirtySections) {
                    this.mc.f_91060_.m_109770_(pos.m_123170_(), pos.m_123206_(), pos.m_123222_());
                }
                this.dirtySections.clear();
            }
        }
    }

    public int adjustPackedLight(BlockPos pos, int packedLight) {
        double entityLight = this.getLight(pos);
        if (entityLight > (double)LightTexture.m_109883_((int)packedLight)) {
            return packedLight & 0xFFF00000 | (int)(entityLight * 16.0);
        }
        return packedLight;
    }

    public double getLight(BlockPos pos) {
        double maxLight = 0.0;
        for (ILightData source : this.activeLightSources) {
            double light = source.getLightMap().getDouble((Object)pos);
            if (!(light > maxLight)) continue;
            maxLight = light;
        }
        return maxLight;
    }

    private void enqueueDirtySource(ILightData source) {
        if (this.dirtyLightSources.size() < 60) {
            source.setLightDirty(true);
            this.dirtyLightSources.enqueue((Object)source);
        }
    }

    private boolean needsUpdate(ILightData source) {
        Entity entity = source.getEntity();
        Vec3 entityPos = entity.m_20318_(1.0f);
        double camDist = this.mc.f_91063_.m_109153_().m_90583_().m_82557_(entityPos);
        if (camDist > 2500.0) {
            int updateSpeed;
            int n = updateSpeed = camDist < 40000.0 ? 2 : 3;
            if (entity.f_19797_ % updateSpeed != 0) {
                return false;
            }
        }
        double oldX = source.getLightX();
        double oldY = source.getLightY();
        double oldZ = source.getLightZ();
        double lightX = entityPos.f_82479_;
        double lightY = entityPos.f_82480_ + (double)(entity.m_20206_() * 0.5f);
        double lightZ = entityPos.f_82481_;
        int brightness = source.getBrightness();
        int lastBrightness = source.getLastProcessedBrightness();
        double radiusSqr = source.getLightRadiusSqr();
        double lastRadiusSqr = source.getLastProcessedLightRadiusSqr();
        boolean moved = Math.abs(lightX - oldX) > 0.1 || Math.abs(lightY - oldY) > 0.1 || Math.abs(lightZ - oldZ) > 0.1;
        return brightness != lastBrightness || radiusSqr != lastRadiusSqr || moved && ((double)brightness > 0.0 || (double)lastBrightness > 0.0);
    }

    private void processLight(ILightData source, float partial) {
        boolean moved;
        double oldX = source.getLightX();
        double oldY = source.getLightY();
        double oldZ = source.getLightZ();
        Entity entity = source.getEntity();
        Vec3 entityPos = entity.m_20318_(partial);
        double lightX = entityPos.f_82479_;
        double lightY = entityPos.f_82480_ + (double)(entity.m_20206_() * 0.5f);
        double lightZ = entityPos.f_82481_;
        int brightness = source.getBrightness();
        int lastBrightness = source.getLastProcessedBrightness();
        double radiusSqr = source.getLightRadiusSqr();
        double lastRadiusSqr = source.getLastProcessedLightRadiusSqr();
        boolean bl = moved = Math.abs(lightX - oldX) > 0.1 || Math.abs(lightY - oldY) > 0.1 || Math.abs(lightZ - oldZ) > 0.1;
        if (source.isLightDirty() || brightness != lastBrightness || radiusSqr != lastRadiusSqr || moved && ((double)brightness > 0.0 || (double)lastBrightness > 0.0)) {
            source.setLightX(lightX);
            source.setLightY(lightY);
            source.setLightZ(lightZ);
            source.setLastProcessedBrightness(brightness);
            source.setLastProcessedLightRadiusSqr(radiusSqr);
            int bX = Mth.m_14107_((double)lightX);
            int bY = Mth.m_14107_((double)lightY);
            int bZ = Mth.m_14107_((double)lightZ);
            int bOldX = Mth.m_14107_((double)oldX);
            int bOldY = Mth.m_14107_((double)oldY);
            int bOldZ = Mth.m_14107_((double)oldZ);
            double radius = Math.sqrt(radiusSqr);
            int lastRadius = (int)Math.sqrt(lastRadiusSqr);
            Object2DoubleMap<BlockPos> lightMap = source.getLightMap();
            if (lastBrightness > 0) {
                lightMap.clear();
            }
            if (moved || radiusSqr < lastRadiusSqr) {
                this.collectDirtySections(bOldX, bOldY, bOldZ, lastRadius, lastRadiusSqr);
            }
            if (radiusSqr > 0.0) {
                LevelChunkSection section;
                this.collectDirtySections(bX, bY, bZ, (int)radius, radiusSqr);
                BlockPos startPos = new BlockPos(bX, bY, bZ);
                double dropOff = Math.max(1.0, (double)brightness / radius);
                lightMap.put((Object)startPos, (double)source.getBrightness() * (1.0 - EntityLightEngine.getDist(startPos, source) / radius));
                ObjectOpenHashSet visited = new ObjectOpenHashSet((int)(1.3334 * radiusSqr * radius + 4.0 * radiusSqr + 4.6667 * radius + 7.0));
                visited.add((Object)startPos);
                ObjectArrayFIFOQueue positions = new ObjectArrayFIFOQueue((int)(4.0 * radiusSqr + 4.0 * radius + 2.0));
                for (Direction dir : Direction.values()) {
                    positions.enqueue((Object)startPos.m_142300_(dir));
                }
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                int sectionX = SectionPos.m_123171_((int)startPos.m_123341_());
                int sectionZ = SectionPos.m_123171_((int)startPos.m_123343_());
                LevelChunk chunk = this.mc.f_91073_.m_6325_(sectionX, sectionZ);
                int sectionIndex = chunk.m_151564_(startPos.m_123342_());
                LevelChunkSection levelChunkSection = section = chunk.m_151562_(startPos.m_123342_()) ? null : chunk.m_183278_(sectionIndex);
                while (!positions.isEmpty()) {
                    double light;
                    BlockState state;
                    BlockPos pos = (BlockPos)positions.dequeue();
                    double dist = EntityLightEngine.getDist(pos, source);
                    if (dist > radius) continue;
                    if (chunk.m_151562_(pos.m_123342_())) {
                        state = Blocks.f_50016_.m_49966_();
                    } else {
                        int newSectionX = SectionPos.m_123171_((int)pos.m_123341_());
                        int newSectionZ = SectionPos.m_123171_((int)pos.m_123343_());
                        if (sectionX != newSectionX || sectionZ != newSectionZ) {
                            sectionX = newSectionX;
                            sectionZ = newSectionZ;
                            chunk = this.mc.f_91073_.m_6325_(sectionX, sectionZ);
                            sectionIndex = chunk.m_151564_(pos.m_123342_());
                            section = chunk.m_183278_(sectionIndex);
                        } else {
                            int newSectionIndex = chunk.m_151564_(pos.m_123342_());
                            if (sectionIndex != newSectionIndex) {
                                sectionIndex = newSectionIndex;
                                section = chunk.m_183278_(sectionIndex);
                            }
                        }
                        BlockState blockState = state = this.mc.f_91073_.m_151562_(pos.m_123342_()) ? Blocks.f_50016_.m_49966_() : section.m_62982_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF);
                    }
                    if (!state.m_60795_()) {
                        dist += (double)state.m_60739_((BlockGetter)this.mc.f_91073_, pos);
                    }
                    if ((light = (double)source.getBrightness() * (1.0 - dist / radius)) > 0.0) {
                        double maxNeighborLight = Double.NEGATIVE_INFINITY;
                        for (AxisDirection axisDir : AxisDirection.values()) {
                            double neighborLight;
                            mutablePos.m_122178_(pos.m_123341_() + axisDir.x, pos.m_123342_() + axisDir.y, pos.m_123343_() + axisDir.z);
                            if (!lightMap.containsKey((Object)mutablePos) || (neighborLight = lightMap.getDouble((Object)mutablePos)) <= 0.0) continue;
                            if (maxNeighborLight == Double.NEGATIVE_INFINITY) {
                                BlockState neighborState;
                                VoxelShape shape;
                                if (state.m_60815_() && Block.m_49916_((VoxelShape)(shape = state.m_60655_((BlockGetter)this.mc.f_91073_, pos, axisDir.normal)))) {
                                    maxNeighborLight = 0.0;
                                    continue;
                                }
                                if (chunk.m_151562_(mutablePos.m_123342_())) {
                                    neighborState = Blocks.f_50016_.m_49966_();
                                } else {
                                    int neighborSectionX = SectionPos.m_123171_((int)mutablePos.m_123341_());
                                    int neighborSectionZ = SectionPos.m_123171_((int)mutablePos.m_123343_());
                                    if (sectionX != neighborSectionX || sectionZ != neighborSectionZ) {
                                        sectionX = neighborSectionX;
                                        sectionZ = neighborSectionZ;
                                        chunk = this.mc.f_91073_.m_6325_(sectionX, sectionZ);
                                        sectionIndex = chunk.m_151564_(mutablePos.m_123342_());
                                        section = chunk.m_183278_(sectionIndex);
                                    } else {
                                        int newSectionIndex = chunk.m_151564_(mutablePos.m_123342_());
                                        if (sectionIndex != newSectionIndex) {
                                            sectionIndex = newSectionIndex;
                                            section = chunk.m_183278_(sectionIndex);
                                        }
                                    }
                                    neighborState = section.m_62982_(mutablePos.m_123341_() & 0xF, mutablePos.m_123342_() & 0xF, mutablePos.m_123343_() & 0xF);
                                }
                                if (neighborState.m_60815_()) {
                                    VoxelShape shape2;
                                    VoxelShape neighborShape = neighborState.m_60655_((BlockGetter)this.mc.f_91073_, (BlockPos)mutablePos, axisDir.getOpposite().normal);
                                    if (Block.m_49916_((VoxelShape)neighborShape)) {
                                        maxNeighborLight = 0.0;
                                        continue;
                                    }
                                    if (state.m_60815_() && Shapes.m_83145_((VoxelShape)(shape2 = state.m_60655_((BlockGetter)this.mc.f_91073_, pos, axisDir.normal)), (VoxelShape)neighborShape)) {
                                        maxNeighborLight = 0.0;
                                        continue;
                                    }
                                }
                            }
                            if (!(neighborLight > maxNeighborLight)) continue;
                            maxNeighborLight = neighborLight;
                        }
                        if (light > maxNeighborLight - 0.001 && maxNeighborLight != Double.NEGATIVE_INFINITY) {
                            light = maxNeighborLight - dropOff;
                        }
                        if (light > 0.0) {
                            for (AxisDirection axisDir : AxisDirection.values()) {
                                BlockState neighborState;
                                VoxelShape shape;
                                mutablePos.m_122178_(pos.m_123341_() + axisDir.x, pos.m_123342_() + axisDir.y, pos.m_123343_() + axisDir.z);
                                if (state.m_60815_() && Block.m_49916_((VoxelShape)(shape = state.m_60655_((BlockGetter)this.mc.f_91073_, pos, axisDir.normal)))) {
                                    if (lightMap.containsKey((Object)mutablePos)) continue;
                                    lightMap.put((Object)mutablePos.m_7949_(), 0.0);
                                    continue;
                                }
                                if (chunk.m_151562_(mutablePos.m_123342_())) {
                                    neighborState = Blocks.f_50016_.m_49966_();
                                } else {
                                    int neighborSectionX = SectionPos.m_123171_((int)mutablePos.m_123341_());
                                    int neighborSectionZ = SectionPos.m_123171_((int)mutablePos.m_123343_());
                                    if (sectionX != neighborSectionX || sectionZ != neighborSectionZ) {
                                        sectionX = neighborSectionX;
                                        sectionZ = neighborSectionZ;
                                        chunk = this.mc.f_91073_.m_6325_(sectionX, sectionZ);
                                        sectionIndex = chunk.m_151564_(mutablePos.m_123342_());
                                        section = chunk.m_183278_(sectionIndex);
                                    } else {
                                        int newSectionIndex = chunk.m_151564_(mutablePos.m_123342_());
                                        if (sectionIndex != newSectionIndex) {
                                            sectionIndex = newSectionIndex;
                                            section = chunk.m_183278_(sectionIndex);
                                        }
                                    }
                                    neighborState = section.m_62982_(mutablePos.m_123341_() & 0xF, mutablePos.m_123342_() & 0xF, mutablePos.m_123343_() & 0xF);
                                }
                                if (neighborState.m_60815_()) {
                                    VoxelShape shape3;
                                    VoxelShape neighborShape = neighborState.m_60655_((BlockGetter)this.mc.f_91073_, (BlockPos)mutablePos, axisDir.getOpposite().normal);
                                    if (Block.m_49916_((VoxelShape)neighborShape)) {
                                        if (lightMap.containsKey((Object)mutablePos)) continue;
                                        lightMap.put((Object)mutablePos.m_7949_(), 0.0);
                                        continue;
                                    }
                                    if (state.m_60815_() && Shapes.m_83145_((VoxelShape)(shape3 = state.m_60655_((BlockGetter)this.mc.f_91073_, pos, axisDir.normal)), (VoxelShape)neighborShape)) {
                                        if (lightMap.containsKey((Object)mutablePos)) continue;
                                        lightMap.put((Object)mutablePos.m_7949_(), 0.0);
                                        continue;
                                    }
                                }
                                if (visited.contains((Object)mutablePos)) continue;
                                BlockPos neighborPos = mutablePos.m_7949_();
                                visited.add((Object)neighborPos);
                                positions.enqueue((Object)neighborPos);
                            }
                        }
                    }
                    lightMap.put((Object)pos, light);
                }
                this.activeLightSources.add(source);
            } else {
                this.activeLightSources.remove(source);
            }
        }
    }

    private static double getDist(BlockPos pos, ILightData source) {
        return Math.abs(source.getLightX() - (double)pos.m_123341_() - 0.5) + Math.abs(source.getLightY() - (double)pos.m_123342_() - 0.5) + Math.abs(source.getLightZ() - (double)pos.m_123343_() - 0.5);
    }

    private void collectDirtySections(int blockX, int blockY, int blockZ, int radius, double radiusSqr) {
        ObjectOpenHashSet sections;
        if (radius < 8) {
            sections = new ObjectOpenHashSet(8);
            int xMin = SectionPos.m_123171_((int)(blockX - radius));
            int yMin = SectionPos.m_123171_((int)(blockY - radius));
            int zMin = SectionPos.m_123171_((int)(blockZ - radius));
            int xMax = SectionPos.m_123171_((int)(blockX + radius));
            int yMax = SectionPos.m_123171_((int)(blockY + radius));
            int zMax = SectionPos.m_123171_((int)(blockZ + radius));
            sections.add(SectionPos.m_123173_((int)xMin, (int)yMin, (int)zMin));
            sections.add(SectionPos.m_123173_((int)xMax, (int)yMin, (int)zMin));
            sections.add(SectionPos.m_123173_((int)xMin, (int)yMin, (int)zMax));
            sections.add(SectionPos.m_123173_((int)xMin, (int)yMax, (int)zMin));
            sections.add(SectionPos.m_123173_((int)xMax, (int)yMin, (int)zMax));
            sections.add(SectionPos.m_123173_((int)xMax, (int)yMax, (int)zMin));
            sections.add(SectionPos.m_123173_((int)xMin, (int)yMax, (int)zMax));
            sections.add(SectionPos.m_123173_((int)xMax, (int)yMax, (int)zMax));
        } else {
            sections = new ObjectOpenHashSet(22);
            for (int x = blockX - radius; x <= blockX + radius; x += radius) {
                for (int y = blockY - radius; y <= blockY + radius; y += radius) {
                    for (int z = blockZ - radius; z <= blockZ + radius; z += radius) {
                        sections.add(SectionPos.m_123173_((int)SectionPos.m_123171_((int)x), (int)SectionPos.m_123171_((int)y), (int)SectionPos.m_123171_((int)z)));
                    }
                }
            }
        }
        for (SectionPos section : sections) {
            int zDist;
            int yDist;
            if (this.dirtySections.contains(section)) continue;
            int minX = SectionPos.m_123223_((int)section.m_123341_());
            int minY = SectionPos.m_123223_((int)section.m_123342_());
            int minZ = SectionPos.m_123223_((int)section.m_123343_());
            int xDist = Mth.m_14045_((int)blockX, (int)minX, (int)(minX + 15)) - blockX;
            if (!((double)(xDist * xDist + (yDist = Mth.m_14045_((int)blockY, (int)minY, (int)(minY + 15)) - blockY) * yDist + (zDist = Mth.m_14045_((int)blockZ, (int)minZ, (int)(minZ + 15)) - blockZ) * zDist) <= radiusSqr)) continue;
            this.dirtySections.add(section);
        }
    }
}

