/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.gui.SoundToast;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryClient;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.RenderUtil;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class EntryToast
extends SoundToast {
    public static final TranslatableComponent PREFIX_HIDDEN = new TranslatableComponent("nightfall.entry_toast.prefix_hidden");
    public static final TranslatableComponent PREFIX_ADDENDUM = new TranslatableComponent("nightfall.entry_toast.prefix_addendum");
    public static final TranslatableComponent PREFIX = new TranslatableComponent("nightfall.entry_toast.prefix");
    protected final EntryClient entry;
    protected final Type type;
    protected final TranslatableComponent text;
    protected final TranslatableComponent prefix;

    public EntryToast(Entry entry) {
        EntryClient entryClient = this.entry = entry.isAddendum ? ClientEngine.get().getEntry(entry.parents.get(0).getId()) : ClientEngine.get().getEntry(entry.getRegistryName());
        this.type = entry.isAddendum ? Type.ADDENDUM : (entry.isHidden ? Type.HIDDEN : Type.STANDARD);
        this.prefix = switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.STANDARD -> PREFIX;
            case Type.HIDDEN -> PREFIX_HIDDEN;
            case Type.ADDENDUM -> PREFIX_ADDENDUM;
        };
        this.text = new TranslatableComponent(((Entry)((Object)this.entry.entry.get())).getDescriptionId());
    }

    @Override
    protected Component getText() {
        return this.prefix.m_6881_().m_7220_((Component)this.text);
    }

    @Override
    protected void renderBg(PoseStack stack, ToastComponent toastComponent, long timeSinceLastVisible) {
        if (!this.entry.itemIcon.m_41619_()) {
            RenderUtil.renderItem(stack, this.entry.itemIcon, 2, 2, 0, this.type == Type.HIDDEN);
        } else {
            if (this.type == Type.HIDDEN) {
                RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.entry.icon);
            GuiComponent.m_93133_((PoseStack)stack, (int)2, (int)2, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void playSound(Toast.Visibility visibility, SoundManager soundManager) {
        if (visibility == Toast.Visibility.SHOW) {
            ClientEngine.get().playToastSound((SoundEvent)SoundsNF.ENTRY_UPDATED.get(), 1.0f, 1.0f);
        }
    }

    protected static enum Type {
        STANDARD,
        HIDDEN,
        ADDENDUM;

    }
}

