/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.item.client.IModifiable;
import frostnox.nightfall.registry.forge.AttributesNF;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;

public abstract class OverlayNF
extends GuiComponent {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/overlay.png");
    private static boolean registered = false;
    protected static final Random random = new Random();
    private static int lastHealth;
    private static int displayHealth;
    private static long healthBlinkTime;
    private static long lastHealthTime;

    public static void register() {
        Minecraft mc = Minecraft.m_91087_();
        if (!registered) {
            IIngameOverlay healthOverlay = OverlayRegistry.registerOverlayBottom((String)"Health", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
                if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements() && mc.f_91074_ != null) {
                    gui.setupOverlayRenderState(true, false);
                    OverlayNF.renderHealth(mStack);
                }
            });
            IIngameOverlay foodOverlay = OverlayRegistry.registerOverlayBottom((String)"Food", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
                if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements() && mc.f_91074_ != null) {
                    gui.setupOverlayRenderState(true, false);
                    OverlayNF.renderFood(mStack);
                }
            });
            IIngameOverlay staminaOverlay = OverlayRegistry.registerOverlayBottom((String)"Stamina", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
                if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements() && mc.f_91074_ != null && !mc.f_91074_.m_108633_()) {
                    gui.setupOverlayRenderState(true, false);
                    OverlayNF.renderStamina(mStack);
                }
            });
            IIngameOverlay airOverlay = OverlayRegistry.registerOverlayBottom((String)"Air", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
                if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                    gui.setupOverlayRenderState(true, false);
                    OverlayNF.renderAir(mStack);
                }
            });
            IIngameOverlay crosshairOverlay = OverlayRegistry.registerOverlayTop((String)"Crosshair", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
                if (!mc.f_91066_.f_92062_) {
                    gui.setupOverlayRenderState(true, false);
                    gui.m_93250_(-90);
                    OverlayNF.renderCrosshair(poseStack);
                }
            });
            IIngameOverlay optionalItemsOverlay = OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"OptionalItems", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
                if (!mc.f_91066_.f_92062_ && mc.f_91074_ != null && !mc.f_91074_.m_5833_()) {
                    gui.setupOverlayRenderState(true, false);
                    OverlayNF.renderOptionalItems(mStack);
                }
            });
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.AIR_LEVEL_ELEMENT, (boolean)false);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.ARMOR_LEVEL_ELEMENT, (boolean)false);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.PLAYER_HEALTH_ELEMENT, (boolean)false);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.FOOD_LEVEL_ELEMENT, (boolean)false);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (boolean)false);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.JUMP_BAR_ELEMENT, (boolean)false);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.MOUNT_HEALTH_ELEMENT, (boolean)false);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT, (boolean)false);
        }
        registered = true;
    }

    protected static void draw(PoseStack pPoseStack, int x, int pY, int pUOffset, int pVOffset, int pUWidth, int pVHeight) {
        OverlayNF.draw(pPoseStack, x, pY, 0, pUOffset, pVOffset, pUWidth, pVHeight);
    }

    protected static void draw(PoseStack pPoseStack, int x, int pY, int blitOffset, int pUOffset, int pVOffset, int pUWidth, int pVHeight) {
        OverlayNF.m_93143_((PoseStack)pPoseStack, (int)x, (int)pY, (int)blitOffset, (float)pUOffset, (float)pVOffset, (int)pUWidth, (int)pVHeight, (int)256, (int)256);
    }

    protected static void renderAttributeBar(PoseStack stack, int posX, int posY, int vOff, int size, int maxSize, float value, float displayValue, boolean highlight) {
        int length = size * 9 + 1;
        OverlayNF.draw(stack, posX, posY, 0, vOff, length, 5);
        --length;
        if (size != maxSize) {
            OverlayNF.draw(stack, posX + length, posY, maxSize * 9, vOff, 1, 5);
        }
        OverlayNF.draw(stack, posX, posY, 0, vOff + 5, Math.round(value * (float)length), 5);
        if (highlight && value < displayValue) {
            OverlayNF.draw(stack, posX, posY, 0, vOff + 5, Math.round(displayValue * (float)length), 5);
        }
    }

    protected static void renderAttributeBarDynamic(PoseStack stack, int posX, int posY, int vOff, int size, int value, int displayValue, boolean highlight) {
        OverlayNF.draw(stack, posX, posY, 0, vOff, 10, 5);
        ++posX;
        if (10 <= value || highlight && 10 < displayValue) {
            OverlayNF.draw(stack, posX, posY, 28, vOff, 9, 5);
        } else {
            int u = Math.round(9.0f * ((float)value / 10.0f));
            if (u > 0) {
                OverlayNF.draw(stack, posX, posY, 28, vOff, u, 5);
            }
        }
        posX += 9;
        for (int i = 1; i < size; ++i) {
            int uWidth;
            int v = i * 10;
            OverlayNF.draw(stack, posX, posY, i == size - 1 ? 19 : 10, vOff, 9, 5);
            int n = uWidth = i == size - 1 ? 8 : 9;
            if (v + 10 <= value || highlight && v + 10 < displayValue) {
                OverlayNF.draw(stack, posX, posY, 28, vOff, uWidth, 5);
            } else if (v < value) {
                int u = Math.round((float)uWidth * ((float)(value - v) / 10.0f));
                if (u > 0) {
                    OverlayNF.draw(stack, posX, posY, 28, vOff, u, 5);
                }
            } else if (highlight && v < displayValue) {
                OverlayNF.draw(stack, posX, posY, 28, vOff, Math.round((float)uWidth * ((float)(displayValue - v) / 10.0f)), 5);
            }
            posX += 9;
        }
    }

    protected static void renderHealth(PoseStack stack) {
        boolean highlight;
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        Minecraft mc = Minecraft.m_91087_();
        Player p = (Player)mc.m_91288_();
        if (p == null) {
            return;
        }
        int health = Mth.m_14167_((float)p.m_21223_());
        int tickCount = ClientEngine.get().getTickCount();
        boolean bl = highlight = healthBlinkTime > (long)tickCount && (healthBlinkTime - (long)tickCount) / 3L % 2L == 1L;
        if (health < lastHealth && p.f_19802_ > 0) {
            lastHealthTime = Util.m_137550_();
            healthBlinkTime = tickCount + 20;
        }
        if (Util.m_137550_() - lastHealthTime > 1000L) {
            lastHealth = health;
            displayHealth = health;
            lastHealthTime = Util.m_137550_();
        }
        lastHealth = health;
        int healthLast = displayHealth;
        AttributeInstance attrMaxHealth = p.m_21051_(Attributes.f_22276_);
        float healthMax = Math.max((float)attrMaxHealth.m_22135_(), (float)Math.max(healthLast, health));
        int vitality = Mth.m_14143_((float)AttributesNF.getVitality((LivingEntity)p));
        int absorb = Mth.m_14167_((float)p.m_6103_());
        random.setSeed((long)tickCount * 312871L);
        int posX = mc.m_91268_().m_85445_() / 2 - 89;
        int posY = mc.m_91268_().m_85446_() - 29;
        OverlayNF.renderAttributeBar(stack, posX, posY, 0, vitality, 20, p.m_21223_() / healthMax, (float)displayHealth / healthMax, highlight);
        OverlayNF.draw(stack, posX - 3, posY - 1, 0, 40, 7, 7);
        RenderSystem.m_69461_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93098_);
    }

    protected static void renderFood(PoseStack stack) {
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer p = mc.f_91074_;
        if (p == null) {
            return;
        }
        FoodData stats = mc.f_91074_.m_36324_();
        int food = stats.m_38702_() * 5;
        int posX = mc.m_91268_().m_85445_() / 2 - 89;
        int posY = mc.m_91268_().m_85446_() - 43;
        OverlayNF.renderAttributeBar(stack, posX, posY, 20, 10, 10, (float)food / 100.0f, food, false);
        OverlayNF.draw(stack, posX - 3, posY - 1, 14, 40, 7, 7);
        RenderSystem.m_69461_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93098_);
    }

    protected static void renderStamina(PoseStack stack) {
        double stamina;
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer p = mc.f_91074_;
        if (p == null) {
            return;
        }
        double lastStamina = ClientEngine.get().getLastStamina();
        double d = stamina = p.m_6084_() ? PlayerData.get((Player)p).getStamina() : lastStamina;
        if (Math.abs(stamina - lastStamina) > 0.001) {
            stamina = Mth.m_14139_((double)ClientEngine.get().getPartialTick(), (double)lastStamina, (double)stamina);
        }
        int endurance = Math.round((float)p.m_21051_((Attribute)AttributesNF.ENDURANCE.get()).m_22135_());
        double maxStamina = AttributesNF.getMaxStamina((Player)p);
        int posX = mc.m_91268_().m_85445_() / 2 - 89;
        int posY = mc.m_91268_().m_85446_() - 36;
        OverlayNF.renderAttributeBar(stack, posX, posY, 10, endurance, 20, (float)(stamina / maxStamina), (float)stamina, false);
        OverlayNF.draw(stack, posX - 3, posY - 1, 7, 40, 7, 7);
        RenderSystem.m_69461_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93098_);
    }

    protected static void renderAir(PoseStack stack) {
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer p = mc.f_91074_;
        if (p == null || !p.m_6084_()) {
            return;
        }
        int posX = mc.m_91268_().m_85445_() / 2 - 89;
        int posY = mc.m_91268_().m_85446_() - 50;
        int air = p.m_20146_();
        if (air < 300) {
            OverlayNF.renderAttributeBar(stack, posX, posY, 30, 10, 10, (float)air / 300.0f, air, false);
            OverlayNF.draw(stack, posX - 3, posY - 1, 21, 40, 7, 7);
        }
        RenderSystem.m_69461_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93098_);
    }

    protected static void renderCrosshair(PoseStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        Options options = mc.f_91066_;
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        if (options.m_92176_().m_90612_() && (mc.f_91072_.m_105295_() != GameType.SPECTATOR || OverlayNF.canRenderCrosshairForSpectator(mc.f_91077_))) {
            RenderSystem.m_69478_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            OverlayNF.draw(stack, (width - 7) / 2, (height - 7) / 2, 0, 47, 7, 7);
            RenderSystem.m_69461_();
        }
    }

    protected static boolean canRenderCrosshairForSpectator(HitResult pRayTrace) {
        if (pRayTrace == null) {
            return false;
        }
        if (pRayTrace.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)pRayTrace).m_82443_() instanceof MenuProvider;
        }
        if (pRayTrace.m_6662_() == HitResult.Type.BLOCK) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            BlockPos blockpos = ((BlockHitResult)pRayTrace).m_82425_();
            return level.m_8055_(blockpos).m_60750_((Level)level, blockpos) != null;
        }
        return false;
    }

    protected static void renderOptionalItems(PoseStack stack) {
        boolean offPresent;
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.m_91268_().m_85445_() / 2;
        int height = mc.m_91268_().m_85446_();
        ItemStack mainItem = ClientEngine.get().getOptionalMainItem();
        ItemStack offItem = ClientEngine.get().getOptionalOffItem();
        boolean mainPresent = !mainItem.m_41619_();
        boolean bl = offPresent = !offItem.m_41619_();
        if (mainPresent || offPresent) {
            IModifiable modifiable;
            Item item;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            if (mainPresent) {
                int n;
                item = mc.f_91074_.m_21205_().m_41720_();
                if (item instanceof IModifiable) {
                    modifiable = (IModifiable)item;
                    n = modifiable.getBackgroundUOffset();
                } else {
                    n = 0;
                }
                OverlayNF.draw(stack, width + 91 + 7, height - 22, n, 54, 22, 22);
            }
            if (offPresent) {
                int n;
                item = mc.f_91074_.m_21206_().m_41720_();
                if (item instanceof IModifiable) {
                    modifiable = (IModifiable)item;
                    n = modifiable.getBackgroundUOffset();
                } else {
                    n = 0;
                }
                OverlayNF.draw(stack, width - 91 - 48, height - 22, n, 54, 20, 22);
            }
        }
        if (mainPresent) {
            mc.m_91291_().m_115203_(mainItem, width + 91 + 10, height - 16 - 3);
            mc.m_91291_().m_115169_(mc.f_91062_, mainItem, width + 91 + 10, height - 16 - 3);
        }
        if (offPresent) {
            mc.m_91291_().m_115203_(offItem, width - 91 - 45, height - 16 - 3);
            mc.m_91291_().m_115169_(mc.f_91062_, offItem, width - 91 - 45, height - 16 - 3);
        }
    }
}

