/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.gui.OverlayNF;
import frostnox.nightfall.entity.PlayerAttribute;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.capability.AttributeSelectionToServer;
import frostnox.nightfall.util.RenderUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;

public class AttributeSelectionScreen
extends Screen {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/screen/attribute_selection.png");
    public static final int WIDTH = 112;
    public static final int HEIGHT = 101;
    private static final int MARGIN = 8;
    private final Minecraft mc;
    protected final Component pauseText = new TranslatableComponent("menu.paused");

    public AttributeSelectionScreen() {
        super(NarratorChatListener.f_93310_);
        this.mc = Minecraft.m_91087_();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partial) {
        this.m_7333_(stack);
        if (this.m_7043_() && this.mc.m_91091_() && !this.mc.m_91092_().m_6992_()) {
            AttributeSelectionScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.pauseText, (int)(this.f_96543_ / 2), (int)40, (int)0xFFFFFF);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int x = this.f_96543_ / 2 - 56;
        int y = this.f_96544_ / 2 - 50;
        AttributeSelectionScreen.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)112, (int)101, (int)128, (int)128);
        LocalPlayer player = this.mc.f_91074_;
        RenderUtil.drawCenteredFont(stack, this.mc.f_91062_, (Component)RenderUtil.ATTRIBUTES_TEXT.m_6879_().m_130940_(ChatFormatting.UNDERLINE), x + 56, y += 8, 0xFFFFFF, false);
        y += 11;
        int freePoints = 0;
        IPlayerData capP = PlayerData.get((Player)player);
        for (PlayerAttribute attribute : PlayerAttribute.values()) {
            freePoints -= capP.getAttributePoints(attribute);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        for (int i = 0; i < 6; ++i) {
            if (i == 2) continue;
            int arrowY = y - 1 + i * 11;
            int arrowX = x + 112 - 8 - 5 - 11;
            int upOff = 0;
            int downOff = 0;
            int points = capP.getAttributePoints(PlayerAttribute.values()[i]);
            if (points >= 3 || freePoints <= 0) {
                upOff = 10;
            }
            if (points <= -3) {
                downOff = 10;
            }
            if (mouseY >= arrowY - 1 && mouseY < arrowY + 9) {
                if (mouseX >= arrowX - 7 - 1 && mouseX < arrowX - 7 + 6) {
                    if (upOff != 10) {
                        upOff = 5;
                    }
                } else if (mouseX >= arrowX - 1 && mouseX < arrowX + 6 && downOff != 10) {
                    downOff = 5;
                }
            }
            AttributeSelectionScreen.m_93133_((PoseStack)stack, (int)(arrowX - 7), (int)arrowY, (float)upOff, (float)101.0f, (int)5, (int)9, (int)128, (int)128);
            AttributeSelectionScreen.m_93133_((PoseStack)stack, (int)arrowX, (int)arrowY, (float)(15 + downOff), (float)101.0f, (int)5, (int)9, (int)128, (int)128);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)OverlayNF.TEXTURE);
        int iconYStart = y;
        for (int i = 0; i < 6; ++i) {
            int iconY = y - 1 + i * 11;
            AttributeSelectionScreen.m_93133_((PoseStack)stack, (int)(x + 8), (int)iconY, (float)(i * 9), (float)96.0f, (int)9, (int)9, (int)256, (int)256);
        }
        for (PlayerAttribute attribute : PlayerAttribute.values()) {
            this.mc.f_91062_.m_92889_(stack, (Component)RenderUtil.getAttributeText(attribute), (float)(x + 8 + 10), (float)y, 0xFFFFFF);
            if (attribute == PlayerAttribute.WILLPOWER) {
                RenderUtil.drawRightText(stack, this.mc.f_91062_, "?", x + 112 - 8, y, 0xFFFFFF, false, 0xF000F0);
            } else {
                RenderUtil.drawRightText(stack, this.mc.f_91062_, "" + (10 + capP.getAttributePoints(attribute)), x + 112 - 8, y, 0xFFFFFF, false, 0xF000F0);
            }
            y += 11;
        }
        this.mc.f_91062_.m_92889_(stack, (Component)RenderUtil.FREE_POINTS_TEXT.m_6881_().m_130946_("" + freePoints), (float)(x + 8 + 1), (float)y, 0xFFFFFF);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int finX = x + 112 - 8 - 9;
        if (mouseX >= finX && mouseX < finX + 9 && mouseY >= --y && mouseY < y + 9) {
            AttributeSelectionScreen.m_93133_((PoseStack)stack, (int)(x + 112 - 8 - 9), (int)y, (float)39.0f, (float)101.0f, (int)9, (int)9, (int)128, (int)128);
            this.m_96602_(stack, (Component)new TranslatableComponent("screen.finalize"), mouseX, mouseY);
        } else {
            AttributeSelectionScreen.m_93133_((PoseStack)stack, (int)(x + 112 - 8 - 9), (int)y, (float)30.0f, (float)101.0f, (int)9, (int)9, (int)128, (int)128);
        }
        if (mouseX >= x + 8 && mouseX < x + 112 - 8 - 5 - 11 - 7 - 7) {
            for (int i = 0; i < 6; ++i) {
                int iconY = iconYStart - 1 + i * 11;
                if (mouseY < iconY - 1 || mouseY >= iconY + 10) continue;
                PlayerAttribute attribute = PlayerAttribute.values()[i];
                ObjectArrayList components = new ObjectArrayList(2);
                String plus = capP.getAttributePoints(attribute) >= 0 ? "+" : "";
                switch (attribute) {
                    case VITALITY: {
                        components.add(new TranslatableComponent("screen." + attribute + ".info", new Object[]{100 + 10 * capP.getAttributePoints(attribute)}));
                        break;
                    }
                    case ENDURANCE: {
                        components.add(new TranslatableComponent("screen." + attribute + ".info", new Object[]{100 + 10 * capP.getAttributePoints(attribute), plus + 5 * capP.getAttributePoints(attribute)}));
                        break;
                    }
                    case WILLPOWER: {
                        components.add(new TranslatableComponent("screen." + attribute + ".info", new Object[]{100 + 10 * capP.getAttributePoints(attribute)}));
                        break;
                    }
                    case STRENGTH: {
                        components.add(new TranslatableComponent("screen." + attribute + ".info", new Object[]{plus + 5 * capP.getAttributePoints(attribute)}));
                        break;
                    }
                    case AGILITY: {
                        components.add(new TranslatableComponent("screen." + attribute + ".info", new Object[]{plus + 3 * capP.getAttributePoints(attribute)}));
                        break;
                    }
                    case PERCEPTION: {
                        components.add(new TranslatableComponent("screen." + attribute + ".info"));
                    }
                }
                this.m_169388_(stack, (List)components, Optional.empty(), mouseX, mouseY);
                break;
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int x = this.f_96543_ / 2 - 56;
        int y = this.f_96544_ / 2 - 50 + 8 + 11;
        int freePoints = 0;
        IPlayerData capP = PlayerData.get((Player)this.mc.f_91074_);
        for (PlayerAttribute attribute : PlayerAttribute.values()) {
            freePoints -= capP.getAttributePoints(attribute);
        }
        int finishX = x + 112 - 8 - 9;
        int finishY = y + 66 - 1;
        if (mouseX >= (double)finishX && mouseX < (double)(finishX + 9) && mouseY >= (double)finishY && mouseY < (double)(finishY + 9)) {
            NetworkHandler.toServer(new AttributeSelectionToServer(capP.copyAttributePoints()));
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
            this.m_7379_();
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            if (i == 2) continue;
            int arrowY = y - 1 + i * 11;
            int arrowX = x + 112 - 8 - 5 - 11;
            PlayerAttribute attribute = PlayerAttribute.values()[i];
            int points = capP.getAttributePoints(attribute);
            if (!(mouseY >= (double)(arrowY - 1)) || !(mouseY < (double)(arrowY + 9))) continue;
            if (mouseX >= (double)(arrowX - 7 - 1) && mouseX < (double)(arrowX - 7 + 6)) {
                if (points >= 3 || freePoints <= 0) continue;
                capP.setAttributePoints(attribute, points + 1);
                this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                break;
            }
            if (!(mouseX >= (double)(arrowX - 1)) || !(mouseX < (double)(arrowX + 6)) || points <= -3) continue;
            capP.setAttributePoints(attribute, points - 1);
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
            break;
        }
        return false;
    }

    public boolean m_7043_() {
        return this.mc.f_91074_ == null || this.mc.f_91074_.f_19797_ > 100;
    }

    public boolean m_6913_() {
        return false;
    }
}

