/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.block.block.anvil.TieredAnvilContainer;
import frostnox.nightfall.client.gui.screen.PartialInventoryScreen;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.blockentity.StartSmithingToServer;
import frostnox.nightfall.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class TieredAnvilScreen
extends PartialInventoryScreen<TieredAnvilContainer> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/screen/tiered_anvil.png");
    private int startIndex;
    private boolean displayRecipes;
    private float scrollOffs;
    private boolean grabbedScrollBar = false;

    public TieredAnvilScreen(TieredAnvilContainer container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    @Override
    protected ResourceLocation getInventoryTexture() {
        return INVENTORY_METAL_TEXTURE;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partial) {
        if (((TieredAnvilContainer)this.f_97732_).getSelectedRecipeIndex() == -1) {
            this.displayRecipes = ((TieredAnvilContainer)this.f_97732_).hasValidInput();
            if (!this.displayRecipes) {
                this.startIndex = 0;
            }
        }
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partial);
        this.m_7025_(stack, mouseX, mouseY);
    }

    @Override
    protected void m_7286_(PoseStack stack, float partial, int mouseX, int mouseY) {
        int y;
        int row;
        int x;
        int offset;
        int i;
        super.m_7286_(stack, partial, mouseX, mouseY);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int buttonX = this.f_97735_ + 143;
        int buttonY = this.f_97736_ + 35;
        int heatTier = ((TieredAnvilContainer)this.f_97732_).entity.getBestHeatSource().getTier();
        if (((TieredAnvilContainer)this.f_97732_).getSelectedRecipeIndex() != -1 && heatTier >= ((TieredAnvilContainer)this.f_97732_).recipes.get(((TieredAnvilContainer)this.f_97732_).getSelectedRecipeIndex()).getTier()) {
            double xPos = mouseX - buttonX;
            double yPos = mouseY - buttonY;
            if (xPos >= -1.0 && xPos < 17.0 && yPos >= -1.0 && yPos < 17.0) {
                RenderUtil.renderGradient(stack, buttonX, buttonY, 16, 16, this.m_93252_(), Integer.MAX_VALUE);
            }
        } else {
            RenderUtil.renderGradient(stack, buttonX, buttonY, 16, 16, this.m_93252_(), 0x7F000000);
        }
        if (((TieredAnvilContainer)this.f_97732_).entity.hasWaterSource()) {
            this.m_93228_(stack, this.f_97735_ + 143, this.f_97736_ + 14, 0, 184, 16, 15);
        }
        if (heatTier > 0) {
            this.m_93228_(stack, this.f_97735_ + 143, this.f_97736_ + 58, 17 * heatTier, 184, 16, 15);
        }
        if (this.canScroll()) {
            this.m_93228_(stack, this.f_97735_ + 115, this.f_97736_ + 16 + (int)(51.0f * this.scrollOffs), 18, 166, 3, 3);
        }
        int listStart = this.startIndex + 9;
        int listX = this.f_97735_ + 58;
        int listY = this.f_97736_ + 16;
        for (i = this.startIndex; i < listStart && i < ((TieredAnvilContainer)this.f_97732_).recipes.size(); ++i) {
            offset = i - this.startIndex;
            x = listX + offset % 3 * 18;
            row = offset / 3;
            y = listY + row * 18;
            this.m_93228_(stack, x, y, 0, this.f_97727_, 18, 18);
        }
        for (i = this.startIndex; i < listStart && i < ((TieredAnvilContainer)this.f_97732_).recipes.size(); ++i) {
            offset = i - this.startIndex;
            x = listX + offset % 3 * 18 + 1;
            row = offset / 3;
            y = listY + row * 18 + 1;
            this.f_96541_.m_91291_().m_115203_(((TieredAnvilContainer)this.f_97732_).recipes.get(i).m_8043_(), x, y);
        }
        for (i = this.startIndex; i < listStart && i < ((TieredAnvilContainer)this.f_97732_).recipes.size(); ++i) {
            offset = i - this.startIndex;
            x = listX + offset % 3 * 18;
            row = offset / 3;
            y = listY + row * 18;
            if (i == ((TieredAnvilContainer)this.f_97732_).getSelectedRecipeIndex()) {
                RenderUtil.renderGradient(stack, x + 1, y + 1, 16, 16, this.m_93252_(), 0x7F000000);
                continue;
            }
            if (mouseX < x || mouseY < y || mouseX >= x + 18 || mouseY >= y + 18) continue;
            RenderUtil.renderGradient(stack, x + 1, y + 1, 16, 16, this.m_93252_(), Integer.MAX_VALUE);
        }
    }

    public void m_7379_() {
        this.grabbedScrollBar = false;
        super.m_7379_();
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.grabbedScrollBar = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            this.updateScroll(mouseX, mouseY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.updateScroll(mouseX, mouseY)) {
            this.grabbedScrollBar = true;
            return true;
        }
        if (((TieredAnvilContainer)this.f_97732_).getSelectedRecipeIndex() != -1) {
            ResourceLocation id;
            int x = this.f_97735_ + 143;
            int y = this.f_97736_ + 35;
            double xPos = mouseX - (double)x;
            double yPos = mouseY - (double)y;
            if (xPos >= -1.0 && xPos < 17.0 && yPos >= -1.0 && yPos < 17.0 && ((TieredAnvilContainer)this.f_97732_).entity.canStartSmithing((Player)this.f_96541_.f_91074_, id = ((TieredAnvilContainer)this.f_97732_).recipes.get(((TieredAnvilContainer)this.f_97732_).getSelectedRecipeIndex()).m_6423_())) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                NetworkHandler.toServer(new StartSmithingToServer(id, ((TieredAnvilContainer)this.f_97732_).f_38840_));
            }
        }
        if (this.displayRecipes) {
            int listX = this.f_97735_ + 58;
            int listY = this.f_97736_ + 16;
            int listStart = this.startIndex + 9;
            for (int i = this.startIndex; i < listStart; ++i) {
                int i1 = i - this.startIndex;
                double d0 = mouseX - (double)(listX + i1 % 3 * 18);
                double d1 = mouseY - (double)(listY + i1 / 3 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 18.0) || !(d1 < 18.0) || !((TieredAnvilContainer)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, i)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                return true;
            }
        }
        if (((TieredAnvilContainer)this.f_97732_).recipes.size() > 9 && (this.canScrollUp() || this.canScrollDown())) {
            int arrowX = this.f_97735_ + 112;
            int upY = this.f_97736_ + 19;
            int downY = this.f_97736_ + 55;
            double xPos = mouseX - (double)arrowX;
            double yPosUp = mouseY - (double)upY;
            double yPosDown = mouseY - (double)downY;
            if (xPos >= 0.0 && xPos < 13.0) {
                if (yPosUp >= 0.0 && yPosUp < 12.0 && this.canScrollUp()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                    this.startIndex -= 3;
                    this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - 1.0f / (float)this.getOffScreenRows()), (float)0.0f, (float)1.0f);
                    return true;
                }
                if (yPosDown >= 0.0 && yPosDown < 12.0 && this.canScrollDown()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                    this.startIndex += 3;
                    this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs + 1.0f / (float)this.getOffScreenRows()), (float)0.0f, (float)1.0f);
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double x, double y, double scrollAmount) {
        if (scrollAmount < 0.0 ? this.canScrollDown() : this.canScrollUp()) {
            int offScreenRows = this.getOffScreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - scrollAmount / (double)offScreenRows);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)offScreenRows) + 0.5) * 3;
        }
        return true;
    }

    private boolean updateScroll(double mouseX, double mouseY) {
        if (!this.canScroll()) {
            return false;
        }
        int barX = this.f_97735_ + 115;
        int barYMin = this.f_97736_ + 16;
        int barYMax = barYMin + 54;
        if (this.grabbedScrollBar || mouseX >= (double)(barX - 1) && mouseX <= (double)(barX + 3) && mouseY >= (double)barYMin && mouseY <= (double)barYMax) {
            this.scrollOffs = (float)((mouseY - (double)barYMin - 2.0) / 51.0);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffScreenRows()) + 0.5) * 3;
            return true;
        }
        return false;
    }

    private int getOffScreenRows() {
        return (Math.max(0, ((TieredAnvilContainer)this.f_97732_).recipes.size() - 9) + 3 - 1) / 3;
    }

    private boolean canScrollUp() {
        return this.startIndex != 0;
    }

    private boolean canScrollDown() {
        return ((TieredAnvilContainer)this.f_97732_).recipes.size() - this.startIndex > 9;
    }

    private boolean canScroll() {
        return ((TieredAnvilContainer)this.f_97732_).recipes.size() > 9;
    }

    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        super.m_7025_(stack, mouseX, mouseY);
        if (this.displayRecipes) {
            int listX = this.f_97735_ + 58;
            int listY = this.f_97736_ + 16;
            int listStart = this.startIndex + 9;
            for (int i = this.startIndex; i < listStart && i < ((TieredAnvilContainer)this.f_97732_).recipes.size(); ++i) {
                int i1 = i - this.startIndex;
                int j1 = listX + i1 % 3 * 18;
                int k1 = listY + i1 / 3 * 18;
                if (mouseX < j1 || mouseX >= j1 + 18 || mouseY < k1 || mouseY >= k1 + 18) continue;
                this.m_6057_(stack, ((TieredAnvilContainer)this.f_97732_).recipes.get(i).m_8043_(), mouseX, mouseY);
            }
        }
    }
}

