/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen.encyclopedia;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.gui.screen.encyclopedia.EncyclopediaCategory;
import frostnox.nightfall.client.gui.screen.encyclopedia.EncyclopediaTab;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryClient;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryCompletedScreen;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.encyclopedia.EntryStage;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.capability.EntryNotificationToServer;
import frostnox.nightfall.network.message.capability.PuzzleContainerRequestToServer;
import frostnox.nightfall.util.RenderUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;

public class EncyclopediaScreen
extends Screen {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/encyclopedia/encyclopedia.png");
    public static final TranslatableComponent LOCKED_ENTRY = new TranslatableComponent("encyclopedia.locked_entry");
    public static final int WIDTH = 396;
    public static final int HEIGHT = 276;
    private final EncyclopediaTab[] tabs;
    private boolean showTabs;
    public static EncyclopediaTab selectedTab;
    @Nullable
    private Screen entryScreen = null;
    private final Minecraft mc = Minecraft.m_91087_();
    public boolean dirtyTabs = false;

    public EncyclopediaScreen() {
        super(NarratorChatListener.f_93310_);
        this.tabs = new EncyclopediaTab[ClientEngine.get().getCategories().size()];
        this.refreshTabs();
    }

    protected EncyclopediaTab getTab(EncyclopediaCategory category) {
        for (EncyclopediaTab tab : this.tabs) {
            if (tab == null || category != tab.category) continue;
            return tab;
        }
        return null;
    }

    public void setEntryScreen(@Nullable Screen screen) {
        this.entryScreen = screen;
        if (screen != null) {
            this.entryScreen.m_6575_(this.mc, this.mc.m_91268_().m_85445_(), this.mc.m_91268_().m_85446_());
        }
        this.m_7522_((GuiEventListener)this.entryScreen);
    }

    public void refreshTabs() {
        int i = 0;
        IPlayerData capP = PlayerData.get((Player)this.mc.f_91074_);
        int unlockedTabs = 0;
        for (EncyclopediaCategory category : ClientEngine.get().getCategories()) {
            if (capP.hasEntry(category.unlockEntryId())) {
                this.tabs[i] = new EncyclopediaTab(category);
                ++unlockedTabs;
            }
            ++i;
        }
        this.showTabs = unlockedTabs > 1;
        selectedTab = selectedTab == null ? this.getTab(ClientEngine.get().WYLDERY) : this.getTab(EncyclopediaScreen.selectedTab.category);
    }

    protected void m_7856_() {
        if (this.entryScreen != null) {
            this.entryScreen.m_6575_(this.mc, this.mc.m_91268_().m_85445_(), this.mc.m_91268_().m_85446_());
        }
    }

    public void m_96624_() {
        if (this.dirtyTabs) {
            this.dirtyTabs = false;
            this.refreshTabs();
        }
        ++EncyclopediaScreen.selectedTab.tickCount;
        for (EncyclopediaTab tab : this.tabs) {
            if (tab == null) continue;
            boolean hasNotifications = false;
            for (ResourceLocation id : PlayerData.get((Player)this.mc.f_91074_).getEntryNotifications()) {
                EntryClient entry = ClientEngine.get().getEntry(id);
                if (entry == null || entry.category != tab.category) continue;
                hasNotifications = true;
                break;
            }
            tab.hasNotifications = hasNotifications;
        }
        if (this.entryScreen != null) {
            this.entryScreen.m_96624_();
        }
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partial) {
        int tabY;
        int tabX;
        if (this.entryScreen == null) {
            this.m_7333_(poseStack);
        }
        super.m_6305_(poseStack, x, y, partial);
        int xOffset = (this.f_96543_ - 396) / 2;
        int yOffset = (this.f_96544_ - 276) / 2;
        int mouseX = x - xOffset;
        int mouseY = y - yOffset;
        if (selectedTab != null) {
            PoseStack viewStack = RenderSystem.m_157191_();
            viewStack.m_85836_();
            viewStack.m_85837_((double)(xOffset + 15), (double)(yOffset + 15), 0.0);
            RenderSystem.m_157182_();
            selectedTab.render(poseStack);
            viewStack.m_85849_();
            RenderSystem.m_157182_();
            RenderSystem.m_69456_((int)515);
            RenderSystem.m_69465_();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        EncyclopediaScreen.m_93143_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)this.m_93252_(), (float)0.0f, (float)0.0f, (int)396, (int)276, (int)512, (int)512);
        if (this.showTabs) {
            for (int i = 0; i < this.tabs.length; ++i) {
                if (this.tabs[i] == null) continue;
                tabX = 7 + 24 * i;
                tabY = -20;
                int yOff = 5;
                if (this.tabs[i] == selectedTab) {
                    yOff = 0;
                } else if (this.entryScreen == null && mouseX >= tabX && mouseX < tabX + 20 && mouseY >= tabY && mouseY < tabY + 20) {
                    yOff = 0;
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                EncyclopediaScreen.m_93133_((PoseStack)poseStack, (int)(tabX + xOffset), (int)(tabY + yOff + yOffset), (float)0.0f, (float)385.0f, (int)20, (int)(20 - yOff), (int)512, (int)512);
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.tabs[i].category.icon());
                EncyclopediaScreen.m_93133_((PoseStack)poseStack, (int)(tabX + xOffset + 2), (int)(tabY + yOff + yOffset + 2), (float)0.0f, (float)0.0f, (int)16, (int)(16 - Math.max(0, yOff - 2)), (int)16, (int)16);
                if (this.tabs[i] == selectedTab) {
                    RenderUtil.renderGradient(poseStack, tabX + xOffset, tabY + yOff + yOffset, 20, 20 - yOff, this.m_93252_(), 1329602560);
                }
                if (!this.tabs[i].hasNotifications) continue;
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                EncyclopediaScreen.m_93133_((PoseStack)poseStack, (int)(tabX + xOffset), (int)(tabY + yOff + yOffset), (float)0.0f, (float)364.0f, (int)20, (int)(20 - yOff), (int)512, (int)512);
            }
        }
        if (this.entryScreen != null) {
            this.entryScreen.m_6305_(poseStack, x, y, partial);
        } else {
            EntryClient entry;
            if (this.showTabs) {
                for (int i = 0; i < this.tabs.length; ++i) {
                    if (this.tabs[i] == null) continue;
                    tabX = 7 + 24 * i;
                    tabY = -20;
                    if (mouseX < tabX || mouseX >= tabX + 20 || mouseY < tabY || mouseY >= tabY + 20) continue;
                    this.m_96602_(poseStack, (Component)new TranslatableComponent(this.tabs[i].category.name()), x, y);
                    break;
                }
            }
            if (selectedTab != null && mouseX >= 15 && mouseX < 381 && mouseY >= 15 && mouseY < 261 && (entry = selectedTab.hoveredEntry(mouseX, mouseY)) != null) {
                if (PlayerData.get((Player)this.mc.f_91074_).hasEntryStage(entry.entry.getId(), EntryStage.LOCKED)) {
                    this.m_96602_(poseStack, (Component)LOCKED_ENTRY, x, y);
                } else {
                    this.m_96602_(poseStack, (Component)new TranslatableComponent(((Entry)((Object)entry.entry.get())).getDescriptionId()), x, y);
                }
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == ClientEngine.get().keyEncyclopedia.getKey().m_84873_()) {
            if (this.entryScreen != null) {
                this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundContainerClosePacket(this.mc.f_91074_.f_36096_.f_38840_));
                this.mc.f_91074_.f_36096_ = this.mc.f_91074_.f_36095_;
                this.entryScreen = null;
                this.m_7522_(null);
            } else {
                this.m_7379_();
            }
            return true;
        }
        if (pKeyCode == this.mc.f_91066_.f_92092_.getKey().m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7979_(double x, double y, int button, double dragX, double dragY) {
        if (this.entryScreen != null) {
            return this.entryScreen.m_7979_(x, y, button, dragX, dragY);
        }
        int xOffset = (this.f_96543_ - 396) / 2 + 15;
        int yOffset = (this.f_96544_ - 276) / 2 + 15;
        if (button == 0 && selectedTab != null && x >= (double)xOffset && x < (double)(xOffset + 366) && y >= (double)yOffset && y < (double)(yOffset + 246)) {
            selectedTab.scroll(dragX, dragY);
            return true;
        }
        return false;
    }

    public boolean m_6375_(double x, double y, int button) {
        EntryClient entry;
        if (this.entryScreen != null) {
            return this.entryScreen.m_6375_(x, y, button);
        }
        int xOffset = (this.f_96543_ - 396) / 2 + 15;
        int yOffset = (this.f_96544_ - 276) / 2 + 15;
        double mouseX = x - (double)((this.f_96543_ - 396) / 2);
        double mouseY = y - (double)((this.f_96544_ - 276) / 2);
        if (this.showTabs) {
            for (int i = 0; i < this.tabs.length; ++i) {
                if (this.tabs[i] == null) continue;
                int tabX = 7 + 24 * i;
                int tabY = -20;
                if (!(mouseX >= (double)tabX) || !(mouseX < (double)(tabX + 20)) || !(mouseY >= (double)tabY) || !(mouseY < (double)(tabY + 20)) || this.tabs[i] == selectedTab) continue;
                selectedTab = this.tabs[i];
                EncyclopediaScreen.selectedTab.tickCount = 0;
                this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
            }
        }
        if (button == 0 && selectedTab != null && x >= (double)xOffset && x < (double)(xOffset + 366) && y >= (double)yOffset && y < (double)(yOffset + 246) && (entry = selectedTab.hoveredEntry(mouseX, mouseY)) != null) {
            ResourceLocation id;
            IPlayerData capP = PlayerData.get((Player)this.mc.f_91074_);
            EntryStage stage = capP.getStage(id = entry.entry.getId());
            if (stage == EntryStage.HIDDEN || stage == EntryStage.LOCKED) {
                return false;
            }
            if (capP.hasEntryNotification(id)) {
                capP.removeEntryNotification(id);
                NetworkHandler.toServer(new EntryNotificationToServer(id, true));
            }
            if (stage == EntryStage.PUZZLE) {
                NetworkHandler.toServer(new PuzzleContainerRequestToServer(id));
            } else if (stage == EntryStage.COMPLETED) {
                this.setEntryScreen(new EntryCompletedScreen(entry));
            }
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)0.85f));
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        if (this.entryScreen != null) {
            return this.entryScreen.m_6348_(x, y, button);
        }
        return super.m_6348_(x, y, button);
    }

    public void m_7379_() {
        if (this.entryScreen != null) {
            this.entryScreen.m_7379_();
        }
        super.m_7379_();
    }
}

