/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen.encyclopedia;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.gui.screen.encyclopedia.EncyclopediaCategory;
import frostnox.nightfall.client.gui.screen.encyclopedia.EncyclopediaScreen;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryClient;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.encyclopedia.EntryStage;
import frostnox.nightfall.registry.EntriesNF;
import frostnox.nightfall.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.RegistryObject;

public class EncyclopediaTab
extends GuiComponent {
    public static final int BACKGROUND_WIDTH = 366;
    public static final int BACKGROUND_HEIGHT = 246;
    public static final int IMAGE_WIDTH = 366;
    public static final int IMAGE_HEIGHT = 314;
    public static final int GRID_SIZE = 25;
    public static final int GRID_SLOT_SIZE = 24;
    public static final int BUTTON_SIZE = 20;
    public static final int ICON_SIZE = 16;
    private static final int MIN_POS = -12;
    private static final int MAX_POS = 12;
    private static final int OFFSET = 290;
    private static final int GRID_MIN = -288;
    private static final int X_CENTER = -119;
    private static final int Y_CENTER = -179;
    public final EncyclopediaCategory category;
    private final Minecraft mc;
    private double scrollX;
    private double scrollY;
    protected int tickCount = 0;
    public boolean hasNotifications;

    public EncyclopediaTab(EncyclopediaCategory category) {
        this.category = category;
        this.mc = Minecraft.m_91087_();
    }

    public void render(PoseStack poseStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.category.background());
        EncyclopediaTab.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)366, (int)246, (int)366, (int)314);
        int xScroll = Mth.m_14107_((double)this.scrollX);
        int yScroll = Mth.m_14107_((double)this.scrollY);
        IPlayerData encyclopedia = PlayerData.get((Player)this.mc.f_91074_);
        for (EntryClient cEntry : ClientEngine.get().getEntries(this.category)) {
            boolean renderEntry;
            EntryStage stage = encyclopedia.getStage(cEntry.entry.getId());
            if (stage == EntryStage.HIDDEN) continue;
            int x = cEntry.x * 24 + xScroll + -119;
            int y = cEntry.y * 24 + yScroll + -179;
            int sizeX = 0;
            int sizeY = 0;
            int uOff = 0;
            int vOff = 0;
            boolean bl = renderEntry = x > -312 && x < 74 && y > -312 && y < -46;
            if (x > 54) {
                sizeX = x - 54;
            } else if (x < -292) {
                sizeX = uOff = -(x - -288 + 4);
            }
            if (y > -66) {
                sizeY = y - -66;
            } else if (y < -292) {
                sizeY = vOff = -(y - -288 + 4);
            }
            int iconX = Mth.m_14045_((int)x, (int)-294, (int)78);
            int iconY = Mth.m_14045_((int)y, (int)-294, (int)-42);
            x = Mth.m_14045_((int)x, (int)-292, (int)78);
            y = Mth.m_14045_((int)y, (int)-292, (int)-42);
            Entry entry = EntriesNF.get(cEntry.entry.getId());
            if (!cEntry.separated) {
                for (RegistryObject<? extends Entry> prerequisite : entry.parents) {
                    EntryClient pEntry = ClientEngine.get().getEntry(cEntry.category, prerequisite.getId());
                    if (pEntry == null) continue;
                    int xDist = cEntry.x - pEntry.x;
                    int yDist = cEntry.y - pEntry.y;
                    while (xDist != 0 || yDist != 0) {
                        int connectorX = pEntry.x + xDist;
                        int connectorY = pEntry.y + yDist;
                        int offX = connectorX * 24 + xScroll + -119;
                        int offY = connectorY * 24 + yScroll + -179;
                        int u = 0;
                        if (connectorX == cEntry.x && connectorY == pEntry.y) {
                            u = cEntry.x > pEntry.x ? (cEntry.y > pEntry.y ? 120 : 72) : (cEntry.y < pEntry.y ? 96 : 48);
                        } else if (connectorX == pEntry.x && connectorY == cEntry.y) {
                            u = cEntry.x < pEntry.x ? (cEntry.y > pEntry.y ? 120 : 72) : (cEntry.y > pEntry.y ? 96 : 48);
                        } else if (connectorX != pEntry.x) {
                            u = 24;
                        }
                        if (connectorX != cEntry.x || connectorY != cEntry.y) {
                            RenderSystem.m_157456_((int)0, (ResourceLocation)this.category.background());
                            this.blitInside(poseStack, offX, offY, u, 266);
                        }
                        if (xDist != 0 && (yDist == 0 || Math.abs(xDist) < Math.abs(yDist))) {
                            xDist += xDist < 0 ? 1 : -1;
                            continue;
                        }
                        yDist += yDist < 0 ? 1 : -1;
                    }
                }
            }
            if (!renderEntry) continue;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.category.background());
            EncyclopediaTab.m_93133_((PoseStack)poseStack, (int)(290 + x + 2), (int)(290 + y + 2), (float)uOff, (float)(246 + vOff), (int)(20 - sizeX), (int)(20 - sizeY), (int)366, (int)314);
            if (!cEntry.itemIcon.m_41619_()) {
                int xi = x + 4 - uOff;
                int yi = y + 4 - vOff;
                if (xi > -306 && xi < 76 && yi > -306 && yi < -44) {
                    RenderUtil.renderItem(poseStack, cEntry.itemIcon, 290 + xi, 290 + yi, this.m_93252_(), stage != EntryStage.COMPLETED);
                }
            } else {
                RenderSystem.m_157456_((int)0, (ResourceLocation)cEntry.icon);
                if (stage != EntryStage.COMPLETED) {
                    RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                EncyclopediaTab.m_93133_((PoseStack)poseStack, (int)(290 + iconX + 4), (int)(290 + iconY + 4), (float)Math.max(0, uOff - 2), (float)Math.max(0, vOff - 2), (int)(16 - Math.max(0, sizeX - 2)), (int)(16 - Math.max(0, sizeY - 2)), (int)16, (int)16);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (stage == EntryStage.LOCKED) {
                RenderUtil.renderGradient(poseStack, 290 + x + 2, 290 + y + 2, 20 - sizeX, 20 - sizeY, this.m_93252_(), 0x7F000000);
            } else if (stage == EntryStage.PUZZLE) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)Mth.m_14179_((float)ClientEngine.get().getPartialTick(), (float)Mth.m_14031_((float)((float)(this.tickCount - 1) / 8.0f)), (float)Mth.m_14031_((float)((float)this.tickCount / 8.0f))));
                RenderUtil.renderGradient(poseStack, 290 + x + 2, 290 + y + 2, 20 - sizeX, 20 - sizeY, this.m_93252_(), Integer.MAX_VALUE);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (!encyclopedia.hasEntryNotification(cEntry.entry.getId())) continue;
            RenderSystem.m_157456_((int)0, (ResourceLocation)EncyclopediaScreen.TEXTURE);
            EncyclopediaTab.m_93133_((PoseStack)poseStack, (int)(290 + x + 2), (int)(290 + y + 2), (float)uOff, (float)(364 + vOff), (int)(20 - sizeX), (int)(20 - sizeY), (int)512, (int)512);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.category.background());
        for (EntryClient cEntry : ClientEngine.get().getEntries(this.category)) {
            if (cEntry.separated || !encyclopedia.hasEntry(cEntry.entry.getId())) continue;
            Entry entry = EntriesNF.get(cEntry.entry.getId());
            for (RegistryObject<? extends Entry> prerequisite : entry.parents) {
                EntryClient pEntry = ClientEngine.get().getEntry(cEntry.category, prerequisite.getId());
                if (pEntry == null) continue;
                int xDist = cEntry.x - pEntry.x;
                int yDist = cEntry.y - pEntry.y;
                int xMove = 0;
                int yMove = 0;
                if (xDist != 0 && (yDist == 0 || Math.abs(xDist) < Math.abs(yDist))) {
                    xMove = xDist < 0 ? 1 : -1;
                } else {
                    yMove = yDist < 0 ? 1 : -1;
                }
                int x = pEntry.x + xDist + xMove;
                int y = pEntry.y + yDist + yMove;
                int entryX = x * 24 + xScroll + -119;
                int entryY = y * 24 + yScroll + -179;
                int u = yMove == 1 ? 0 : (xMove == 1 ? 24 : (xMove == -1 ? 48 : 72));
                this.blitInside(poseStack, entryX, entryY, u, 290);
            }
        }
    }

    protected void blitInside(PoseStack poseStack, int x, int y, int u, int v) {
        int sizeX = 0;
        int sizeY = 0;
        int uOff = 0;
        int vOff = 0;
        if (x >= -314 && x < 78 && y >= -314 && y < -42) {
            if (x > 54) {
                sizeX = x - 54;
            } else if (x < -290) {
                sizeX = uOff = -(x - -288 + 2);
            }
            if (y > -66) {
                sizeY = y - -66;
            } else if (y < -290) {
                sizeY = vOff = -(y - -288 + 2);
            }
            x = Mth.m_14045_((int)x, (int)-290, (int)78);
            y = Mth.m_14045_((int)y, (int)-290, (int)-42);
            EncyclopediaTab.m_93133_((PoseStack)poseStack, (int)(290 + x), (int)(290 + y), (float)(u + uOff), (float)(v + vOff), (int)(24 - sizeX), (int)(24 - sizeY), (int)366, (int)314);
        }
    }

    public EntryClient hoveredEntry(double x, double y) {
        int xScroll = Mth.m_14107_((double)this.scrollX);
        int yScroll = Mth.m_14107_((double)this.scrollY);
        IPlayerData encyclopedia = PlayerData.get((Player)this.mc.f_91074_);
        for (EntryClient entry : ClientEngine.get().getEntries(this.category)) {
            if (!encyclopedia.hasEntry(entry.entry.getId())) continue;
            int entryX = 290 + entry.x * 24 + xScroll + 17 + -119;
            int entryY = 290 + entry.y * 24 + yScroll + 17 + -179;
            if (!(x >= (double)entryX) || !(x < (double)(entryX + 20)) || !(y >= (double)entryY) || !(y < (double)(entryY + 20))) continue;
            return entry;
        }
        return null;
    }

    public void scroll(double dragX, double dragY) {
        this.scrollX = Mth.m_14008_((double)(this.scrollX + dragX), (double)-288.0, (double)288.0);
        this.scrollY = Mth.m_14008_((double)(this.scrollY + dragY), (double)-288.0, (double)288.0);
    }
}

