/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen.encyclopedia;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.gui.screen.encyclopedia.EncyclopediaScreen;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryClient;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryPuzzleScreen;
import frostnox.nightfall.client.gui.screen.inventory.RecipeViewerComponent;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.IEncyclopediaRecipe;
import frostnox.nightfall.util.RenderUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class EntryCompletedScreen
extends Screen {
    private final Minecraft mc = Minecraft.m_91087_();
    private final EntryClient cEntry;
    private final List<List<ItemStack>> groupedItems;
    private final RecipeViewerComponent recipeViewer;
    private int tickCount;

    public EntryCompletedScreen(EntryClient cEntry) {
        super(NarratorChatListener.f_93310_);
        IEncyclopediaRecipe encyclopediaRecipe;
        this.cEntry = cEntry;
        ObjectArrayList unlockedItems = new ObjectArrayList(15);
        ObjectArrayList allItems = new ObjectArrayList(15);
        for (Recipe<?> recipe : RenderUtil.getUnlockedRecipes((Player)this.mc.f_91074_)) {
            if (!(recipe instanceof IEncyclopediaRecipe) || !cEntry.containsEntry((encyclopediaRecipe = (IEncyclopediaRecipe)recipe).getRequirementId()) || unlockedItems.contains(recipe.m_8043_().m_41720_())) continue;
            unlockedItems.add(recipe.m_8043_().m_41720_());
        }
        for (Recipe<?> recipe : RenderUtil.getSearchableRecipes((Player)this.mc.f_91074_)) {
            if (!(recipe instanceof IEncyclopediaRecipe) || !cEntry.containsEntry((encyclopediaRecipe = (IEncyclopediaRecipe)recipe).getRequirementId()) || allItems.contains(recipe.m_8043_().m_41720_())) continue;
            allItems.add(recipe.m_8043_().m_41720_());
        }
        this.recipeViewer = new RecipeViewerComponent();
        this.groupedItems = new ObjectArrayList(8);
        if (!unlockedItems.isEmpty()) {
            this.recipeViewer.setVisible(true);
            this.recipeViewer.setRecipeItem((Item)unlockedItems.get(0));
            Object2ObjectArrayMap taggedItems = new Object2ObjectArrayMap(8);
            for (Item item : unlockedItems) {
                if (EntryCompletedScreen.skipItem(item, taggedItems.values())) continue;
                if (item.m_204114_().m_203656_(TagsNF.RECIPE_GROUP)) {
                    boolean added = false;
                    for (TagKey tag : item.m_204114_().m_203616_().toList()) {
                        if (taggedItems.containsKey(tag) || tag.f_203868_().m_135815_().contains("no_recipe_grouping/")) continue;
                        List tagItems = ForgeRegistries.ITEMS.tags().getTag(tag).stream().toList();
                        int match = 0;
                        for (Item tagItem : tagItems) {
                            if (!allItems.contains(tagItem)) {
                                match = 1;
                                break;
                            }
                            if (tagItem.m_204114_().m_203656_(TagsNF.RECIPE_GROUP)) continue;
                            match = 2;
                            break;
                        }
                        if (match == 0) {
                            added = true;
                            taggedItems.put(tag, tagItems.stream().filter(((List)unlockedItems)::contains).map(ItemStack::new).toList());
                            break;
                        }
                        if (match != 2) continue;
                        added = true;
                        taggedItems.put(tag, List.of());
                    }
                    if (added) continue;
                    this.groupedItems.add(List.of(new ItemStack((ItemLike)item)));
                    continue;
                }
                this.groupedItems.add(List.of(new ItemStack((ItemLike)item)));
            }
            this.groupedItems.addAll(taggedItems.values().stream().filter(list -> !list.isEmpty()).toList());
        }
        ClientEngine.get().openEntry = cEntry;
    }

    private static boolean skipItem(Item item, Collection<List<ItemStack>> taggedItems) {
        for (List<ItemStack> taggedItemStacks : taggedItems) {
            for (ItemStack itemStack : taggedItemStacks) {
                if (itemStack.m_41720_() != item) continue;
                return true;
            }
        }
        return false;
    }

    public void m_96624_() {
        ++this.tickCount;
    }

    public void m_7379_() {
        super.m_7379_();
        ClientEngine.get().openEntry = null;
    }

    public void m_6305_(PoseStack stack, int x, int y, float partial) {
        RenderSystem.m_69465_();
        this.m_7333_(stack);
        super.m_6305_(stack, x, y, partial);
        if (this.cEntry != null) {
            int yPos;
            int xPos;
            int i;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)EncyclopediaScreen.TEXTURE);
            stack.m_85836_();
            int xOff = this.f_96543_ / 2 - 55;
            int yOff = this.f_96544_ / 2 - 34 - 45;
            stack.m_85837_((double)xOff, (double)yOff, 0.0);
            EntryCompletedScreen.m_93133_((PoseStack)stack, (int)0, (int)0, (float)0.0f, (float)444.0f, (int)110, (int)68, (int)512, (int)512);
            EntryPuzzleScreen.renderImage(stack, this.cEntry.completedImage);
            for (i = 0; i < this.groupedItems.size(); ++i) {
                xPos = 5 + i % 5 * 21 + xOff;
                yPos = 5 + i / 5 * 21 + yOff;
                this.mc.m_91291_().m_115203_(this.groupedItems.get(i).get(this.tickCount / 24 % this.groupedItems.get(i).size()), xPos, yPos);
            }
            stack.m_85849_();
            if (this.recipeViewer.isVisible()) {
                this.recipeViewer.setOffset(this.f_96543_ / 2 - 61, yOff + 68 + 5);
                this.recipeViewer.m_6305_(stack, x, y, partial);
            }
            for (i = 0; i < this.groupedItems.size(); ++i) {
                xPos = 5 + i % 5 * 21 + xOff;
                yPos = 5 + yOff + i / 5 * 21;
                if (x < xPos || x >= xPos + 16 || y < yPos || y >= yPos + 16) continue;
                this.m_6057_(stack, this.groupedItems.get(i).get(this.tickCount / 24 % this.groupedItems.get(i).size()), x, y);
            }
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.recipeViewer.m_6375_(x, y, button)) {
            return true;
        }
        int xOff = this.f_96543_ / 2 - 55;
        int yOff = this.f_96544_ / 2 - 34 - 45;
        for (int i = 0; i < this.groupedItems.size(); ++i) {
            int xPos = 5 + i % 5 * 21 + xOff;
            int yPos = 5 + yOff + i / 5 * 21;
            if (!(x >= (double)xPos) || !(x < (double)(xPos + 16)) || !(y >= (double)yPos) || !(y < (double)(yPos + 16)) || !this.recipeViewer.setRecipeItem(this.groupedItems.get(i).get(this.tickCount / 24 % this.groupedItems.get(i).size()).m_41720_())) continue;
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        }
        return super.m_6375_(x, y, button);
    }
}

