/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen.encyclopedia;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.gui.screen.PartialInventoryScreen;
import frostnox.nightfall.client.gui.screen.encyclopedia.EncyclopediaScreen;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryClient;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryCompletedScreen;
import frostnox.nightfall.encyclopedia.Entry;
import frostnox.nightfall.encyclopedia.EntryStage;
import frostnox.nightfall.encyclopedia.Puzzle;
import frostnox.nightfall.encyclopedia.PuzzleContainer;
import frostnox.nightfall.encyclopedia.knowledge.Knowledge;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericToServer;
import frostnox.nightfall.registry.KnowledgeNF;
import frostnox.nightfall.registry.WorldConditionsNF;
import frostnox.nightfall.util.RenderUtil;
import frostnox.nightfall.world.condition.WorldCondition;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;

public class EntryPuzzleScreen
extends PartialInventoryScreen<PuzzleContainer> {
    public static final int BACKGROUND_WIDTH = 110;
    public static final int BACKGROUND_HEIGHT = 68;
    public static final TranslatableComponent MISSING_KNOWLEDGE = new TranslatableComponent("encyclopedia.missing_knowledge");
    public static final TranslatableComponent HIDDEN_KNOWLEDGE = new TranslatableComponent("encyclopedia.hidden_knowledge");
    private static final int MAX_IMAGE_SIZE = 150;
    private final Minecraft mc = Minecraft.m_91087_();
    private final EntryClient cEntry;
    private final String tipPrefix;

    public EntryPuzzleScreen(PuzzleContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.cEntry = ClientEngine.get().getEntry(pMenu.entry.getRegistryName());
        this.tipPrefix = ((Entry)((Object)this.cEntry.entry.get())).getDescriptionId();
        ClientEngine.get().openEntry = this.cEntry;
    }

    @Override
    protected ResourceLocation getInventoryTexture() {
        return INVENTORY_PAPER_TEXTURE;
    }

    protected void m_181908_() {
        EntryStage stage = PlayerData.get((Player)this.mc.f_91074_).getStage(this.cEntry.entry.getId());
        if (stage != EntryStage.PUZZLE) {
            this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundContainerClosePacket(this.mc.f_91074_.f_36096_.f_38840_));
            this.mc.f_91074_.f_36096_ = this.mc.f_91074_.f_36095_;
            Screen screen = this.mc.f_91080_;
            if (screen instanceof EncyclopediaScreen) {
                EncyclopediaScreen encyclopediaScreen = (EncyclopediaScreen)screen;
                if (stage == EntryStage.COMPLETED) {
                    encyclopediaScreen.setEntryScreen(new EntryCompletedScreen(this.cEntry));
                } else {
                    encyclopediaScreen.setEntryScreen(null);
                }
            } else {
                this.m_7379_();
            }
        }
    }

    public void m_7379_() {
        super.m_7379_();
        this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundContainerClosePacket(this.mc.f_91074_.f_36096_.f_38840_));
        this.mc.f_91074_.f_36096_ = this.mc.f_91074_.f_36095_;
        Screen screen = this.mc.f_91080_;
        if (screen instanceof EncyclopediaScreen) {
            EncyclopediaScreen encyclopediaScreen = (EncyclopediaScreen)screen;
            encyclopediaScreen.setEntryScreen(null);
        }
        ClientEngine.get().openEntry = null;
    }

    @Override
    protected void m_7286_(PoseStack stack, float partial, int mouseX, int mouseY) {
        RenderSystem.m_69465_();
        this.m_7333_(stack);
        super.m_7286_(stack, partial, mouseX, mouseY);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)EncyclopediaScreen.TEXTURE);
        stack.m_85836_();
        int xOff = this.f_96543_ / 2 - 55;
        int yOff = this.f_96544_ / 2 - 34 - 45;
        stack.m_85837_((double)xOff, (double)yOff, 0.0);
        Puzzle puzzle = ((Entry)((Object)this.cEntry.entry.get())).puzzle;
        if (puzzle != null) {
            int rows = 1;
            if (!puzzle.knowledge().isEmpty()) {
                ++rows;
            }
            if (!puzzle.conditions().isEmpty()) {
                ++rows;
            }
            if (rows == 1) {
                EntryPuzzleScreen.m_93133_((PoseStack)stack, (int)0, (int)42, (float)0.0f, (float)444.0f, (int)110, (int)22, (int)512, (int)512);
                EntryPuzzleScreen.m_93133_((PoseStack)stack, (int)0, (int)64, (float)0.0f, (float)508.0f, (int)110, (int)4, (int)512, (int)512);
            } else if (rows == 2) {
                EntryPuzzleScreen.m_93133_((PoseStack)stack, (int)0, (int)21, (float)0.0f, (float)444.0f, (int)110, (int)43, (int)512, (int)512);
                EntryPuzzleScreen.m_93133_((PoseStack)stack, (int)0, (int)64, (float)0.0f, (float)508.0f, (int)110, (int)4, (int)512, (int)512);
            } else {
                EntryPuzzleScreen.m_93133_((PoseStack)stack, (int)0, (int)0, (float)0.0f, (float)444.0f, (int)110, (int)68, (int)512, (int)512);
            }
            for (int i = 0; i < puzzle.ingredients().size(); ++i) {
                EntryPuzzleScreen.m_93133_((PoseStack)stack, (int)(4 + i * 21), (int)46, (float)0.0f, (float)406.0f, (int)18, (int)18, (int)512, (int)512);
            }
            for (int x = 1; x <= rows - 1; ++x) {
                int slots = rows == 2 ? (puzzle.knowledge().isEmpty() ? puzzle.conditions().size() : puzzle.knowledge().size()) : (x == 1 ? puzzle.knowledge().size() : puzzle.conditions().size());
                for (int i = 0; i < slots; ++i) {
                    EntryPuzzleScreen.m_93133_((PoseStack)stack, (int)(4 + i * 21), (int)(46 - 21 * x), (float)19.0f, (float)406.0f, (int)18, (int)18, (int)512, (int)512);
                }
            }
            EntryPuzzleScreen.m_93133_((PoseStack)stack, (int)(4 + puzzle.ingredients().size() * 21), (int)46, (float)0.0f, (float)425.0f, (int)18, (int)18, (int)512, (int)512);
        }
        EntryPuzzleScreen.renderImage(stack, this.cEntry.puzzleImage);
        stack.m_85849_();
    }

    public void m_6305_(PoseStack stack, int x, int y, float partial) {
        Puzzle puzzle;
        super.m_6305_(stack, x, y, partial);
        if (this.cEntry != null && (puzzle = ((Entry)((Object)this.cEntry.entry.get())).puzzle) != null) {
            int yPos;
            int i;
            stack.m_85836_();
            int xOff = this.f_96543_ / 2 - 55;
            int yOff = this.f_96544_ / 2 - 34 - 45;
            IPlayerData capP = PlayerData.get((Player)this.mc.f_91074_);
            stack.m_85837_((double)xOff, (double)yOff, 200.0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            for (i = 0; i < puzzle.conditions().size(); ++i) {
                int yPos2;
                WorldCondition condition = (WorldCondition)((Object)puzzle.conditions().get(i).get());
                int xPos = 5 + i * 21;
                int n = yPos2 = puzzle.knowledge().isEmpty() ? 26 : 5;
                if (condition.test((Player)this.mc.f_91074_)) {
                    RenderUtil.renderSprite(stack, xPos, yPos2, WorldConditionsNF.SATISFIED_CONDITION_TEXTURE);
                    continue;
                }
                RenderUtil.renderSprite(stack, xPos, yPos2, WorldConditionsNF.UNSATISFIED_CONDITION_TEXTURE);
            }
            for (i = 0; i < puzzle.knowledge().size(); ++i) {
                int xPos = 5 + i * 21;
                yPos = 26;
                Knowledge knowledge = (Knowledge)((Object)puzzle.knowledge().get(i).get());
                if (!capP.hasKnowledge(knowledge.getRegistryName())) {
                    RenderUtil.renderSprite(stack, xPos, yPos, KnowledgeNF.UNKNOWN_KNOWLEDGE_TEXTURE);
                    continue;
                }
                RenderUtil.renderSprite(stack, xPos, yPos, KnowledgeNF.KNOWLEDGE_TEXTURE);
            }
            if (!this.canExperiment(puzzle)) {
                RenderUtil.renderGradient(stack, 4 + puzzle.ingredients().size() * 21, 46, 18, 18, this.m_93252_(), 0x7F000000);
                if (this.isHoveringExperimentButton(x, y, puzzle) && !puzzle.hasAllKnowledge(PlayerData.get((Player)this.mc.f_91074_))) {
                    this.m_96602_(stack, (Component)MISSING_KNOWLEDGE, x - xOff, y - yOff);
                }
            } else if (this.isHoveringExperimentButton(x, y, puzzle)) {
                RenderUtil.renderGradient(stack, 4 + puzzle.ingredients().size() * 21, 46, 18, 18, this.m_93252_(), Integer.MAX_VALUE);
            }
            for (i = 0; i < puzzle.conditions().size(); ++i) {
                int xPos = xOff + 4 + i * 21;
                yPos = yOff + (puzzle.knowledge().isEmpty() ? 25 : 4);
                if (x < xPos || x >= xPos + 18 || y < yPos || y >= yPos + 18) continue;
                TranslatableComponent tip = new TranslatableComponent(this.tipPrefix + ".condition_" + i);
                this.m_96602_(stack, (Component)tip, x - xOff, y - yOff);
            }
            for (i = 0; i < puzzle.knowledge().size(); ++i) {
                int xPos = xOff + 4 + i * 21;
                yPos = yOff + 25;
                if (x < xPos || x >= xPos + 18 || y < yPos || y >= yPos + 18) continue;
                String key = this.tipPrefix + ".knowledge_" + i;
                if (Language.m_128107_().m_6722_(key)) {
                    this.m_96602_(stack, (Component)new TranslatableComponent(key), x - xOff, y - yOff);
                    continue;
                }
                this.m_96602_(stack, (Component)HIDDEN_KNOWLEDGE, x - xOff, y - yOff);
            }
            stack.m_85849_();
        }
        this.m_7025_(stack, x, y);
    }

    protected void m_7025_(PoseStack pPoseStack, int x, int pY) {
        if (this.f_97734_ != null) {
            TranslatableComponent tip = new TranslatableComponent(this.tipPrefix + ".item_" + this.f_97734_.m_150661_());
            if (!(this.f_97734_.f_40219_ < 36 || ((PuzzleContainer)this.f_97732_).m_142621_().m_41619_() && this.f_97734_.m_6657_())) {
                this.m_96602_(pPoseStack, (Component)tip, x, pY);
            } else {
                ItemStack item = this.f_97734_.m_7993_();
                if (!item.m_41619_()) {
                    List components = this.m_96555_(item);
                    if (this.f_97734_.f_40219_ >= 36) {
                        components.add(TextComponent.f_131282_);
                        components.add(tip);
                    }
                    this.renderTooltip(pPoseStack, components, item.m_150921_(), x, pY, null, item);
                }
            }
        }
    }

    private boolean isHoveringExperimentButton(double x, double y, Puzzle puzzle) {
        int buttonX = this.f_96543_ / 2 - 55 + 4 + puzzle.ingredients().size() * 21;
        int buttonY = this.f_96544_ / 2 - 34 - 45 + 46;
        return x >= (double)buttonX && x < (double)(buttonX + 18) && y >= (double)buttonY && y < (double)(buttonY + 18);
    }

    private boolean canExperiment(Puzzle puzzle) {
        if (((PuzzleContainer)this.f_97732_).inventory.isFull()) {
            return puzzle.hasAllKnowledge(PlayerData.get((Player)this.mc.f_91074_));
        }
        return false;
    }

    static void renderImage(PoseStack poseStack, EntryClient.Image image) {
        if (image != null) {
            int x = 155;
            int y = 34 - image.height() / 2;
            int margin = 8;
            int width = Math.min(image.width() + margin * 2, 150);
            int height = Math.min(image.height() + margin * 2, 150);
            EntryPuzzleScreen.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)111.0f, (float)362.0f, (int)width, (int)height, (int)512, (int)512);
            EntryPuzzleScreen.m_93133_((PoseStack)poseStack, (int)x, (int)(y + height - margin), (float)111.0f, (float)(512 - margin), (int)width, (int)margin, (int)512, (int)512);
            EntryPuzzleScreen.m_93133_((PoseStack)poseStack, (int)(x + width - margin), (int)y, (float)(261 - margin), (float)362.0f, (int)margin, (int)height, (int)512, (int)512);
            EntryPuzzleScreen.m_93133_((PoseStack)poseStack, (int)(x + width - margin), (int)(y + height - margin), (float)(261 - margin), (float)(512 - margin), (int)margin, (int)margin, (int)512, (int)512);
            RenderSystem.m_157456_((int)0, (ResourceLocation)image.texture());
            EntryPuzzleScreen.m_93133_((PoseStack)poseStack, (int)(x + margin), (int)(y + margin), (float)0.0f, (float)0.0f, (int)image.width(), (int)image.height(), (int)image.width(), (int)image.height());
        }
    }

    protected boolean m_7467_(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        return false;
    }

    public boolean m_6375_(double x, double y, int button) {
        Puzzle puzzle = ((Entry)((Object)this.cEntry.entry.get())).puzzle;
        if (puzzle != null && this.isHoveringExperimentButton(x, y, puzzle) && this.canExperiment(puzzle)) {
            NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.PUZZLE_EXPERIMENT_SERVER));
            return true;
        }
        return super.m_6375_(x, y, button);
    }
}

