/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.gui.screen.PartialInventoryScreen;
import frostnox.nightfall.client.gui.screen.ScreenGuiComponent;
import frostnox.nightfall.client.gui.screen.inventory.CreativePlayerInventoryScreen;
import frostnox.nightfall.client.gui.screen.inventory.PlayerStatsComponent;
import frostnox.nightfall.client.gui.screen.inventory.RecipeSearchComponent;
import frostnox.nightfall.registry.forge.AttributesNF;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;

public class PlayerInventoryScreen
extends EffectRenderingInventoryScreen<InventoryMenu> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/screen/player_inventory.png");
    public static final int IMAGE_HEIGHT = 166;
    public final RecipeSearchComponent recipeSearch;
    private boolean recipeSearchInit = false;
    public final PlayerStatsComponent stats;
    public ScreenGuiComponent selectedComponent;
    private int selectedIndex = -1;
    private float xOld;
    private float yOld;

    public PlayerInventoryScreen(Player player) {
        super((AbstractContainerMenu)player.f_36095_, player.m_150109_(), (Component)new TranslatableComponent("container.crafting"));
        this.f_96546_ = true;
        this.f_97728_ = 98;
        this.f_97729_ = 13;
        this.recipeSearch = new RecipeSearchComponent(this);
        this.stats = new PlayerStatsComponent(this);
    }

    public void m_181908_() {
        if (this.f_96541_.f_91072_.m_105290_()) {
            this.f_96541_.m_91152_((Screen)new CreativePlayerInventoryScreen((Player)this.f_96541_.f_91074_));
        } else if (this.selectedComponent != null) {
            this.selectedComponent.containerTick();
        }
    }

    protected void m_7856_() {
        if (this.f_96541_.f_91072_.m_105290_()) {
            this.f_96541_.m_91152_((Screen)new CreativePlayerInventoryScreen((Player)this.f_96541_.f_91074_));
        } else {
            super.m_7856_();
            if (!this.recipeSearchInit) {
                this.recipeSearch.init();
                this.recipeSearchInit = true;
            }
            if (this.selectedComponent != null) {
                this.selectedComponent.onOpen();
            }
            this.stats.init();
            this.f_96541_.f_91068_.m_90926_(true);
        }
    }

    public int getLeftPos() {
        return this.f_97735_;
    }

    public int getTopPos() {
        return this.f_97736_;
    }

    protected void m_7027_(PoseStack pPoseStack, int x, int pY) {
        this.f_96547_.m_92889_(pPoseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 3420462);
    }

    protected void m_194014_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        this.m_7333_(poseStack);
        int x = this.f_97735_;
        int y = this.f_97736_;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        for (int i = 0; i < 2; ++i) {
            int tabX = x + 7 + 24 * i;
            int tabY = y - 19;
            int v = 166;
            int yOff = 5;
            if (i == this.selectedIndex) {
                v += 20;
                yOff = 0;
            } else if (mouseX >= tabX && mouseX < tabX + 20 && mouseY >= tabY && mouseY < tabY + 20) {
                yOff = 0;
            }
            PlayerInventoryScreen.m_93133_((PoseStack)poseStack, (int)tabX, (int)(tabY + yOff), (float)0.0f, (float)v, (int)20, (int)(20 - yOff), (int)512, (int)256);
            int u = 20 + 20 * i;
            v = 166;
            PlayerInventoryScreen.m_93133_((PoseStack)poseStack, (int)tabX, (int)(tabY + yOff), (float)u, (float)v, (int)20, (int)(20 - yOff), (int)512, (int)256);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partial);
        if (this.selectedComponent != null) {
            this.selectedComponent.m_6305_(poseStack, mouseX, mouseY, partial);
        }
        if (this.selectedComponent != this.recipeSearch || !this.recipeSearch.isRecipeSelected()) {
            super.m_194014_(poseStack, mouseX, mouseY);
        }
        this.m_7025_(poseStack, mouseX, mouseY);
        this.xOld = mouseX;
        this.yOld = mouseY;
    }

    protected void m_7286_(PoseStack poseStack, float partial, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PartialInventoryScreen.INVENTORY_WOOD_TEXTURE);
        int x = this.f_97735_;
        int y = this.f_97736_;
        PlayerInventoryScreen.m_93133_((PoseStack)poseStack, (int)(x + 7), (int)(y + 83), (float)7.0f, (float)7.0f, (int)162, (int)76, (int)176, (int)90);
        for (int i = 0; i < AttributesNF.getInventoryCapacity((Player)this.f_96541_.f_91074_); ++i) {
            int offX = 7 + i % 4 * 18;
            int offY = 7 + i / 4 * 18;
            int slotX = x + 90 + offX;
            int slotY = y + 83 + i / 4 * 18;
            PlayerInventoryScreen.m_93133_((PoseStack)poseStack, (int)slotX, (int)slotY, (float)(18 + offX), (float)offY, (int)18, (int)18, (int)176, (int)90);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        PlayerInventoryScreen.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)512, (int)256);
        PoseStack modelStack = RenderSystem.m_157191_();
        modelStack.m_85836_();
        modelStack.m_85837_(0.5, 0.0, 0.0);
        InventoryScreen.m_98850_((int)(x + 49), (int)(y + 73), (int)30, (float)((float)x + 49.5f - this.xOld), (float)((float)y + 73.0f - 50.0f - this.yOld), (LivingEntity)this.f_96541_.f_91074_);
        modelStack.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int x = this.f_97735_;
        int y = this.f_97736_;
        for (int i = 0; i < 2; ++i) {
            int tabX = x + 7 + 24 * i;
            int tabY = y - 19;
            if (!(mouseX >= (double)tabX) || !(mouseX < (double)(tabX + 20)) || !(mouseY >= (double)tabY) || !(mouseY < (double)(tabY + 20))) continue;
            if (this.selectedIndex == i) {
                this.selectedIndex = -1;
                if (this.selectedComponent != null) {
                    this.selectedComponent.onClose();
                }
                this.selectedComponent = null;
            } else {
                this.selectedIndex = i;
                if (this.selectedComponent != null) {
                    this.selectedComponent.onClose();
                }
                if (i == 0) {
                    this.selectedComponent = this.recipeSearch;
                } else if (i == 1) {
                    this.selectedComponent = this.stats;
                }
                this.selectedComponent.onOpen();
            }
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
        }
        if (this.selectedComponent != null && this.selectedComponent.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.selectedComponent != null && this.selectedComponent.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double x, double y, double scrollAmount) {
        if (this.selectedComponent != null && this.selectedComponent.m_6050_(x, y, scrollAmount)) {
            return true;
        }
        return super.m_6050_(x, y, scrollAmount);
    }

    public boolean m_7979_(double x, double y, int button, double dragX, double dragY) {
        if (this.selectedComponent != null && this.selectedComponent.m_7979_(x, y, button, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(x, y, button, dragX, dragY);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.selectedComponent != null && this.selectedComponent.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.selectedComponent != null && this.selectedComponent.m_7920_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.selectedComponent != null && this.selectedComponent.m_5534_(pCodePoint, pModifiers)) {
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public void m_6057_(PoseStack poseStack, ItemStack itemStack, int x, int y) {
        super.m_6057_(poseStack, itemStack, x, y);
    }

    public void m_7861_() {
        if (this.recipeSearchInit) {
            this.recipeSearch.removed();
        }
        this.f_96541_.f_91068_.m_90926_(false);
        super.m_7861_();
    }
}

