/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.client.gui.OverlayNF;
import frostnox.nightfall.client.gui.screen.ScreenGuiComponent;
import frostnox.nightfall.client.gui.screen.inventory.PlayerInventoryScreen;
import frostnox.nightfall.entity.PlayerAttribute;
import frostnox.nightfall.item.item.TieredArmorItem;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.RenderUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.DecimalFormat;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PlayerStatsComponent
extends ScreenGuiComponent {
    private final Minecraft mc = Minecraft.m_91087_();
    private final PlayerInventoryScreen screen;

    public PlayerStatsComponent(PlayerInventoryScreen screen) {
        this.screen = screen;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PlayerInventoryScreen.TEXTURE);
        int x = this.screen.getLeftPos() - 112 - 1;
        int y = this.screen.getTopPos();
        PlayerStatsComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)176.0f, (float)0.0f, (int)112, (int)166, (int)512, (int)256);
        LocalPlayer player = this.mc.f_91074_;
        RenderUtil.drawCenteredFont(poseStack, this.mc.f_91062_, (Component)RenderUtil.ATTRIBUTES_TEXT.m_6879_().m_130940_(ChatFormatting.UNDERLINE), x + 56, y += 13, 0, false);
        int margin = 8;
        RenderSystem.m_157456_((int)0, (ResourceLocation)OverlayNF.TEXTURE);
        int iconYStart = y += 10;
        for (int i = 0; i < 12; ++i) {
            int iconY = y - 1 + i * 10;
            if (i > 5) {
                iconY += 11;
            }
            PlayerStatsComponent.m_93133_((PoseStack)poseStack, (int)(x + margin), (int)iconY, (float)(i * 9), (float)96.0f, (int)9, (int)9, (int)256, (int)256);
        }
        for (PlayerAttribute attribute : PlayerAttribute.values()) {
            this.mc.f_91062_.m_92889_(poseStack, (Component)RenderUtil.getAttributeText(attribute), (float)(x + margin + 10), (float)y, 0);
            if (attribute == PlayerAttribute.WILLPOWER) {
                RenderUtil.drawRightText(poseStack, this.mc.f_91062_, "?", x + 112 - margin, y, 0, false, 0xF000F0);
            } else {
                RenderUtil.drawRightText(poseStack, this.mc.f_91062_, "" + AttributesNF.getValue((Player)player, attribute), x + 112 - margin, y, 0, false, 0xF000F0);
            }
            y += 10;
        }
        RenderUtil.drawCenteredFont(poseStack, this.mc.f_91062_, (Component)RenderUtil.RESISTANCES_TEXT.m_6879_().m_130940_(ChatFormatting.UNDERLINE), x + 56, y, 0, false);
        ++y;
        EnumMap<DamageType, Double> armorDefenses = new EnumMap<DamageType, Double>(DamageType.class);
        EnumMap<DamageType, Double> baseDefenses = new EnumMap<DamageType, Double>(DamageType.class);
        for (DamageType type : DamageType.STANDARD_TYPES) {
            armorDefenses.put(type, 0.0);
            baseDefenses.put(type, player.m_21051_(AttributesNF.getDefense(type)).m_22135_() * 100.0);
        }
        for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35975_.get(i);
            Item type = stack.m_41720_();
            if (!(type instanceof TieredArmorItem)) continue;
            TieredArmorItem armor = (TieredArmorItem)type;
            float durabilityPenalty = CombatUtil.getArmorDefenseDurabilityPenalty(stack.m_41776_() - stack.m_41773_(), stack.m_41776_());
            for (DamageType type2 : DamageType.STANDARD_TYPES) {
                armorDefenses.put(type2, (Double)armorDefenses.get((Object)type2) + (double)(armor.material.getDefense(armor.slot, type2.asArray(), true) * 100.0f * durabilityPenalty));
            }
        }
        DecimalFormat format = new DecimalFormat("0.0");
        for (DamageType type : DamageType.STANDARD_TYPES) {
            this.mc.f_91062_.m_92883_(poseStack, RenderUtil.getDamageTypeText(type).getString(), (float)(x + 10 + margin), (float)(y += 10), 0);
            RenderUtil.drawRightText(poseStack, this.mc.f_91062_, format.format((Double)armorDefenses.get((Object)type) + (Double)baseDefenses.get((Object)type)) + "%", x + 112 - margin, y, 0, false, 0xF000F0);
        }
        if (mouseX >= x + margin && mouseX < x + 112 - margin) {
            for (int i = 0; i < 13; ++i) {
                int iconY = iconYStart - 1 + i * 10;
                if (i > 6) {
                    ++iconY;
                }
                if (mouseY < iconY - 1 || mouseY >= iconY + (i == 6 ? 10 : 9)) continue;
                ObjectArrayList components = new ObjectArrayList();
                if (i < 6) {
                    PlayerAttribute attribute = PlayerAttribute.values()[i];
                    int modifier = AttributesNF.getValue((Player)player, attribute) - 10;
                    String plus = modifier >= 0 ? "+" : "";
                    switch (attribute) {
                        case VITALITY: {
                            components.add(new TranslatableComponent("screen." + attribute + ".info", new Object[]{(int)player.m_21133_(Attributes.f_22276_)}));
                            break;
                        }
                        case ENDURANCE: {
                            components.add(new TranslatableComponent("screen." + attribute + ".info", new Object[]{(int)AttributesNF.getMaxStamina((Player)player), plus + 5 * modifier}));
                            break;
                        }
                        case WILLPOWER: {
                            components.add(new TranslatableComponent("screen." + attribute + ".info"));
                            break;
                        }
                        case STRENGTH: {
                            components.add(new TranslatableComponent("screen." + attribute + ".info", new Object[]{plus + 5 * modifier}));
                            break;
                        }
                        case AGILITY: {
                            components.add(new TranslatableComponent("screen." + attribute + ".info", new Object[]{plus + 3 * modifier}));
                            break;
                        }
                        case PERCEPTION: {
                            components.add(new TranslatableComponent("screen." + attribute + ".info"));
                        }
                    }
                } else if (i != 6) {
                    DamageType type;
                    type = DamageType.values()[i - 7];
                    components.add(RenderUtil.EFFECT_DEFENSE_TEXT.m_6879_().m_130946_(format.format(baseDefenses.get((Object)type)) + "%"));
                    components.add(RenderUtil.ARMOR_DEFENSE_TEXT.m_6879_().m_130946_(format.format(armorDefenses.get((Object)type)) + "%"));
                }
                this.screen.m_169388_(poseStack, (List)components, Optional.empty(), mouseX, mouseY);
                break;
            }
        }
    }
}

