/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.gui.screen.ScreenGuiComponent;
import frostnox.nightfall.client.gui.screen.inventory.PlayerInventoryScreen;
import frostnox.nightfall.client.gui.screen.inventory.RecipeViewerComponent;
import frostnox.nightfall.data.recipe.IEncyclopediaRecipe;
import frostnox.nightfall.item.item.FilledBucketItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericToServer;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.util.RenderUtil;
import frostnox.nightfall.world.inventory.PlayerInventoryContainer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class RecipeSearchComponent
extends ScreenGuiComponent {
    private static final int ROWS = 8;
    private static final int COLUMNS = 5;
    private static final int SIZE = 40;
    private final Minecraft mc;
    private final PlayerInventoryScreen screen;
    private EditBox searchBox;
    private int startIndex = 0;
    private float scrollOffs;
    private boolean grabbedScrollBar = false;
    private int selectedIndex = Integer.MIN_VALUE;
    private final List<Recipe<?>> searchableRecipes;
    private final List<Item> allItems;
    private final List<Item> searchedItems;
    private final List<Item> visibleItems = new ObjectArrayList(40);
    private boolean ignoreTextInput;
    private String lastSearch = "";
    private final RecipeViewerComponent recipeViewer;

    public RecipeSearchComponent(PlayerInventoryScreen screen) {
        this.mc = Minecraft.m_91087_();
        this.screen = screen;
        this.searchableRecipes = RenderUtil.getSearchableRecipes((Player)this.mc.f_91074_);
        this.allItems = new ObjectArrayList(this.searchableRecipes.size());
        this.searchedItems = new ObjectArrayList(this.searchableRecipes.size());
        this.recipeViewer = new RecipeViewerComponent(this.searchableRecipes);
    }

    public void updateItems() {
        ItemStack itemStack;
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
        this.allItems.clear();
        ItemStack searchItem = ((PlayerInventoryContainer)this.screen.m_6262_()).getSearchItem();
        Item item = searchItem.m_41720_();
        if (item instanceof FilledBucketItem) {
            FilledBucketItem bucket = (FilledBucketItem)item;
            itemStack = new ItemStack((ItemLike)FluidsNF.getAsItem(bucket.getFluid()));
        } else {
            itemStack = ItemStack.f_41583_;
        }
        ItemStack altSearchItem = itemStack;
        boolean checkIngredient = !searchItem.m_41619_();
        Iterator recipes = this.searchableRecipes.stream().iterator();
        while (recipes.hasNext()) {
            IEncyclopediaRecipe encyclopediaRecipe;
            Recipe recipe = (Recipe)recipes.next();
            if (this.allItems.contains(recipe.m_8043_().m_41720_())) continue;
            if (checkIngredient) {
                boolean skip = true;
                for (Ingredient ingredient : recipe.m_7527_()) {
                    if (!ingredient.test(searchItem) && (altSearchItem.m_41619_() || !ingredient.test(altSearchItem))) continue;
                    skip = false;
                    break;
                }
                if (skip) continue;
            }
            if (recipe instanceof IEncyclopediaRecipe && !(encyclopediaRecipe = (IEncyclopediaRecipe)recipe).isUnlocked((Player)this.mc.f_91074_)) continue;
            this.allItems.add(recipe.m_8043_().m_41720_());
        }
        this.updateVisibleItems();
        this.updateSearchedItems();
    }

    protected void updateVisibleItems() {
        this.visibleItems.clear();
        String search = this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        int i = 0;
        int scrollSkips = 0;
        for (int j = 0; j < this.allItems.size() && i < 40; ++j) {
            Item item = this.allItems.get(j);
            if (!search.isEmpty() && !item.m_41466_().getString().toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))) continue;
            if (scrollSkips < this.startIndex) {
                ++scrollSkips;
                continue;
            }
            this.visibleItems.add(item);
            ++i;
        }
    }

    protected void updateSearchedItems() {
        this.selectedIndex = Integer.MIN_VALUE;
        this.searchedItems.clear();
        String search = this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        for (Item item : this.allItems) {
            if (!search.isEmpty() && !item.m_41466_().getString().toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))) continue;
            this.searchedItems.add(item);
        }
    }

    @Override
    public void init() {
        int x = this.screen.getLeftPos() - 112 - 2;
        int y = this.screen.getTopPos();
        String s = this.searchBox != null ? this.searchBox.m_94155_() : "";
        this.searchBox = new EditBox(this.mc.f_91062_, x + 6, y + 5, 85, 9, (Component)new TranslatableComponent("itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(s);
        this.updateItems();
    }

    @Override
    public void containerTick() {
        this.searchBox.m_94120_();
    }

    @Override
    public void onClose() {
        this.searchBox.m_94194_(false);
        this.recipeViewer.setVisible(false);
        this.selectedIndex = Integer.MIN_VALUE;
        this.grabbedScrollBar = false;
        NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.CLOSE_RECIPE_SEARCH_SERVER));
    }

    @Override
    public void onOpen() {
        this.init();
    }

    public boolean isRecipeSelected() {
        return this.recipeViewer.isVisible();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        int y;
        int row;
        int x;
        int i;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PlayerInventoryScreen.TEXTURE);
        this.searchBox.f_93620_ = this.screen.getLeftPos() - 112 - 2 + 6;
        this.searchBox.f_93621_ = this.screen.getTopPos() + 5;
        RecipeSearchComponent.m_93133_((PoseStack)poseStack, (int)(this.screen.getLeftPos() - 112 - 1 + 8), (int)(this.screen.getTopPos() - 17), (float)288.0f, (float)220.0f, (int)18, (int)18, (int)512, (int)256);
        RecipeSearchComponent.m_93133_((PoseStack)poseStack, (int)(this.screen.getLeftPos() - 112 - 1), (int)this.screen.getTopPos(), (float)288.0f, (float)0.0f, (int)112, (int)166, (int)512, (int)256);
        if (!this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
            this.mc.f_91062_.m_92889_(poseStack, (Component)new TranslatableComponent("container.nightfall.search").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_GRAY), (float)(this.screen.getLeftPos() - 112 - 2 + 8), (float)(this.screen.getTopPos() + 5), -1);
        } else {
            this.searchBox.m_6305_(poseStack, mouseX, mouseY, partial);
        }
        RenderSystem.m_69482_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PlayerInventoryScreen.TEXTURE);
        if (this.canScroll()) {
            RecipeSearchComponent.m_93133_((PoseStack)poseStack, (int)(this.screen.getLeftPos() - 112 + 95), (int)(this.screen.getTopPos() + 16 + (int)(134.0f * this.scrollOffs)), (float)306.0f, (float)166.0f, (int)3, (int)5, (int)512, (int)256);
        }
        int listX = this.screen.getLeftPos() - 112 - 2 + 6;
        int listY = this.screen.getTopPos() + 16;
        for (i = 0; i < 40 && i < this.visibleItems.size(); ++i) {
            x = listX + i % 5 * 18;
            row = i / 5;
            y = listY + row * 18;
            int yOff = 166;
            if (mouseX >= x && mouseY >= y && mouseX < x + 18 && mouseY < y + 18) {
                yOff += 36;
            } else if (i == this.selectedIndex) {
                yOff += 18;
            }
            RecipeSearchComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)288.0f, (float)yOff, (int)18, (int)(row == 7 ? 17 : 18), (int)512, (int)256);
        }
        for (i = 0; i < 40 && i < this.visibleItems.size(); ++i) {
            x = listX + i % 5 * 18 + 1;
            row = i / 5;
            y = listY + row * 18 + 1;
            this.mc.m_91291_().m_115203_(new ItemStack((ItemLike)((Item)this.visibleItems.toArray()[i])), x, y);
        }
        for (i = 0; i < 40 && i < this.visibleItems.size(); ++i) {
            x = listX + i % 5 * 18;
            int y2 = listY + i / 5 * 18;
            if (mouseX < x || mouseX >= x + 18 || mouseY < y2 || mouseY >= y2 + 18) continue;
            this.screen.m_6057_(poseStack, new ItemStack((ItemLike)((Item)this.visibleItems.toArray()[i])), mouseX, mouseY);
        }
        if (this.recipeViewer.isVisible()) {
            this.recipeViewer.setOffset(this.screen.getLeftPos() + 176 + 2, this.screen.getTopPos());
            this.recipeViewer.m_6305_(poseStack, mouseX, mouseY, partial);
        }
    }

    private boolean updateScroll(double mouseX, double mouseY) {
        if (!this.canScroll()) {
            return false;
        }
        int barX = this.screen.getLeftPos() - 112 + 95;
        int barYMin = this.screen.getTopPos() + 16;
        int barYMax = barYMin + 134 + 5;
        if (this.grabbedScrollBar || mouseX >= (double)(barX - 1) && mouseX <= (double)(barX + 3) && mouseY >= (double)barYMin && mouseY <= (double)barYMax) {
            this.scrollOffs = (float)((mouseY - (double)barYMin - 2.0) / 134.0);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffScreenRows()) + 0.5) * 5;
            this.updateVisibleItems();
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.searchBox.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.recipeViewer.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.updateScroll(mouseX, mouseY)) {
            this.grabbedScrollBar = true;
            return true;
        }
        int listX = this.screen.getLeftPos() - 112 - 2 + 6;
        int listY = this.screen.getTopPos() + 17;
        for (int i = 0; i < 40 && i < this.visibleItems.size(); ++i) {
            int x = listX + i % 5 * 18;
            int y = listY + i / 5 * 18;
            if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 18)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 18))) continue;
            this.selectedIndex = i;
            this.recipeViewer.setVisible(true);
            this.recipeViewer.setRecipeItem((Item)this.visibleItems.toArray()[i]);
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        boolean ret = this.grabbedScrollBar;
        this.grabbedScrollBar = false;
        return ret;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            return this.updateScroll(mouseX, mouseY);
        }
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        if (!this.mc.f_91074_.m_5833_()) {
            if (this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
                this.checkSearchStringUpdate();
                return true;
            }
            if (this.searchBox.m_93696_() && this.searchBox.m_94213_() && pKeyCode != 256) {
                return true;
            }
            if (this.mc.f_91066_.f_92098_.m_90832_(pKeyCode, pScanCode) && !this.searchBox.m_93696_()) {
                this.ignoreTextInput = true;
                this.searchBox.m_94178_(true);
                return true;
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (!this.mc.f_91074_.m_5833_() && this.searchBox.m_5534_(pCodePoint, pModifiers)) {
            this.checkSearchStringUpdate();
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public boolean m_6050_(double x, double y, double scrollAmount) {
        if (scrollAmount < 0.0 ? this.canScrollDown() : this.canScrollUp()) {
            int offScreenRows = this.getOffScreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - scrollAmount / (double)offScreenRows);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)offScreenRows) + 0.5) * 5;
            if (this.selectedIndex != Integer.MIN_VALUE) {
                this.selectedIndex = (int)((double)this.selectedIndex + scrollAmount * 5.0);
            }
            this.updateVisibleItems();
        }
        return true;
    }

    private int getOffScreenRows() {
        return (Math.max(0, this.searchedItems.size() - 40) + 5 - 1) / 5;
    }

    private boolean canScrollUp() {
        return this.startIndex != 0;
    }

    private boolean canScrollDown() {
        return this.searchedItems.size() - this.startIndex > 40;
    }

    private boolean canScroll() {
        return this.searchedItems.size() > 40;
    }

    private void checkSearchStringUpdate() {
        String search = this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        if (!search.equals(this.lastSearch)) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
            this.updateVisibleItems();
            this.updateSearchedItems();
            this.lastSearch = search;
        }
    }

    public void removed() {
        this.mc.f_91068_.m_90926_(false);
    }
}

