/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.gui.screen.ScreenGuiComponent;
import frostnox.nightfall.data.recipe.IRenderableRecipe;
import frostnox.nightfall.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.commons.compress.utils.Lists;

public class RecipeViewerComponent
extends ScreenGuiComponent {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"textures/gui/screen/recipe_viewer.png");
    public static final int WIDTH = 122;
    public static final int HEIGHT = 81;
    public static final int ARROW_WIDTH = 16;
    public static final int ARROW_HEIGHT = 11;
    private final Minecraft mc;
    private final List<Recipe<?>> allRecipes;
    private List<Recipe<?>> recipes = Lists.newArrayList();
    private Item item;
    private int pages;
    private int page;
    private boolean visible;
    private int xOffset;
    private int yOffset;

    public RecipeViewerComponent() {
        this.mc = Minecraft.m_91087_();
        this.allRecipes = RenderUtil.getUnlockedRecipes((Player)this.mc.f_91074_);
    }

    public RecipeViewerComponent(List<Recipe<?>> allRecipes) {
        this.mc = Minecraft.m_91087_();
        this.allRecipes = allRecipes;
    }

    public boolean setRecipeItem(Item item) {
        if (item == this.item) {
            return false;
        }
        ArrayList recipes = Lists.newArrayList();
        recipes.clear();
        this.allRecipes.forEach(recipe -> {
            if (recipe.m_8043_().m_41720_().equals(item)) {
                recipes.add(recipe);
            }
        });
        if (recipes.isEmpty()) {
            return false;
        }
        this.recipes = recipes;
        this.item = item;
        this.pages = recipes.size();
        this.page = 0;
        return true;
    }

    public void setOffset(int x, int y) {
        this.xOffset = x;
        this.yOffset = y;
    }

    public Item getItem() {
        return this.item;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        Recipe<?> recipe;
        int uOff;
        poseStack.m_85837_((double)this.xOffset, (double)this.yOffset, 0.0);
        mouseX -= this.xOffset;
        mouseY -= this.yOffset;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.m_69465_();
        RecipeViewerComponent.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)122, (int)81, (int)128, (int)128);
        if (this.page != 0) {
            uOff = this.onLeftArrow(mouseX, mouseY) ? 16 : 0;
            RecipeViewerComponent.m_93133_((PoseStack)poseStack, (int)83, (int)67, (float)uOff, (float)92.0f, (int)16, (int)11, (int)128, (int)128);
        }
        if (this.page < this.pages - 1) {
            uOff = this.onRightArrow(mouseX, mouseY) ? 16 : 0;
            RecipeViewerComponent.m_93133_((PoseStack)poseStack, (int)103, (int)67, (float)uOff, (float)81.0f, (int)16, (int)11, (int)128, (int)128);
        }
        if ((recipe = this.recipes.get(this.page)) instanceof IRenderableRecipe) {
            IRenderableRecipe renderableRecipe = (IRenderableRecipe)recipe;
            poseStack.m_85836_();
            renderableRecipe.render(poseStack, this.mc.f_91080_, mouseX + this.xOffset, mouseY + this.yOffset, partial, this.xOffset, this.yOffset);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 200.0);
            RenderUtil.drawCenteredFont(poseStack, this.mc.f_91062_, (Component)renderableRecipe.getTitle(), 61, 3, 3420462, false);
            poseStack.m_85849_();
        }
        poseStack.m_85837_((double)(-this.xOffset), (double)(-this.yOffset), 0.0);
    }

    private boolean onLeftArrow(double x, double y) {
        int arrowX = 83;
        int arrowY = 67;
        return x >= (double)(arrowX - 2) && x < (double)(arrowX + 2 + 16) && y >= (double)(arrowY - 2) && y < (double)(arrowY + 2 + 11);
    }

    private boolean onRightArrow(double x, double y) {
        int arrowX = 103;
        int arrowY = 67;
        return x >= (double)(arrowX - 2) && x < (double)(arrowX + 2 + 16) && y >= (double)(arrowY - 2) && y < (double)(arrowY + 2 + 11);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean m_6375_(double x, double y, int button) {
        IRenderableRecipe renderableRecipe;
        ItemStack item;
        Recipe<?> recipe;
        if (!this.recipes.isEmpty() && (recipe = this.recipes.get(this.page)) instanceof IRenderableRecipe && !(item = (renderableRecipe = (IRenderableRecipe)recipe).clickItem(this.mc.f_91080_, (int)x - this.xOffset, (int)y - this.yOffset)).m_41619_() && !item.m_41720_().equals(this.item)) {
            if (this.setRecipeItem(item.m_41720_())) {
                this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            }
            return true;
        }
        if (this.onRightArrow(x -= (double)this.xOffset, y -= (double)this.yOffset) && this.page < this.pages - 1) {
            ++this.page;
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        } else if (this.onLeftArrow(x, y) && this.page != 0) {
            --this.page;
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        }
        return false;
    }
}

