/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.gui.screen.item;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.gui.OverlayNF;
import frostnox.nightfall.item.client.IModifiable;
import frostnox.nightfall.item.client.IScreenCache;
import frostnox.nightfall.util.MathUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import oshi.util.tuples.Pair;

public class ModifiableItemScreen
extends Screen {
    public static final int DEFAULT_BACKGROUND = 0;
    public static final int BUILDING_BACKGROUND = 22;
    protected static final float[] ANIMATION = new float[]{1.0f, 1.2f, 1.45f, 1.4f, 1.25f, 1.1f, 1.0f};
    public final int radius;
    public final int diameter;
    public final boolean mainHand;
    protected int slices;
    protected float sliceSize;
    protected final Minecraft mc;
    protected static int activeIndex = -1;
    protected static int page = 1;
    protected static int pageCount = 1;
    protected final IModifiable modifiableItem;
    protected List<ItemStack> items;
    protected int[] itemAnimateTimes = new int[0];
    protected boolean shouldAnimateSameItem = false;

    public ModifiableItemScreen(int radius, int slices, boolean mainHand, IModifiable modifiableItem, List<ItemStack> items) {
        super(NarratorChatListener.f_93310_);
        this.radius = radius;
        this.diameter = radius * 2;
        this.setSlices(slices);
        this.mainHand = mainHand;
        this.mc = Minecraft.m_91087_();
        this.f_96546_ = true;
        this.modifiableItem = modifiableItem;
        this.setItems(items);
        this.updatePages(modifiableItem, items.size());
    }

    public void setItems(List<ItemStack> items) {
        this.items = items;
        if (this.itemAnimateTimes.length != items.size()) {
            this.itemAnimateTimes = new int[items.size()];
            Arrays.fill(this.itemAnimateTimes, -1);
        }
    }

    public boolean allowMovementInputs() {
        return true;
    }

    public void setSlices(int slices) {
        this.slices = Math.max(1, slices);
        this.sliceSize = MathUtil.toRadians(360.0f / (float)this.slices);
    }

    protected Pair<Integer, Integer> getItemPosition(int index) {
        float angle = (float)index * this.sliceSize;
        return new Pair((Object)Math.round((float)(-this.radius) * Mth.m_14031_((float)angle)), (Object)Math.round((float)this.radius * Mth.m_14089_((float)angle)));
    }

    protected void drawHoverTooltip(PoseStack stack, ItemStack item, int mouseX, int mouseY, int x, int y) {
        if (!item.m_41619_() && mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16) {
            this.m_6057_(stack, item, mouseX, mouseY);
        }
    }

    public static void initSelection(Minecraft mc, List<ItemStack> items, IModifiable modifiableItem, boolean mainHand) {
        Screen screen = mc.f_91080_;
        if (screen instanceof ModifiableItemScreen) {
            ModifiableItemScreen screen2 = (ModifiableItemScreen)screen;
            screen2.setItems(items);
        }
        activeIndex = ModifiableItemScreen.updateSelection(modifiableItem, items, mainHand);
        page = modifiableItem.getLastUsedPage();
    }

    public static int updateSelection(IScreenCache modifiableItem, List<ItemStack> items, boolean mainHand) {
        if (items.isEmpty()) {
            ClientEngine.get().setModifiableIndex(mainHand, ItemStack.f_41583_, 0);
            return -1;
        }
        int index = 0;
        Item lastItem = modifiableItem.getLastUsedItem();
        if (lastItem != null) {
            for (int i = 0; i < items.size(); ++i) {
                if (items.get(i).m_41720_() != lastItem) continue;
                index = i;
                break;
            }
        }
        ItemStack item = items.get(index);
        ClientEngine.get().setModifiableIndex(mainHand, item, index);
        return index;
    }

    protected static void movePage(IScreenCache modifiableItem, int pages) {
        page = Mth.m_14045_((int)(page + pages), (int)1, (int)pageCount);
        modifiableItem.setLastUsedPage(page);
    }

    protected void updatePages(IScreenCache modifiableItem, int itemsSize) {
        pageCount = 1 + (itemsSize - 1) / this.slices;
        if (page > pageCount) {
            page = 1;
            modifiableItem.setLastUsedPage(page);
        }
    }

    protected void updateSlice(double mouseX, double mouseY) {
        double centeredX = mouseX - (double)this.f_96543_ / 2.0;
        double centeredY = mouseY - (double)this.f_96544_ / 2.0;
        int minRadius = this.radius - 16;
        int maxRadius = this.radius + 16;
        double distSqr = centeredX * centeredX + centeredY * centeredY;
        if (distSqr > (double)(minRadius * minRadius) && distSqr < (double)(maxRadius * maxRadius)) {
            double angle = (Math.atan2(-centeredX, centeredY) + (double)(this.sliceSize / 2.0f) + Math.PI + Math.PI * 2) % (Math.PI * 2);
            boolean noSlices = true;
            for (int i = (page - 1) * this.slices; i < this.items.size(); ++i) {
                if (!(angle < (double)(this.sliceSize * (float)(i % this.slices + 1)))) continue;
                this.modifiableItem.setLastUsedItem(this.items.get(i).m_41720_());
                int lastIndex = activeIndex;
                activeIndex = ModifiableItemScreen.updateSelection(this.modifiableItem, this.items, this.mainHand);
                if (this.itemAnimateTimes[i] == -1 && (this.shouldAnimateSameItem || activeIndex != lastIndex)) {
                    this.itemAnimateTimes[i] = 0;
                    this.shouldAnimateSameItem = false;
                }
                noSlices = false;
                break;
            }
            if (noSlices) {
                this.shouldAnimateSameItem = true;
            }
        } else {
            this.shouldAnimateSameItem = true;
        }
    }

    public void m_96624_() {
        for (int i = 0; i < this.itemAnimateTimes.length; ++i) {
            if (this.itemAnimateTimes[i] >= 0) {
                int n = i;
                this.itemAnimateTimes[n] = this.itemAnimateTimes[n] + 1;
            }
            if (this.itemAnimateTimes[i] < 7) continue;
            this.itemAnimateTimes[i] = -1;
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        int yPos;
        int xPos;
        Pair<Integer, Integer> pos;
        ItemStack item;
        int startIndex;
        int i;
        if (this.mc.f_91074_.m_21120_(this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND).m_41720_() != this.modifiableItem) {
            this.m_7379_();
            return;
        }
        super.m_6305_(poseStack, mouseX, mouseY, partial);
        int widthHalf = this.f_96543_ / 2;
        int heightHalf = this.f_96544_ / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = startIndex = (page - 1) * this.slices; i < this.items.size() && (i == startIndex || i % this.slices != 0); ++i) {
            item = this.items.get(i);
            pos = this.getItemPosition(i);
            xPos = widthHalf - (Integer)pos.getA() - 8;
            yPos = heightHalf - (Integer)pos.getB() - 8;
            RenderSystem.m_157456_((int)0, (ResourceLocation)OverlayNF.TEXTURE);
            ModifiableItemScreen.m_93133_((PoseStack)poseStack, (int)(xPos - 3), (int)(yPos - 3), (float)this.modifiableItem.getBackgroundUOffset(), (float)54.0f, (int)22, (int)22, (int)256, (int)256);
            if (this.itemAnimateTimes[i] > 0) {
                PoseStack modelStack = RenderSystem.m_157191_();
                modelStack.m_85836_();
                int animationTime = this.itemAnimateTimes[i];
                float scale = Mth.m_14179_((float)ClientEngine.get().getPartialTick(), (float)ANIMATION[animationTime - 1], (float)ANIMATION[animationTime]);
                int itemX = xPos + 8;
                int itemY = yPos + 8;
                modelStack.m_85837_((double)itemX, (double)itemY, 0.0);
                modelStack.m_85841_(scale, scale, 1.0f);
                modelStack.m_85837_((double)(-itemX), (double)(-itemY), 0.0);
                RenderSystem.m_157182_();
                this.mc.m_91291_().m_115203_(item, xPos, yPos);
                this.mc.m_91291_().m_115169_(this.mc.f_91062_, item, xPos, yPos);
                modelStack.m_85849_();
                RenderSystem.m_157182_();
                continue;
            }
            this.mc.m_91291_().m_115203_(item, xPos, yPos);
            this.mc.m_91291_().m_115169_(this.mc.f_91062_, item, xPos, yPos);
        }
        for (i = startIndex; i < this.items.size() && (i == startIndex || i % this.slices != 0); ++i) {
            item = this.items.get(i);
            pos = this.getItemPosition(i);
            xPos = widthHalf - (Integer)pos.getA() - 8;
            yPos = heightHalf - (Integer)pos.getB() - 8;
            if (mouseX < xPos - 3 || mouseX >= xPos + 16 + 3 || mouseY < yPos - 3 || mouseY >= yPos + 16 + 3) continue;
            this.m_6057_(poseStack, item, mouseX, mouseY);
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.updateSlice(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        ModifiableItemScreen.movePage(this.modifiableItem, (int)scrollAmount);
        this.updateSlice(mouseX, mouseY);
        return super.m_6050_(mouseX, mouseY, scrollAmount);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean result = super.m_7933_(keyCode, scanCode, modifiers);
        if (!result) {
            for (KeyMapping key : this.mc.f_91066_.f_92059_) {
                if (key.getKey().m_84873_() != keyCode) continue;
                if (key.getKeyConflictContext() == ClientEngine.get().movementKeyConflict) break;
                return true;
            }
        }
        return result;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        if (this.allowMovementInputs()) {
            for (KeyMapping mapping : ClientEngine.get().movementConflictKeys) {
                InputConstants.Key key = mapping.getKey();
                if (key.m_84868_() != InputConstants.Type.KEYSYM || key.m_84873_() == InputConstants.f_84822_.m_84873_()) continue;
                mapping.m_7249_(InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.m_84873_()));
            }
        }
    }
}

