/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.player.IClientAction;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.item.IActionableItem;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimatedItemModel
implements IModelGeometry<AnimatedItemModel> {
    private final BlockModel baseModel;
    private final BlockModel inventoryModel;
    private final double swapSpeed;
    private final double swapYOffset;

    public AnimatedItemModel(BlockModel baseModel, BlockModel inventoryModel, double swapSpeed, double swapYOffset) {
        this.baseModel = baseModel;
        this.inventoryModel = inventoryModel;
        this.swapSpeed = swapSpeed;
        this.swapYOffset = swapYOffset;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new UnfinishedModel(owner.useSmoothLighting(), owner.isShadedInGui(), owner.isSideLit(), this.swapSpeed, this.swapYOffset, spriteGetter.apply(owner.resolveTexture("particle")), this.baseModel.m_111449_(bakery, this.baseModel, spriteGetter, modelTransform, modelLocation, owner.isSideLit()), this.inventoryModel.m_111449_(bakery, this.inventoryModel, spriteGetter, modelTransform, modelLocation, owner.isSideLit()));
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        textures.addAll(this.baseModel.m_5500_(modelGetter, missingTextureErrors));
        textures.addAll(this.inventoryModel.m_5500_(modelGetter, missingTextureErrors));
        return textures;
    }

    private static class UnfinishedModel
    implements BakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final double swapSpeed;
        private final double swapYOffset;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final BakedModel baseModel;
        private final BakedModel inventoryModel;

        private UnfinishedModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, double swapSpeed, double swapYOffset, TextureAtlasSprite particle, BakedModel baseModel, BakedModel inventoryModel) {
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.swapSpeed = swapSpeed;
            this.swapYOffset = swapYOffset;
            this.particle = particle;
            this.baseModel = baseModel;
            this.inventoryModel = inventoryModel;
            this.overrides = new AnimatedOverrideList(this);
        }

        public List<BakedQuad> m_6840_(@javax.annotation.Nullable BlockState state, @javax.annotation.Nullable Direction side, Random rand) {
            return Collections.emptyList();
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public ItemTransforms m_7442_() {
            return ItemTransforms.f_111786_;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType type, PoseStack poseStack) {
            if (type == ItemTransforms.TransformType.FIXED || type == ItemTransforms.TransformType.GROUND || type == ItemTransforms.TransformType.GUI) {
                return this.inventoryModel.handlePerspective(type, poseStack);
            }
            return this.baseModel.handlePerspective(type, poseStack);
        }
    }

    public static class Loader
    implements IModelLoader<AnimatedItemModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void m_6213_(ResourceManager pResourceManager) {
        }

        public AnimatedItemModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"base"), BlockModel.class);
            BlockModel inventoryModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"inventory"), BlockModel.class);
            double swapSpeed = 1.0;
            if (modelContents.has("swapSpeed")) {
                swapSpeed = modelContents.get("swapSpeed").getAsDouble();
            }
            double swapYOffset = 0.0;
            if (modelContents.has("swapYOffset")) {
                swapYOffset = modelContents.get("swapYOffset").getAsDouble();
            }
            return new AnimatedItemModel(baseModel, inventoryModel, swapSpeed, swapYOffset);
        }
    }

    public static class ActionableModel
    implements IDynamicBakedModel {
        protected BakedModel baseModel;
        protected LivingEntity user;
        private final ItemTransforms defaultTransforms;
        private final AnimationData animData;

        private ActionableModel(BakedModel model, @javax.annotation.Nullable LivingEntity user) {
            this.baseModel = model;
            this.user = user;
            ItemTransforms t = model.m_7442_();
            this.defaultTransforms = new ItemTransforms(t.f_111788_, t.f_111788_, t.f_111790_, t.f_111790_, t.f_111791_, t.f_111792_, t.f_111793_, t.f_111794_, t.moddedTransforms);
            this.animData = new AnimationData();
        }

        public LivingEntity getUser() {
            return this.user;
        }

        public void animateFirstPersonStun(int frame, int duration) {
            int offset = duration / 2;
            this.animData.tCalc.add(0.0f, 0.0f, 0.0f);
            this.animData.tCalc.setEasing(Easing.outQuart);
            this.animData.tCalc.length = offset;
            if (frame > offset) {
                this.animData.resetLengths(duration, Easing.inOutSine);
                this.animData.toDefault();
            }
        }

        public void animateThirdPersonStun(int frame, int duration) {
            this.animData.resetLengths(duration / 2, Easing.outQuart);
            this.animData.toDefault();
        }

        public ItemTransforms getDefaultTransforms() {
            return new ItemTransforms(this.defaultTransforms);
        }

        public void updateAnimation(IActionTracker capA, HumanoidArm side, float partialTick, boolean firstPerson) {
            InteractionHand hand;
            if (firstPerson) {
                this.animData.setDefaults(this.defaultTransforms.f_111790_.f_111756_, this.defaultTransforms.f_111790_.f_111755_, this.defaultTransforms.f_111790_.f_111757_);
            } else {
                this.animData.setDefaults(this.defaultTransforms.f_111788_.f_111756_, this.defaultTransforms.f_111788_.f_111755_, this.defaultTransforms.f_111788_.f_111757_);
            }
            this.animData.reset();
            int state = capA.getState();
            Action action = capA.getAction();
            int frame = capA.getFrame();
            int duration = capA.getDuration();
            LivingEntity livingEntity = this.user;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                v0 = PlayerData.get(player).getActiveHand();
            } else {
                v0 = hand = InteractionHand.MAIN_HAND;
            }
            if (AnimationUtil.getSideFromHand(hand) == side) {
                if (firstPerson && action instanceof IClientAction) {
                    IClientAction clientAction = (IClientAction)((Object)action);
                    this.animData.update(frame, duration, capA.modifyPartialTick(partialTick), Easing.inOutSine);
                    clientAction.transformModelFP(state, capA.getFrame(), capA.getDuration(), action.getChargeProgress(capA.getCharge(), capA.getChargePartial()), this.user, this.animData);
                } else if (!firstPerson) {
                    this.animData.update(frame, duration, capA.modifyPartialTick(partialTick), Easing.inOutSine);
                    action.transformLayer(state, capA.getFrame(), capA.getDuration(), action.getChargeProgress(capA.getCharge(), capA.getChargePartial()), this.user, this.animData);
                }
            } else if (action instanceof IClientAction) {
                IClientAction clientAction = (IClientAction)((Object)action);
                if (firstPerson) {
                    this.animData.update(frame, duration, capA.modifyPartialTick(partialTick), Easing.inOutSine);
                    clientAction.transformOppositeModelFP(state, capA.getFrame(), capA.getDuration(), action.getChargeProgress(capA.getCharge(), capA.getChargePartial()), this.user, this.animData);
                } else {
                    this.animData.update(frame, duration, capA.modifyPartialTick(partialTick), Easing.inOutSine);
                    clientAction.transformOppositeLayer(state, capA.getFrame(), capA.getDuration(), action.getChargeProgress(capA.getCharge(), capA.getChargePartial()), this.user, this.animData);
                }
            }
            if (capA.isStunned()) {
                this.animData.update(capA.getStunFrame(), capA.getStunDuration(), partialTick, Easing.inOutSine);
                this.animData.tCalc.setStaticVector(this.animData.tCalc.getTransformations());
                this.animData.rCalc.setStaticVector(this.animData.rCalc.getTransformations());
                this.animData.sCalc.setStaticVector(this.animData.sCalc.getTransformations());
                if (firstPerson) {
                    this.animateFirstPersonStun(capA.getStunFrame(), capA.getStunDuration());
                } else {
                    this.animateThirdPersonStun(capA.getStunFrame(), capA.getStunDuration());
                }
            }
        }

        public List<BakedQuad> m_6840_(@javax.annotation.Nullable BlockState state, @javax.annotation.Nullable Direction side, Random rand) {
            return this.baseModel.m_6840_(state, side, rand);
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
            return this.baseModel.getQuads(state, side, rand, extraData);
        }

        public ItemOverrides m_7343_() {
            return this.baseModel.m_7343_();
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return this.baseModel.m_7539_();
        }

        public boolean m_7547_() {
            return this.baseModel.m_7547_();
        }

        public boolean m_7521_() {
            return this.baseModel.m_7521_();
        }

        public TextureAtlasSprite m_6160_() {
            return this.baseModel.m_6160_();
        }

        public ItemTransforms m_7442_() {
            ItemTransforms transforms = new ItemTransforms(this.getDefaultTransforms());
            ItemTransform rfp = transforms.f_111790_;
            ItemTransform lfp = transforms.f_111789_;
            ItemTransform rtp = transforms.f_111788_;
            ItemTransform ltp = transforms.f_111787_;
            ItemTransform rightFP = new ItemTransform(rfp.f_111755_.m_122281_(), rfp.f_111756_.m_122281_(), rfp.f_111757_.m_122281_());
            ItemTransform leftFP = new ItemTransform(lfp.f_111755_.m_122281_(), lfp.f_111756_.m_122281_(), lfp.f_111757_.m_122281_());
            ItemTransform rightTP = new ItemTransform(rtp.f_111755_.m_122281_(), rtp.f_111756_.m_122281_(), rtp.f_111757_.m_122281_());
            ItemTransform leftTP = new ItemTransform(ltp.f_111755_.m_122281_(), ltp.f_111756_.m_122281_(), ltp.f_111757_.m_122281_());
            if (this.user != null && this.user.m_6084_() && (this.user instanceof Player || this.user instanceof ActionableEntity)) {
                HumanoidArm side;
                IActionTracker capA = ActionTracker.get((Entity)this.user);
                ItemStack stackMain = ItemStack.f_41583_;
                ItemStack stackOff = ItemStack.f_41583_;
                if (this.user.m_21205_().m_41720_() instanceof IActionableItem) {
                    stackMain = this.user.m_21205_();
                }
                if (this.user.m_21206_().m_41720_() instanceof IActionableItem) {
                    stackOff = this.user.m_21206_();
                }
                float partialTick = ClientEngine.get().getPartialTick();
                if (!stackMain.m_41619_()) {
                    side = AnimationUtil.getSideFromHand(InteractionHand.MAIN_HAND);
                    this.updateAnimation(capA, side, partialTick, true);
                    if (side == HumanoidArm.RIGHT) {
                        rightFP = new ItemTransform(this.animData.rCalc.getTransformations(), this.animData.tCalc.getTransformations(), this.animData.sCalc.getTransformations());
                    } else {
                        leftFP = new ItemTransform(this.animData.rCalc.getTransformations(), this.animData.tCalc.getTransformations(), this.animData.sCalc.getTransformations());
                    }
                    this.updateAnimation(capA, side, partialTick, false);
                    if (side == HumanoidArm.RIGHT) {
                        rightTP = new ItemTransform(this.animData.rCalc.getTransformations(), this.animData.tCalc.getTransformations(), this.animData.sCalc.getTransformations());
                    } else {
                        leftTP = new ItemTransform(this.animData.rCalc.getTransformations(), this.animData.tCalc.getTransformations(), this.animData.sCalc.getTransformations());
                    }
                }
                if (!stackOff.m_41619_()) {
                    side = AnimationUtil.getSideFromHand(InteractionHand.OFF_HAND);
                    this.updateAnimation(capA, side, partialTick, true);
                    if (side == HumanoidArm.RIGHT) {
                        rightFP = new ItemTransform(this.animData.rCalc.getTransformations(), this.animData.tCalc.getTransformations(), this.animData.sCalc.getTransformations());
                    } else {
                        leftFP = new ItemTransform(this.animData.rCalc.getTransformations(), this.animData.tCalc.getTransformations(), this.animData.sCalc.getTransformations());
                    }
                    this.updateAnimation(capA, side, partialTick, false);
                    if (side == HumanoidArm.RIGHT) {
                        rightTP = new ItemTransform(this.animData.rCalc.getTransformations(), this.animData.tCalc.getTransformations(), this.animData.sCalc.getTransformations());
                    } else {
                        leftTP = new ItemTransform(this.animData.rCalc.getTransformations(), this.animData.tCalc.getTransformations(), this.animData.sCalc.getTransformations());
                    }
                }
            }
            leftFP.f_111755_.setY(leftFP.f_111755_.m_122260_() - 180.0f);
            leftFP.f_111755_.setZ(-leftFP.f_111755_.m_122269_());
            leftTP.f_111755_.setY(leftTP.f_111755_.m_122260_() - 180.0f);
            leftTP.f_111755_.setZ(-leftTP.f_111755_.m_122269_());
            return new ItemTransforms(leftTP, rightTP, leftFP, rightFP, transforms.f_111791_, transforms.f_111792_, transforms.f_111793_, transforms.f_111794_, transforms.moddedTransforms);
        }
    }

    public static class Model
    implements BakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final ItemOverrides overrides;
        public final double swapSpeed;
        public final double swapYOffset;
        private final TextureAtlasSprite particle;
        public final BakedModel baseModel;
        public final BakedModel inventoryModel;

        private Model(UnfinishedModel model, BakedModel baseModel, BakedModel inventoryModel, LivingEntity user) {
            this.isAmbientOcclusion = model.isAmbientOcclusion;
            this.isGui3d = model.isGui3d;
            this.isSideLit = model.isSideLit;
            this.overrides = model.overrides;
            this.swapSpeed = model.swapSpeed;
            this.swapYOffset = model.swapYOffset;
            this.particle = model.particle;
            this.baseModel = new ActionableModel(baseModel, user);
            this.inventoryModel = inventoryModel;
        }

        public List<BakedQuad> m_6840_(@javax.annotation.Nullable BlockState state, @javax.annotation.Nullable Direction side, Random rand) {
            return Collections.emptyList();
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.baseModel.m_6160_();
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public ItemTransforms m_7442_() {
            return this.baseModel.m_7442_();
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType type, PoseStack poseStack) {
            if (type == ItemTransforms.TransformType.FIXED || type == ItemTransforms.TransformType.GROUND || type == ItemTransforms.TransformType.GUI) {
                return this.inventoryModel.handlePerspective(type, poseStack);
            }
            return this.baseModel.handlePerspective(type, poseStack);
        }
    }

    public static class AnimatedOverrideList
    extends ItemOverrides {
        private final UnfinishedModel model;

        public AnimatedOverrideList(UnfinishedModel model) {
            this.model = model;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @javax.annotation.Nullable ClientLevel world, @javax.annotation.Nullable LivingEntity entity, int seed) {
            return new Model(this.model, this.model.baseModel.m_7343_().m_173464_(this.model.baseModel, stack, world, entity, seed), this.model.inventoryModel.m_7343_().m_173464_(this.model.inventoryModel, stack, world, entity, seed), entity);
        }
    }
}

