/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class AnimatedItemModelBuilder
extends ModelBuilder<AnimatedItemModelBuilder> {
    protected final ItemModelBuilder itemModelBuilder;
    protected JsonObject base = null;
    protected JsonObject inventory = null;
    protected float swapSpeed = 1.0f;
    protected float swapYOffset = 0.0f;

    public AnimatedItemModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation, existingFileHelper);
        this.itemModelBuilder = new ItemModelBuilder(this.location, existingFileHelper);
    }

    public AnimatedItemModelBuilder base(JsonObject json) {
        this.base = json;
        return this;
    }

    public AnimatedItemModelBuilder inventory(JsonObject json) {
        this.inventory = json;
        return this;
    }

    public AnimatedItemModelBuilder swapSpeed(float swapSpeed) {
        this.swapSpeed = swapSpeed;
        return this;
    }

    public AnimatedItemModelBuilder swapYOffset(float swapYOffset) {
        this.swapYOffset = swapYOffset;
        return this;
    }

    public AnimatedItemModelBuilder animatedLoader() {
        return (AnimatedItemModelBuilder)(this.customLoader((itemModelBuilder, existingFileHelper1) -> new CustomLoaderBuilder<AnimatedItemModelBuilder>(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"animated-item"), itemModelBuilder, existingFileHelper1){})).end();
    }

    public ItemModelBuilder itemModelBuilder() {
        return this.itemModelBuilder;
    }

    public JsonObject toJson() {
        JsonObject proxyJson;
        JsonObject root = super.toJson();
        if (this.swapSpeed != 1.0f) {
            root.addProperty("swapSpeed", (Number)Float.valueOf(this.swapSpeed));
        }
        if (this.swapYOffset != 0.0f) {
            root.addProperty("swapYOffset", (Number)Float.valueOf(this.swapYOffset));
        }
        if (this.base != null) {
            root.add("base", (JsonElement)this.base);
        }
        if (this.inventory != null) {
            root.add("inventory", (JsonElement)this.inventory);
        }
        if ((proxyJson = this.itemModelBuilder.toJson()).has("overrides")) {
            root.add("overrides", (JsonElement)proxyJson.getAsJsonArray("overrides"));
        }
        return root;
    }
}

