/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class AnimatedModel<T extends Entity>
extends EntityModel<T> {
    public final ImmutableList<AnimatedModelPart> parts;

    public AnimatedModel(ModelPart model) {
        this(model, RenderType::m_110458_);
    }

    public AnimatedModel(ModelPart root, Function<ResourceLocation, RenderType> renderFunc) {
        super(renderFunc);
        AnimatedModel.convertChildren(root);
        List originalParts = root.m_171331_().collect(Collectors.toList());
        originalParts.remove(0);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModelPart part : originalParts) {
            builder.add((Object)((AnimatedModelPart)part));
        }
        this.parts = builder.build();
        this.setDefaultPose();
    }

    private static void convertChildren(ModelPart part) {
        for (Map.Entry entry : part.f_104213_.entrySet()) {
            AnimatedModel.convertChildren((ModelPart)entry.getValue());
            part.f_104213_.put((String)entry.getKey(), new AnimatedModelPart((ModelPart)entry.getValue()));
        }
    }

    public void setDefaultPose() {
        for (AnimatedModelPart part : this.parts) {
            part.setDefaultPose();
        }
    }

    public void resetPose() {
        for (AnimatedModelPart part : this.parts) {
            part.resetPose();
        }
    }

    public void readDataFromModel() {
        for (AnimatedModelPart part : this.parts) {
            part.readAnimation();
        }
    }

    public void writeDataToModel() {
        for (AnimatedModelPart part : this.parts) {
            part.writeAnimation();
        }
    }

    public void updateData(int frame, int length, float partialTicks, Easing easing) {
        for (AnimatedModelPart part : this.parts) {
            part.animationData.update(frame, length, partialTicks, easing);
        }
    }

    public abstract EnumMap<EntityPart, AnimationData> getDataFromModel();

    public void doCombatAnimations(T entity, PoseStack matrix) {
        ActionableEntity animEntity;
        IActionTracker capA;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        float partialTicks = ClientEngine.get().getPartialTick();
        if (entity instanceof ActionableEntity && !(capA = (animEntity = (ActionableEntity)((Object)entity)).getActionTracker()).isInactive()) {
            partialTicks = capA.modifyPartialTick(partialTicks);
            Action action = capA.getAction();
            AnimationCalculator mCalc = new AnimationCalculator(capA.getDuration(), capA.getFrame(), partialTicks);
            this.readDataFromModel();
            this.updateData(capA.getFrame(), capA.getDuration(), partialTicks, Easing.inOutSine);
            EnumMap<EntityPart, AnimationData> data = this.getDataFromModel();
            action.transformModel(capA.getState(), capA.getFrame(), capA.getDuration(), action.getChargeProgress(capA.getCharge(), capA.getChargePartial()), action.getPitch(livingEntity, partialTicks), livingEntity, data, mCalc);
            Vector3f rotVec = mCalc.getTransformations();
            this.writeDataToModel();
            this.applyMatrixRotation(mCalc.getTransformations(), matrix);
            if (capA.isStunned()) {
                partialTicks = ClientEngine.get().getPartialTick();
                mCalc = new AnimationCalculator(capA.getStunDuration(), capA.getStunFrame(), partialTicks);
                int dir = (((Entity)entity).f_19797_ - capA.getStunFrame()) % 2 == 0 ? -1 : 1;
                float mag = Mth.m_14036_((float)((float)capA.getStunDuration() / 7.0f), (float)0.5f, (float)1.0f);
                this.animateStun(capA.getStunFrame(), capA.getStunDuration(), dir, mag, entity, mCalc, rotVec, partialTicks);
                rotVec = mCalc.getTransformations();
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(rotVec.m_122239_()));
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(rotVec.m_122260_()));
                matrix.m_85845_(Vector3f.f_122227_.m_122240_(rotVec.m_122269_()));
            }
        }
    }

    public void animateStun(int frame, int duration, int dir, float mag, T user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        int offset;
        for (AnimatedModelPart part : this.parts) {
            if (this.getNoStunParts().contains((Object)part)) continue;
            AnimationUtil.stunPartToDefault(part, part.animationData, frame, duration, partialTicks);
        }
        mCalc.length = offset = duration / 2;
        mCalc.setEasing(Easing.outQuart);
        mCalc.add(0.0f, -7.5f * mag * (float)dir, 0.0f);
        if (frame > offset) {
            mCalc.setEasing(Easing.inOutSine);
            mCalc.offset = offset;
            mCalc.length = duration;
            mVec.m_122261_(-1.0f);
            mCalc.extend(mVec);
        }
    }

    protected List<AnimatedModelPart> getNoStunParts() {
        return List.of();
    }

    protected void applyMatrixRotation(Vector3f rotations, PoseStack matrix) {
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(rotations.m_122239_()));
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(rotations.m_122260_()));
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(rotations.m_122269_()));
    }

    public void rotateX(ModelPart part, float degree, float slow, float swingOffset, float positionOffset, float limbSwing, float limbSwingAmount, Easing easing, boolean symmetric) {
        part.f_104203_ = (float)((double)part.f_104203_ + ((double)AnimationUtil.getProgress(limbSwing + swingOffset * slow, slow, easing, symmetric) * Math.toRadians(degree) * (double)limbSwingAmount + (double)(positionOffset * limbSwingAmount)));
    }

    public void rotateY(ModelPart part, float degree, float slow, float swingOffset, float positionOffset, float limbSwing, float limbSwingAmount, Easing easing, boolean symmetric) {
        part.f_104204_ = (float)((double)part.f_104204_ + ((double)AnimationUtil.getProgress(limbSwing + swingOffset * slow, slow, easing, symmetric) * Math.toRadians(degree) * (double)limbSwingAmount + (double)(positionOffset * limbSwingAmount)));
    }

    public void rotateZ(ModelPart part, float degree, float slow, float swingOffset, float positionOffset, float limbSwing, float limbSwingAmount, Easing easing, boolean symmetric) {
        part.f_104205_ = (float)((double)part.f_104205_ + ((double)AnimationUtil.getProgress(limbSwing + swingOffset * slow, slow, easing, symmetric) * Math.toRadians(degree) * (double)limbSwingAmount + (double)(positionOffset * limbSwingAmount)));
    }

    public void translateX(ModelPart part, float distance, float slow, float swingOffset, float positionOffset, float limbSwing, float limbSwingAmount, Easing easing, boolean symmetric) {
        part.f_104200_ += AnimationUtil.getProgress(limbSwing + swingOffset * slow, slow, easing, symmetric) * distance * limbSwingAmount + positionOffset * limbSwingAmount;
    }

    public void translateY(ModelPart part, float distance, float slow, float swingOffset, float positionOffset, float limbSwing, float limbSwingAmount, Easing easing, boolean symmetric) {
        part.f_104201_ += AnimationUtil.getProgress(limbSwing + swingOffset * slow, slow, easing, symmetric) * distance * limbSwingAmount + positionOffset * limbSwingAmount;
    }

    public void translateZ(ModelPart part, float distance, float slow, float swingOffset, float positionOffset, float limbSwing, float limbSwingAmount, Easing easing, boolean symmetric) {
        part.f_104202_ += AnimationUtil.getProgress(limbSwing + swingOffset * slow, slow, easing, symmetric) * distance * limbSwingAmount + positionOffset * limbSwingAmount;
    }
}

