/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.data.Vec3f;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;

public class AnimatedModelPart
extends ModelPart {
    public float defaultXRot;
    public float defaultYRot;
    public float defaultZRot;
    public float defaultX;
    public float defaultY;
    public float defaultZ;
    public AnimationData animationData;
    public float xScale = 1.0f;
    public float yScale = 1.0f;
    public float zScale = 1.0f;

    public AnimatedModelPart(ModelPart part) {
        super(part.f_104212_, part.f_104213_);
        this.f_104200_ = part.f_104200_;
        this.f_104201_ = part.f_104201_;
        this.f_104202_ = part.f_104202_;
        this.f_104203_ = part.f_104203_;
        this.f_104204_ = part.f_104204_;
        this.f_104205_ = part.f_104205_;
        this.f_104207_ = part.f_104207_;
        this.defaultXRot = this.f_104203_;
        this.defaultYRot = this.f_104204_;
        this.defaultZRot = this.f_104205_;
        this.defaultX = this.f_104200_;
        this.defaultY = this.f_104201_;
        this.defaultZ = this.f_104202_;
        this.animationData = new AnimationData(new Vector3f(this.f_104200_, this.f_104201_, this.f_104202_), new Vector3f(this.f_104203_, this.f_104204_, this.f_104205_), new Vector3f(this.xScale, this.yScale, this.zScale), new Vector3f());
    }

    public void m_104299_(PoseStack pPoseStack) {
        super.m_104299_(pPoseStack);
        if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
            pPoseStack.m_85841_(this.xScale, this.yScale, this.zScale);
        }
    }

    public void writeAnimation() {
        Vector3f rVec = MathUtil.toRadians(this.animationData.rCalc.getTransformations());
        Vector3f tVec = this.animationData.tCalc.getTransformations();
        this.f_104203_ = rVec.m_122239_();
        this.f_104204_ = rVec.m_122260_();
        this.f_104205_ = rVec.m_122269_();
        this.f_104200_ = tVec.m_122239_();
        this.f_104201_ = tVec.m_122260_();
        this.f_104202_ = tVec.m_122269_();
    }

    public void readAnimation() {
        this.animationData.setDefaults(this.f_104200_, this.f_104201_, this.f_104202_, MathUtil.toDegrees(this.f_104203_), MathUtil.toDegrees(this.f_104204_), MathUtil.toDegrees(this.f_104205_), 1.0f, 1.0f, 1.0f);
        this.animationData.tCalc.setStaticVector(this.animationData.dTranslation);
        this.animationData.rCalc.setStaticVector(this.animationData.dRotation);
        this.animationData.sCalc.setStaticVector(this.animationData.dScale);
    }

    public void setDefaultPose() {
        this.defaultXRot = this.f_104203_;
        this.defaultYRot = this.f_104204_;
        this.defaultZRot = this.f_104205_;
        this.defaultX = this.f_104200_;
        this.defaultY = this.f_104201_;
        this.defaultZ = this.f_104202_;
    }

    public void resetPose() {
        this.f_104203_ = this.defaultXRot;
        this.f_104204_ = this.defaultYRot;
        this.f_104205_ = this.defaultZRot;
        this.f_104200_ = this.defaultX;
        this.f_104201_ = this.defaultY;
        this.f_104202_ = this.defaultZ;
    }

    public void setScale(@Nullable Vec3f scale) {
        if (scale == null) {
            return;
        }
        this.xScale = scale.x();
        this.yScale = scale.y();
        this.zScale = scale.z();
    }
}

