/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.client.model.entity.ArmorModel;
import frostnox.nightfall.client.model.entity.ArmorStandDummyModel;
import frostnox.nightfall.client.model.entity.AttachedEntityModel;
import frostnox.nightfall.client.model.entity.CockatriceModel;
import frostnox.nightfall.client.model.entity.CreeperModel;
import frostnox.nightfall.client.model.entity.DeerModel;
import frostnox.nightfall.client.model.entity.DrakefowlBabyModel;
import frostnox.nightfall.client.model.entity.DrakefowlModel;
import frostnox.nightfall.client.model.entity.DregModel;
import frostnox.nightfall.client.model.entity.EctoplasmInnerModel;
import frostnox.nightfall.client.model.entity.EctoplasmOuterModel;
import frostnox.nightfall.client.model.entity.HuskModel;
import frostnox.nightfall.client.model.entity.JellyfishInnerModel;
import frostnox.nightfall.client.model.entity.JellyfishOuterModel;
import frostnox.nightfall.client.model.entity.OlmurModel;
import frostnox.nightfall.client.model.entity.PitDevilModel;
import frostnox.nightfall.client.model.entity.PlayerModelNF;
import frostnox.nightfall.client.model.entity.RabbitModel;
import frostnox.nightfall.client.model.entity.RockwormModel;
import frostnox.nightfall.client.model.entity.ScorpionModel;
import frostnox.nightfall.client.model.entity.SkeletonModel;
import frostnox.nightfall.client.model.entity.SpiderModel;
import frostnox.nightfall.client.model.entity.TrollModel;
import frostnox.nightfall.client.render.blockentity.CauldronRenderer;
import frostnox.nightfall.client.render.blockentity.ChestRendererNF;
import frostnox.nightfall.client.render.entity.BoatRendererNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.item.ArmorType;
import frostnox.nightfall.item.ITieredArmorMaterial;
import frostnox.nightfall.item.Style;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.registry.forge.ItemsNF;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.registries.RegistryObject;

public class ModelRegistryNF {
    private static final Map<ModelLayerLocation, LayerDefinition> layers = new Object2ObjectOpenHashMap();
    private static final Map<ITieredArmorMaterial, ModelLayerLocation> materialMap = new Object2ObjectOpenHashMap();
    private static final Map<Item, Pair<EntityPart, ModelLayerLocation>> equipmentMap = new Object2ObjectOpenHashMap();
    private static final Map<Item, Pair<EntityPart, ModelLayerLocation>> accessoryMap = new Object2ObjectOpenHashMap();
    public static ModelLayerLocation CHEST;
    public static ModelLayerLocation DOUBLE_CHEST_LEFT;
    public static ModelLayerLocation DOUBLE_CHEST_RIGHT;
    public static ModelLayerLocation SIGN;
    public static ModelLayerLocation CAULDRON;
    public static ModelLayerLocation ARMOR_STAND;
    public static ModelLayerLocation BOAT;
    public static ModelLayerLocation PLAYER;
    public static ModelLayerLocation PLAYER_SLIM;
    public static ModelLayerLocation RABBIT;
    public static ModelLayerLocation DEER;
    public static ModelLayerLocation DRAKEFOWL;
    public static ModelLayerLocation DRAKEFOWL_BABY;
    public static ModelLayerLocation HUSK;
    public static ModelLayerLocation SKELETON;
    public static ModelLayerLocation DREG;
    public static ModelLayerLocation CREEPER;
    public static ModelLayerLocation COCKATRICE;
    public static ModelLayerLocation SPIDER;
    public static ModelLayerLocation ROCKWORM;
    public static ModelLayerLocation PIT_DEVIL;
    public static ModelLayerLocation ECTOPLASM_LARGE_INNER;
    public static ModelLayerLocation ECTOPLASM_LARGE_OUTER;
    public static ModelLayerLocation ECTOPLASM_LARGE_OUTER_INNER;
    public static ModelLayerLocation ECTOPLASM_MEDIUM_INNER;
    public static ModelLayerLocation ECTOPLASM_MEDIUM_OUTER;
    public static ModelLayerLocation ECTOPLASM_MEDIUM_OUTER_INNER;
    public static ModelLayerLocation ECTOPLASM_SMALL_INNER;
    public static ModelLayerLocation ECTOPLASM_SMALL_OUTER;
    public static ModelLayerLocation ECTOPLASM_SMALL_OUTER_INNER;
    public static ModelLayerLocation SCORPION;
    public static ModelLayerLocation TROLL;
    public static ModelLayerLocation OLMUR;
    public static ModelLayerLocation JELLYFISH_INNER;
    public static ModelLayerLocation JELLYFISH_OUTER;
    public static ModelLayerLocation INNER_ARMOR;
    public static ModelLayerLocation OUTER_ARMOR;
    public static ModelLayerLocation FLAT_ARMOR;
    public static ModelLayerLocation TAPERED_ARMOR;
    public static ModelLayerLocation SLIM_ARMOR;
    public static ModelLayerLocation PLATE_SURVIVOR;
    public static ModelLayerLocation PLATE_EXPLORER;
    public static ModelLayerLocation CHAINMAIL_EXPLORER;
    public static ModelLayerLocation PLATE_SLAYER;
    public static ModelLayerLocation SCALE_SLAYER;
    public static ModelLayerLocation CHAINMAIL_SLAYER;
    public static ModelLayerLocation BACKPACK;
    public static ModelLayerLocation POUCH;
    public static ModelLayerLocation MASK;
    public static ModelLayerLocation NECKLACE;
    public static ModelLayerLocation LANTERN;

    public static void init(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition innerArmor = LayerDefinition.m_171565_((MeshDefinition)ArmorModel.createVanillaMesh(new CubeDeformation(0.5f)), (int)64, (int)32);
        LayerDefinition outerArmor = LayerDefinition.m_171565_((MeshDefinition)ArmorModel.createVanillaMesh(new CubeDeformation(1.0f)), (int)64, (int)32);
        CHEST = ModelRegistryNF.register("chest", ChestRendererNF.createSingleBodyLayer());
        DOUBLE_CHEST_LEFT = ModelRegistryNF.register("double_chest_left", ChestRendererNF.createDoubleBodyLeftLayer());
        DOUBLE_CHEST_RIGHT = ModelRegistryNF.register("double_chest_right", ChestRendererNF.createDoubleBodyRightLayer());
        SIGN = ModelRegistryNF.register("sign", SignRenderer.m_173654_());
        CAULDRON = ModelRegistryNF.register("cauldron", CauldronRenderer.createLayer());
        ARMOR_STAND = ModelRegistryNF.register("armor_stand", ArmorStandDummyModel.createBodyLayer());
        BOAT = ModelRegistryNF.register("boat", BoatRendererNF.createModel());
        PLAYER = ModelRegistryNF.register("player_combat", LayerDefinition.m_171565_((MeshDefinition)PlayerModelNF.m_170825_(CubeDeformation.f_171458_, false), (int)64, (int)64));
        PLAYER_SLIM = ModelRegistryNF.register("player_slim_combat", LayerDefinition.m_171565_((MeshDefinition)PlayerModelNF.m_170825_(CubeDeformation.f_171458_, true), (int)64, (int)64));
        RABBIT = ModelRegistryNF.register("rabbit", RabbitModel.createBodyLayer());
        DEER = ModelRegistryNF.register("deer", DeerModel.createBodyLayer());
        DRAKEFOWL = ModelRegistryNF.register("drakefowl", DrakefowlModel.createBodyLayer());
        DRAKEFOWL_BABY = ModelRegistryNF.register("drakefowl_baby", DrakefowlBabyModel.createBodyLayer());
        HUSK = ModelRegistryNF.register("husk", HuskModel.createBodyLayer());
        SKELETON = ModelRegistryNF.register("skeleton", SkeletonModel.createBodyLayer());
        DREG = ModelRegistryNF.register("dreg", DregModel.createBodyLayer());
        CREEPER = ModelRegistryNF.register("creeper", CreeperModel.createBodyLayer());
        COCKATRICE = ModelRegistryNF.register("cockatrice", CockatriceModel.createBodyLayer());
        SPIDER = ModelRegistryNF.register("spider", SpiderModel.createBodyLayer());
        ROCKWORM = ModelRegistryNF.register("rockworm", RockwormModel.createBodyLayer());
        PIT_DEVIL = ModelRegistryNF.register("pit_devil", PitDevilModel.createBodyLayer());
        ECTOPLASM_LARGE_INNER = ModelRegistryNF.register("ectoplasm_large_inner", EctoplasmInnerModel.createLargeLayer());
        ECTOPLASM_LARGE_OUTER = ModelRegistryNF.register("ectoplasm_large_outer", EctoplasmOuterModel.createLargeLayer());
        ECTOPLASM_LARGE_OUTER_INNER = ModelRegistryNF.register("ectoplasm_large_outer_inner", EctoplasmOuterModel.createLargeInnerLayer());
        ECTOPLASM_MEDIUM_INNER = ModelRegistryNF.register("ectoplasm_medium_inner", EctoplasmInnerModel.createMediumLayer());
        ECTOPLASM_MEDIUM_OUTER = ModelRegistryNF.register("ectoplasm_medium_outer", EctoplasmOuterModel.createMediumLayer());
        ECTOPLASM_MEDIUM_OUTER_INNER = ModelRegistryNF.register("ectoplasm_medium_outer_inner", EctoplasmOuterModel.createMediumInnerLayer());
        ECTOPLASM_SMALL_INNER = ModelRegistryNF.register("ectoplasm_small_inner", EctoplasmInnerModel.createSmallLayer());
        ECTOPLASM_SMALL_OUTER = ModelRegistryNF.register("ectoplasm_small_outer", EctoplasmOuterModel.createSmallLayer());
        ECTOPLASM_SMALL_OUTER_INNER = ModelRegistryNF.register("ectoplasm_small_outer_inner", EctoplasmOuterModel.createSmallInnerLayer());
        SCORPION = ModelRegistryNF.register("scorpion", ScorpionModel.createBodyLayer());
        TROLL = ModelRegistryNF.register("troll", TrollModel.createBodyLayer());
        OLMUR = ModelRegistryNF.register("olmur", OlmurModel.createBodyLayer());
        JELLYFISH_INNER = ModelRegistryNF.register("jellyfish_inner", JellyfishInnerModel.createInnerLayer());
        JELLYFISH_OUTER = ModelRegistryNF.register("jellyfish_outer", JellyfishOuterModel.createOuterLayer());
        INNER_ARMOR = ModelRegistryNF.register("armor", innerArmor, "inner_armor");
        OUTER_ARMOR = ModelRegistryNF.register("armor", outerArmor, "outer_armor");
        FLAT_ARMOR = ModelRegistryNF.register("armor", ArmorModel.createFlatLayer(), "flat");
        TAPERED_ARMOR = ModelRegistryNF.register("armor", ArmorModel.createTaperedLayer(), "tapered");
        SLIM_ARMOR = ModelRegistryNF.register("armor", ArmorModel.createSlimLayer(), "slim");
        PLATE_SURVIVOR = ModelRegistryNF.register("armor", ArmorModel.createPlateSurvivorLayer(), "plate_survivor");
        PLATE_EXPLORER = ModelRegistryNF.register("armor", ArmorModel.createPlateExplorerLayer(), "plate_explorer");
        CHAINMAIL_EXPLORER = ModelRegistryNF.register("armor", ArmorModel.createChainmailExplorerLayer(), "chainmail_explorer");
        PLATE_SLAYER = ModelRegistryNF.register("armor", ArmorModel.createPlateSlayerLayer(), "plate_slayer");
        SCALE_SLAYER = ModelRegistryNF.register("armor", ArmorModel.createScaleSlayerLayer(), "scale_slayer");
        CHAINMAIL_SLAYER = ModelRegistryNF.register("armor", ArmorModel.createChainmailSlayerLayer(), "chainmail_slayer");
        for (TieredArmorMaterial mat : TieredArmorMaterial.values()) {
            if (mat == TieredArmorMaterial.RAGGED) {
                ModelRegistryNF.mapArmor(mat, SLIM_ARMOR);
                continue;
            }
            if (mat == TieredArmorMaterial.RUSTED) {
                ModelRegistryNF.mapArmor(mat, TAPERED_ARMOR);
                continue;
            }
            if (mat.getArmorType() == ArmorType.PLATE) {
                if (mat.getStyle() == Style.SURVIVOR) {
                    ModelRegistryNF.mapArmor(mat, PLATE_SURVIVOR);
                    continue;
                }
                if (mat.getStyle() == Style.EXPLORER) {
                    ModelRegistryNF.mapArmor(mat, PLATE_EXPLORER);
                    continue;
                }
                if (mat.getStyle() != Style.SLAYER) continue;
                ModelRegistryNF.mapArmor(mat, PLATE_SLAYER);
                continue;
            }
            if (mat.getArmorType() == ArmorType.SCALE) {
                if (mat.getStyle() == Style.SURVIVOR) {
                    ModelRegistryNF.mapArmor(mat, TAPERED_ARMOR);
                    continue;
                }
                if (mat.getStyle() == Style.EXPLORER) {
                    ModelRegistryNF.mapArmor(mat, FLAT_ARMOR);
                    continue;
                }
                if (mat.getStyle() != Style.SLAYER) continue;
                ModelRegistryNF.mapArmor(mat, SCALE_SLAYER);
                continue;
            }
            if (mat.getArmorType() == ArmorType.CHAINMAIL) {
                if (mat.getStyle() == Style.SURVIVOR) {
                    ModelRegistryNF.mapArmor(mat, FLAT_ARMOR);
                    continue;
                }
                if (mat.getStyle() == Style.EXPLORER) {
                    ModelRegistryNF.mapArmor(mat, CHAINMAIL_EXPLORER);
                    continue;
                }
                if (mat.getStyle() != Style.SLAYER) continue;
                ModelRegistryNF.mapArmor(mat, CHAINMAIL_SLAYER);
                continue;
            }
            ModelRegistryNF.mapArmor(mat, TAPERED_ARMOR);
        }
        BACKPACK = ModelRegistryNF.register("equipment", AttachedEntityModel.createBackpackLayer(), "backpack");
        ModelRegistryNF.mapEquipment((Item)ItemsNF.BACKPACK.get(), EntityPart.BODY, BACKPACK);
        POUCH = ModelRegistryNF.register("accessory", AttachedEntityModel.createPouchLayer(), "pouch");
        ModelRegistryNF.mapAccessory((Item)ItemsNF.POUCH.get(), EntityPart.BODY, POUCH);
        MASK = ModelRegistryNF.register("accessory", AttachedEntityModel.createMaskLayer(), "mask");
        ModelRegistryNF.mapAccessory((Item)ItemsNF.MASK.get(), EntityPart.HEAD, MASK);
        NECKLACE = ModelRegistryNF.register("accessory", AttachedEntityModel.createNecklaceLayer(), "necklace");
        ModelRegistryNF.mapAccessory((Item)ItemsNF.WARDING_CHARM.get(), EntityPart.BODY, NECKLACE);
        LANTERN = ModelRegistryNF.register("accessory", AttachedEntityModel.createLanternLayer(), "lantern");
        for (RegistryObject registryObject : ItemsNF.LANTERNS.values()) {
            ModelRegistryNF.mapAccessory((Item)registryObject.get(), EntityPart.BODY, LANTERN);
        }
        for (RegistryObject registryObject : ItemsNF.LANTERNS_UNLIT.values()) {
            ModelRegistryNF.mapAccessory((Item)registryObject.get(), EntityPart.BODY, LANTERN);
        }
        for (ModelLayerLocation modelLayerLocation : layers.keySet()) {
            event.registerLayerDefinition(modelLayerLocation, () -> layers.get(location));
        }
    }

    public static ModelLayerLocation getArmor(ITieredArmorMaterial material) {
        if (!materialMap.containsKey(material)) {
            throw new IllegalStateException("Material " + material.getName() + " is missing in armor model map");
        }
        return materialMap.get(material);
    }

    public static void mapArmor(ITieredArmorMaterial material, ModelLayerLocation model) {
        if (materialMap.containsKey(material)) {
            Nightfall.LOGGER.warn("Duplicate material in armor model map, overwriting " + material.getName());
        }
        materialMap.put(material, model);
    }

    @Nullable
    public static Pair<EntityPart, ModelLayerLocation> getEquipment(Item equipment) {
        return equipmentMap.get(equipment);
    }

    public static void mapEquipment(Item equipment, EntityPart attachedPart, ModelLayerLocation model) {
        if (equipmentMap.containsKey(equipment)) {
            Nightfall.LOGGER.warn("Duplicate equipment in model map, overwriting " + equipment.getRegistryName());
        }
        equipmentMap.put(equipment, (Pair<EntityPart, ModelLayerLocation>)Pair.of((Object)((Object)attachedPart), (Object)model));
    }

    @Nullable
    public static Pair<EntityPart, ModelLayerLocation> getAccessory(Item accessory) {
        return accessoryMap.get(accessory);
    }

    public static void mapAccessory(Item accessory, EntityPart attachedPart, ModelLayerLocation model) {
        if (accessoryMap.containsKey(accessory)) {
            Nightfall.LOGGER.warn("Duplicate accessory in model map, overwriting " + accessory.getRegistryName());
        }
        accessoryMap.put(accessory, (Pair<EntityPart, ModelLayerLocation>)Pair.of((Object)((Object)attachedPart), (Object)model));
    }

    private static ModelLayerLocation register(String pathName, LayerDefinition layer) {
        return ModelRegistryNF.register(pathName, layer, "main");
    }

    private static ModelLayerLocation register(String pathName, LayerDefinition layer, String layerName) {
        ModelLayerLocation location = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)pathName), layerName);
        layers.put(location, layer);
        return location;
    }
}

