/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.client.model.entity.ArmorModel;
import frostnox.nightfall.client.model.entity.IHumanoidModel;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public abstract class AnimatedHumanoidModel<T extends LivingEntity>
extends AnimatedModel<T>
implements ArmedModel,
HeadedModel,
IHumanoidModel {
    public AnimatedModelPart neck;
    public AnimatedModelPart head;
    public AnimatedModelPart body;
    public AnimatedModelPart rightArm;
    public AnimatedModelPart rightHand;
    public AnimatedModelPart leftArm;
    public AnimatedModelPart leftHand;
    public AnimatedModelPart rightLeg;
    public AnimatedModelPart leftLeg;
    private final EnumMap<EntityPart, AnimatedModelPart> partMap = new EnumMap(EntityPart.class);
    private final List<AnimatedModelPart> noStunParts;

    public AnimatedHumanoidModel(ModelPart model) {
        this(model, RenderType::m_110458_);
    }

    public AnimatedHumanoidModel(ModelPart model, Function<ResourceLocation, RenderType> renderFunc) {
        super(model, renderFunc);
        this.body = (AnimatedModelPart)model.m_171324_("body");
        this.rightLeg = (AnimatedModelPart)model.m_171324_("right_leg");
        this.leftLeg = (AnimatedModelPart)model.m_171324_("left_leg");
        this.neck = (AnimatedModelPart)this.body.m_171324_("neck");
        this.head = (AnimatedModelPart)this.neck.m_171324_("head");
        this.rightArm = (AnimatedModelPart)this.body.m_171324_("right_arm");
        this.rightHand = (AnimatedModelPart)this.rightArm.m_171324_("right_hand");
        this.leftArm = (AnimatedModelPart)this.body.m_171324_("left_arm");
        this.leftHand = (AnimatedModelPart)this.leftArm.m_171324_("left_hand");
        this.partMap.put(EntityPart.NECK, this.neck);
        this.partMap.put(EntityPart.HEAD, this.head);
        this.partMap.put(EntityPart.BODY, this.body);
        this.partMap.put(EntityPart.ARM_RIGHT, this.rightArm);
        this.partMap.put(EntityPart.HAND_RIGHT, this.rightHand);
        this.partMap.put(EntityPart.ARM_LEFT, this.leftArm);
        this.partMap.put(EntityPart.HAND_LEFT, this.leftHand);
        this.partMap.put(EntityPart.LEG_RIGHT, this.rightLeg);
        this.partMap.put(EntityPart.LEG_LEFT, this.leftLeg);
        this.noStunParts = List.of(this.rightLeg, this.leftLeg);
    }

    protected Iterable<ModelPart> rootParts() {
        return ImmutableList.of((Object)((Object)this.body), (Object)((Object)this.rightLeg), (Object)((Object)this.leftLeg));
    }

    public void setAllVisible(boolean visibility) {
        this.neck.f_104207_ = visibility;
        this.head.f_104207_ = visibility;
        this.body.f_104207_ = visibility;
        this.rightArm.f_104207_ = visibility;
        this.rightHand.f_104207_ = visibility;
        this.leftArm.f_104207_ = visibility;
        this.leftHand.f_104207_ = visibility;
        this.rightLeg.f_104207_ = visibility;
        this.leftLeg.f_104207_ = visibility;
    }

    public void m_102624_(EntityModel<T> model) {
        model.f_102608_ = this.f_102608_;
        model.f_102609_ = this.f_102609_;
        model.f_102610_ = this.f_102610_;
        if (model instanceof AnimatedHumanoidModel) {
            AnimatedHumanoidModel modelA = (AnimatedHumanoidModel)model;
            modelA.neck.m_104315_(this.neck);
            modelA.head.m_104315_(this.head);
            modelA.body.m_104315_(this.body);
            modelA.rightArm.m_104315_(this.rightArm);
            modelA.leftArm.m_104315_(this.leftArm);
            modelA.rightHand.m_104315_(this.rightHand);
            modelA.leftHand.m_104315_(this.leftHand);
            modelA.leftLeg.m_104315_(this.leftLeg);
            modelA.rightLeg.m_104315_(this.rightLeg);
        }
    }

    public void copyPropertiesTo(ArmorModel model) {
        model.f_102608_ = this.f_102608_;
        model.f_102609_ = this.f_102609_;
        model.f_102610_ = this.f_102610_;
        model.head.m_104315_(this.head);
        model.neck.m_104315_(this.neck);
        model.bodyHeadJoint.m_104315_(this.body);
        model.body.m_104315_(this.body);
        model.innerBody.m_104315_(this.body);
        model.bodyRightArmJoint.m_104315_(this.body);
        model.rightArm.m_104315_(this.rightArm);
        model.bodyLeftArmJoint.m_104315_(this.body);
        model.leftArm.m_104315_(this.leftArm);
        model.rightHand.m_104315_(this.rightHand);
        model.leftHand.m_104315_(this.leftHand);
        model.rightLeg.m_104315_(this.rightLeg);
        model.rightLeg.f_104202_ -= 0.001f;
        model.leftLeg.m_104315_(this.leftLeg);
        model.rightFoot.m_104315_(model.rightLeg);
        model.leftFoot.m_104315_(model.leftLeg);
        model.rightSkirt.m_104315_(model.rightLeg);
        model.leftSkirt.m_104315_(model.leftLeg);
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.rootParts().forEach(part -> part.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha));
    }

    public void m_6002_(HumanoidArm side, PoseStack stack) {
        this.body.m_104299_(stack);
        this.getArm(side).m_104299_(stack);
        this.getHand(side).m_104299_(stack);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public ModelPart getArm(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHand(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.leftHand : this.rightHand;
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.HAND_RIGHT, this.rightHand.animationData);
        map.put(EntityPart.ARM_RIGHT, this.rightArm.animationData);
        map.put(EntityPart.HAND_LEFT, this.leftHand.animationData);
        map.put(EntityPart.ARM_LEFT, this.leftArm.animationData);
        map.put(EntityPart.LEG_RIGHT, this.rightLeg.animationData);
        map.put(EntityPart.LEG_LEFT, this.leftLeg.animationData);
        map.put(EntityPart.HEAD, this.head.animationData);
        map.put(EntityPart.NECK, this.neck.animationData);
        map.put(EntityPart.BODY, this.body.animationData);
        return map;
    }

    @Override
    public ModelPart getModelPart(EntityPart part) {
        return this.partMap.get((Object)part);
    }

    @Override
    protected void applyMatrixRotation(Vector3f rotations, PoseStack matrix) {
        super.applyMatrixRotation(rotations, matrix);
        this.head.f_104203_ -= MathUtil.toRadians(rotations.m_122239_());
        this.head.f_104204_ -= MathUtil.toRadians(rotations.m_122260_());
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, T user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        super.animateStun(frame, duration, dir, mag, user, mCalc, mVec, partialTicks);
        AnimationUtil.stunPartToDefaultWithPause(this.head, this.head.animationData, frame, duration, partialTicks, -12.0f * mag, 1);
        AnimationUtil.stunPartToDefaultWithPause(this.neck, this.neck.animationData, frame, duration, partialTicks, 0.0f, 1);
        AnimationUtil.stunPartToDefaultWithPause(this.body, this.body.animationData, frame, duration, partialTicks, -12.0f * mag, 1);
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return this.noStunParts;
    }
}

