/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.data.Vec3f;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;

public class ArmorModel
extends AnimatedModel<LivingEntity> {
    public final AnimatedModelPart body;
    public final AnimatedModelPart innerBody;
    public final AnimatedModelPart bodyHeadJoint;
    public final AnimatedModelPart neck;
    public final AnimatedModelPart head;
    public final AnimatedModelPart bodyLeftArmJoint;
    public final AnimatedModelPart leftArm;
    public final AnimatedModelPart leftHand;
    public final AnimatedModelPart bodyRightArmJoint;
    public final AnimatedModelPart rightArm;
    public final AnimatedModelPart rightHand;
    public final AnimatedModelPart leftLeg;
    public final AnimatedModelPart rightLeg;
    public final AnimatedModelPart leftFoot;
    public final AnimatedModelPart rightFoot;
    public final AnimatedModelPart leftSkirt;
    public final AnimatedModelPart rightSkirt;

    public ArmorModel(ModelPart model, ImmutableMap<String, Vec3f> scaleMap) {
        super(model, RenderType::m_110458_);
        this.body = (AnimatedModelPart)model.m_171324_("body");
        this.body.setScale((Vec3f)scaleMap.get((Object)"body"));
        this.innerBody = (AnimatedModelPart)model.m_171324_("inner_body");
        this.innerBody.setScale((Vec3f)scaleMap.get((Object)"body"));
        this.bodyHeadJoint = (AnimatedModelPart)model.m_171324_("body_head_joint");
        this.neck = (AnimatedModelPart)this.bodyHeadJoint.m_171324_("neck");
        this.head = (AnimatedModelPart)this.neck.m_171324_("head");
        this.head.setScale((Vec3f)scaleMap.get((Object)"head"));
        this.bodyLeftArmJoint = (AnimatedModelPart)model.m_171324_("body_left_arm_joint");
        this.leftArm = (AnimatedModelPart)this.bodyLeftArmJoint.m_171324_("left_arm_joint");
        this.leftHand = (AnimatedModelPart)this.leftArm.m_171324_("left_arm");
        this.leftHand.setScale((Vec3f)scaleMap.get((Object)"arm"));
        this.bodyRightArmJoint = (AnimatedModelPart)model.m_171324_("body_right_arm_joint");
        this.rightArm = (AnimatedModelPart)this.bodyRightArmJoint.m_171324_("right_arm_joint");
        this.rightHand = (AnimatedModelPart)this.rightArm.m_171324_("right_arm");
        this.rightHand.setScale((Vec3f)scaleMap.get((Object)"arm"));
        this.leftLeg = (AnimatedModelPart)model.m_171324_("left_leg");
        this.leftLeg.setScale((Vec3f)scaleMap.get((Object)"leg"));
        this.rightLeg = (AnimatedModelPart)model.m_171324_("right_leg");
        this.rightLeg.setScale((Vec3f)scaleMap.get((Object)"leg"));
        this.leftFoot = (AnimatedModelPart)model.m_171324_("left_foot");
        this.leftFoot.setScale((Vec3f)scaleMap.get((Object)"leg"));
        this.rightFoot = (AnimatedModelPart)model.m_171324_("right_foot");
        this.rightFoot.setScale((Vec3f)scaleMap.get((Object)"leg"));
        this.leftSkirt = (AnimatedModelPart)model.m_171324_("left_skirt");
        this.leftSkirt.setScale((Vec3f)scaleMap.get((Object)"leg"));
        this.rightSkirt = (AnimatedModelPart)model.m_171324_("right_skirt");
        this.rightSkirt.setScale((Vec3f)scaleMap.get((Object)"leg"));
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        return new EnumMap<EntityPart, AnimationData>(EntityPart.class);
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, LivingEntity user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return List.of();
    }

    public void setupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.headParts().forEach(p_102061_ -> p_102061_.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha));
        this.bodyParts().forEach(p_102051_ -> p_102051_.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha));
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)((Object)this.bodyHeadJoint));
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)((Object)this.body), (Object)((Object)this.innerBody), (Object)((Object)this.bodyRightArmJoint), (Object)((Object)this.bodyLeftArmJoint), (Object)((Object)this.rightLeg), (Object)((Object)this.leftLeg), (Object)((Object)this.rightFoot), (Object)((Object)this.leftFoot), (Object)((Object)this.rightSkirt), (Object)((Object)this.leftSkirt));
    }

    public void setAllVisible(boolean visible) {
        this.body.f_104207_ = visible;
        this.innerBody.f_104207_ = visible;
        this.bodyHeadJoint.f_104207_ = visible;
        this.neck.f_104207_ = visible;
        this.head.f_104207_ = visible;
        this.bodyLeftArmJoint.f_104207_ = visible;
        this.leftArm.f_104207_ = visible;
        this.leftHand.f_104207_ = visible;
        this.bodyRightArmJoint.f_104207_ = visible;
        this.rightArm.f_104207_ = visible;
        this.rightHand.f_104207_ = visible;
        this.leftLeg.f_104207_ = visible;
        this.rightLeg.f_104207_ = visible;
        this.leftFoot.f_104207_ = visible;
        this.rightFoot.f_104207_ = visible;
        this.leftSkirt.f_104207_ = visible;
        this.rightSkirt.f_104207_ = visible;
    }

    public static MeshDefinition createVanillaMesh(CubeDeformation cubeDef) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition inner_body = partdefinition.m_171599_("inner_body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_foot = partdefinition.m_171599_("left_foot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_foot = partdefinition.m_171599_("right_foot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body_head_joint = partdefinition.m_171599_("body_head_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body_head_joint.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition body_right_arm_joint = partdefinition.m_171599_("body_right_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_joint = body_right_arm_joint.m_171599_("right_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = right_arm_joint.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body_left_arm_joint = partdefinition.m_171599_("body_left_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_joint = body_left_arm_joint.m_171599_("left_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = left_arm_joint.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef).m_171555_(false), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition right_skirt = partdefinition.m_171599_("right_skirt", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_skirt = partdefinition.m_171599_("left_skirt", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.01f));
        return meshdefinition;
    }

    public static MeshDefinition createFlatMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body_head_joint = partdefinition.m_171599_("body_head_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body_head_joint.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 42).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(64, 24).m_171488_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -13.0f, -3.0f, 10.0f, 14.0f, 6.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition inner_body = partdefinition.m_171599_("inner_body", CubeListBuilder.m_171558_().m_171514_(33, 13).m_171488_(-4.5f, -4.0f, -2.5f, 9.0f, 4.0f, 5.0f, new CubeDeformation(0.02f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition body_right_arm_joint = partdefinition.m_171599_("body_right_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_joint = body_right_arm_joint.m_171599_("right_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-6.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = right_arm_joint.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171480_().m_171488_(-3.5f, -3.0f, -3.0f, 6.0f, 14.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(64, 42).m_171480_().m_171488_(-2.5f, -3.0f, -2.5f, 5.0f, 14.0f, 5.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body_left_arm_joint = partdefinition.m_171599_("body_left_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_joint = body_left_arm_joint.m_171599_("left_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = left_arm_joint.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-2.5f, -3.0f, -3.0f, 6.0f, 14.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(64, 42).m_171488_(-2.5f, -3.0f, -2.5f, 5.0f, 14.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(44, 27).m_171480_().m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.99f, (float)12.0f, (float)0.0f));
        PartDefinition right_foot = partdefinition.m_171599_("right_foot", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171480_().m_171488_(-3.01f, 6.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171419_((float)-1.99f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(44, 27).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.99f, (float)12.0f, (float)0.01f));
        PartDefinition left_foot = partdefinition.m_171599_("left_foot", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-2.99f, 6.0f, -3.01f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.99f, (float)12.0f, (float)0.01f));
        PartDefinition right_skirt = partdefinition.m_171599_("right_skirt", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.99f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r1 = right_skirt.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-2.8f, 0.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(-0.02f)), PartPose.m_171423_((float)0.2f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition left_skirt = partdefinition.m_171599_("left_skirt", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.99f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r2 = left_skirt.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171480_().m_171488_(-3.2f, 0.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(-0.03f)).m_171555_(false), PartPose.m_171423_((float)-0.2f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        return meshdefinition;
    }

    public static MeshDefinition createTaperedMesh() {
        MeshDefinition meshdefinition = ArmorModel.createFlatMesh();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -13.0f, -3.0f, 10.0f, 9.0f, 6.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition inner_body = partdefinition.m_171599_("inner_body", CubeListBuilder.m_171558_().m_171514_(33, 13).m_171488_(-4.5f, -4.0f, -2.5f, 9.0f, 4.0f, 5.0f, new CubeDeformation(0.03f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_skirt = partdefinition.m_171599_("right_skirt", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.99f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r1 = right_skirt.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(33, 1).m_171488_(-2.53f, 0.0f, -2.5f, 6.0f, 7.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.2f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition left_skirt = partdefinition.m_171599_("left_skirt", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.99f, (float)12.0f, (float)0.0f));
        PartDefinition cube_r2 = left_skirt.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(33, 1).m_171480_().m_171488_(-3.46f, 0.0f, -2.5f, 6.0f, 7.0f, 5.0f, new CubeDeformation(0.02f)).m_171555_(false), PartPose.m_171423_((float)-0.2f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        return meshdefinition;
    }

    public static LayerDefinition createFlatLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)ArmorModel.createFlatMesh(), (int)128, (int)64);
    }

    public static LayerDefinition createTaperedLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)ArmorModel.createTaperedMesh(), (int)128, (int)64);
    }

    public static LayerDefinition createSlimLayer() {
        MeshDefinition meshdefinition = ArmorModel.createTaperedMesh();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(2, 1).m_171488_(-4.5f, -13.0f, -2.5f, 9.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition inner_body = partdefinition.m_171599_("inner_body", CubeListBuilder.m_171558_().m_171514_(33, 15).m_171488_(-4.5f, -2.0f, -2.5f, 9.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createPlateSurvivorLayer() {
        MeshDefinition meshdefinition = ArmorModel.createFlatMesh();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -13.0f, -3.0f, 10.0f, 14.0f, 6.0f, new CubeDeformation(-0.01f)).m_171514_(106, 0).m_171488_(-5.0f, -12.0f, -4.0f, 10.0f, 6.0f, 1.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createPlateExplorerLayer() {
        MeshDefinition meshdefinition = ArmorModel.createFlatMesh();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171597_("body_head_joint").m_171597_("neck").m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 42).m_171488_(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(80, 0).m_171488_(-6.0f, -6.0f, -6.0f, 12.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(64, 24).m_171488_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createChainmailExplorerLayer() {
        MeshDefinition meshdefinition = ArmorModel.createFlatMesh();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171597_("body_head_joint").m_171597_("neck").m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 42).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(64, 24).m_171488_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.01f)).m_171514_(80, 0).m_171488_(-6.0f, -7.0f, -6.0f, 12.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createPlateSlayerLayer() {
        MeshDefinition meshdefinition = ArmorModel.createFlatMesh();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171597_("body_head_joint").m_171597_("neck").m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 42).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(64, 24).m_171488_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.01f)).m_171514_(104, 7).m_171488_(-1.0f, -10.0f, -6.0f, 2.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(122, 21).m_171488_(-0.5f, -11.0f, 4.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(124, 25).m_171488_(-0.5f, -10.0f, 6.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(108, 22).m_171488_(-0.5f, -9.0f, 5.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -13.0f, -3.0f, 10.0f, 9.0f, 6.0f, new CubeDeformation(-0.01f)).m_171514_(118, 0).m_171488_(1.0f, -11.0f, -4.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(102, 0).m_171488_(-5.0f, -11.0f, -4.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(112, 0).m_171488_(-1.0f, -11.0f, -4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createScaleSlayerLayer() {
        MeshDefinition meshdefinition = ArmorModel.createTaperedMesh();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body_right_arm_joint = partdefinition.m_171599_("body_right_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_joint = body_right_arm_joint.m_171599_("right_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-6.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = right_arm_joint.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171480_().m_171488_(-3.5f, -3.0f, -3.0f, 6.0f, 14.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(104, 0).m_171488_(-3.5f, -5.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(64, 42).m_171480_().m_171488_(-2.5f, -3.0f, -2.5f, 5.0f, 14.0f, 5.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body_left_arm_joint = partdefinition.m_171599_("body_left_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_joint = body_left_arm_joint.m_171599_("left_arm_joint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = left_arm_joint.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-2.5f, -3.0f, -3.0f, 6.0f, 14.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(104, 0).m_171480_().m_171488_(-2.5f, -5.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(64, 42).m_171488_(-2.5f, -3.0f, -2.5f, 5.0f, 14.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createChainmailSlayerLayer() {
        MeshDefinition meshdefinition = ArmorModel.createFlatMesh();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171597_("body_head_joint").m_171597_("neck").m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 42).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(64, 24).m_171488_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.01f)).m_171514_(86, 50).m_171488_(-6.0f, -3.0f, -3.0f, 12.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }
}

