/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.model.entity.AnimatedHumanoidModel;
import frostnox.nightfall.entity.entity.ArmorStandDummyEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class ArmorStandDummyModel
extends AnimatedHumanoidModel<ArmorStandDummyEntity> {
    private final ModelPart rightBodyStick;
    private final ModelPart leftBodyStick;
    private final ModelPart shoulderStick;
    private final ModelPart basePlate;

    public ArmorStandDummyModel(ModelPart root) {
        super(root);
        ModelPart body = root.m_171324_("body");
        this.rightBodyStick = body.m_171324_("right_body_stick");
        this.leftBodyStick = body.m_171324_("left_body_stick");
        this.shoulderStick = body.m_171324_("shoulder_stick");
        this.basePlate = root.m_171324_("base_plate");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(-6.0f, -12.0f, -1.5f, 12.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        body.m_171599_("right_body_stick", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-3.0f, 3.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        body.m_171599_("left_body_stick", CubeListBuilder.m_171558_().m_171514_(48, 16).m_171481_(1.0f, 3.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        body.m_171599_("shoulder_stick", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171481_(-4.0f, 10.0f, -1.0f, 8.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(24, 0), PartPose.m_171419_((float)-6.0f, (float)-10.0f, (float)0.0f));
        rightArm.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-2.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.f_171404_);
        PartDefinition leftArm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171480_(), PartPose.m_171419_((float)6.0f, (float)-10.0f, (float)0.0f));
        leftArm.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171480_().m_171481_(0.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.f_171404_);
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        root.m_171599_("base_plate", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-6.0f, 11.0f, -6.0f, 12.0f, 1.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(ArmorStandDummyEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.basePlate.f_104203_ = 0.0f;
        this.basePlate.f_104204_ = (float)Math.PI / 180 * -Mth.m_14189_((float)pPartialTick, (float)pEntity.f_19859_, (float)pEntity.m_146908_());
        this.basePlate.f_104205_ = 0.0f;
    }

    public void setupAnim(ArmorStandDummyEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.f_104203_ = (float)Math.PI / 180 * pEntity.getHeadPose().m_123156_();
        this.head.f_104204_ = (float)Math.PI / 180 * pEntity.getHeadPose().m_123157_();
        this.head.f_104205_ = (float)Math.PI / 180 * pEntity.getHeadPose().m_123158_();
        this.body.f_104203_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123156_();
        this.body.f_104204_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123157_();
        this.body.f_104205_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123158_();
        this.leftArm.f_104203_ = (float)Math.PI / 180 * pEntity.getLeftArmPose().m_123156_();
        this.leftArm.f_104204_ = (float)Math.PI / 180 * pEntity.getLeftArmPose().m_123157_();
        this.leftArm.f_104205_ = (float)Math.PI / 180 * pEntity.getLeftArmPose().m_123158_();
        this.rightArm.f_104203_ = (float)Math.PI / 180 * pEntity.getRightArmPose().m_123156_();
        this.rightArm.f_104204_ = (float)Math.PI / 180 * pEntity.getRightArmPose().m_123157_();
        this.rightArm.f_104205_ = (float)Math.PI / 180 * pEntity.getRightArmPose().m_123158_();
        this.leftLeg.f_104203_ = (float)Math.PI / 180 * pEntity.getLeftLegPose().m_123156_();
        this.leftLeg.f_104204_ = (float)Math.PI / 180 * pEntity.getLeftLegPose().m_123157_();
        this.leftLeg.f_104205_ = (float)Math.PI / 180 * pEntity.getLeftLegPose().m_123158_();
        this.rightLeg.f_104203_ = (float)Math.PI / 180 * pEntity.getRightLegPose().m_123156_();
        this.rightLeg.f_104204_ = (float)Math.PI / 180 * pEntity.getRightLegPose().m_123157_();
        this.rightLeg.f_104205_ = (float)Math.PI / 180 * pEntity.getRightLegPose().m_123158_();
        this.leftArm.f_104207_ = pEntity.isShowArms();
        this.rightArm.f_104207_ = pEntity.isShowArms();
        this.basePlate.f_104207_ = !pEntity.isNoBasePlate();
        this.rightBodyStick.f_104203_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123156_();
        this.rightBodyStick.f_104204_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123157_();
        this.rightBodyStick.f_104205_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123158_();
        this.leftBodyStick.f_104203_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123156_();
        this.leftBodyStick.f_104204_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123157_();
        this.leftBodyStick.f_104205_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123158_();
        this.shoulderStick.f_104203_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123156_();
        this.shoulderStick.f_104204_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123157_();
        this.shoulderStick.f_104205_ = (float)Math.PI / 180 * pEntity.getBodyPose().m_123158_();
    }

    @Override
    protected Iterable<ModelPart> rootParts() {
        return Iterables.concat(super.rootParts(), (Iterable)ImmutableList.of((Object)this.basePlate));
    }

    @Override
    public void m_6002_(HumanoidArm pSide, PoseStack stack) {
        ModelPart modelpart = this.getArm(pSide);
        boolean flag = modelpart.f_104207_;
        modelpart.f_104207_ = true;
        super.m_6002_(pSide, stack);
        modelpart.f_104207_ = flag;
        stack.m_85841_(0.999f, 1.0f, 1.0f);
        stack.m_85837_(pSide == HumanoidArm.RIGHT ? -0.06255 : 0.06255, 0.625, -0.125);
    }
}

