/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.CockatriceEntity;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CockatriceModel
extends AnimatedModel<CockatriceEntity>
implements HeadedModel {
    private final AnimatedModelPart body;
    private final AnimatedModelPart neck;
    private final AnimatedModelPart head;
    private final AnimatedModelPart tail;
    private final AnimatedModelPart wingRight;
    private final AnimatedModelPart wingLeft;
    private final AnimatedModelPart legRight;
    private final AnimatedModelPart legLeft;
    private final List<AnimatedModelPart> noStunParts;

    public CockatriceModel(ModelPart root) {
        super(root);
        this.body = (AnimatedModelPart)root.m_171324_("body");
        this.neck = (AnimatedModelPart)this.body.m_171324_("neck");
        this.head = (AnimatedModelPart)this.neck.m_171324_("head");
        this.tail = (AnimatedModelPart)this.body.m_171324_("tail");
        this.wingRight = (AnimatedModelPart)this.body.m_171324_("wing_right");
        this.wingLeft = (AnimatedModelPart)this.body.m_171324_("wing_left");
        this.legRight = (AnimatedModelPart)root.m_171324_("leg_right");
        this.legLeft = (AnimatedModelPart)root.m_171324_("leg_left");
        this.noStunParts = List.of(this.head);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-3.5f, -4.5f, -5.5f, 7.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(52, 20).m_171488_(-1.5f, -9.0f, -1.0f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)-5.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-2.0f, -4.0f, -3.5f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(12, 0).m_171488_(-1.0f, -3.0f, -6.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(12, 3).m_171488_(0.0f, 0.0f, -4.5f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(14, 15).m_171488_(0.0f, -6.0f, -2.5f, 0.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(0.0f, -2.5f, -3.5f, 0.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-2.5f, (float)1.0f, (float)0.0f, (float)-0.3229f, (float)0.0f));
        PartDefinition cube_r2 = head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(0.0f, -2.5f, -3.5f, 0.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-2.5f, (float)1.0f, (float)0.0f, (float)0.3229f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-1.0f, -0.5f, 7.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 27).m_171488_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.5f));
        PartDefinition wing_right = body.m_171599_("wing_right", CubeListBuilder.m_171558_().m_171514_(-12, 50).m_171488_(-13.0f, 0.0f, -1.5f, 13.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)-3.5f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)0.8727f));
        PartDefinition wing_left = body.m_171599_("wing_left", CubeListBuilder.m_171558_().m_171514_(-12, 50).m_171480_().m_171488_(0.0f, 0.0f, -1.5f, 13.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)-3.5f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)-0.8727f));
        PartDefinition leg_right = partdefinition.m_171599_("leg_right", CubeListBuilder.m_171558_().m_171514_(28, 27).m_171488_(-1.0f, 8.5f, -8.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)-3.5f, (float)14.5f, (float)3.0f));
        PartDefinition cube_r3 = leg_right.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(20, 27).m_171488_(-1.0f, -0.6f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leg_left = partdefinition.m_171599_("leg_left", CubeListBuilder.m_171558_().m_171514_(28, 27).m_171480_().m_171488_(-1.0f, 8.5f, -8.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171419_((float)3.5f, (float)14.5f, (float)3.0f));
        PartDefinition cube_r4 = leg_left.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(20, 27).m_171480_().m_171488_(-1.0f, -0.6f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CockatriceEntity entity, float limbSwing, float limbSwingAmount, float time, float netHeadYaw, float headPitch) {
        this.resetPose();
        float speed = 4.25f;
        limbSwingAmount = Math.min(1.0f, limbSwingAmount * 2.0f);
        float trackAmount = AnimationUtil.applyEasing(Mth.m_14179_((float)ClientEngine.get().getPartialTick(), (float)entity.targetTimeLast, (float)entity.targetTime) / 9.0f, Easing.inOutSine);
        this.head.f_104203_ += MathUtil.toRadians(headPitch);
        if (netHeadYaw > 60.0f || netHeadYaw < -60.0f) {
            float yaw = Mth.m_14036_((float)netHeadYaw, (float)-60.0f, (float)60.0f);
            this.head.f_104204_ += MathUtil.toRadians(netHeadYaw - yaw);
            this.neck.f_104204_ += MathUtil.toRadians(yaw);
        } else {
            this.neck.f_104204_ += MathUtil.toRadians(netHeadYaw);
        }
        if (!entity.m_21224_()) {
            float idle4;
            float idle3;
            float idle2;
            float idleAmount = 1.0f - trackAmount;
            this.rotateX(this.tail, 4.0f, 30.0f, 0.0f, 0.0f, time, idleAmount, Easing.inOutSine, false);
            int hash = entity.m_142081_().hashCode();
            float idle1 = (time + (float)(hash & 0xFF)) % 210.0f;
            if (idle1 < 6.0f) {
                this.rotateX(this.wingRight, 5.0f, 3.0f, 0.0f, 0.0f, idle1, idleAmount, Easing.inOutSine, false);
            }
            if ((idle2 = (time + (float)(hash >> 8 & 0xFF)) % 210.0f) < 6.0f) {
                this.rotateX(this.wingLeft, 5.0f, 3.0f, 0.0f, 0.0f, idle2, idleAmount, Easing.inOutSine, false);
            }
            if ((idle3 = (time + (float)(hash >> 16 & 0xFF)) % 320.0f) < 90.0f) {
                float p = Easing.inOutCubic.apply(idle3 < 4.0f ? idle3 / 4.0f : (idle3 >= 86.0f ? 1.0f - (idle3 - 86.0f) / 4.0f : 1.0f));
                this.head.f_104204_ += MathUtil.toRadians(10.0f) * p * idleAmount;
            }
            if ((idle4 = (time + (float)(hash >>> 24 & 0xFF)) % 320.0f) < 90.0f) {
                float p = Easing.inOutCubic.apply(idle4 < 4.0f ? idle4 / 4.0f : (idle4 >= 86.0f ? 1.0f - (idle4 - 86.0f) / 4.0f : 1.0f));
                this.head.f_104204_ += MathUtil.toRadians(-10.0f) * p * idleAmount;
            }
            this.translateY(this.neck, 0.1f, 30.0f, 0.0f, 0.0f, time, 1.0f, Easing.inOutSine, true);
            this.translateY(this.body, -0.1f, 30.0f, 0.0f, 0.0f, time, 1.0f, Easing.inOutSine, true);
        }
        this.neck.f_104203_ += MathUtil.toRadians(45.0f) * trackAmount;
        this.head.f_104202_ += -1.0f * trackAmount;
        this.head.f_104203_ += MathUtil.toRadians(-45.0f) * trackAmount;
        this.wingLeft.f_104204_ += MathUtil.toRadians(-50.0f) * trackAmount;
        this.wingLeft.f_104205_ += MathUtil.toRadians(125.0f) * trackAmount;
        this.wingRight.f_104204_ += MathUtil.toRadians(50.0f) * trackAmount;
        this.wingRight.f_104205_ += MathUtil.toRadians(-125.0f) * trackAmount;
        this.translateY(this.neck, 0.5f, speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.translateY(this.body, -0.5f, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.translateY(this.legLeft, -1.0f, speed, 2.7488937f, -0.5f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.translateY(this.legRight, -1.0f, speed, -0.3926991f, -0.5f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.translateZ(this.legLeft, -1.0f, speed, (float)Math.PI, -1.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.translateZ(this.legRight, -1.0f, speed, 0.0f, -1.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.legLeft, 125.0f, 1.0f * speed, (float)Math.PI, MathUtil.toRadians(-25.0f), limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.legRight, 125.0f, 1.0f * speed, 0.0f, MathUtil.toRadians(-25.0f), limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateZ(this.wingLeft, 20.0f, 1.0f * speed, (float)Math.PI, 0.0f, limbSwing, limbSwingAmount * (1.0f - trackAmount), Easing.inOutSine, false);
        this.rotateZ(this.wingRight, 20.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount * (1.0f - trackAmount), Easing.inOutSine, false);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.legRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.legLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.LEG_RIGHT, this.legRight.animationData);
        map.put(EntityPart.LEG_LEFT, this.legLeft.animationData);
        map.put(EntityPart.WING_RIGHT, this.wingRight.animationData);
        map.put(EntityPart.WING_LEFT, this.wingLeft.animationData);
        map.put(EntityPart.NECK, this.neck.animationData);
        map.put(EntityPart.HEAD, this.head.animationData);
        map.put(EntityPart.BODY, this.body.animationData);
        map.put(EntityPart.TAIL, this.tail.animationData);
        return map;
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, CockatriceEntity user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        super.animateStun(frame, duration, dir, mag, user, mCalc, mVec, partialTicks);
        AnimationUtil.stunPartToDefaultWithPause(this.head, this.head.animationData, frame, duration, partialTicks, -20.0f * mag, 1);
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return this.noStunParts;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

