/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.CreeperEntity;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CreeperModel
extends AnimatedModel<CreeperEntity>
implements HeadedModel {
    private final AnimatedModelPart body;
    private final AnimatedModelPart head;
    private final AnimatedModelPart legBackRight;
    private final AnimatedModelPart legBackLeft;
    private final AnimatedModelPart legFrontRight;
    private final AnimatedModelPart legFrontLeft;
    private final List<AnimatedModelPart> noStunParts;

    public CreeperModel(ModelPart root) {
        super(root);
        this.body = (AnimatedModelPart)root.m_171324_("body");
        this.head = (AnimatedModelPart)this.body.m_171324_("head");
        this.legBackRight = (AnimatedModelPart)root.m_171324_("legBackRight");
        this.legBackLeft = (AnimatedModelPart)root.m_171324_("legBackLeft");
        this.legFrontRight = (AnimatedModelPart)root.m_171324_("legFrontRight");
        this.legFrontLeft = (AnimatedModelPart)root.m_171324_("legFrontLeft");
        this.noStunParts = List.of(this.head);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition legBackRight = partdefinition.m_171599_("legBackRight", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)2.0f));
        PartDefinition legBackLeft = partdefinition.m_171599_("legBackLeft", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)18.0f, (float)2.0f));
        PartDefinition legFrontRight = partdefinition.m_171599_("legFrontRight", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)-2.0f));
        PartDefinition legFrontLeft = partdefinition.m_171599_("legFrontLeft", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)18.0f, (float)-2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(CreeperEntity entity, float limbSwing, float limbSwingAmount, float time, float netHeadYaw, float headPitch) {
        this.resetPose();
        limbSwingAmount = Math.min(1.0f, limbSwingAmount * 2.0f);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.body.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.035f * limbSwingAmount;
        this.legBackRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.65f * limbSwingAmount;
        this.legBackLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.65f * limbSwingAmount;
        this.legFrontRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.65f * limbSwingAmount;
        this.legFrontLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.65f * limbSwingAmount;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.legBackRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.legBackLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.legFrontRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.legFrontLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.LEG_RIGHT, this.legFrontRight.animationData);
        map.put(EntityPart.LEG_LEFT, this.legFrontLeft.animationData);
        map.put(EntityPart.LEG_2_RIGHT, this.legBackRight.animationData);
        map.put(EntityPart.LEG_2_LEFT, this.legBackLeft.animationData);
        map.put(EntityPart.HEAD, this.head.animationData);
        map.put(EntityPart.BODY, this.body.animationData);
        return map;
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, CreeperEntity user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        super.animateStun(frame, duration, dir, mag, user, mCalc, mVec, partialTicks);
        AnimationUtil.stunPartToDefaultWithPause(this.head, this.head.animationData, frame, duration, partialTicks, -20.0f * mag, 1);
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return this.noStunParts;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

