/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.Sex;
import frostnox.nightfall.entity.entity.animal.DeerEntity;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import frostnox.nightfall.world.Season;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DeerModel
extends AnimatedModel<DeerEntity>
implements HeadedModel {
    private final AnimatedModelPart body;
    private final AnimatedModelPart hindRightLeg;
    private final AnimatedModelPart hindLeftLeg;
    private final AnimatedModelPart neck;
    private final AnimatedModelPart head;
    private final AnimatedModelPart antlers;
    private final AnimatedModelPart antlersYoung;
    private final AnimatedModelPart antlersMature;
    private final AnimatedModelPart antlersYoungSpecial;
    private final AnimatedModelPart antlersMatureSpecial;
    private final AnimatedModelPart rightEar;
    private final AnimatedModelPart leftEar;
    private final AnimatedModelPart tail;
    private final AnimatedModelPart frontRightLeg;
    private final AnimatedModelPart frontLeftLeg;
    private final List<AnimatedModelPart> noStunParts;

    public DeerModel(ModelPart root) {
        super(root);
        this.body = (AnimatedModelPart)root.m_171324_("body");
        this.hindRightLeg = (AnimatedModelPart)root.m_171324_("hind_right_leg");
        this.hindLeftLeg = (AnimatedModelPart)root.m_171324_("hind_left_leg");
        this.neck = (AnimatedModelPart)this.body.m_171324_("neck");
        this.head = (AnimatedModelPart)this.neck.m_171324_("head");
        this.antlers = (AnimatedModelPart)this.head.m_171324_("antlers");
        this.antlersYoung = (AnimatedModelPart)this.antlers.m_171324_("young");
        this.antlersMature = (AnimatedModelPart)this.antlers.m_171324_("mature");
        this.antlersYoungSpecial = (AnimatedModelPart)this.antlers.m_171324_("young_special");
        this.antlersMatureSpecial = (AnimatedModelPart)this.antlers.m_171324_("mature_special");
        this.rightEar = (AnimatedModelPart)this.head.m_171324_("right_ear");
        this.leftEar = (AnimatedModelPart)this.head.m_171324_("left_ear");
        this.tail = (AnimatedModelPart)this.body.m_171324_("tail");
        this.frontRightLeg = (AnimatedModelPart)root.m_171324_("front_right_leg");
        this.frontLeftLeg = (AnimatedModelPart)root.m_171324_("front_left_leg");
        this.noStunParts = List.of(this.head);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-3.0f, -3.5f, -7.0f, 6.0f, 7.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.5f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -8.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)-5.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(28, 0).m_171488_(-1.0f, -2.0f, -5.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition antlers = head.m_171599_("antlers", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition young = antlers.m_171599_("young", CubeListBuilder.m_171558_().m_171514_(18, 21).m_171488_(1.0f, -5.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(18, 21).m_171480_().m_171488_(-5.0f, -5.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mature = antlers.m_171599_("mature", CubeListBuilder.m_171558_().m_171514_(26, 21).m_171488_(1.0f, -5.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(26, 21).m_171480_().m_171488_(-5.0f, -5.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition young_special = antlers.m_171599_("young_special", CubeListBuilder.m_171558_().m_171514_(18, 26).m_171488_(1.0f, -5.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(18, 26).m_171480_().m_171488_(-5.0f, -5.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mature_special = antlers.m_171599_("mature_special", CubeListBuilder.m_171558_().m_171514_(26, 26).m_171488_(1.0f, -5.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(26, 26).m_171480_().m_171488_(-5.0f, -5.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(26, 11).m_171480_().m_171488_(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(26, 11).m_171488_(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.1345f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(18, 16).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)7.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition front_right_leg = partdefinition.m_171599_("front_right_leg", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-0.99f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)15.0f, (float)-5.0f));
        PartDefinition front_left_leg = partdefinition.m_171599_("front_left_leg", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171480_().m_171488_(-1.01f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)15.0f, (float)-5.0f));
        PartDefinition hind_right_leg = partdefinition.m_171599_("hind_right_leg", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-0.99f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)15.0f, (float)5.0f));
        PartDefinition hind_left_leg = partdefinition.m_171599_("hind_left_leg", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171480_().m_171488_(-1.01f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)15.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(DeerEntity entity, float limbSwing, float limbSwingAmount, float time, float netHeadYaw, float headPitch) {
        this.resetPose();
        this.antlersYoung.f_104207_ = false;
        this.antlersMature.f_104207_ = false;
        this.antlersYoungSpecial.f_104207_ = false;
        this.antlersMatureSpecial.f_104207_ = false;
        if (entity.getDeerType() == DeerEntity.Type.BRIAR) {
            if (entity.getSex() == Sex.MALE) {
                if (entity.isSpecial()) {
                    this.antlersMatureSpecial.f_104207_ = true;
                } else {
                    this.antlersMature.f_104207_ = true;
                }
            } else if (entity.isSpecial()) {
                this.antlersYoungSpecial.f_104207_ = true;
            } else {
                this.antlersYoung.f_104207_ = true;
            }
        } else if (entity.getSex() == Sex.MALE) {
            Season season = Season.get(entity.f_19853_);
            if (season == Season.SUMMER) {
                if (entity.isSpecial()) {
                    this.antlersYoungSpecial.f_104207_ = true;
                } else {
                    this.antlersYoung.f_104207_ = true;
                }
            } else if (season == Season.FALL) {
                if (entity.isSpecial()) {
                    this.antlersMatureSpecial.f_104207_ = true;
                } else {
                    this.antlersMature.f_104207_ = true;
                }
            }
        }
        float speed = 4.5f;
        limbSwingAmount = Math.min(1.0f, limbSwingAmount * 2.0f);
        float sprintAmount = AnimationUtil.applyEasing(Mth.m_14179_((float)ClientEngine.get().getPartialTick(), (float)entity.sprintTimeLast, (float)entity.sprintTime) / 9.0f, Easing.inOutSine);
        float walkAmount = 1.0f - sprintAmount;
        sprintAmount *= limbSwingAmount;
        walkAmount *= limbSwingAmount;
        this.head.f_104203_ += MathUtil.toRadians(headPitch);
        if (netHeadYaw > 45.0f || netHeadYaw < -45.0f) {
            float yaw = Mth.m_14036_((float)netHeadYaw, (float)-45.0f, (float)45.0f);
            this.head.f_104204_ += MathUtil.toRadians(netHeadYaw - yaw);
            this.neck.f_104204_ += MathUtil.toRadians(yaw);
        } else {
            this.neck.f_104204_ += MathUtil.toRadians(netHeadYaw);
        }
        if (!entity.m_21224_() && walkAmount > 0.0f) {
            float idle4;
            float idle3;
            int hash = entity.m_142081_().hashCode();
            float idle1 = (time + (float)(hash & 0xFF)) % 220.0f;
            if (idle1 < 8.0f) {
                this.rotateZ(this.tail, 7.5f, 4.0f, 0.0f, 0.0f, idle1 + 2.0f, walkAmount, Easing.inOutSine, true);
            }
            if ((idle3 = (time + (float)(hash >> 16 & 0xFF)) % 310.0f) < 90.0f) {
                float p = Easing.inOutCubic.apply(idle3 < 4.0f ? idle3 / 4.0f : (idle3 >= 86.0f ? 1.0f - (idle3 - 86.0f) / 4.0f : 1.0f));
                this.rightEar.f_104204_ += MathUtil.toRadians(12.5f) * p * walkAmount;
            }
            if ((idle4 = (time + (float)(hash >>> 24 & 0xFF)) % 310.0f) < 90.0f) {
                float p = Easing.inOutCubic.apply(idle4 < 4.0f ? idle4 / 4.0f : (idle4 >= 86.0f ? 1.0f - (idle4 - 86.0f) / 4.0f : 1.0f));
                this.leftEar.f_104204_ += MathUtil.toRadians(-12.5f) * p * walkAmount;
            }
        }
        this.rotateX(this.tail, 7.5f, speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        if (sprintAmount > 0.0f) {
            speed = 3.5f;
            this.rotateX(this.body, 5.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, sprintAmount, Easing.inOutSine, true);
            this.rotateX(this.head, -5.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, sprintAmount, Easing.inOutSine, true);
            for (AnimatedModelPart part : new AnimatedModelPart[]{this.body, this.frontRightLeg, this.frontLeftLeg, this.hindRightLeg, this.hindLeftLeg}) {
                this.translateY(part, -1.5f, 1.0f * speed, (float)Math.PI, 0.0f, limbSwing, sprintAmount, Easing.inOutSine, false);
            }
            this.frontRightLeg.f_104203_ += MathUtil.toRadians(-10.0f) * sprintAmount;
            this.frontLeftLeg.f_104203_ += MathUtil.toRadians(-10.0f) * sprintAmount;
            this.rotateX(this.frontRightLeg, 42.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, sprintAmount, Easing.inOutCubic, true);
            this.rotateX(this.frontLeftLeg, 42.0f, 1.0f * speed, 0.19634955f, 0.0f, limbSwing, sprintAmount, Easing.inOutCubic, true);
            this.translateY(this.frontRightLeg, -0.75f, speed, 1.5707964f, 0.0f, limbSwing, sprintAmount, Easing.inOutSine, false);
            this.translateY(this.frontLeftLeg, -0.75f, speed, 1.7671459f, 0.0f, limbSwing, sprintAmount, Easing.inOutSine, false);
            this.hindRightLeg.f_104203_ += MathUtil.toRadians(10.0f) * sprintAmount;
            this.hindLeftLeg.f_104203_ += MathUtil.toRadians(10.0f) * sprintAmount;
            this.rotateX(this.hindLeftLeg, -42.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, sprintAmount, Easing.inOutCubic, true);
            this.rotateX(this.hindRightLeg, -42.0f, 1.0f * speed, 0.19634955f, 0.0f, limbSwing, sprintAmount, Easing.inOutCubic, true);
            this.translateY(this.hindLeftLeg, -1.5f, speed, -1.5707964f, 0.0f, limbSwing, sprintAmount, Easing.inOutSine, false);
            this.translateY(this.hindRightLeg, -1.5f, speed, -1.3744469f, 0.0f, limbSwing, sprintAmount, Easing.inOutSine, false);
        }
        if (walkAmount > 0.0f) {
            speed = 4.5f;
            this.frontRightLeg.f_104203_ += MathUtil.toRadians(-5.0f) * walkAmount;
            this.frontLeftLeg.f_104203_ += MathUtil.toRadians(-5.0f) * walkAmount;
            this.hindRightLeg.f_104203_ += MathUtil.toRadians(5.0f) * walkAmount;
            this.hindLeftLeg.f_104203_ += MathUtil.toRadians(5.0f) * walkAmount;
            this.rotateX(this.frontRightLeg, 42.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, walkAmount, Easing.inOutSine, true);
            this.rotateX(this.frontLeftLeg, -42.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, walkAmount, Easing.inOutSine, true);
            this.rotateX(this.hindRightLeg, -42.0f, 1.0f * speed, 0.19634955f, 0.0f, limbSwing, walkAmount, Easing.inOutSine, true);
            this.rotateX(this.hindLeftLeg, 42.0f, 1.0f * speed, 0.19634955f, 0.0f, limbSwing, walkAmount, Easing.inOutSine, true);
            this.translateY(this.frontRightLeg, -0.5f, speed, 1.5707964f, 0.0f, limbSwing, walkAmount, Easing.inOutSine, false);
            this.translateY(this.frontLeftLeg, -0.5f, speed, -1.5707964f, 0.0f, limbSwing, walkAmount, Easing.inOutSine, false);
            this.translateY(this.hindLeftLeg, -0.5f, speed, 1.7671459f, 0.0f, limbSwing, walkAmount, Easing.inOutSine, false);
            this.translateY(this.hindRightLeg, -0.5f, speed, -1.3744469f, 0.0f, limbSwing, walkAmount, Easing.inOutSine, false);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.hindRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.hindLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.LEG_RIGHT, this.frontRightLeg.animationData);
        map.put(EntityPart.LEG_LEFT, this.frontLeftLeg.animationData);
        map.put(EntityPart.LEG_2_RIGHT, this.hindRightLeg.animationData);
        map.put(EntityPart.LEG_2_LEFT, this.hindLeftLeg.animationData);
        map.put(EntityPart.NECK, this.neck.animationData);
        map.put(EntityPart.HEAD, this.head.animationData);
        map.put(EntityPart.EAR_RIGHT, this.rightEar.animationData);
        map.put(EntityPart.EAR_LEFT, this.leftEar.animationData);
        map.put(EntityPart.BODY, this.body.animationData);
        map.put(EntityPart.TAIL, this.tail.animationData);
        return map;
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, DeerEntity user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        super.animateStun(frame, duration, dir, mag, user, mCalc, mVec, partialTicks);
        AnimationUtil.stunPartToDefaultWithPause(this.head, this.head.animationData, frame, duration, partialTicks, -20.0f * mag, 1);
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return this.noStunParts;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

