/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.animal.DrakefowlBabyEntity;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class DrakefowlBabyModel
extends AnimatedModel<DrakefowlBabyEntity>
implements HeadedModel {
    private final AnimatedModelPart body;
    private final AnimatedModelPart neck;
    private final AnimatedModelPart head;
    private final AnimatedModelPart wingRight;
    private final AnimatedModelPart wingLeft;
    private final AnimatedModelPart legRight;
    private final AnimatedModelPart legLeft;
    private final List<AnimatedModelPart> noStunParts;

    public DrakefowlBabyModel(ModelPart root) {
        super(root);
        this.body = (AnimatedModelPart)root.m_171324_("body");
        this.neck = (AnimatedModelPart)this.body.m_171324_("neck");
        this.head = (AnimatedModelPart)this.neck.m_171324_("head");
        this.wingRight = (AnimatedModelPart)this.body.m_171324_("rightWing");
        this.wingLeft = (AnimatedModelPart)this.body.m_171324_("leftWing");
        this.legRight = (AnimatedModelPart)root.m_171324_("rightLeg");
        this.legLeft = (AnimatedModelPart)root.m_171324_("leftLeg");
        this.noStunParts = List.of(this.head);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -1.5f, -2.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)20.5f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-1.5f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-1.0f, -1.5f, -1.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)-1.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(9, 0).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-1.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)1.309f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(9, 0).m_171480_().m_171488_(-2.0f, 0.0f, -1.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.5f, (float)-1.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-1.309f));
        PartDefinition leftLeg = partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(9, 8).m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)22.0f, (float)-0.5f));
        PartDefinition rightLeg = partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(9, 8).m_171480_().m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)22.0f, (float)-0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void setupAnim(DrakefowlBabyEntity entity, float limbSwing, float limbSwingAmount, float time, float netHeadYaw, float headPitch) {
        this.resetPose();
        float speed = 4.25f;
        limbSwingAmount = Math.min(1.0f, limbSwingAmount * 2.0f);
        this.neck.f_104203_ += MathUtil.toRadians(headPitch);
        this.neck.f_104204_ += MathUtil.toRadians(netHeadYaw);
        if (!entity.m_21224_()) {
            float idle4;
            float idleAmount = 1.0f;
            int hash = entity.m_142081_().hashCode();
            float idle3 = (time + (float)(hash >> 16 & 0xFF)) % 210.0f;
            if (idle3 < 90.0f) {
                float p = Easing.inOutCubic.apply(idle3 < 4.0f ? idle3 / 4.0f : (idle3 >= 86.0f ? 1.0f - (idle3 - 86.0f) / 4.0f : 1.0f));
                this.neck.f_104204_ += MathUtil.toRadians(12.0f) * p * idleAmount;
            }
            if ((idle4 = (time + (float)(hash >>> 24 & 0xFF)) % 210.0f) < 90.0f) {
                float p = Easing.inOutCubic.apply(idle4 < 4.0f ? idle4 / 4.0f : (idle4 >= 86.0f ? 1.0f - (idle4 - 86.0f) / 4.0f : 1.0f));
                this.neck.f_104204_ += MathUtil.toRadians(-12.0f) * p * idleAmount;
            }
        }
        this.translateZ(this.neck, -0.625f, speed / 2.0f, (float)Math.PI, 0.0f, limbSwing, limbSwingAmount, Easing.inOutCubic, false);
        this.translateY(this.legLeft, -0.5f, speed, 2.7488937f, -0.5f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.translateY(this.legRight, -0.5f, speed, -0.3926991f, -0.5f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.translateZ(this.legLeft, 1.0f, speed, (float)Math.PI, -1.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.translateZ(this.legRight, 1.0f, speed, 0.0f, -1.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.legLeft, 115.0f, 1.0f * speed, (float)Math.PI, MathUtil.toRadians(-30.0f), limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.legRight, 115.0f, 1.0f * speed, 0.0f, MathUtil.toRadians(-30.0f), limbSwing, limbSwingAmount, Easing.inOutSine, false);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.legRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.legLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.LEG_RIGHT, this.legRight.animationData);
        map.put(EntityPart.LEG_LEFT, this.legLeft.animationData);
        map.put(EntityPart.WING_RIGHT, this.wingRight.animationData);
        map.put(EntityPart.WING_LEFT, this.wingLeft.animationData);
        map.put(EntityPart.NECK, this.neck.animationData);
        map.put(EntityPart.HEAD, this.head.animationData);
        map.put(EntityPart.BODY, this.body.animationData);
        return map;
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, DrakefowlBabyEntity user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        super.animateStun(frame, duration, dir, mag, user, mCalc, mVec, partialTicks);
        AnimationUtil.stunPartToDefaultWithPause(this.head, this.head.animationData, frame, duration, partialTicks, -20.0f * mag, 1);
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return this.noStunParts;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

