/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.EctoplasmEntity;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class EctoplasmInnerModel
extends AnimatedModel<EctoplasmEntity> {
    private static float DIST = 0.85f;
    private static float FREQ = 0.008f;
    private static float[] Y_DIST = new float[]{DIST * 0.7f, DIST * 0.9f, DIST * 0.75f, DIST * 0.85f, DIST * 0.72f, DIST * 1.1f, DIST * 0.93f, DIST * 1.04f, DIST * 0.88f, DIST * 1.0f};
    private static float[] Y_OFF = new float[]{0.0f, 1.5707964f, 4.712389f, 2.3561945f, 5.4977875f, 0.7853982f, 3.926991f, (float)Math.PI * 2, 1.1780972f, 5.105088f};
    private static float[] Y_FREQ = new float[]{FREQ * 1.0f, FREQ * 0.7f, FREQ * 0.8f, FREQ * 0.95f, FREQ * 1.05f, FREQ * 0.83f, FREQ * 0.98f, FREQ * 1.1f, FREQ * 0.76f, FREQ * 0.9f};
    private static boolean[] DO_X_ROT = new boolean[]{false, true, false, true, false, true, true, false, false, false};
    private static float[] XZ_FREQ = new float[]{FREQ * 0.8f, FREQ * 0.9f, FREQ * 0.85f, FREQ * 0.7f, FREQ * 0.8f, FREQ * 0.92f, FREQ * 0.72f, FREQ * 0.78f, FREQ * 1.08f, FREQ * 0.87f};
    private final AnimatedModelPart bones;
    private final AnimatedModelPart skull;
    private final AnimatedModelPart clubCentered;
    private final AnimatedModelPart club;
    private final AnimatedModelPart bone1;
    private final AnimatedModelPart bone2;
    private final AnimatedModelPart bone3;
    private final AnimatedModelPart bone4;
    private final AnimatedModelPart bone5;
    private final AnimatedModelPart bone6;
    private final AnimatedModelPart bone7;
    private final AnimatedModelPart bone8;
    private final AnimatedModelPart bone9;
    private AnimatedModelPart[] animParts;
    private List<AnimatedModelPart> noStunParts;

    public EctoplasmInnerModel(ModelPart root) {
        super(root);
        this.bones = (AnimatedModelPart)root.m_171324_("bones");
        this.skull = (AnimatedModelPart)this.bones.m_171324_("skull");
        this.clubCentered = (AnimatedModelPart)this.bones.m_171324_("clubCentered");
        this.club = (AnimatedModelPart)this.clubCentered.m_171324_("club");
        this.bone1 = (AnimatedModelPart)this.bones.m_171324_("bone1");
        this.bone2 = (AnimatedModelPart)this.bones.m_171324_("bone2");
        this.bone3 = (AnimatedModelPart)this.bones.m_171324_("bone3");
        this.bone4 = (AnimatedModelPart)this.bones.m_171324_("bone4");
        this.bone5 = (AnimatedModelPart)this.bones.m_171324_("bone5");
        this.bone6 = (AnimatedModelPart)this.bones.m_171324_("bone6");
        this.bone7 = (AnimatedModelPart)this.bones.m_171324_("bone7");
        this.bone8 = (AnimatedModelPart)this.bones.m_171324_("bone8");
        this.bone9 = (AnimatedModelPart)this.bones.m_171324_("bone9");
        this.animParts = new AnimatedModelPart[]{this.skull, this.bone1, this.bone2, this.bone3, this.bone4, this.bone5, this.bone6, this.bone7, this.bone8, this.bone9};
        this.noStunParts = List.of(this.bones);
    }

    public static LayerDefinition createLargeLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bones = partdefinition.m_171599_("bones", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition skull = bones.m_171599_("skull", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.3491f));
        PartDefinition clubCentered = bones.m_171599_("clubCentered", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition club = clubCentered.m_171599_("club", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -12.0f, -1.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(13, 0).m_171488_(-2.0f, -16.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)-8.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bone1 = bones.m_171599_("bone1", CubeListBuilder.m_171558_().m_171514_(21, 9).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)2.0f, (float)7.0f, (float)-0.7854f, (float)-0.4363f, (float)0.0f));
        PartDefinition bone2 = bones.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(21, 9).m_171488_(-1.0f, -3.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)9.5f, (float)-5.0f, (float)0.0f, (float)0.5236f, (float)-1.2217f));
        PartDefinition bone3 = bones.m_171599_("bone3", CubeListBuilder.m_171558_().m_171514_(2, 18).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.5f, (float)8.0f, (float)-6.0f, (float)-0.6981f, (float)1.0472f, (float)0.0f));
        PartDefinition bone4 = bones.m_171599_("bone4", CubeListBuilder.m_171558_().m_171514_(5, 18).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.5f, (float)4.0f, (float)-6.0f, (float)0.0f, (float)-1.309f, (float)-0.7854f));
        PartDefinition bone5 = bones.m_171599_("bone5", CubeListBuilder.m_171558_().m_171514_(1, 17).m_171488_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.0f, (float)7.5f, (float)9.0f, (float)-1.3963f, (float)-0.3491f, (float)0.0f));
        PartDefinition bone6 = bones.m_171599_("bone6", CubeListBuilder.m_171558_().m_171514_(21, 9).m_171488_(-1.0f, -3.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)8.0f, (float)7.0f, (float)-0.7854f, (float)1.7453f, (float)0.0f));
        PartDefinition bone7 = bones.m_171599_("bone7", CubeListBuilder.m_171558_().m_171514_(8, 17).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-11.5f, (float)-10.5f, (float)-10.5f, (float)0.0f, (float)-1.3963f, (float)-0.8727f));
        PartDefinition bone8 = bones.m_171599_("bone8", CubeListBuilder.m_171558_().m_171514_(4, 18).m_171488_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)11.0f, (float)-4.0f, (float)-11.0f, (float)0.0f, (float)-1.309f, (float)1.9199f));
        PartDefinition bone9 = bones.m_171599_("bone9", CubeListBuilder.m_171558_().m_171514_(6, 20).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-10.5f, (float)11.5f, (float)0.0f, (float)1.2217f, (float)1.309f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createMediumLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bones = partdefinition.m_171599_("bones", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition skull = bones.m_171599_("skull", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.3491f));
        PartDefinition clubCentered = bones.m_171599_("clubCentered", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition club = clubCentered.m_171599_("club", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -12.0f, -1.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(13, 0).m_171488_(-2.0f, -16.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bone1 = bones.m_171599_("bone1", CubeListBuilder.m_171558_().m_171514_(21, 9).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)1.0f, (float)4.5f, (float)-0.7854f, (float)-0.4363f, (float)0.0f));
        PartDefinition bone2 = bones.m_171599_("bone2", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)3.5f, (float)4.5f, (float)-5.0f, (float)0.0f, (float)0.5236f, (float)-1.2217f));
        PartDefinition bone3 = bones.m_171599_("bone3", CubeListBuilder.m_171558_().m_171514_(2, 18).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)5.5f, (float)-5.0f, (float)-0.6981f, (float)1.0472f, (float)0.0f));
        PartDefinition bone4 = bones.m_171599_("bone4", CubeListBuilder.m_171558_().m_171514_(5, 18).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-3.5f, (float)-6.0f, (float)0.0f, (float)-1.309f, (float)-0.7854f));
        PartDefinition bone5 = bones.m_171599_("bone5", CubeListBuilder.m_171558_().m_171514_(1, 17).m_171488_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)5.0f, (float)5.0f, (float)-1.3963f, (float)-0.3491f, (float)0.0f));
        PartDefinition bone6 = bones.m_171599_("bone6", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)2.0f, (float)3.0f, (float)7.0f, (float)-0.7854f, (float)1.7453f, (float)0.0f));
        PartDefinition bone7 = bones.m_171599_("bone7", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-11.5f, (float)-15.5f, (float)-10.5f, (float)0.0f, (float)-1.3963f, (float)-0.8727f));
        PartDefinition bone8 = bones.m_171599_("bone8", CubeListBuilder.m_171558_().m_171514_(4, 18).m_171488_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)2.5f, (float)-5.5f, (float)0.0f, (float)-1.309f, (float)1.9199f));
        PartDefinition bone9 = bones.m_171599_("bone9", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-3.0f, (float)-16.5f, (float)12.5f, (float)0.0f, (float)1.2217f, (float)1.309f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createSmallLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bones = partdefinition.m_171599_("bones", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition skull = bones.m_171599_("skull", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)-11.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.3491f));
        PartDefinition clubCentered = bones.m_171599_("clubCentered", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition club = clubCentered.m_171599_("club", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bone1 = bones.m_171599_("bone1", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-5.0f, (float)-4.0f, (float)4.5f, (float)-0.7854f, (float)-0.4363f, (float)0.0f));
        PartDefinition bone2 = bones.m_171599_("bone2", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)3.5f, (float)-0.5f, (float)-5.0f, (float)0.0f, (float)0.5236f, (float)-1.2217f));
        PartDefinition bone3 = bones.m_171599_("bone3", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-4.0f, (float)0.5f, (float)-5.0f, (float)-0.6981f, (float)1.0472f, (float)0.0f));
        PartDefinition bone4 = bones.m_171599_("bone4", CubeListBuilder.m_171558_().m_171514_(5, 18).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-1.5f, (float)-2.0f, (float)0.0f, (float)-1.309f, (float)-0.7854f));
        PartDefinition bone5 = bones.m_171599_("bone5", CubeListBuilder.m_171558_().m_171514_(1, 17).m_171488_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)1.5f, (float)1.0f, (float)-1.3963f, (float)-0.3491f, (float)0.0f));
        PartDefinition bone6 = bones.m_171599_("bone6", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)2.0f, (float)-2.0f, (float)7.0f, (float)-0.7854f, (float)1.7453f, (float)0.0f));
        PartDefinition bone7 = bones.m_171599_("bone7", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-11.5f, (float)-20.5f, (float)-10.5f, (float)0.0f, (float)-1.3963f, (float)-0.8727f));
        PartDefinition bone8 = bones.m_171599_("bone8", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)5.0f, (float)-2.5f, (float)-5.5f, (float)0.0f, (float)-1.309f, (float)1.9199f));
        PartDefinition bone9 = bones.m_171599_("bone9", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-3.0f, (float)-21.5f, (float)12.5f, (float)0.0f, (float)1.2217f, (float)1.309f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(EctoplasmEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetPose();
        this.clubCentered.f_104204_ += MathUtil.toRadians(180.0f + entity.m_5675_(ClientEngine.get().getPartialTick()));
        float speed = 60.0f;
        for (int i = 0; i < this.animParts.length; ++i) {
            AnimatedModelPart part = this.animParts[i];
            this.translateY(part, Y_DIST[i], speed, Y_OFF[i], 0.0f, ageInTicks, 1.0f, Easing.inOutSine, true);
            part.f_104204_ += ageInTicks * Y_FREQ[i] % ((float)Math.PI * 2);
            if (DO_X_ROT[i]) {
                part.f_104203_ += ageInTicks * XZ_FREQ[i] % ((float)Math.PI * 2);
                continue;
            }
            part.f_104205_ += ageInTicks * XZ_FREQ[i] % ((float)Math.PI * 2);
        }
        this.translateY(this.club, 0.8f, speed, 3.5342917f, 0.0f, ageInTicks, 1.0f, Easing.inOutSine, true);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.bones.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.BODY_2, this.bones.animationData);
        map.put(EntityPart.ARM_RIGHT, this.clubCentered.animationData);
        map.put(EntityPart.HAND_RIGHT, this.club.animationData);
        return map;
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, EctoplasmEntity user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        super.animateStun(frame, duration, dir, mag, user, mCalc, mVec, partialTicks);
        float progress = AnimationUtil.getStunProgress(frame, duration, partialTicks);
        progress = frame < duration / 2 ? Easing.outQuart.apply(progress) : Easing.inOutSine.apply(progress);
        float f = this.bones.f_104201_;
        this.bones.f_104201_ = f + (switch (user.size) {
            default -> throw new IncompatibleClassChangeError();
            case EctoplasmEntity.Size.LARGE -> 3.0f;
            case EctoplasmEntity.Size.MEDIUM -> 1.5f;
            case EctoplasmEntity.Size.SMALL -> 1.0f;
        }) * progress;
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return this.noStunParts;
    }
}

