/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.model.entity.AnimatedHumanoidModel;
import frostnox.nightfall.entity.entity.monster.HuskEntity;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.math.Easing;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;

public class HuskModel
extends AnimatedHumanoidModel<HuskEntity> {
    public HuskModel(ModelPart model) {
        super(model);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)2.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-6.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_hand = right_arm.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0524f, (float)0.0524f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_hand = left_arm.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)-0.0524f, (float)-0.0524f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.09f, 0.0f, -2.09f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)2.1f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.91f, 0.0f, -2.09f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)2.1f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(HuskEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetPose();
        float partialTicks = ClientEngine.get().getPartialTick();
        float degree = 1.0f;
        float speed = 4.2f;
        if (limbSwingAmount > 0.5f) {
            limbSwingAmount = 0.5f;
        }
        this.head.f_104203_ += MathUtil.toRadians(headPitch);
        this.head.f_104204_ += MathUtil.toRadians(netHeadYaw);
        int hash = entity.m_142081_().hashCode();
        this.head.f_104205_ = this.head.f_104205_ + MathUtil.toRadians(hash % 8 * (hash % 2 == 0 ? 1 : -1));
        if (!entity.m_21224_()) {
            this.rotateX(this.rightHand, 2.0f, 50.0f, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, 1.0f, Easing.inOutSine, true);
            this.rotateZ(this.rightHand, 2.5f, 50.0f, 0.5f, 0.0f, (float)entity.f_19797_ + partialTicks, 1.0f, Easing.inOutSine, true);
            this.rotateX(this.leftHand, 2.0f, 50.0f, 0.75f, 0.0f, (float)entity.f_19797_ + partialTicks, 1.0f, Easing.inOutSine, true);
            this.rotateZ(this.leftHand, -2.5f, 50.0f, 0.6f, 0.0f, (float)entity.f_19797_ + partialTicks, 1.0f, Easing.inOutSine, true);
        }
        this.translateY(this.body, 1.0f, 0.5f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.translateY(this.rightLeg, 1.0f, 0.5f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.translateY(this.leftLeg, 1.0f, 0.5f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateZ(this.body, 3.0f * degree, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateX(this.head, -2.0f * degree, 1.0f * speed, 0.0f, MathUtil.toRadians(-2.0f), limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateX(this.rightLeg, 90.0f * degree, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateX(this.leftLeg, -90.0f * degree, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateX(this.rightArm, -30.0f * degree, 1.0f * speed, 0.2f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rightArm.f_104205_ = (float)((double)this.rightArm.f_104205_ + Math.toRadians(10.0) * (double)limbSwingAmount);
        this.rotateX(this.leftArm, 33.0f * degree, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.leftArm.f_104205_ = (float)((double)this.leftArm.f_104205_ + Math.toRadians(-10.0) * (double)limbSwingAmount);
    }

    @Override
    public void m_6002_(HumanoidArm side, PoseStack stack) {
        super.m_6002_(side, stack);
        stack.m_85837_(0.0, 0.625, -0.125);
    }
}

