/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.PitDevilEntity;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class PitDevilModel
extends AnimatedModel<PitDevilEntity>
implements HeadedModel {
    private final AnimatedModelPart hindRightLeg;
    private final AnimatedModelPart hindLeftLeg;
    private final AnimatedModelPart body;
    private final AnimatedModelPart neck;
    private final AnimatedModelPart head;
    private final AnimatedModelPart rightEar;
    private final AnimatedModelPart leftEar;
    private final AnimatedModelPart tail;
    private final AnimatedModelPart frontRightLeg;
    private final AnimatedModelPart frontLeftLeg;
    private final List<AnimatedModelPart> noStunParts;

    public PitDevilModel(ModelPart root) {
        super(root);
        this.body = (AnimatedModelPart)root.m_171324_("body");
        this.neck = (AnimatedModelPart)this.body.m_171324_("neck");
        this.head = (AnimatedModelPart)this.neck.m_171324_("head");
        this.leftEar = (AnimatedModelPart)this.head.m_171324_("leftEar");
        this.rightEar = (AnimatedModelPart)this.head.m_171324_("rightEar");
        this.tail = (AnimatedModelPart)this.body.m_171324_("tail");
        this.frontLeftLeg = (AnimatedModelPart)root.m_171324_("frontLeftLeg");
        this.frontRightLeg = (AnimatedModelPart)root.m_171324_("frontRightLeg");
        this.hindRightLeg = (AnimatedModelPart)root.m_171324_("hindRightLeg");
        this.hindLeftLeg = (AnimatedModelPart)root.m_171324_("hindLeftLeg");
        this.noStunParts = List.of(this.head);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-5.5f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(1, 21).m_171488_(-3.0f, -3.0f, -4.5f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(24, 27).m_171488_(-2.0f, -1.0f, -6.5f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(19, 21).m_171488_(0.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-2.0f, (float)-0.5f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(19, 21).m_171480_().m_171488_(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-2.0f, (float)-0.5f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(42, 0).m_171488_(-1.5f, -1.5f, -0.5f, 3.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)6.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition frontLeftLeg = partdefinition.m_171599_("frontLeftLeg", CubeListBuilder.m_171558_().m_171514_(42, 12).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)19.0f, (float)-5.0f));
        PartDefinition frontRightLeg = partdefinition.m_171599_("frontRightLeg", CubeListBuilder.m_171558_().m_171514_(42, 12).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)19.0f, (float)-5.0f));
        PartDefinition hindRightLeg = partdefinition.m_171599_("hindRightLeg", CubeListBuilder.m_171558_().m_171514_(42, 12).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)19.0f, (float)5.0f));
        PartDefinition hindLeftLeg = partdefinition.m_171599_("hindLeftLeg", CubeListBuilder.m_171558_().m_171514_(42, 12).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)19.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(PitDevilEntity entity, float limbSwing, float limbSwingAmount, float time, float netHeadYaw, float headPitch) {
        this.resetPose();
        float speed = 3.1f;
        limbSwingAmount = Math.min(1.0f, limbSwingAmount * 2.0f);
        this.head.f_104203_ += MathUtil.toRadians(headPitch);
        this.head.f_104204_ += MathUtil.toRadians(netHeadYaw);
        if (!entity.m_21224_()) {
            float idle4;
            float idle3;
            float idle2;
            int hash = entity.m_142081_().hashCode();
            float idle1 = (time + (float)(hash & 0xFF)) % 220.0f;
            if (idle1 < 4.0f) {
                this.rotateX(this.rightEar, 5.0f, 2.0f, 0.0f, 0.0f, idle1, 1.0f, Easing.inOutSine, false);
            }
            if ((idle2 = (time + (float)(hash >> 8 & 0xFF)) % 220.0f) < 4.0f) {
                this.rotateX(this.leftEar, 5.0f, 2.0f, 0.0f, 0.0f, idle2, 1.0f, Easing.inOutSine, false);
            }
            if ((idle3 = (time + (float)(hash >> 16 & 0xFF)) % 310.0f) < 90.0f) {
                float p = Easing.inOutSine.apply(idle3 < 6.0f ? idle3 / 6.0f : (idle3 >= 84.0f ? 1.0f - (idle3 - 84.0f) / 6.0f : 1.0f));
                this.rightEar.f_104204_ += MathUtil.toRadians(10.0f) * p;
                this.head.f_104204_ += MathUtil.toRadians(10.0f) * p;
            }
            if ((idle4 = (time + (float)(hash >>> 24 & 0xFF)) % 310.0f) < 90.0f) {
                float p = Easing.inOutSine.apply(idle4 < 6.0f ? idle4 / 6.0f : (idle4 >= 84.0f ? 1.0f - (idle4 - 84.0f) / 6.0f : 1.0f));
                this.leftEar.f_104204_ += MathUtil.toRadians(-10.0f) * p;
                this.head.f_104204_ += MathUtil.toRadians(-10.0f) * p;
            }
        }
        this.rotateX(this.body, 2.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        for (AnimatedModelPart part : new AnimatedModelPart[]{this.body, this.frontRightLeg, this.frontLeftLeg, this.hindRightLeg, this.hindLeftLeg}) {
            this.translateY(part, -0.5f, 1.0f * speed, 1.5707964f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        }
        this.tail.f_104203_ += MathUtil.toRadians(20.0f) * limbSwingAmount;
        this.rotateX(this.tail, 5.0f, speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.frontRightLeg.f_104203_ += MathUtil.toRadians(-10.0f) * limbSwingAmount;
        this.hindRightLeg.f_104203_ += MathUtil.toRadians(10.0f) * limbSwingAmount;
        this.frontLeftLeg.f_104203_ += MathUtil.toRadians(-10.0f) * limbSwingAmount;
        this.hindLeftLeg.f_104203_ += MathUtil.toRadians(10.0f) * limbSwingAmount;
        this.rotateX(this.frontRightLeg, 70.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateX(this.hindRightLeg, 70.0f, 1.0f * speed, 2.7488937f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateX(this.frontLeftLeg, 70.0f, 1.0f * speed, 2.9452431f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateX(this.hindLeftLeg, 70.0f, 1.0f * speed, 5.6941366f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.hindRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.hindLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.LEG_RIGHT, this.frontRightLeg.animationData);
        map.put(EntityPart.LEG_LEFT, this.frontLeftLeg.animationData);
        map.put(EntityPart.LEG_2_RIGHT, this.hindRightLeg.animationData);
        map.put(EntityPart.LEG_2_LEFT, this.hindLeftLeg.animationData);
        map.put(EntityPart.NECK, this.neck.animationData);
        map.put(EntityPart.HEAD, this.head.animationData);
        map.put(EntityPart.EAR_RIGHT, this.rightEar.animationData);
        map.put(EntityPart.EAR_LEFT, this.leftEar.animationData);
        map.put(EntityPart.BODY, this.body.animationData);
        map.put(EntityPart.TAIL, this.tail.animationData);
        return map;
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, PitDevilEntity user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        super.animateStun(frame, duration, dir, mag, user, mCalc, mVec, partialTicks);
        AnimationUtil.stunPartToDefaultWithPause(this.head, this.head.animationData, frame, duration, partialTicks, -20.0f * mag, 1);
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return this.noStunParts;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

