/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.model.entity.ArmorModel;
import frostnox.nightfall.client.model.entity.IHumanoidModel;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PlayerModelNF<T extends Player>
extends PlayerModel<T>
implements IHumanoidModel {
    private final List<ModelPart> cubes = Lists.newArrayList();
    public final ModelPart leftHand;
    public final ModelPart rightHand;
    public final ModelPart leftSleeveN;
    public final ModelPart rightSleeveN;
    public final ModelPart cloakN;
    public final boolean slim;
    public AnimationData leftArmData = new AnimationData();
    public AnimationData rightArmData = new AnimationData();
    public AnimationData leftHandData = new AnimationData();
    public AnimationData rightHandData = new AnimationData();
    public AnimationData leftLegData = new AnimationData();
    public AnimationData rightLegData = new AnimationData();
    private final EnumMap<EntityPart, ModelPart> partMap = new EnumMap(EntityPart.class);

    public PlayerModelNF(ModelPart model, boolean slim) {
        super(model, slim);
        this.slim = slim;
        this.leftHand = model.m_171324_("left_arm").m_171324_("left_hand");
        this.rightHand = model.m_171324_("right_arm").m_171324_("right_hand");
        this.cloakN = model.m_171324_("cloakN");
        this.leftSleeveN = model.m_171324_("left_arm").m_171324_("left_sleeveN");
        this.rightSleeveN = model.m_171324_("right_arm").m_171324_("right_sleeveN");
        this.cubes.add(this.f_102808_);
        this.cubes.add(this.f_102810_);
        this.cubes.add(this.f_102814_);
        this.cubes.add(this.f_102813_);
        this.partMap.put(EntityPart.NECK, this.f_102810_);
        this.partMap.put(EntityPart.HEAD, this.f_102808_);
        this.partMap.put(EntityPart.BODY, this.f_102810_);
        this.partMap.put(EntityPart.ARM_RIGHT, this.f_102811_);
        this.partMap.put(EntityPart.HAND_RIGHT, this.rightHand);
        this.partMap.put(EntityPart.ARM_LEFT, this.f_102812_);
        this.partMap.put(EntityPart.HAND_LEFT, this.leftHand);
        this.partMap.put(EntityPart.LEG_RIGHT, this.f_102813_);
        this.partMap.put(EntityPart.LEG_LEFT, this.f_102814_);
    }

    public static MeshDefinition m_170825_(CubeDeformation cubeDef, boolean slim) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition base = meshdefinition.m_171576_();
        base.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        base.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        base.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        base.m_171599_("ear", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 1.0f, cubeDef), PartPose.f_171404_);
        base.m_171599_("cloak", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171496_(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, cubeDef, 1.0f, 0.5f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        base.m_171599_("cloakN", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171496_(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, cubeDef, 1.0f, 0.5f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        if (slim) {
            base.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)5.5f, (float)2.5f, (float)0.0f));
            base.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)-5.5f, (float)2.5f, (float)0.0f));
            PartDefinition rightArm = base.m_171597_("right_arm");
            PartDefinition leftArm = base.m_171597_("left_arm");
            leftArm.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.5f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            rightArm.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-1.5f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            leftArm.m_171599_("left_sleeveN", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.5f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.25f)), PartPose.m_171419_((float)5.5f, (float)2.5f, (float)0.0f));
            rightArm.m_171599_("right_sleeveN", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-1.5f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.25f)), PartPose.m_171419_((float)-5.5f, (float)2.5f, (float)0.0f));
            base.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            base.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
        } else {
            base.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)6.0f, (float)2.0f, (float)0.0f));
            base.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)-6.0f, (float)2.0f, (float)0.0f));
            PartDefinition rightArm = base.m_171597_("right_arm");
            PartDefinition leftArm = base.m_171597_("left_arm");
            leftArm.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            rightArm.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            leftArm.m_171599_("left_sleeveN", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.25f)), PartPose.m_171419_((float)6.0f, (float)2.0f, (float)0.0f));
            rightArm.m_171599_("right_sleeveN", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.25f)), PartPose.m_171419_((float)-6.0f, (float)2.0f, (float)0.0f));
            base.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            base.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        }
        base.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        base.m_171599_("left_pants", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.248f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        base.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        base.m_171599_("right_pants", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.249f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        base.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDef.m_171469_(0.25f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        return meshdefinition;
    }

    @Override
    public ModelPart getModelPart(EntityPart part) {
        return this.partMap.get((Object)part);
    }

    public void setupAnim(T player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float tilt;
        boolean flag3;
        boolean flag = player.m_21256_() > 4;
        boolean flag1 = player.m_6067_();
        float partial = ClientEngine.get().getPartialTick();
        this.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = flag ? -0.7853982f : (this.f_102818_ > 0.0f ? (flag1 ? this.m_102835_(this.f_102818_, this.f_102808_.f_104203_, -0.7853982f) : this.m_102835_(this.f_102818_, this.f_102808_.f_104203_, headPitch * ((float)Math.PI / 180))) : headPitch * ((float)Math.PI / 180));
        this.leftHand.f_104200_ = 0.0f;
        this.leftHand.f_104201_ = 0.0f;
        this.leftHand.f_104202_ = 0.0f;
        this.rightHand.f_104200_ = 0.0f;
        this.rightHand.f_104201_ = 0.0f;
        this.rightHand.f_104202_ = 0.0f;
        this.leftHand.f_104203_ = 0.0f;
        this.leftHand.f_104204_ = 0.0f;
        this.leftHand.f_104205_ = 0.0f;
        this.rightHand.f_104203_ = 0.0f;
        this.rightHand.f_104204_ = 0.0f;
        this.rightHand.f_104205_ = 0.0f;
        this.f_102810_.f_104204_ = 0.0f;
        this.f_102811_.f_104202_ = 0.0f;
        this.f_102811_.f_104200_ = -5.0f;
        this.f_102812_.f_104202_ = 0.0f;
        this.f_102812_.f_104200_ = 5.0f;
        this.f_102808_.f_104202_ = 0.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)player.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.f_102812_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f;
        this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f;
        this.f_102813_.f_104204_ = 0.0f;
        this.f_102814_.f_104204_ = 0.0f;
        this.f_102813_.f_104205_ = 0.0f;
        this.f_102814_.f_104205_ = 0.0f;
        if (this.f_102609_) {
            this.f_102811_.f_104203_ += -0.62831855f;
            this.f_102812_.f_104203_ += -0.62831855f;
            this.f_102813_.f_104203_ = -1.4137167f;
            this.f_102813_.f_104204_ = 0.31415927f;
            this.f_102813_.f_104205_ = 0.07853982f;
            this.f_102814_.f_104203_ = -1.4137167f;
            this.f_102814_.f_104204_ = -0.31415927f;
            this.f_102814_.f_104205_ = -0.07853982f;
        }
        this.f_102811_.f_104204_ = 0.0f;
        this.f_102812_.f_104204_ = 0.0f;
        boolean flag2 = player.m_5737_() == HumanoidArm.RIGHT;
        boolean bl = flag3 = flag2 ? this.f_102815_.m_102897_() : this.f_102816_.m_102897_();
        if (flag2 != flag3) {
            this.poseLeftArm(player);
            this.poseRightArm(player);
        } else {
            this.poseRightArm(player);
            this.poseLeftArm(player);
        }
        float crouchProgress = AnimationUtil.getCrouchProgress(player, partial);
        if (this.f_102608_ > 0.0f) {
            HumanoidArm arm = this.getSwingingArm(player);
            ModelPart model = this.m_102851_(arm);
            float progress = this.f_102608_;
            float armSwing = Mth.m_14031_((float)(Mth.m_14116_((float)progress) * ((float)Math.PI * 2))) * 0.2f;
            this.f_102810_.f_104204_ = -Mth.m_14031_((float)(progress * (float)Math.PI)) * (0.3f - 0.15f * crouchProgress);
            if (arm == HumanoidArm.LEFT) {
                this.f_102810_.f_104204_ *= -1.0f;
                armSwing = -armSwing;
            }
            this.f_102811_.f_104202_ = Mth.m_14031_((float)armSwing) * 5.0f;
            this.f_102811_.f_104200_ *= Mth.m_14089_((float)armSwing);
            this.f_102812_.f_104202_ = -Mth.m_14031_((float)armSwing) * 5.0f;
            this.f_102812_.f_104200_ *= Mth.m_14089_((float)armSwing);
            this.f_102811_.f_104204_ += armSwing;
            this.f_102812_.f_104204_ += armSwing;
            progress = 1.0f - this.f_102608_;
            progress = 1.0f - progress * progress * progress;
            model.f_104203_ -= Mth.m_14031_((float)(progress * (float)Math.PI)) * 1.2f + Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.f_102808_.f_104203_ - 0.7f) * 0.75f;
            model.f_104204_ += armSwing * 2.0f;
            model.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
        }
        IPlayerData capP = PlayerData.get(player);
        double climbYAmount = capP.getClimbYAmount();
        if (capP.isClimbing()) {
            Vector3d hitCoords = capP.getClimbPosition();
            climbYAmount = Mth.m_14008_((double)((hitCoords.f_86215_ - player.m_20318_((float)partial).f_82480_) / 1.85), (double)0.0, (double)1.0);
            capP.setClimbYAmount(climbYAmount);
            if (LevelUtil.isPositionFullyClimbable(player, hitCoords)) {
                climbYAmount = -1.0;
                capP.setClimbYAmount(climbYAmount);
            }
        }
        this.f_102810_.f_104203_ = 0.0f;
        this.f_102813_.f_104200_ = -2.0f;
        this.f_102813_.f_104202_ = 0.0f;
        this.f_102814_.f_104200_ = 2.0f;
        this.f_102814_.f_104202_ = 0.0f;
        this.f_102813_.f_104201_ = 12.0f;
        this.f_102814_.f_104201_ = 12.0f;
        this.f_102808_.f_104201_ = 0.0f;
        this.f_102810_.f_104201_ = 12.0f;
        this.f_102810_.f_104202_ = 0.0f;
        this.f_102812_.f_104201_ = 2.0f;
        this.f_102811_.f_104201_ = 2.0f;
        ItemStack chestItem = player.m_6844_(EquipmentSlot.CHEST);
        if (chestItem.m_41619_()) {
            this.cloakN.f_104202_ = 0.0f;
            this.cloakN.f_104201_ = 0.0f;
        } else {
            this.cloakN.f_104202_ = -1.1f;
            this.cloakN.f_104201_ = -0.85f;
        }
        this.cloakN.f_104203_ = player.m_6047_() ? MathUtil.toRadians(25.0f) : 0.0f;
        if (chestItem.m_150930_((Item)ItemsNF.BACKPACK.get())) {
            this.cloakN.f_104207_ = false;
        }
        float climbProgress = AnimationUtil.getClimbProgress(player, partial);
        if ((crouchProgress > 0.0f || 1.0 - climbYAmount > 0.0 && climbYAmount > -1.0 && capP.isClimbing() || climbProgress > 0.0f && climbYAmount > -1.0) && !player.m_20143_()) {
            if (climbYAmount > -1.0 && climbProgress > 0.0f) {
                float climbAmountProgress = (1.0f - (float)climbYAmount) * 0.6f;
                if (crouchProgress < (climbAmountProgress *= climbProgress)) {
                    crouchProgress = climbAmountProgress;
                }
            }
            if (crouchProgress < 0.0f) {
                crouchProgress = 0.0f;
            }
            this.f_102810_.f_104203_ += 0.5f * crouchProgress;
            this.f_102811_.f_104203_ += 0.4f * crouchProgress;
            this.f_102812_.f_104203_ += 0.4f * crouchProgress;
            this.f_102813_.f_104200_ += 0.1f * crouchProgress;
            this.f_102813_.f_104202_ += 4.0f * crouchProgress;
            this.f_102814_.f_104200_ += -0.1f * crouchProgress;
            this.f_102814_.f_104202_ += 4.0f * crouchProgress;
            this.f_102813_.f_104201_ += 0.2f * crouchProgress;
            this.f_102814_.f_104201_ += 0.2f * crouchProgress;
            this.f_102808_.f_104201_ += 4.2f * crouchProgress;
            this.f_102810_.f_104201_ += 1.8f * crouchProgress;
            this.f_102810_.f_104202_ += 5.8f * crouchProgress;
            this.f_102812_.f_104201_ += 3.2f * crouchProgress;
            this.f_102811_.f_104201_ += 3.2f * crouchProgress;
            this.cloakN.f_104203_ += MathUtil.toRadians(-25.0f) * crouchProgress;
            this.cloakN.f_104202_ += 1.4f * crouchProgress;
            this.cloakN.f_104201_ += 1.85f * crouchProgress;
        }
        if (this.f_102816_ != HumanoidModel.ArmPose.SPYGLASS && !player.m_20143_()) {
            AnimationUtils.m_170341_((ModelPart)this.f_102811_, (float)ageInTicks, (float)1.0f);
        }
        if (this.f_102815_ != HumanoidModel.ArmPose.SPYGLASS && !player.m_20143_()) {
            AnimationUtils.m_170341_((ModelPart)this.f_102812_, (float)ageInTicks, (float)-1.0f);
        }
        if ((tilt = AnimationUtil.getAirborneProgress(player, partial)) > 0.0f) {
            this.f_102811_.f_104205_ += MathUtil.toRadians(3.0f) * tilt;
            this.f_102812_.f_104205_ += MathUtil.toRadians(-3.0f) * tilt;
        }
        if (climbProgress > 0.0f) {
            climbProgress = AnimationUtil.applyEasing(climbProgress, capP.isClimbing() ? Easing.outCubic : Easing.inOutSine);
            float ladderProgress = (float)player.m_20318_((float)partial).f_82480_;
            if (climbYAmount <= -1.0) {
                this.f_102811_.f_104203_ = Mth.m_14179_((float)climbProgress, (float)this.f_102811_.f_104203_, (float)(MathUtil.toRadians(-100.0f) + Mth.m_14089_((float)(ladderProgress * 2.2f + (float)Math.PI)) * 0.5f / f));
                this.f_102812_.f_104203_ = Mth.m_14179_((float)climbProgress, (float)this.f_102812_.f_104203_, (float)(MathUtil.toRadians(-100.0f) + Mth.m_14089_((float)(ladderProgress * 2.2f)) * 0.5f / f));
            } else {
                this.f_102811_.f_104203_ = Mth.m_14179_((float)climbProgress, (float)this.f_102811_.f_104203_, (float)MathUtil.toRadians(-125.0f * (float)climbYAmount - 10.0f));
                this.f_102812_.f_104203_ = Mth.m_14179_((float)climbProgress, (float)this.f_102812_.f_104203_, (float)MathUtil.toRadians(-125.0f * (float)climbYAmount - 10.0f));
                this.f_102811_.f_104204_ += Mth.m_14179_((float)climbProgress, (float)this.f_102811_.f_104204_, (float)(Mth.m_14089_((float)(limbSwing * 0.6662f + 1.8849558f)) * 2.0f * limbSwingAmount * 0.5f / f));
                this.f_102812_.f_104204_ += Mth.m_14179_((float)climbProgress, (float)this.f_102812_.f_104204_, (float)(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f));
            }
            this.f_102811_.f_104205_ = Mth.m_14179_((float)climbProgress, (float)this.f_102811_.f_104205_, (float)0.0f);
            this.f_102812_.f_104205_ = Mth.m_14179_((float)climbProgress, (float)this.f_102812_.f_104205_, (float)0.0f);
            this.f_102813_.f_104203_ = Mth.m_14179_((float)climbProgress, (float)this.f_102813_.f_104203_, (float)(Mth.m_14089_((float)(limbSwing * 0.5f + ladderProgress * 2.2f + (float)Math.PI)) * 0.5f / f));
            this.f_102814_.f_104203_ = Mth.m_14179_((float)climbProgress, (float)this.f_102814_.f_104203_, (float)(Mth.m_14089_((float)(limbSwing * 0.5f + ladderProgress * 2.2f)) * 0.5f / f));
        }
        if (this.f_102818_ > 0.0f && !player.m_21255_()) {
            float f3;
            HumanoidArm handside = this.getSwingingArm(player);
            float f2 = handside == HumanoidArm.RIGHT && this.f_102608_ > 0.0f ? 0.0f : this.f_102818_;
            float f4 = f3 = handside == HumanoidArm.LEFT && this.f_102608_ > 0.0f ? 0.0f : this.f_102818_;
            if (!player.m_20143_()) {
                float f1 = limbSwing % 26.0f;
                this.f_102811_.f_104204_ = Mth.m_14179_((float)f2, (float)this.f_102811_.f_104204_, (float)0.0f);
                this.f_102812_.f_104204_ = Mth.m_14179_((float)f3, (float)this.f_102812_.f_104204_, (float)0.0f);
                if (f1 < 14.0f) {
                    this.f_102811_.f_104203_ = Mth.m_14179_((float)f2, (float)this.f_102811_.f_104203_, (float)MathUtil.toRadians(-180.0f));
                    this.f_102812_.f_104203_ = Mth.m_14179_((float)f3, (float)this.f_102812_.f_104203_, (float)MathUtil.toRadians(-180.0f));
                    this.f_102811_.f_104205_ = Mth.m_14179_((float)f2, (float)this.f_102811_.f_104205_, (float)(MathUtil.toRadians(-90.0f) * f1 / 14.0f));
                    this.f_102812_.f_104205_ = Mth.m_14179_((float)f3, (float)this.f_102812_.f_104205_, (float)(MathUtil.toRadians(90.0f) * f1 / 14.0f));
                } else if (f1 >= 14.0f && f1 < 22.0f) {
                    float f6 = (f1 - 14.0f) / 8.0f;
                    this.f_102811_.f_104203_ = Mth.m_14179_((float)f2, (float)this.f_102811_.f_104203_, (float)(MathUtil.toRadians(-180.0f) + MathUtil.toRadians(90.0f) * f6));
                    this.f_102812_.f_104203_ = Mth.m_14179_((float)f3, (float)this.f_102812_.f_104203_, (float)(MathUtil.toRadians(-180.0f) + MathUtil.toRadians(90.0f) * f6));
                    this.f_102811_.f_104205_ = Mth.m_14179_((float)f2, (float)this.f_102811_.f_104205_, (float)(MathUtil.toRadians(-90.0f) + MathUtil.toRadians(90.0f) * f6));
                    this.f_102812_.f_104205_ = Mth.m_14179_((float)f3, (float)this.f_102812_.f_104205_, (float)(MathUtil.toRadians(90.0f) + MathUtil.toRadians(-90.0f) * f6));
                } else if (f1 >= 22.0f && f1 < 26.0f) {
                    float f42 = (f1 - 22.0f) / 4.0f;
                    this.f_102811_.f_104203_ = Mth.m_14179_((float)f2, (float)this.f_102811_.f_104203_, (float)(MathUtil.toRadians(-90.0f) + MathUtil.toRadians(-90.0f) * f42));
                    this.f_102812_.f_104203_ = Mth.m_14179_((float)f3, (float)this.f_102812_.f_104203_, (float)(MathUtil.toRadians(-90.0f) + MathUtil.toRadians(-90.0f) * f42));
                    this.f_102811_.f_104205_ = Mth.m_14179_((float)f2, (float)this.f_102811_.f_104205_, (float)0.0f);
                    this.f_102812_.f_104205_ = Mth.m_14179_((float)f3, (float)this.f_102812_.f_104205_, (float)0.0f);
                }
                this.f_102814_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102814_.f_104203_, (float)(0.3f * Mth.m_14089_((float)(limbSwing * 0.33333334f + (float)Math.PI))));
                this.f_102813_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102813_.f_104203_, (float)(0.3f * Mth.m_14089_((float)(limbSwing * 0.33333334f))));
            } else {
                this.f_102810_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102810_.f_104203_, (float)-0.19634955f);
                this.f_102808_.f_104202_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102808_.f_104202_, (float)1.8f);
                this.f_102812_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)0.0f, (float)-2.8274333f);
                this.f_102811_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)0.0f, (float)-2.8274333f);
                this.f_102812_.f_104203_ += Mth.m_14179_((float)this.f_102818_, (float)0.0f, (float)(0.025f * Mth.m_14089_((float)(limbSwing * 0.65f))));
                this.f_102811_.f_104203_ += Mth.m_14179_((float)this.f_102818_, (float)0.0f, (float)(0.025f * Mth.m_14089_((float)(limbSwing * 0.65f + (float)Math.PI))));
                this.f_102812_.f_104205_ += Mth.m_14179_((float)f3, (float)0.0f, (float)(0.08f * Mth.m_14089_((float)(limbSwing * 0.65f + 0.0f)) - 0.1f));
                this.f_102811_.f_104205_ += Mth.m_14179_((float)f2, (float)0.0f, (float)(0.08f * Mth.m_14089_((float)(limbSwing * 0.65f + 1.5707964f)) + 0.1f));
                this.f_102812_.f_104202_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102812_.f_104202_, (float)1.8f);
                this.f_102811_.f_104202_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102811_.f_104202_, (float)1.8f);
                this.f_102814_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102814_.f_104203_, (float)0.0f);
                this.f_102813_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102813_.f_104203_, (float)0.0f);
                this.f_102814_.f_104205_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102814_.f_104205_, (float)-0.175f);
                this.f_102813_.f_104205_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102813_.f_104205_, (float)0.175f);
                this.f_102814_.f_104205_ += Mth.m_14179_((float)this.f_102818_, (float)this.f_102814_.f_104205_, (float)(0.14f * Mth.m_14089_((float)(limbSwing * 0.75f + (float)Math.PI))));
                this.f_102813_.f_104205_ += Mth.m_14179_((float)this.f_102818_, (float)this.f_102813_.f_104205_, (float)(0.14f * Mth.m_14089_((float)(limbSwing * 0.75f + (float)Math.PI))));
                this.f_102814_.f_104201_ += Mth.m_14179_((float)this.f_102818_, (float)0.0f, (float)(1.2f * Mth.m_14089_((float)(limbSwing * 0.75f)))) - 1.2f;
                this.f_102813_.f_104201_ += Mth.m_14179_((float)this.f_102818_, (float)0.0f, (float)(1.2f * Mth.m_14089_((float)(limbSwing * 0.75f + (float)Math.PI)))) - 1.2f;
            }
        }
    }

    public float doCombatAnimations(Player player, PoseStack matrix) {
        if (!player.m_6084_()) {
            return 0.0f;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        if (capA.isInactive()) {
            return 0.0f;
        }
        float partialTicks = capA.modifyPartialTick(ClientEngine.get().getPartialTick());
        AnimationCalculator mCalc = new AnimationCalculator(capA.getDuration(), capA.getFrame(), partialTicks);
        this.readDataFromModel(capA, partialTicks);
        Action action = capA.getAction();
        action.transformModel(capA.getState(), capA.getFrame(), capA.getDuration(), action.getChargeProgress(capA.getCharge(), capA.getChargePartial()), action.getPitch((LivingEntity)player, partialTicks), (LivingEntity)player, this.getDataFromModel(), mCalc);
        Vector3f rotVec = mCalc.getTransformations();
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(rotVec.m_122239_()));
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(rotVec.m_122260_()));
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(rotVec.m_122269_()));
        this.f_102808_.f_104204_ -= MathUtil.toRadians(rotVec.m_122260_());
        this.writeDataToModel();
        if (capA.isStunned()) {
            partialTicks = ClientEngine.get().getPartialTick();
            mCalc = new AnimationCalculator(capA.getStunDuration(), capA.getStunFrame(), partialTicks);
            this.animateStun(capA.getStunFrame(), capA.getStunDuration(), player, mCalc, rotVec, ClientEngine.get().getPartialTick());
            rotVec = mCalc.getTransformations();
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(rotVec.m_122239_()));
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(rotVec.m_122260_()));
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(rotVec.m_122269_()));
            this.f_102808_.f_104204_ -= MathUtil.toRadians(rotVec.m_122260_());
        }
        return MathUtil.toRadians(rotVec.m_122260_());
    }

    public void animateStun(int frame, int duration, Player user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        int offset;
        int dir = (user.f_19797_ - frame) % 2 == 0 ? -1 : 1;
        float mag = Mth.m_14036_((float)((float)duration / 10.0f), (float)0.5f, (float)1.0f);
        AnimationUtil.stunPart(this.f_102808_, frame, duration, partialTicks, -12.0f * mag, 1);
        if (!ActionTracker.get((Entity)user).getAction().isEmpty()) {
            AnimationUtil.stunPartToDefault(this.rightHand, this.rightHandData, frame, duration, partialTicks);
            AnimationUtil.stunPartToDefault(this.f_102811_, this.rightArmData, frame, duration, partialTicks);
            AnimationUtil.stunPartToDefault(this.leftHand, this.leftHandData, frame, duration, partialTicks);
            AnimationUtil.stunPartToDefault(this.f_102812_, this.leftArmData, frame, duration, partialTicks);
            AnimationUtil.stunPartToDefault(this.f_102813_, this.rightLegData, frame, duration, partialTicks);
            AnimationUtil.stunPartToDefault(this.f_102814_, this.leftLegData, frame, duration, partialTicks);
        } else {
            AnimationUtil.stunPartToDefaultWithPause(this.rightHand, this.rightHandData, frame, duration, partialTicks, 35.0f * mag, -dir);
            AnimationUtil.stunPartToDefaultWithPause(this.leftHand, this.leftHandData, frame, duration, partialTicks, 35.0f * mag, dir);
            AnimationUtil.stunPartToDefaultWithPause(this.f_102813_, this.rightLegData, frame, duration, partialTicks, 40.0f * mag, dir);
            AnimationUtil.stunPartToDefaultWithPause(this.f_102814_, this.leftLegData, frame, duration, partialTicks, 40.0f * mag, -dir);
        }
        mCalc.length = offset = duration / 2;
        mCalc.setEasing(Easing.outQuart);
        mCalc.add(0.0f, -7.5f * mag * (float)dir, 0.0f);
        if (frame > offset) {
            mCalc.setEasing(Easing.inOutSine);
            mCalc.offset = offset;
            mCalc.length = duration;
            mVec.m_122261_(-1.0f);
            mCalc.extend(mVec);
        }
    }

    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.HAND_RIGHT, this.rightHandData);
        map.put(EntityPart.ARM_RIGHT, this.rightArmData);
        map.put(EntityPart.HAND_LEFT, this.leftHandData);
        map.put(EntityPart.ARM_LEFT, this.leftArmData);
        map.put(EntityPart.LEG_RIGHT, this.rightLegData);
        map.put(EntityPart.LEG_LEFT, this.leftLegData);
        return map;
    }

    public void readDataFromModel(IActionTracker capC, float partialTicks) {
        this.leftArmData.readFromModelPart(this.f_102812_);
        this.leftArmData.update(capC.getFrame(), capC.getDuration(), partialTicks);
        this.rightArmData.readFromModelPart(this.f_102811_);
        this.rightArmData.update(capC.getFrame(), capC.getDuration(), partialTicks);
        this.leftHandData.readFromModelPart(this.leftHand);
        this.leftHandData.update(capC.getFrame(), capC.getDuration(), partialTicks);
        this.rightHandData.readFromModelPart(this.rightHand);
        this.rightHandData.update(capC.getFrame(), capC.getDuration(), partialTicks);
        this.leftLegData.readFromModelPart(this.f_102814_);
        this.leftLegData.update(capC.getFrame(), capC.getDuration(), partialTicks);
        this.rightLegData.readFromModelPart(this.f_102813_);
        this.rightLegData.update(capC.getFrame(), capC.getDuration(), partialTicks);
    }

    public void writeDataToModel() {
        this.leftArmData.writeToModelPart(this.f_102812_);
        this.rightArmData.writeToModelPart(this.f_102811_);
        this.leftHandData.writeToModelPart(this.leftHand);
        this.rightHandData.writeToModelPart(this.rightHand);
        this.leftLegData.writeToModelPart(this.f_102814_);
        this.rightLegData.writeToModelPart(this.f_102813_);
    }

    public void m_6002_(HumanoidArm side, PoseStack stack) {
        ModelPart arm = this.m_102851_(side);
        ModelPart hand = this.getHand(side);
        if (this.slim) {
            float f = 0.5f * (float)(side == HumanoidArm.RIGHT ? 1 : -1);
            arm.f_104200_ += f;
            arm.m_104299_(stack);
            hand.m_104299_(stack);
            arm.f_104200_ -= f;
        } else {
            arm.m_104299_(stack);
            hand.m_104299_(stack);
        }
    }

    public ModelPart m_103406_(Random p_228288_1_) {
        return this.cubes.get(p_228288_1_.nextInt(this.cubes.size()));
    }

    public ModelPart getHand(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.leftHand : this.rightHand;
    }

    public ModelPart m_102851_(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.f_102812_ : this.f_102811_;
    }

    public void m_8009_(boolean p_178719_1_) {
        super.m_8009_(p_178719_1_);
        this.leftHand.f_104207_ = p_178719_1_;
        this.rightHand.f_104207_ = p_178719_1_;
        this.leftSleeveN.f_104207_ = p_178719_1_;
        this.rightSleeveN.f_104207_ = p_178719_1_;
        this.cloakN.f_104207_ = p_178719_1_;
    }

    public void copyPropertiesTo(ArmorModel model) {
        model.f_102608_ = this.f_102608_;
        model.f_102609_ = this.f_102609_;
        model.f_102610_ = this.f_102610_;
        model.head.m_104315_(this.f_102808_);
        model.body.m_104315_(this.f_102810_);
        model.innerBody.m_104315_(this.f_102810_);
        model.rightArm.m_104315_(this.f_102811_);
        model.rightHand.m_104315_(this.rightHand);
        model.leftArm.m_104315_(this.f_102812_);
        model.leftHand.m_104315_(this.leftHand);
        model.rightLeg.m_104315_(this.f_102813_);
        model.rightLeg.f_104202_ -= 0.001f;
        model.leftLeg.m_104315_(this.f_102814_);
        model.rightFoot.m_104315_(model.rightLeg);
        model.leftFoot.m_104315_(model.leftLeg);
        model.rightSkirt.m_104315_(model.rightLeg);
        model.leftSkirt.m_104315_(model.leftLeg);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.f_102809_, (Object)this.f_103376_, (Object)this.f_103377_, (Object)this.f_103378_);
    }

    public void m_103411_(PoseStack p_228289_1_, VertexConsumer p_228289_2_, int p_228289_3_, int p_228289_4_) {
        this.cloakN.m_104301_(p_228289_1_, p_228289_2_, p_228289_3_, p_228289_4_);
    }

    protected void poseRightArm(T player) {
        switch (this.f_102816_) {
            case EMPTY: {
                this.f_102811_.f_104203_ *= 0.85f;
                this.f_102811_.f_104204_ = 0.0f;
                break;
            }
            case BLOCK: {
                this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - 0.9424779f;
                this.f_102811_.f_104204_ = -0.5235988f;
                break;
            }
            case ITEM: {
                this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.45f - 0.31415927f;
                this.f_102811_.f_104204_ = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - (float)Math.PI;
                this.f_102811_.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.f_102811_.f_104204_ = -0.1f + this.f_102808_.f_104204_;
                this.f_102812_.f_104204_ = 0.1f + this.f_102808_.f_104204_ + 0.4f;
                this.f_102811_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                this.f_102812_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.m_102086_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, player, (boolean)true);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.m_102097_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (ModelPart)this.f_102808_, (boolean)true);
                break;
            }
            case SPYGLASS: {
                this.f_102811_.f_104203_ = Mth.m_14036_((float)(this.f_102808_.f_104203_ - 1.9198622f - (player.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.f_102811_.f_104204_ = this.f_102808_.f_104204_ - 0.2617994f;
            }
        }
    }

    protected void poseLeftArm(T player) {
        switch (this.f_102815_) {
            case EMPTY: {
                this.f_102812_.f_104203_ *= 0.85f;
                this.f_102812_.f_104204_ = 0.0f;
                break;
            }
            case BLOCK: {
                this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.45f - 0.9424779f;
                this.f_102812_.f_104204_ = 0.5235988f;
                break;
            }
            case ITEM: {
                this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - 0.31415927f;
                this.f_102812_.f_104204_ = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - (float)Math.PI;
                this.f_102812_.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.f_102811_.f_104204_ = -0.1f + this.f_102808_.f_104204_ - 0.4f;
                this.f_102812_.f_104204_ = 0.1f + this.f_102808_.f_104204_;
                this.f_102811_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                this.f_102812_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.m_102086_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, player, (boolean)false);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.m_102097_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (ModelPart)this.f_102808_, (boolean)false);
                break;
            }
            case SPYGLASS: {
                this.f_102812_.f_104203_ = Mth.m_14036_((float)(this.f_102808_.f_104203_ - 1.9198622f - (player.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.f_102812_.f_104204_ = this.f_102808_.f_104204_ + 0.2617994f;
            }
        }
    }

    protected HumanoidArm getSwingingArm(T entity) {
        HumanoidArm humanoidarm = entity.m_5737_();
        return ((Player)entity).f_20912_ == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.m_20828_();
    }
}

