/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.RockwormEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class RockwormModel
extends AnimatedModel<RockwormEntity>
implements HeadedModel {
    private final AnimatedModelPart upperBody;
    private final AnimatedModelPart upperBodyCubes;
    private final AnimatedModelPart lowerBody;
    private final AnimatedModelPart lowerBodyCubes;
    private final AnimatedModelPart head;
    private final List<AnimatedModelPart> noStunParts;

    public RockwormModel(ModelPart root) {
        super(root);
        this.lowerBody = (AnimatedModelPart)root.m_171324_("lower_body");
        this.lowerBodyCubes = (AnimatedModelPart)this.lowerBody.m_171324_("lower_body_cubes");
        this.upperBody = (AnimatedModelPart)this.lowerBody.m_171324_("upper_body");
        this.upperBodyCubes = (AnimatedModelPart)this.upperBody.m_171324_("upper_body_cubes");
        this.head = (AnimatedModelPart)this.upperBody.m_171324_("head");
        this.noStunParts = List.of(this.head);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition lower_body = partdefinition.m_171599_("lower_body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)24.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition lower_body_cubes = lower_body.m_171599_("lower_body_cubes", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -13.0f, -3.0f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition upper_body = lower_body.m_171599_("upper_body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-13.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition upper_body_cubes = upper_body.m_171599_("upper_body_cubes", CubeListBuilder.m_171558_().m_171514_(25, 0).m_171488_(-3.0f, -13.0f, -3.0f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = upper_body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-3.0f, -6.0f, -3.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)-13.0f, (float)0.0f, (float)1.309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(34, 27).m_171480_().m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)-2.5f, (float)1.5f, (float)-0.3491f, (float)0.7854f, (float)-0.5236f));
        PartDefinition cube_r2 = head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(34, 27).m_171480_().m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)-2.5f, (float)-2.0f, (float)0.5236f, (float)-0.7854f, (float)-0.6109f));
        PartDefinition cube_r3 = head.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(34, 27).m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)-2.5f, (float)-2.0f, (float)0.5236f, (float)0.7854f, (float)0.6109f));
        PartDefinition cube_r4 = head.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(34, 27).m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)-2.5f, (float)1.5f, (float)-0.3491f, (float)-0.7854f, (float)0.5236f));
        PartDefinition cube_r5 = head.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(43, 27).m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)2.5f, (float)-0.4189f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(RockwormEntity entity, float limbSwing, float limbSwingAmount, float time, float netHeadYaw, float headPitch) {
        this.resetPose();
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ += headPitch * ((float)Math.PI / 180);
        if (!entity.m_21224_()) {
            int hash = entity.m_142081_().hashCode();
            float idle = time + (float)(hash & 0xFF);
            this.rotateZ(this.lowerBody, 0.6f, 60.0f, 0.0f, 0.0f, idle, 1.0f, Easing.inOutSine, true);
            this.rotateZ(this.upperBody, 1.2f, 60.0f, 1.2566371f, 0.0f, idle, 1.0f, Easing.inOutSine, true);
            IActionTracker capA = entity.getActionTracker();
            if (!capA.isStunned() && capA.getActionID().equals((Object)ActionsNF.ROCKWORM_RETREAT.getId())) {
                float progress = capA.getProgress(ClientEngine.get().getPartialTick());
                this.lowerBodyCubes.f_104207_ = progress < 0.5f;
                this.upperBodyCubes.f_104207_ = progress < 0.8f;
            } else if (!capA.isStunned() && capA.getActionID().equals((Object)ActionsNF.ROCKWORM_EMERGE.getId())) {
                float progress = capA.getProgress(ClientEngine.get().getPartialTick());
                this.lowerBodyCubes.f_104207_ = progress > 0.5f;
                this.upperBodyCubes.f_104207_ = progress > 0.2f;
            } else {
                this.lowerBodyCubes.f_104207_ = true;
                this.upperBodyCubes.f_104207_ = true;
            }
        }
        if (entity.f_20919_ > 0) {
            float anim = ((float)entity.f_20919_ + ClientEngine.get().getPartialTick() - 1.0f) / 20.0f * 1.6f;
            anim = Math.min(1.0f, Mth.m_14116_((float)anim));
            int dir = entity.getSynchedRandom() % 2 == 0 ? 1 : -1;
            this.lowerBody.f_104200_ += (float)(-5 * dir) * anim;
            this.lowerBody.f_104202_ += 5.0f * anim;
            this.lowerBody.f_104205_ += MathUtil.toRadians(90.0f) * (float)dir * anim;
            this.upperBody.f_104203_ += MathUtil.toRadians(90.0f) * anim;
            this.head.f_104203_ += MathUtil.toRadians(30.0f) * anim;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.lowerBody.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.HEAD, this.head.animationData);
        map.put(EntityPart.BODY_2, this.upperBody.animationData);
        map.put(EntityPart.BODY, this.lowerBody.animationData);
        return map;
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, RockwormEntity user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        super.animateStun(frame, duration, dir, mag, user, mCalc, mVec, partialTicks);
        AnimationUtil.stunPartToDefaultWithPause(this.head, this.head.animationData, frame, duration, partialTicks, -20.0f * mag, 1);
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return this.noStunParts;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

