/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.ScorpionEntity;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class ScorpionModel
extends AnimatedModel<ScorpionEntity>
implements HeadedModel {
    private final AnimatedModelPart hindBody;
    private final AnimatedModelPart hindRightLeg;
    private final AnimatedModelPart hindLeftLeg;
    private final AnimatedModelPart frontBody;
    private final AnimatedModelPart head;
    private final AnimatedModelPart rightEar;
    private final AnimatedModelPart leftEar;
    private final AnimatedModelPart antlers;
    private final AnimatedModelPart frontRightLeg;
    private final AnimatedModelPart frontLeftLeg;
    private final List<AnimatedModelPart> noStunParts;

    public ScorpionModel(ModelPart root) {
        super(root);
        this.hindBody = (AnimatedModelPart)root.m_171324_("hind_body");
        this.hindRightLeg = (AnimatedModelPart)this.hindBody.m_171324_("hind_right_leg");
        this.hindLeftLeg = (AnimatedModelPart)this.hindBody.m_171324_("hind_left_leg");
        this.frontBody = (AnimatedModelPart)root.m_171324_("front_body");
        this.head = (AnimatedModelPart)this.frontBody.m_171324_("head");
        this.rightEar = (AnimatedModelPart)this.head.m_171324_("right_ear");
        this.leftEar = (AnimatedModelPart)this.head.m_171324_("left_ear");
        this.antlers = (AnimatedModelPart)this.head.m_171324_("antlers");
        this.frontRightLeg = (AnimatedModelPart)this.frontBody.m_171324_("front_right_leg");
        this.frontLeftLeg = (AnimatedModelPart)this.frontBody.m_171324_("front_left_leg");
        this.noStunParts = List.of(this.head);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition hind_body = partdefinition.m_171599_("hind_body", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-2.0f, -4.5f, 0.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(12, 1).m_171488_(-1.0f, -3.5f, 4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition hind_right_leg = hind_body.m_171599_("hind_right_leg", CubeListBuilder.m_171558_().m_171514_(15, 15).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-0.5f, (float)2.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition hind_left_leg = hind_body.m_171599_("hind_left_leg", CubeListBuilder.m_171558_().m_171514_(15, 15).m_171480_().m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-0.5f, (float)2.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition front_body = partdefinition.m_171599_("front_body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -4.5f, -4.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = front_body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(13, 5).m_171488_(-1.5f, -2.0f, -2.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(16, 12).m_171488_(-1.5f, -1.0f, -3.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)-3.5f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(10, 16).m_171488_(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-2.0f, (float)-0.5f, (float)0.0f, (float)1.1345f, (float)0.0f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(10, 16).m_171480_().m_171488_(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)-2.0f, (float)-0.5f, (float)0.0f, (float)-1.1345f, (float)0.0f));
        PartDefinition antlers = head.m_171599_("antlers", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(0.5f, -5.0f, -1.5f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(22, 0).m_171480_().m_171488_(-3.5f, -5.0f, -1.5f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition front_right_leg = front_body.m_171599_("front_right_leg", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-0.5f, (float)-3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition front_left_leg = front_body.m_171599_("front_left_leg", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171480_().m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.5f, (float)-0.5f, (float)-3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(ScorpionEntity entity, float limbSwing, float limbSwingAmount, float time, float netHeadYaw, float headPitch) {
        this.resetPose();
        float speed = 3.3f;
        limbSwingAmount = Math.min(1.0f, limbSwingAmount * 2.0f);
        if (!entity.m_21224_()) {
            float idle4;
            float idle3;
            float idle2;
            int hash = entity.m_142081_().hashCode();
            float idle1 = (time + (float)(hash & 0xFF)) % 220.0f;
            if (idle1 < 4.0f) {
                this.rotateX(this.rightEar, 5.0f, 2.0f, 0.0f, 0.0f, idle1, 1.0f, Easing.inOutSine, false);
            }
            if ((idle2 = (time + (float)(hash >> 8 & 0xFF)) % 220.0f) < 4.0f) {
                this.rotateX(this.leftEar, 5.0f, 2.0f, 0.0f, 0.0f, idle2, 1.0f, Easing.inOutSine, false);
            }
            if ((idle3 = (time + (float)(hash >> 16 & 0xFF)) % 310.0f) < 90.0f) {
                float p = Easing.inOutCubic.apply(idle3 < 4.0f ? idle3 / 4.0f : (idle3 >= 86.0f ? 1.0f - (idle3 - 86.0f) / 4.0f : 1.0f));
                this.rightEar.f_104204_ += MathUtil.toRadians(10.0f) * p;
                this.head.f_104204_ += MathUtil.toRadians(10.0f) * p;
            }
            if ((idle4 = (time + (float)(hash >>> 24 & 0xFF)) % 310.0f) < 90.0f) {
                float p = Easing.inOutCubic.apply(idle4 < 4.0f ? idle4 / 4.0f : (idle4 >= 86.0f ? 1.0f - (idle4 - 86.0f) / 4.0f : 1.0f));
                this.leftEar.f_104204_ += MathUtil.toRadians(-10.0f) * p;
                this.head.f_104204_ += MathUtil.toRadians(-10.0f) * p;
            }
        }
        this.frontRightLeg.f_104202_ += 0.5f * (1.0f - limbSwingAmount);
        this.frontLeftLeg.f_104202_ += 0.5f * (1.0f - limbSwingAmount);
        this.frontBody.f_104201_ += -2.5f * limbSwingAmount;
        this.hindBody.f_104201_ += -2.5f * limbSwingAmount;
        this.frontRightLeg.f_104203_ += MathUtil.toRadians(20.0f) * limbSwingAmount;
        this.frontLeftLeg.f_104203_ += MathUtil.toRadians(20.0f) * limbSwingAmount;
        this.hindRightLeg.f_104203_ += MathUtil.toRadians(30.0f) * limbSwingAmount;
        this.hindLeftLeg.f_104203_ += MathUtil.toRadians(30.0f) * limbSwingAmount;
        this.translateY(this.frontBody, -1.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutCubic, false);
        this.translateY(this.hindBody, -1.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutCubic, false);
        this.translateZ(this.frontBody, 0.5f, 1.0f * speed, (float)Math.PI, 0.0f, limbSwing, limbSwingAmount, Easing.inOutCubic, false);
        this.translateZ(this.hindBody, -0.5f, 1.0f * speed, (float)Math.PI, 0.0f, limbSwing, limbSwingAmount, Easing.inOutCubic, false);
        this.rotateX(this.frontRightLeg, 120.0f, 1.0f * speed, 3.4906585f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.frontLeftLeg, 120.0f, 1.0f * speed, (float)Math.PI, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.hindRightLeg, 110.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.hindLeftLeg, 110.0f, 1.0f * speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.hindBody.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontBody.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.LEG_RIGHT, this.frontRightLeg.animationData);
        map.put(EntityPart.LEG_LEFT, this.frontLeftLeg.animationData);
        map.put(EntityPart.LEG_2_RIGHT, this.hindRightLeg.animationData);
        map.put(EntityPart.LEG_2_LEFT, this.hindLeftLeg.animationData);
        map.put(EntityPart.HEAD, this.head.animationData);
        map.put(EntityPart.EAR_RIGHT, this.rightEar.animationData);
        map.put(EntityPart.EAR_LEFT, this.leftEar.animationData);
        map.put(EntityPart.BODY, this.frontBody.animationData);
        map.put(EntityPart.BODY_2, this.hindBody.animationData);
        return map;
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, ScorpionEntity user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        super.animateStun(frame, duration, dir, mag, user, mCalc, mVec, partialTicks);
        AnimationUtil.stunPartToDefaultWithPause(this.head, this.head.animationData, frame, duration, partialTicks, -20.0f * mag, 1);
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return this.noStunParts;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

