/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.model.AnimatedModel;
import frostnox.nightfall.client.model.AnimatedModelPart;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.entity.monster.SpiderEntity;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SpiderModel
extends AnimatedModel<SpiderEntity>
implements HeadedModel {
    private final AnimatedModelPart body;
    private final AnimatedModelPart head;
    private final AnimatedModelPart rightLeg1;
    private final AnimatedModelPart rightLeg2;
    private final AnimatedModelPart rightLeg3;
    private final AnimatedModelPart rightLeg4;
    private final AnimatedModelPart leftLeg1;
    private final AnimatedModelPart leftLeg2;
    private final AnimatedModelPart leftLeg3;
    private final AnimatedModelPart leftLeg4;
    private final List<AnimatedModelPart> noStunParts;

    public SpiderModel(ModelPart root) {
        super(root);
        this.body = (AnimatedModelPart)root.m_171324_("body");
        this.head = (AnimatedModelPart)root.m_171324_("head");
        this.rightLeg1 = (AnimatedModelPart)root.m_171324_("rightJoint1");
        this.rightLeg2 = (AnimatedModelPart)root.m_171324_("rightJoint2");
        this.rightLeg3 = (AnimatedModelPart)root.m_171324_("rightJoint3");
        this.rightLeg4 = (AnimatedModelPart)root.m_171324_("rightJoint4");
        this.leftLeg1 = (AnimatedModelPart)root.m_171324_("leftJoint1");
        this.leftLeg2 = (AnimatedModelPart)root.m_171324_("leftJoint2");
        this.leftLeg3 = (AnimatedModelPart)root.m_171324_("leftJoint3");
        this.leftLeg4 = (AnimatedModelPart)root.m_171324_("leftJoint4");
        this.noStunParts = List.of(this.head);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-3.0f, -2.5f, 0.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.5f, (float)-2.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.5f, (float)-2.0f));
        PartDefinition rightJoint1 = partdefinition.m_171599_("rightJoint1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)21.5f, (float)-1.5f));
        PartDefinition rightLeg1 = rightJoint1.m_171599_("rightLeg1", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-7.5f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)-0.9599f, (float)-0.5236f));
        PartDefinition rightJoint2 = partdefinition.m_171599_("rightJoint2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)21.5f, (float)-0.5f));
        PartDefinition rightLeg2 = rightJoint2.m_171599_("rightLeg2", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-7.5f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)-0.3491f));
        PartDefinition rightJoint3 = partdefinition.m_171599_("rightJoint3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)21.5f, (float)0.5f));
        PartDefinition rightLeg3 = rightJoint3.m_171599_("rightLeg3", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-7.5f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-0.3491f));
        PartDefinition rightJoint4 = partdefinition.m_171599_("rightJoint4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)21.5f, (float)1.5f));
        PartDefinition rightLeg4 = rightJoint4.m_171599_("rightLeg4", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-7.5f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.9599f, (float)-0.5236f));
        PartDefinition leftJoint1 = partdefinition.m_171599_("leftJoint1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)21.5f, (float)-1.5f));
        PartDefinition leftLeg1 = leftJoint1.m_171599_("leftLeg1", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171480_().m_171488_(-0.5f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.9599f, (float)0.5236f));
        PartDefinition leftJoint2 = partdefinition.m_171599_("leftJoint2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)21.5f, (float)-0.5f));
        PartDefinition leftLeg2 = leftJoint2.m_171599_("leftLeg2", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171480_().m_171488_(-0.5f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.3491f));
        PartDefinition leftJoint3 = partdefinition.m_171599_("leftJoint3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)21.5f, (float)0.5f));
        PartDefinition leftLeg3 = leftJoint3.m_171599_("leftLeg3", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171480_().m_171488_(-0.5f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.3491f));
        PartDefinition leftJoint4 = partdefinition.m_171599_("leftJoint4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)21.5f, (float)1.5f));
        PartDefinition leftLeg4 = leftJoint4.m_171599_("leftLeg4", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171480_().m_171488_(-0.5f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)-0.9599f, (float)0.5236f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(SpiderEntity entity, float limbSwing, float limbSwingAmount, float time, float netHeadYaw, float headPitch) {
        this.resetPose();
        float speed = 3.5f;
        limbSwingAmount = Math.min(1.0f, limbSwingAmount * 2.0f);
        float trackAmount = AnimationUtil.applyEasing(Mth.m_14179_((float)ClientEngine.get().getPartialTick(), (float)entity.targetTimeLast, (float)entity.targetTime) / 9.0f, Easing.inOutSine);
        if (!entity.m_21224_()) {
            float idle2;
            int hash = entity.m_142081_().hashCode();
            float idle1 = (time + (float)(hash >> 16 & 0xFF)) % 310.0f;
            if (idle1 < 90.0f) {
                float p = Easing.inOutCubic.apply(idle1 < 4.0f ? idle1 / 4.0f : (idle1 >= 86.0f ? 1.0f - (idle1 - 86.0f) / 4.0f : 1.0f));
                this.head.f_104204_ += MathUtil.toRadians(5.0f) * p;
            }
            if ((idle2 = (time + (float)(hash >>> 24 & 0xFF)) % 310.0f) < 90.0f) {
                float p = Easing.inOutCubic.apply(idle2 < 4.0f ? idle2 / 4.0f : (idle2 >= 86.0f ? 1.0f - (idle2 - 86.0f) / 4.0f : 1.0f));
                this.head.f_104204_ += MathUtil.toRadians(-5.0f) * p;
            }
        }
        this.body.f_104203_ += MathUtil.toRadians(12.0f) * trackAmount;
        this.head.f_104202_ += 0.4f * trackAmount;
        this.rotateX(this.rightLeg1, -12.0f, speed / 2.0f, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.rightLeg2, -12.0f, speed / 2.0f, 5.6548667f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.rightLeg3, 12.0f, speed / 2.0f, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.rightLeg4, 12.0f, speed / 2.0f, 5.6548667f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.leftLeg1, -12.0f, speed / 2.0f, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.leftLeg2, -12.0f, speed / 2.0f, 5.6548667f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.leftLeg3, 12.0f, speed / 2.0f, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateX(this.leftLeg4, 12.0f, speed / 2.0f, 5.6548667f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, false);
        this.rotateY(this.rightLeg1, 35.0f, speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateY(this.rightLeg2, 20.0f, speed, 2.8274333f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateY(this.rightLeg3, 20.0f, speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateY(this.rightLeg4, 35.0f, speed, 2.8274333f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateY(this.leftLeg1, 35.0f, speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateY(this.leftLeg2, 20.0f, speed, 2.8274333f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateY(this.leftLeg3, 20.0f, speed, 0.0f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
        this.rotateY(this.leftLeg4, 35.0f, speed, 2.8274333f, 0.0f, limbSwing, limbSwingAmount, Easing.inOutSine, true);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg3.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg4.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg3.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg4.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDataFromModel() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.LEG_RIGHT, this.rightLeg1.animationData);
        map.put(EntityPart.LEG_LEFT, this.leftLeg1.animationData);
        map.put(EntityPart.HEAD, this.head.animationData);
        map.put(EntityPart.BODY, this.body.animationData);
        return map;
    }

    @Override
    public void animateStun(int frame, int duration, int dir, float mag, SpiderEntity user, AnimationCalculator mCalc, Vector3f mVec, float partialTicks) {
        super.animateStun(frame, duration, dir, mag, user, mCalc, mVec, partialTicks);
        AnimationUtil.stunPartToDefaultWithPause(this.head, this.head.animationData, frame, duration, partialTicks, -20.0f * mag, 1);
    }

    @Override
    protected List<AnimatedModelPart> getNoStunParts() {
        return this.noStunParts;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

