/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.particle;

import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.particle.ConstantCollidingParticle;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class FadingParticle
extends ConstantCollidingParticle {
    protected FadingParticle(ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int life, SpriteSet sprite) {
        super(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        this.m_108335_(sprite);
        this.f_107226_ = 1.0f;
        this.f_107225_ = this.f_107223_.nextInt(10) + life;
        this.f_107663_ *= 0.9f + this.f_107223_.nextFloat(0.2f);
        this.f_107219_ = true;
        this.m_107271_(0.85f);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.f_107226_ = !this.f_107208_.m_8055_(new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_)).m_60819_().m_76178_() ? -0.001f : 1.0f;
        int fadeTime = this.f_107225_ * 4 / 5;
        if (this.f_107224_ >= fadeTime) {
            this.m_107271_(Mth.m_14036_((float)(0.85f - ((float)this.f_107224_ + ClientEngine.get().getPartialTick() - (float)fadeTime) / (float)(this.f_107225_ - fadeTime) * 0.85f), (float)0.0f, (float)0.85f));
        }
    }

    public static class PoisonSpitProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public PoisonSpitProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FadingParticle particle = new FadingParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, 18, this.sprite);
            float scale = 0.7f + particle.f_107223_.nextFloat() * 0.6f;
            particle.m_107253_(0.592f * scale, 0.749f * scale, 0.11f * scale);
            return particle;
        }
    }

    public static class GreenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public GreenProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FadingParticle particle = new FadingParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, 160, this.sprite);
            particle.m_107253_(0.35f, 0.493f, 0.271f);
            return particle;
        }
    }

    public static class PaleBlueProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public PaleBlueProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FadingParticle particle = new FadingParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, 160, this.sprite);
            particle.m_107253_(0.442f, 0.598f, 0.652f);
            return particle;
        }
    }

    public static class DarkRedProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public DarkRedProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FadingParticle particle = new FadingParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, 160, this.sprite);
            particle.m_107253_(0.42f, 0.18f, 0.16f);
            return particle;
        }
    }

    public static class RedProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public RedProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FadingParticle particle = new FadingParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, 160, this.sprite);
            particle.m_107253_(0.606f, 0.098f, 0.098f);
            return particle;
        }
    }
}

