/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import frostnox.nightfall.util.MathUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FallingParticle
extends TextureSheetParticle {
    protected final BlockPos.MutableBlockPos mutablePos;

    public FallingParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.mutablePos = new BlockPos.MutableBlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
        this.m_108335_(sprite);
        this.f_107226_ = 1.0f;
        this.f_107215_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107216_ = -this.f_107226_;
        this.f_107230_ = 0.0f;
    }

    protected void onLand() {
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        ++this.f_107224_;
        this.f_107230_ = Math.min(1.0f, (float)this.f_107224_ / 7.0f);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107216_ -= 0.04 * (double)this.f_107226_;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.f_107215_ *= (double)this.f_172258_;
        this.f_107216_ *= (double)this.f_172258_;
        this.f_107217_ *= (double)this.f_172258_;
        if (this.f_107218_) {
            this.onLand();
            this.m_107274_();
        } else {
            Entity camEntity = Minecraft.m_91087_().f_91075_;
            if (camEntity != null && camEntity.m_146892_().m_82531_(this.f_107212_, this.f_107213_, this.f_107214_) > 1296.0) {
                this.m_107274_();
            }
        }
    }

    public void m_6257_(double x, double y, double z) {
        double oldY = y;
        Vec3 col = Entity.m_198894_(null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
        x = col.f_82479_;
        y = col.f_82480_;
        z = col.f_82481_;
        if (y != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, y, z));
            this.m_107275_();
            if (!this.f_107208_.m_6425_((BlockPos)this.mutablePos.m_122178_(Mth.m_14107_((double)this.f_107212_), Mth.m_14107_((double)this.f_107213_), Mth.m_14107_((double)this.f_107214_))).m_76178_()) {
                this.f_107218_ = true;
                return;
            }
        }
        this.f_107218_ = oldY != y;
    }

    public void m_5744_(VertexConsumer buffer, Camera cam, float partial) {
        Vec3 camPos = cam.m_90583_();
        float dX = (float)(Mth.m_14139_((double)partial, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float dY = (float)(Mth.m_14139_((double)partial, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float dZ = (float)(Mth.m_14139_((double)partial, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        Quaternion quaternion = new Quaternion(cam.m_90591_());
        quaternion.m_80148_(Vector3f.f_122223_.m_122240_(-cam.m_90589_()));
        quaternion.m_80148_(Vector3f.f_122225_.m_122270_(MathUtil.toRadians(cam.m_90590_()) + (float)Math.atan2(dX, dZ)));
        if (this.f_107231_ != 0.0f || this.f_107204_ != 0.0f) {
            quaternion.m_80148_(Vector3f.f_122227_.m_122270_(Mth.m_14179_((float)partial, (float)this.f_107204_, (float)this.f_107231_)));
        }
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float quadSize = this.m_5902_(partial);
        for (int i = 0; i < 4; ++i) {
            Vector3f vertex = vertices[i];
            vertex.m_122251_(quaternion);
            vertex.m_122261_(quadSize);
            vertex.m_122272_(dX, dY, dZ);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int light = this.m_6355_(partial);
        buffer.m_5483_((double)vertices[0].m_122239_(), (double)vertices[0].m_122260_(), (double)vertices[0].m_122269_()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[1].m_122239_(), (double)vertices[1].m_122260_(), (double)vertices[1].m_122269_()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[2].m_122239_(), (double)vertices[2].m_122260_(), (double)vertices[2].m_122269_()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[3].m_122239_(), (double)vertices[3].m_122260_(), (double)vertices[3].m_122269_()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FallingParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
        }
    }
}

