/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.particle;

import frostnox.nightfall.block.block.tree.TreeLeavesBlock;
import frostnox.nightfall.client.ClientEngine;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class LeafParticle
extends TextureSheetParticle {
    private final BlockPos pos;
    private final float rotSpeed;

    protected LeafParticle(ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite, BlockState state, boolean color) {
        super(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        this.pos = new BlockPos(x, y, z);
        this.rotSpeed = ((float)Math.random() * 0.3f + 0.7f) * 0.02f;
        this.f_107231_ = (float)Math.random() * ((float)Math.PI * 2);
        this.m_108335_(sprite);
        this.f_107663_ *= 0.85f + this.f_107223_.nextFloat(0.3f);
        this.f_107226_ = 0.05f;
        this.f_107225_ = 400;
        this.f_107215_ *= 0.5;
        this.f_107216_ = 0.0;
        this.f_107217_ *= 0.5;
        if (color) {
            int i = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)worldIn, this.pos, 0);
            this.f_107227_ *= (float)(i >> 16 & 0xFF) / 255.0f;
            this.f_107228_ *= (float)(i >> 8 & 0xFF) / 255.0f;
            this.f_107229_ *= (float)(i & 0xFF) / 255.0f;
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float pPartialTick) {
        int i = super.m_6355_(pPartialTick);
        return i == 0 && this.f_107208_.m_46805_(this.pos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)this.pos) : i;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            FluidState fluid = this.f_107208_.m_8055_(new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_)).m_60819_();
            if (!fluid.m_76178_()) {
                if (fluid.m_205070_(FluidTags.f_13132_)) {
                    this.m_107274_();
                } else {
                    this.f_107204_ = this.f_107231_;
                    this.m_6257_(0.0, (double)Mth.m_14031_((float)((float)this.f_107224_ * 0.08f)) * 0.0013, 0.0);
                    this.f_107215_ = 0.0;
                    this.f_107216_ = 0.0;
                    this.f_107217_ = 0.0;
                }
            } else if (!this.f_107218_) {
                this.f_107204_ = this.f_107231_;
                this.f_107231_ += (float)Math.PI * this.rotSpeed * 2.0f;
                this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            } else {
                this.f_107204_ = this.f_107231_;
                if (Minecraft.m_91405_()) {
                    this.f_107205_ = false;
                    this.m_6257_(0.0, this.f_107216_, 0.0);
                }
            }
            this.f_107216_ -= 0.003;
            this.f_107216_ = Math.max(this.f_107216_, -0.14);
        }
        int fadeTime = this.f_107225_ * 4 / 5;
        if (this.f_107224_ >= fadeTime) {
            this.m_107271_(Mth.m_14036_((float)(1.0f - ((float)this.f_107224_ + ClientEngine.get().getPartialTick() - (float)fadeTime) / (float)(this.f_107225_ - fadeTime)), (float)0.0f, (float)1.0f));
        }
    }

    public static class Provider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(BlockParticleOption type, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LeafParticle leafParticle;
            BlockState state = type.m_123642_();
            Block block = state.m_60734_();
            if (block instanceof TreeLeavesBlock) {
                TreeLeavesBlock leavesBlock = (TreeLeavesBlock)block;
                leafParticle = new LeafParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, state, leavesBlock.type.isDeciduous());
            } else {
                leafParticle = null;
            }
            return leafParticle;
        }
    }
}

