/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.particle;

import frostnox.nightfall.block.IHeatSource;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.fluid.WaterFluidNF;
import frostnox.nightfall.client.particle.FallingParticle;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RainParticle
extends FallingParticle {
    public RainParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        int color = ((WaterFluidNF)((Object)FluidsNF.WATER.get())).getAttributes().getColor((BlockAndTintGetter)level, (BlockPos)this.mutablePos);
        this.f_107230_ = (float)(color >>> 24 & 0xFF) / 255.0f;
        this.f_107227_ = (float)(color >> 16 & 0xFF) / 255.0f;
        this.f_107228_ = (float)(color >> 8 & 0xFF) / 255.0f;
        this.f_107229_ = (float)(color & 0xFF) / 255.0f;
        this.f_107663_ = 0.3f;
        this.m_107250_(0.15f, 0.15f);
        this.f_107226_ = 0.82f;
        this.f_107216_ = -this.f_107226_;
    }

    @Override
    protected void onLand() {
        if (Minecraft.m_91087_().f_91066_.f_92073_ != ParticleStatus.MINIMAL) {
            IHeatSource heatSource;
            BlockState state = this.f_107208_.m_8055_((BlockPos)this.mutablePos.m_122169_(this.f_107212_, this.f_107213_ - 0.05, this.f_107214_));
            Block block = state.m_60734_();
            ParticleOptions particle = block instanceof IHeatSource && (heatSource = (IHeatSource)block).getHeat((Level)this.f_107208_, (BlockPos)this.mutablePos, state) != TieredHeat.NONE ? ParticleTypes.f_123762_ : (ParticleOptions)ParticleTypesNF.RAIN_SPLASH.get();
            this.f_107208_.m_7106_(particle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RainParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
        }
    }
}

