/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import frostnox.nightfall.client.particle.ConstantCollidingParticle;
import frostnox.nightfall.util.MathUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SkaraParticle
extends ConstantCollidingParticle {
    protected static final double SPEED = 0.075;
    protected final float yOffset;
    protected final float rollOffset;
    protected final float baseRoll;
    @Nullable
    protected final LivingEntity owner;
    protected final SpriteSet spriteSet;
    protected final int spriteIndex;
    protected boolean wasHurt;

    protected SkaraParticle(ClientLevel worldIn, double x, double y, double z, double rotation, double isMoving, double ownerId, SpriteSet sprite) {
        super(worldIn, x, y, z, 0.0, 0.0, 0.0);
        boolean hurt;
        LivingEntity livingEntity;
        Entity entity;
        this.owner = ownerId > 0.0 && (entity = worldIn.m_6815_((int)ownerId)) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
        this.f_107225_ = 22 + this.f_107223_.nextInt(8);
        this.f_172258_ = 1.0f;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.spriteIndex = this.f_107223_.nextBoolean() ? 0 : 1;
        this.spriteSet = sprite;
        this.wasHurt = hurt = this.owner != null && (this.owner.f_20916_ > 0 || this.owner.f_20919_ > 0);
        this.m_108337_(sprite.m_5819_(hurt ? this.spriteIndex + 2 : this.spriteIndex, 3));
        this.f_107663_ = 0.125f * (0.95f + this.f_107223_.nextFloat(0.1f));
        this.f_107219_ = true;
        this.f_107226_ = 0.4f;
        this.yOffset = 0.0625f + (this.f_107223_.nextFloat() - 0.5f) / 32.0f;
        this.rollOffset = this.f_107223_.nextFloat() * (float)Math.PI * 2.0f;
        this.baseRoll = isMoving == 1.0 ? (float)rotation + (this.f_107223_.nextFloat() - 0.5f) * (float)Math.PI * 0.25f : this.f_107223_.nextFloat() * (float)Math.PI * 2.0f;
        this.f_107204_ = this.f_107231_ = this.baseRoll + Mth.m_14031_((float)this.rollOffset) * (float)Math.PI / 3.0f;
        if (this.owner != null) {
            this.f_107218_ = this.owner.m_20096_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    @Override
    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            boolean hurt;
            boolean bl = hurt = this.owner != null && (this.owner.f_20916_ > 0 || this.owner.f_20919_ > 0);
            if (hurt != this.wasHurt) {
                this.m_108337_(this.spriteSet.m_5819_(hurt ? this.spriteIndex + 2 : this.spriteIndex, 3));
            }
            this.wasHurt = hurt;
            this.f_107204_ = this.f_107231_;
            this.f_107231_ = this.baseRoll + Mth.m_14031_((float)(this.rollOffset + (float)this.f_107224_ * 0.17f)) * (float)Math.PI / 3.0f;
            if (this.f_107218_) {
                this.f_107205_ = false;
            }
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            this.f_107215_ = (double)(-Mth.m_14031_((float)this.f_107231_)) * 0.075;
            this.f_107217_ = (double)Mth.m_14089_((float)this.f_107231_) * 0.075;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
    }

    public void m_107274_() {
        if (this.f_107218_) {
            BlockState state = this.f_107213_ % 1.0 == 0.0 ? this.f_107208_.m_8055_(new BlockPos(this.f_107212_, this.f_107213_ - 1.0, this.f_107214_)) : this.f_107208_.m_8055_(new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_));
            this.f_107208_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
        }
        super.m_107274_();
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float pPartialTicks) {
        Quaternion rotation;
        Vec3 camPos = camera.m_90583_();
        float dX = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float dY = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float dZ = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        if (this.f_107218_) {
            rotation = new Quaternion(Vector3f.f_122223_.m_122240_(90.0f));
        } else {
            rotation = new Quaternion(camera.m_90591_());
            rotation.m_80148_(Vector3f.f_122223_.m_122240_(-camera.m_90589_()));
            rotation.m_80148_(Vector3f.f_122225_.m_122270_(MathUtil.toRadians(camera.m_90590_()) + (float)Math.atan2(dX, dZ)));
        }
        rotation.m_80148_(Vector3f.f_122227_.m_122270_(Mth.m_14179_((float)pPartialTicks, (float)this.f_107204_, (float)this.f_107231_)));
        Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.m_5902_(pPartialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = positions[i];
            vector3f.m_122251_(rotation);
            vector3f.m_122261_(size);
            vector3f.m_122272_(dX, dY, dZ);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int light = this.m_6355_(pPartialTicks);
        buffer.m_5483_((double)positions[0].m_122239_(), (double)(this.yOffset + positions[0].m_122260_()), (double)positions[0].m_122269_()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)positions[1].m_122239_(), (double)(this.yOffset + positions[1].m_122260_()), (double)positions[1].m_122269_()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)positions[2].m_122239_(), (double)(this.yOffset + positions[2].m_122260_()), (double)positions[2].m_122269_()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)positions[3].m_122239_(), (double)(this.yOffset + positions[3].m_122260_()), (double)positions[3].m_122269_()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SkaraParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
        }
    }
}

