/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.client.particle;

import frostnox.nightfall.block.TieredHeat;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class SparkParticle
extends TextureSheetParticle {
    protected SparkParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet sprite) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        this.m_172260_(pXSpeed, Math.abs(pYSpeed), pZSpeed);
        this.m_108335_(sprite);
        this.f_107226_ = 0.9f;
        this.f_107225_ = this.f_107223_.nextInt(12) + 12;
        this.f_107663_ *= 0.07f + this.f_107223_.nextFloat(0.03f);
        this.f_107219_ = true;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public int m_6355_(float pPartialTick) {
        float f = ((float)this.f_107224_ + pPartialTick) / (float)this.f_107225_;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        int i = super.m_6355_(pPartialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class BlueProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public BlueProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
            Color color = TieredHeat.BLUE.color;
            particle.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            return particle;
        }
    }

    public static class WhiteProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public WhiteProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
            Color color = TieredHeat.WHITE.color;
            particle.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            return particle;
        }
    }

    public static class YellowProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public YellowProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
            Color color = TieredHeat.YELLOW.color;
            particle.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            return particle;
        }
    }

    public static class OrangeProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public OrangeProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
            Color color = TieredHeat.ORANGE.color;
            particle.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            return particle;
        }
    }

    public static class RedProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public RedProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
            Color color = TieredHeat.RED.color;
            particle.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            return particle;
        }
    }
}

